/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.SuffixIconProps;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 2022046694691331240L;
    private String id = "";
    private String text = ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"TreeNode_0", (String)"bos-entity-metadata", (Object[])new Object[0]);
    private String longText = null;
    private String parentid = "";
    private Object data;
    @SdkInternal
    protected List<TreeNode> children;
    private boolean isExpend_i;
    private boolean isOpened;
    private String type;
    private String color;
    private String longNumber;
    private List<Map<String, String>> labelPara = new ArrayList<Map<String, String>>();
    public static final String LNUMBERDLM = ".";
    private boolean isLeaf_i;
    private boolean checkable;
    private String icon;
    private boolean disabled;
    private String img;
    private int labelShowType;
    private SuffixIconProps suffixIconProps;
    private Map<String, Object> childrenAttr = new HashMap<String, Object>(8);

    public boolean isLeaf() {
        return this.isLeaf_i;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf_i = isLeaf;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getImg() {
        return this.img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public void setCheckable(boolean checkable) {
        this.checkable = checkable;
    }

    public List<Map<String, String>> getLabelPara() {
        return this.labelPara;
    }

    public void setLabelPara(List<TreeNodeLabel> labelPara) {
        for (TreeNodeLabel treeNodeLabel : labelPara) {
            this.labelPara.add(treeNodeLabel.returnPara());
        }
    }

    public TreeNode() {
    }

    public TreeNode(String parentId, String id, String text) {
        this(parentId, id, text, null);
    }

    public TreeNode(String parentId, String id, String text, Object data) {
        this(parentId, id, text, false, data);
    }

    public TreeNode(String parentId, String id, String text, boolean isParent) {
        this(parentId, id, text, isParent, null);
    }

    public TreeNode(String parentId, String id, String text, boolean isParent, Object data) {
        this();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            this.setParentid(parentId);
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.setId(id);
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.setText(text);
        }
        if (isParent && this.children == null) {
            this.children = new ArrayList<TreeNode>();
        }
        if (data != null) {
            this.data = data;
        }
    }

    @KSMethod
    public final String getId() {
        return this.id;
    }

    @KSMethod
    public final void setId(String value) {
        this.id = value;
    }

    @KSMethod
    public final String getText() {
        return this.text;
    }

    @KSMethod
    public final void setText(String value) {
        this.text = value;
    }

    @KSMethod
    public final String getLongText() {
        if (this.longText == null) {
            return this.getText();
        }
        return this.longText;
    }

    @KSMethod
    public final void setLongText(String value) {
        this.longText = value;
    }

    @KSMethod
    public final String getParentid() {
        return this.parentid;
    }

    @KSMethod
    public final void setParentid(String value) {
        this.parentid = value;
    }

    @KSMethod
    public List<TreeNode> getChildren() {
        return this.children;
    }

    @KSMethod
    public void setChildren(List<TreeNode> arrayList) {
        this.children = arrayList;
    }

    @KSMethod
    public Object getData() {
        return this.data;
    }

    @KSMethod
    public void setData(Object data) {
        this.data = data;
    }

    @KSMethod
    public String getType() {
        return this.type;
    }

    @KSMethod
    public void setType(String type) {
        this.type = type;
    }

    @KSMethod
    public boolean isExpend() {
        return this.isExpend_i;
    }

    @KSMethod
    public void setExpend(boolean isExpend) {
        this.isExpend_i = isExpend;
    }

    @KSMethod
    public boolean getIsOpened() {
        return this.isOpened;
    }

    @KSMethod
    public void setIsOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    @KSMethod
    public String getColor() {
        return this.color;
    }

    @KSMethod
    public void setColor(String color) {
        this.color = color;
    }

    @KSMethod
    public String getLongNumber() {
        return this.longNumber;
    }

    @KSMethod
    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    @KSMethod
    public int getLabelShowType() {
        return this.labelShowType;
    }

    @KSMethod
    public void setLabelShowType(int labelShowType) {
        this.labelShowType = labelShowType;
    }

    @KSMethod
    public SuffixIconProps getSuffixIconProps() {
        return this.suffixIconProps;
    }

    @KSMethod
    public void setSuffixIconProps(SuffixIconProps suffixIconProps) {
        this.suffixIconProps = suffixIconProps;
    }

    @KSMethod
    public Map<String, Object> getChildrenAttr() {
        return this.childrenAttr;
    }

    @KSMethod
    public void setChildrenAttr(Map<String, Object> childrenAttr) {
        this.childrenAttr = childrenAttr;
    }

    @KSMethod
    public TreeNode addChild(TreeNode node) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TreeNode>());
        }
        if (node != null) {
            this.getChildren().add(node);
        }
        return this;
    }

    @KSMethod
    public TreeNode addChild(int i, TreeNode node) {
        if (this.children == null) {
            this.setChildren(new ArrayList<TreeNode>());
        }
        if (node != null) {
            if (i < this.children.size()) {
                this.children.add(i, node);
            } else {
                this.children.add(node);
            }
        }
        return this;
    }

    @KSMethod
    public TreeNode addChildren(List<TreeNode> nodes) {
        if (this.getChildren() == null) {
            this.setChildren(new ArrayList<TreeNode>());
        }
        if (nodes != null) {
            this.getChildren().addAll(nodes);
        }
        return this;
    }

    @KSMethod
    public TreeNode getTreeNode(String id) {
        return this.getTreeNode(id, 100);
    }

    @KSMethod
    public TreeNode getTreeNode(String id, int maxLevel) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getId(), (CharSequence)id)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeNode child : this.getChildren()) {
                TreeNode node = child.getTreeNode(id, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @KSMethod
    public List<TreeNode> getTreeNodeListById(List<TreeNode> treeNodes, String id, int maxLevel) {
        if (this.getId() != null && this.getId().contains(id)) {
            treeNodes.add(this);
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeNode child : this.getChildren()) {
                child.getTreeNodeListById(treeNodes, id, maxLevel - 1);
            }
        }
        return treeNodes;
    }

    @KSMethod
    public TreeNode getTreeNodeByText(String text, int maxLevel) {
        if (this.getText() != null && this.getText().contains(text)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeNode child : this.getChildren()) {
                TreeNode node = child.getTreeNodeByText(text, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @KSMethod
    public List<TreeNode> getTreeNodeListByText(List<TreeNode> treeNodes, String text, int maxLevel) {
        return this.getTreeNodeListByText(treeNodes, text, null, maxLevel);
    }

    @KSMethod
    public List<TreeNode> getTreeNodeListByText(List<TreeNode> treeNodes, String text, Consumer<TreeNode> childrenLoader, int maxLevel) {
        if (this.getText() != null && this.getText().contains(text)) {
            treeNodes.add(this);
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            if (this.getChildren().isEmpty() && childrenLoader != null) {
                childrenLoader.accept(this);
            }
            for (TreeNode child : this.getChildren()) {
                child.getTreeNodeListByText(treeNodes, text, childrenLoader, maxLevel - 1);
            }
        }
        return treeNodes;
    }

    @KSMethod
    public int getNodeLevel(String id, int startLevel) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getId(), (CharSequence)id)) {
            return startLevel;
        }
        if (this.getChildren() != null) {
            for (TreeNode child : this.getChildren()) {
                int currLevel = child.getNodeLevel(id, startLevel + 1);
                if (currLevel == -1) continue;
                return currLevel;
            }
        }
        return -1;
    }

    @KSMethod
    public List<String> getChildPath(String id) {
        HashMap map = new HashMap();
        this.iterate(100, n -> map.put(n.id, n));
        ArrayList<String> path = new ArrayList<String>();
        while (map.containsKey(id)) {
            path.add(0, id);
            id = ((TreeNode)map.get((Object)id)).parentid;
        }
        return path;
    }

    @KSMethod
    public List<TreeNode> getChildPathNodes(String id) {
        HashMap map = new HashMap();
        this.iterate(100, n -> map.put(n.id, n));
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        while (map.containsKey(id)) {
            path.add(0, (TreeNode)map.get(id));
            id = ((TreeNode)map.get((Object)id)).parentid;
        }
        return path;
    }

    public void iterate(int maxLevel, Consumer<TreeNode> callback) {
        callback.accept(this);
        if (maxLevel > 0 && this.getChildren() != null) {
            for (TreeNode child : this.getChildren()) {
                child.iterate(maxLevel - 1, callback);
            }
        }
    }

    @KSMethod
    public TreeNode deleteChildNode(String id) {
        if (this.getChildren() != null) {
            for (TreeNode child : this.getChildren()) {
                if (child.getId().equalsIgnoreCase(id)) {
                    this.getChildren().remove(child);
                    return this;
                }
                TreeNode node = child.deleteChildNode(id);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @KSMethod
    public static TreeNode Parse(String rootParentId, Map<String, Object> map, String idKey, String textKey, String itemsKey) {
        Object items = map.get(itemsKey);
        TreeNode root = new TreeNode(rootParentId, (String)map.get(idKey), (String)map.get(textKey), items != null, map);
        if (items instanceof List) {
            List children = (List)items;
            for (Map item : children) {
                TreeNode node = TreeNode.Parse(root.getId(), item, idKey, textKey, itemsKey);
                root.addChild(node);
            }
        }
        return root;
    }

    public String toString() {
        return String.format("%s, %s", this.id, this.text);
    }
}

