/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.validate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractValidator {
    private static final String KEY_PRECONDITION = "preCondition";
    private static final String KEY_RULECONDITION = "ruleCondition";
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private ValidatePriority validatePriority = ValidatePriority.Normal;
    private int seq = 0;
    private String instanceId;
    Map<String, Object> validation;
    private BOSExpression preConditionExpr;
    String operationName;
    String OperateType;
    String OperateKey;
    protected ValidateContext validateContext;
    protected ExtendedDataEntitySet extendedDataEntitySet;
    protected ExtendedDataEntity[] dataEntities;
    protected String entityKey;
    protected ErrorLevel errorLevel = ErrorLevel.FatalError;
    protected ValidateResult validateResult;
    protected boolean addBillNoForContent = true;
    List<ExtendedDataEntity> falseDataEntities = new ArrayList<ExtendedDataEntity>();

    public boolean isAddBillNoForContent() {
        return this.addBillNoForContent;
    }

    public void setAddBillNoForContent(boolean addBillNoForContent) {
        this.addBillNoForContent = addBillNoForContent;
    }

    public boolean isSupportSplitPageMode() {
        return false;
    }

    @KSMethod
    public ValidatePriority getValidatePriority() {
        return this.validatePriority;
    }

    @KSMethod
    public void setValidatePriority(ValidatePriority validatePriority) {
        this.validatePriority = validatePriority;
    }

    @KSMethod
    public int getSeq() {
        return this.seq;
    }

    @KSMethod
    public void setSeq(int seq) {
        this.seq = seq;
    }

    @KSMethod
    public String getOperateType() {
        return this.OperateType;
    }

    public void setOperateType(String operateType) {
        this.OperateType = operateType;
    }

    @KSMethod
    public String getOperateKey() {
        return this.OperateKey;
    }

    public void setOperateKey(String operateKey) {
        this.OperateKey = operateKey;
    }

    public OperateOption getOption() {
        return this.validateContext.getOption();
    }

    public ExtendedDataEntitySet getExtendedDataEntitySet() {
        return this.extendedDataEntitySet;
    }

    public void setExtendedDataEntitySet(ExtendedDataEntitySet extendedDataEntitySet) {
        this.extendedDataEntitySet = extendedDataEntitySet;
    }

    @KSMethod
    public ExtendedDataEntity[] getDataEntities() {
        return this.dataEntities;
    }

    public void setDataEntities(ExtendedDataEntity[] dataEntities) {
        this.dataEntities = dataEntities;
    }

    public AbstractValidator() {
        this.initValidateResult();
    }

    public ValidateResult getValidateResult() {
        return this.validateResult;
    }

    public List<ExtendedDataEntity> getFalseDataEntities() {
        return this.falseDataEntities;
    }

    protected void initValidateResult() {
        this.validateResult = new ValidateResult();
    }

    @KSMethod
    protected void addWarningMessage(ExtendedDataEntity dataEntity, String content) {
        String title = this.getOperationName();
        this.addMessage(dataEntity, title, content, ErrorLevel.Warning);
    }

    @KSMethod
    protected void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        String title = this.getOperationName();
        this.addMessage(dataEntity, title, content, ErrorLevel.Error);
    }

    @KSMethod
    protected void addFatalErrorMessage(ExtendedDataEntity dataEntity, String content) {
        String title = this.getOperationName();
        this.addMessage(dataEntity, title, content, ErrorLevel.FatalError);
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String content) {
        String title = this.getOperationName();
        this.addMessage(dataEntity, title, content, this.getErrorLevl());
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String content, ErrorLevel errorLevel) {
        String title = this.getOperationName();
        this.addMessage(dataEntity, title, content, errorLevel);
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String title, String content, ErrorLevel errorLevel) {
        Object pkId = dataEntity.getBillPkId();
        int dataIndex = dataEntity.getDataEntityIndex();
        errorLevel = errorLevel == null ? this.getErrorLevl() : errorLevel;
        String propPrefix = this.validateContext.getValidatePrefix();
        if (StringUtils.isNotBlank((CharSequence)propPrefix)) {
            RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.validateContext.getSubEntityType());
            rowDataModel.setRowContext(dataEntity.getDataEntity());
            OutValue<Object> outValue = new OutValue<Object>();
            rowDataModel.tryGetValue(propPrefix, outValue);
            if (!ObjectUtils.isEmpty((Object)outValue.get())) {
                content = String.format("%s%s %s", outValue.get(), ResManager.loadKDString((String)"\uff1a", (String)"AbstractValidator_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), content);
            }
        } else if (!this.checkValidateSingleData() && StringUtils.isNotBlank((CharSequence)dataEntity.getBillNo()) && this.isAddBillNoForContent()) {
            content = dataEntity.getBillNo() + ResManager.loadKDString((String)"\uff1a", (String)"AbstractValidator_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) + " " + content;
        }
        if (errorLevel == ErrorLevel.Error || errorLevel == ErrorLevel.FatalError || errorLevel == ErrorLevel.Warning) {
            String errorCode = StringUtils.isNotBlank((Object)((Object)dataEntity.getValidataErrorCode())) ? ValidataErrorCode.AttTimeout.getCode() : "errorcode_001";
            ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, dataEntity.getRowIndex(), errorCode, title, content, errorLevel);
            info.setEntityKey(this.getEntityKey());
            info.setSubRowIndex(dataEntity.getSubRowIndex());
            this.validateResult.addErrorInfo(info);
            this.falseDataEntities.add(dataEntity);
        }
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String content, ErrorLevel errorLevel, String pattern) {
        String title = this.getOperationName();
        this.addMessage(dataEntity, title, content, errorLevel, pattern);
    }

    protected void addMessage(ExtendedDataEntity dataEntity, String title, String content, ErrorLevel errorLevel, String pattern) {
        Object pkId = dataEntity.getBillPkId();
        int dataIndex = dataEntity.getDataEntityIndex();
        errorLevel = errorLevel == null ? this.getErrorLevl() : errorLevel;
        String propPrefix = this.validateContext.getValidatePrefix();
        if (StringUtils.isNotBlank((CharSequence)propPrefix)) {
            RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.validateContext.getSubEntityType());
            rowDataModel.setRowContext(dataEntity.getDataEntity());
            OutValue<Object> outValue = new OutValue<Object>();
            rowDataModel.tryGetValue(propPrefix, outValue);
            if (!ObjectUtils.isEmpty((Object)outValue.get())) {
                content = String.format("%s%s %s", outValue.get(), ResManager.loadKDString((String)"\uff1a", (String)"AbstractValidator_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), content);
            }
        } else if (!this.checkValidateSingleData() && StringUtils.isNotBlank((CharSequence)dataEntity.getBillNo()) && this.isAddBillNoForContent()) {
            content = dataEntity.getBillNo() + ResManager.loadKDString((String)"\uff1a", (String)"AbstractValidator_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) + " " + content;
        }
        if (errorLevel == ErrorLevel.Error || errorLevel == ErrorLevel.FatalError || errorLevel == ErrorLevel.Warning) {
            String errorCode = StringUtils.isNotBlank((Object)((Object)dataEntity.getValidataErrorCode())) ? ValidataErrorCode.AttTimeout.getCode() : "errorcode_001";
            ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, dataEntity.getRowIndex(), errorCode, title, content, errorLevel, pattern);
            info.setEntityKey(this.getEntityKey());
            info.setSubRowIndex(dataEntity.getSubRowIndex());
            this.validateResult.addErrorInfo(info);
            this.falseDataEntities.add(dataEntity);
        }
    }

    protected String[] extractVariables(String expr) {
        String[] fieldKeys = null;
        try {
            fieldKeys = FormulaEngine.extractVariables((String)expr);
        }
        catch (Throwable exp) {
            LocaleString validationDesc = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
            String errMessage = String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c%3$s\u8868\u8fbe\u5f0f(%4$s)\uff1a%5$s", (String)"AbstractValidator_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), validationDesc.toString(), expr, exp.getMessage());
            throw new KDBizException(exp, new ErrorCode("", errMessage), new Object[0]);
        }
        return fieldKeys;
    }

    public void setErrorLevel(ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
    }

    public ErrorLevel getErrorLevl() {
        return this.errorLevel;
    }

    protected boolean getErrorWhenExpressIsTrue() {
        return Boolean.TRUE.equals(this.getValidationValueByKey("trueThrow"));
    }

    protected Object getValidationValueByKey(String key) {
        return this.validation.containsKey(key) ? this.validation.get(key) : null;
    }

    public String getOperationName() {
        if (StringUtils.isBlank((CharSequence)this.operationName) && this.validateContext != null) {
            this.operationName = this.validateContext.getOperateName();
        }
        return this.operationName == null ? ResManager.loadKDString((String)"\u672a\u77e5\u65b9\u6cd5", (String)"AbstractValidator_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]) : this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public ValidateContext getValidateContext() {
        return this.validateContext;
    }

    public void setValidateContext(ValidateContext validateContext) {
        this.validateContext = validateContext;
    }

    @KSMethod
    public Map<String, Object> getValidation() {
        return this.validation;
    }

    public void setValidation(Map<String, Object> validation) {
        this.validation = validation;
    }

    @KSMethod
    public String getPreCondition() {
        String preCondition = "";
        if (this.getValidation() == null) {
            return preCondition;
        }
        Map preCondMap = (Map)this.getValidation().get(KEY_PRECONDITION);
        if (preCondMap != null && preCondMap.containsKey(KEY_RULECONDITION)) {
            preCondition = (String)preCondMap.get(KEY_RULECONDITION);
        }
        return preCondition;
    }

    public BOSExpression getPreConditionExpr() {
        if (this.preConditionExpr == null) {
            this.preConditionExpr = new BOSExpression(this.getPreCondition());
        }
        return this.preConditionExpr;
    }

    public void initializeConfiguration() {
    }

    public void initialize() {
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public Set<String> preparePropertys() {
        BOSExpression expr = this.getPreConditionExpr();
        if (expr.isError()) {
            LocaleString validationDesc = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
            String errMessage = String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c%3$s\u524d\u7f6e\u6761\u4ef6(%4$s)\uff1a%5$s", (String)"AbstractValidator_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), validationDesc.toString(), expr.getExpression(), expr.getErrMessage());
            throw new KDBizException(errMessage);
        }
        return new HashSet<String>(expr.getVars());
    }

    private boolean checkValidateSingleData() {
        boolean result = false;
        try {
            int dataEntityLength = this.getValidateContext().getDataEntityLength();
            boolean batchImport = Boolean.parseBoolean(this.getOption().getVariableValue("batchImport", String.valueOf(false)));
            boolean batchOpExecute = Boolean.parseBoolean(this.getOption().getVariableValue("batchOpExecute", String.valueOf(false)));
            if (!batchImport && !batchOpExecute) {
                result = dataEntityLength <= 1;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public abstract void validate();

    protected String getEntryKeyByFieldKey(EntityType entityType, String fieldKey) {
        EntityType mainType = entityType;
        while (mainType.getParent() != null) {
            mainType = (EntityType)mainType.getParent();
        }
        IDataEntityProperty property = mainType.findProperty(fieldKey);
        if (property == null || property.getParent() instanceof MainEntityType) {
            return null;
        }
        return property.getParent().getName();
    }

    protected void addPromptInfo(FieldPos fieldPos) {
        if (this.getValidateContext() == null || this.getOption() == null) {
            return;
        }
        boolean ignoreInteraction = Boolean.parseBoolean(this.getOption().getVariableValue("ignoreinteraction", String.valueOf(false)));
        boolean ignoreWarn = Boolean.parseBoolean(this.getOption().getVariableValue("ignorewarn", String.valueOf(false)));
        if ((ignoreInteraction || ignoreWarn) && this.errorLevel == ErrorLevel.Warning) {
            return;
        }
        this.validateResult.addPromptField(fieldPos);
    }

    public String getValidatorId() {
        if (this.instanceId == null) {
            this.instanceId = Uuid8.generateShortUuid();
        }
        return this.instanceId;
    }
}

