/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.coderule.api.ICoreCodeRuleService;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.IFieldRuleHandle;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.entity.validate.SingleFieldValidator;
import kd.bos.entity.validate.ValidPromtType;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateExpressionContext;
import kd.bos.exception.KDBizException;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.validate.FieldChecker;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.CollectionUtils;

@SdkPublic
public class RequiredValidator
extends SingleFieldValidator {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private LocaleString desc;
    private String express;
    private BOSExpression expr;

    public RequiredValidator(DynamicProperty vProperty, String fieldKey, String fieldName, IValueComparator valueComparator) {
        String entryMustInputCondition;
        this.vProperty = vProperty;
        String mustInputCondition = "";
        if (vProperty instanceof IFieldRuleHandle && StringUtils.isBlank((CharSequence)(mustInputCondition = ((IFieldRuleHandle)vProperty).getMustInputCondition()))) {
            if (vProperty instanceof TimeProp && !((TimeProp)vProperty).isStartTimeRange()) {
                String relatedTime = ((TimeProp)vProperty).getRelateTimeRange();
                IDataEntityProperty relatedTimeProp = (IDataEntityProperty)vProperty.getParent().getProperties().get((Object)relatedTime);
                if (relatedTimeProp instanceof IFieldRuleHandle) {
                    ((TimeProp)vProperty).setMustInputCondition(((IFieldRuleHandle)relatedTimeProp).getMustInputCondition());
                }
            } else if (vProperty instanceof DateTimeProp && !((DateTimeProp)vProperty).isStartDateTimeRange()) {
                String relatedDate = ((DateTimeProp)vProperty).getRelateDateTimeRange();
                IDataEntityProperty relatedDateProp = (IDataEntityProperty)vProperty.getParent().getProperties().get((Object)relatedDate);
                if (relatedDateProp instanceof IFieldRuleHandle) {
                    ((DateTimeProp)vProperty).setMustInputCondition(((IFieldRuleHandle)relatedDateProp).getMustInputCondition());
                }
            }
            mustInputCondition = ((IFieldRuleHandle)vProperty).getMustInputCondition();
        }
        if (StringUtils.isNotBlank((CharSequence)mustInputCondition)) {
            Map mustInputMap = new HashMap();
            try {
                mustInputMap = (Map)SerializationUtils.fromJsonString((String)mustInputCondition, HashMap.class);
            }
            catch (Exception exception) {
                throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u7684\u5fc5\u5f55\u6761\u4ef6\u8868\u8fbe\u5f0f\u5df2\u906d\u5230\u7834\u574f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"RequiredValidator_8", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), vProperty.getDisplayName())));
            }
            this.express = (String)mustInputMap.get("RuleCondition");
            if (StringUtils.isNotBlank((CharSequence)this.express)) {
                this.expr = new BOSExpression(this.express);
                if (this.expr.isError()) {
                    throw new KDBizException(this.buildSyntaxErrMessage(this.expr.getErrMessage()));
                }
            }
        }
        if (vProperty instanceof EntryProp && StringUtils.isNotBlank((CharSequence)(entryMustInputCondition = ((EntryProp)vProperty).getMustInputCondition()))) {
            Map entryMustInputMap = new HashMap(16);
            try {
                entryMustInputMap = (Map)SerializationUtils.fromJsonString((String)entryMustInputCondition, HashMap.class);
            }
            catch (Exception exception) {
                throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53%s\u7684\u5fc5\u5f55\u6761\u4ef6\u8868\u8fbe\u5f0f\u5df2\u906d\u5230\u7834\u574f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"RequiredValidator_11", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), vProperty.getDisplayName())));
            }
            this.express = (String)entryMustInputMap.get("RuleCondition");
            if (StringUtils.isNotBlank((CharSequence)this.express)) {
                this.expr = new BOSExpression(this.express);
                if (this.expr.isError()) {
                    throw new KDBizException(this.buildSyntaxErrMessage(this.expr.getErrMessage()));
                }
            }
        }
        this.fieldName = fieldName;
        this.fieldKey = fieldKey;
        this.valueComparetor = valueComparator;
    }

    @Override
    public Set<String> preparePropertys() {
        Set<String> mustConditionDepField;
        Set<String> propertySet = super.preparePropertys();
        if (this.expr != null && (mustConditionDepField = this.expr.getVars()) != null && mustConditionDepField.size() != 0) {
            propertySet.addAll(mustConditionDepField);
        }
        return propertySet;
    }

    @Override
    public void initializeConfiguration() {
        super.initializeConfiguration();
        if (StringUtils.isBlank((CharSequence)this.express)) {
            return;
        }
        this.desc = LocaleString.fromMap((Map)((Map)this.getValidationValueByKey("description")));
        FieldChecker fieldChecker = new FieldChecker(this.getValidateContext().getSubEntityType());
        fieldChecker.check(this.expr.getVars());
        if (fieldChecker.isNotExistsFields()) {
            throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728", (String)"RequiredValidator_9", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), StringUtils.join((Object[])fieldChecker.getNotExistsFields().toArray(), (String)","))));
        }
        if (fieldChecker.isOverEntry()) {
            throw new KDBizException(this.buildSyntaxErrMessage(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6765\u81ea\u4e8e\u591a\u4e2a\u5355\u636e\u4f53(%s)", (String)"RequiredValidator_10", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), fieldChecker.getOverEntryNames("+"))));
        }
    }

    public RequiredValidator() {
    }

    @Override
    public void validate() {
        EntityType entityType;
        MainEntityType mainType = this.getValidateContext().getBillEntityType();
        boolean isBillNo = mainType instanceof BillEntityType && StringUtils.equals((CharSequence)this.fieldKey, (CharSequence)((BillEntityType)mainType).getBillNo());
        boolean enableNull = this.vProperty.isEnableNull();
        EntityType mainEntityType = entityType = (EntityType)this.dataEntities[0].getDataEntity().getDataEntityType();
        while (mainEntityType.getParent() != null) {
            mainEntityType = (EntityType)mainEntityType.getParent();
        }
        RowDataModel rowModel = new RowDataModel(entityType.getName(), (MainEntityType)mainEntityType);
        ValidateExpressionContext expContext = new ValidateExpressionContext(rowModel, this.getValidateContext());
        boolean containEntryField = false;
        if (this.expr != null) {
            for (String var : this.expr.getVars()) {
                if (!(entityType instanceof EntryType) || entityType.getProperty(var) == null) continue;
                containEntryField = true;
                break;
            }
        }
        for (ExtendedDataEntity extDataEntity : this.dataEntities) {
            if (this.expr != null) {
                expContext.getRowDataModel().setRowContext(extDataEntity.getDataEntity(), extDataEntity.getRowIndex());
                Object exprValue = CalcExprParser.getExpressionValue(this.expr, (ExpressionContext)expContext, this.getValidateContext().getFuncLib());
                if (exprValue instanceof Boolean && !((Boolean)exprValue).booleanValue()) {
                    if (containEntryField) continue;
                    return;
                }
            }
            if (this.vProperty instanceof GeoPointProp) {
                this.geoPointValidator(enableNull, extDataEntity);
                continue;
            }
            Object value = this.vProperty.getValue((Object)extDataEntity.getDataEntity());
            if (value == null && this.vProperty instanceof IPictureProp) {
                value = ((IPictureProp)this.vProperty).getDefaultImgKey();
            }
            if (isBillNo) {
                this.validateBillNo(extDataEntity);
                continue;
            }
            if (!(this.vProperty instanceof MuliLangTextProp) && (!enableNull && this.valueComparetor.compareValue(value) || enableNull && value == null)) {
                String content = this.buildErrMessage(extDataEntity);
                this.addMessage(extDataEntity, content, this.getErrorLevl());
                continue;
            }
            if (!(this.vProperty instanceof MuliLangTextProp)) continue;
            List<String> mustInputLang = this.validateContext.getMustInputLang();
            ArrayList<String> mustInputLan = new ArrayList<String>(5);
            if (CollectionUtils.isNotEmpty(mustInputLang)) {
                for (String lan : mustInputLang) {
                    String valuelan;
                    if (StringUtils.isBlank((Object)value)) {
                        this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity), this.getErrorLevl());
                        continue;
                    }
                    if (value == null || !StringUtils.isBlank((CharSequence)(valuelan = (String)((ILocaleString)value).get((Object)lan))) || mustInputLan.contains(lan)) continue;
                    mustInputLan.add(lan);
                }
                if (mustInputLan.isEmpty()) continue;
                this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity, mustInputLan), this.getErrorLevl());
                continue;
            }
            if ((enableNull || !this.valueComparetor.compareValue(value)) && (!enableNull || value != null)) continue;
            this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity), this.getErrorLevl());
        }
    }

    private void geoPointValidator(boolean enableNull, ExtendedDataEntity extDataEntity) {
        GeoPointProp geoPointProp = (GeoPointProp)this.vProperty;
        DecimalProp longitudeProp = geoPointProp.getLongitudeProp();
        Object longitudeValue = longitudeProp.getValue(extDataEntity.getDataEntity());
        if (!enableNull && longitudeProp.getValueComparator().compareValue(longitudeValue) || enableNull && longitudeValue == null) {
            String content = this.buildErrMessage(extDataEntity);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
        DecimalProp latitudeProp = geoPointProp.getLatitudeProp();
        Object latitudeValue = latitudeProp.getValue(extDataEntity.getDataEntity());
        if (!enableNull && latitudeProp.getValueComparator().compareValue(latitudeValue) || enableNull && latitudeValue == null) {
            String content = this.buildErrMessage(extDataEntity);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
        TextProp addressProp = geoPointProp.getAddressProp();
        Object addressValue = addressProp.getValue(extDataEntity.getDataEntity());
        if (!enableNull && addressProp.getValueComparator().compareValue(addressValue) || enableNull && addressValue == null) {
            String content = this.buildErrMessage(extDataEntity);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
    }

    private void validateBillNo(ExtendedDataEntity extDataEntity) {
        DynamicObject billDataObj = extDataEntity.getDataEntity();
        Object billno = this.vProperty.getValue((Object)billDataObj);
        if (this.valueComparetor.compareValue(billno)) {
            String orgId = null;
            String mainOrgKey = this.getValidateContext().getBillEntityType().getMainOrg();
            if (StringUtils.isNotBlank((CharSequence)mainOrgKey)) {
                Object orgObj = billDataObj.get(mainOrgKey);
                if (orgObj instanceof DynamicObject) {
                    orgId = String.valueOf(((DynamicObject)orgObj).getPkValue());
                } else if (orgObj instanceof Long) {
                    orgId = String.valueOf(orgObj);
                }
            }
            if (!this.isSkipBillNoValidator(billDataObj, orgId)) {
                String content = this.buildErrMessage(extDataEntity);
                this.addPromptInfo(new FieldPos(this.fieldKey, content, ValidPromtType.NOT_NULL.getType(), this.getValidatorId()));
                this.addMessage(extDataEntity, content, this.getErrorLevl());
            }
        }
    }

    private boolean isSkipBillNoValidator(DynamicObject billDataObj, String orgId) {
        if (this.getOption() != null) {
            RefObject result = new RefObject();
            boolean canGetValue = this.getOption().tryGetVariableValue("skipbillnovalidator", result);
            if (canGetValue) {
                return Boolean.parseBoolean(this.getOption().getVariableValue("skipbillnovalidator"));
            }
        }
        ICoreCodeRuleService codeRuleService = (ICoreCodeRuleService)ServiceFactory.getService(ICoreCodeRuleService.class);
        return codeRuleService.isExist(this.getEntityKey(), billDataObj, orgId);
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity) {
        String errorMsg;
        if (this.vProperty.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.vProperty.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u3002", (String)"RequiredValidator_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldName, entryName, extDataEntity.getRowIndex() + 1, subEntryName, extDataEntity.getSubRowIndex() + 1);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u3002", (String)"RequiredValidator_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, this.fieldName);
                String fieldTips = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"RequiredValidator_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldName);
                FieldPos fieldPos = new FieldPos(entryType.getName(), extDataEntity.getRowIndex(), this.fieldKey, fieldTips, ValidPromtType.NOT_NULL.getType(), this.getValidatorId());
                fieldPos.setFullMsg(errorMsg);
                this.addPromptInfo(fieldPos);
            }
        } else {
            errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"RequiredValidator_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldName);
            this.addPromptInfo(new FieldPos(this.fieldKey, errorMsg, ValidPromtType.NOT_NULL.getType(), this.getValidatorId()));
        }
        return errorMsg;
    }

    private String buildErrMessage(ExtendedDataEntity extDataEntity, List<String> langBillParams) {
        String errorMsg;
        String promptLang = ValidateContext.switchLang(langBillParams);
        if (this.vProperty.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.vProperty.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u7684\u201c%6$s\u201d\u503c\u3002", (String)"RequiredValidator_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldName, entryName, extDataEntity.getRowIndex() + 1, subEntryName, extDataEntity.getSubRowIndex() + 1, promptLang);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u503c\u3002", (String)"RequiredValidator_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, this.fieldName, promptLang);
                String fieldTips = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"RequiredValidator_6", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldName, promptLang);
                FieldPos fieldPos = new FieldPos(entryType.getName(), extDataEntity.getRowIndex(), this.fieldKey, fieldTips, ValidPromtType.NOT_NULL.getType(), this.getValidatorId());
                fieldPos.setFullMsg(errorMsg);
                this.addPromptInfo(fieldPos);
            }
        } else {
            errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"RequiredValidator_6", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.fieldName, promptLang);
            this.addPromptInfo(new FieldPos(this.fieldKey, errorMsg, ValidPromtType.NOT_NULL.getType(), this.getValidatorId()));
        }
        return errorMsg;
    }

    private String buildSyntaxErrMessage(String errContext) {
        return String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff0c%3$s\u7684\u8868\u8fbe\u5f0f(%4$s)\uff1a%5$s", (String)"RequiredValidator_7", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), this.getValidateContext().getBillEntityType().getDisplayName().toString(), this.getOperationName(), this.desc.toString(), this.express, errContext);
    }
}

