/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.validate;

import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.IScopeCheck;
import kd.bos.entity.validate.SingleFieldValidator;
import kd.bos.entity.validate.ValidPromtType;

public class ScopeValidator
extends SingleFieldValidator {
    private IScopeCheck scopeCheck;

    public ScopeValidator(DynamicProperty vProperty, String fieldKey, String fieldName) {
        this.vProperty = vProperty;
        this.fieldName = fieldName;
        this.fieldKey = fieldKey;
        if (vProperty instanceof IScopeCheck) {
            this.scopeCheck = (IScopeCheck)vProperty;
        }
    }

    @Override
    public void validate() {
        if (this.scopeCheck == null) {
            return;
        }
        for (ExtendedDataEntity extDataEntity : this.dataEntities) {
            Object fldValue = this.vProperty.getValue((Object)extDataEntity.getDataEntity());
            if (this.scopeCheck.checkScope(fldValue)) continue;
            String content = this.buildErrMessage(extDataEntity, fldValue);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
    }

    private String buildErrMessage(ExtendedDataEntity extDataEntity, Object fldValue) {
        String tip;
        String type;
        String errMessage = this.scopeCheck.getDataScopeMessage(fldValue);
        String promptTips = this.scopeCheck.getDataScopeMessage(fldValue, false);
        String string = type = this.getvProperty() instanceof TextProp ? ValidPromtType.CHECK_LEN.getType() : ValidPromtType.CHECK_SCOPE.getType();
        if (this.vProperty.getParent() instanceof SubEntryType) {
            tip = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\uff0c\u201c%3$s\u201d\u7b2c%4$s\u884c\uff0c%5$s", (String)"ScopeValidator_0", (String)"bos-entity-metadata", (Object[])new Object[0]), ((EntryType)this.vProperty.getParent().getParent()).getDisplayName().toString(), extDataEntity.getRowIndex() + 1, ((EntryType)this.vProperty.getParent()).getDisplayName().toString(), extDataEntity.getSubRowIndex() + 1, errMessage);
        } else if (this.vProperty.getParent() instanceof EntryType) {
            tip = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\uff0c%3$s", (String)"ScopeValidator_1", (String)"bos-entity-metadata", (Object[])new Object[0]), ((EntryType)this.vProperty.getParent()).getDisplayName().toString(), extDataEntity.getRowIndex() + 1, errMessage);
            FieldPos fieldPos = new FieldPos(this.vProperty.getParent().getName(), extDataEntity.getRowIndex(), this.vProperty.getName(), promptTips, type, this.getValidatorId());
            fieldPos.setFullMsg(tip);
            this.addPromptInfo(fieldPos);
        } else {
            tip = errMessage;
            FieldPos fieldPos = new FieldPos(this.vProperty.getName(), promptTips, type, this.getValidatorId());
            fieldPos.setFullMsg(tip);
            this.addPromptInfo(fieldPos);
        }
        return tip;
    }
}

