/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.testtools;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityItemTypes;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.JsonSubEntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.property.SubEntryTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.property.VarcharProp;
import org.jetbrains.annotations.NotNull;

public interface EntityTypeBuilder {
    public static final String BOS_ENTITY_METADATA = "bos-entity-metadata";

    public static EntityTypeBuilder builder(String name, Class<? extends DynamicObjectType> entityTypeCls) {
        return new EntityTypeBuilderImpl(name, entityTypeCls);
    }

    public static BasedataEntityType buildBaseDataType(String name) {
        BasedataEntityType type = (BasedataEntityType)((Object)EntityTypeBuilder.builder(name, BasedataEntityType.class).addPKProp("id").addText("number").addText("name").addLong("masterid").build());
        type.setMasteridType(1);
        type.setMasteridPropName("masterid");
        return type;
    }

    public static BasedataEntityType getBaseDataType(EntityType type, String basedatafield) {
        DynamicProperty property = type.getProperty(basedatafield);
        if (property instanceof BasedataProp) {
            return (BasedataEntityType)((BasedataProp)property).getComplexType();
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u57fa\u7840\u8d44\u6599\u7c7b\u578b%s", (String)"EntityTypeBuilder_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), basedatafield));
    }

    public static EntryType getEntry(EntityType type, String entryProp) {
        DynamicProperty property = type.getProperty(entryProp);
        if (property instanceof EntryProp) {
            return (EntryType)((EntryProp)property).getItemType();
        }
        throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u5206\u5f55\u7c7b\u578b%s", (String)"EntityTypeBuilder_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), entryProp));
    }

    public EntityTypeBuilder addText(String var1);

    public EntityTypeBuilderImpl addMuliLangText(String var1);

    public <T extends EntityType> T build();

    public EntityTypeBuilder addAmount(String var1, String var2);

    public EntityTypeBuilder addDecimal(String var1);

    public EntityTypeBuilder addGeoPoint(String var1);

    public EntityTypeBuilder addUnit(String var1, String var2);

    public EntityTypeBuilder addMateriel(String var1);

    public EntityTypeBuilder addCurrency(String var1);

    public EntityTypeBuilder addBaseData(String var1, String var2);

    public EntityTypeBuilder addBaseData(String var1, BasedataEntityType var2);

    public EntityTypeBuilder addItemClassProp(String var1, String var2);

    public EntityTypeBuilder addItemClassTypeProp(String var1, List<String> var2);

    public EntityTypeBuilder addMulBaseData(String var1, String var2);

    public EntityTypeBuilder addUser(String var1);

    public EntityTypeBuilder addMainOrg(String var1);

    public EntityTypeBuilder addMainOrg(String var1, BasedataEntityType var2);

    public EntityTypeBuilder addRefBillProp(String var1, String var2);

    public EntityTypeBuilder addEntry(String var1, String var2);

    public EntityTypeBuilder addSubEntry(String var1, String var2);

    public EntityTypeBuilder addDate(String var1);

    public EntityTypeBuilder addDateTime(String var1);

    public EntityTypeBuilder addLong(String var1);

    public EntityTypeBuilder addFlexProp(String var1);

    public EntityTypeBuilder addPKProp(String var1);

    public EntityTypeBuilder addInteger(String var1);

    public EntityTypeBuilder addFlexProp(String var1, DynamicObjectType var2);

    public EntityTypeBuilder getHeader();

    public EntityTypeBuilder addCheck(String var1);

    public EntityTypeBuilder addCombo(String var1, List<ValueMapItem> var2);

    public EntityTypeBuilder addMulCombo(String var1, List<ValueMapItem> var2);

    public EntityTypeBuilder addVarcharPKProp(String var1);

    public EntityTypeBuilder addSubEntryTextProp(String var1, String var2);

    public EntityTypeBuilder addJsonSubEntry(String var1, String var2);

    public EntityTypeBuilder addCreatorProp(String var1);

    public EntityTypeBuilder addBillStatusProp(String var1);

    public EntityTypeBuilder addBoolean(String var1);

    public EntityTypeBuilder addLinkEntry(String var1, String var2);

    public EntityTypeBuilder addAttachmentProp(DynamicCollectionProperty var1);

    public static class EntryEntityTypeBuilderImpl
    extends EntityTypeBuilderImpl {
        private final EntityTypeBuilder root;
        private final String fieldName;

        public EntryEntityTypeBuilderImpl(String name, Class<? extends EntryType> entityTypeCls, String fieldName, EntityTypeBuilder root) {
            super(name, entityTypeCls);
            this.root = root;
            this.fieldName = fieldName;
        }

        protected <T extends EntityType> T innerBuild() {
            return super.build();
        }

        @Override
        public <T extends EntityType> T build() {
            return this.root.build();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public EntityTypeBuilder getHeader() {
            return this.root;
        }
    }

    public static class EntityTypeBuilderImpl
    implements EntityTypeBuilder {
        private final Class<? extends DynamicObjectType> entityTypeCls;
        private final List<Consumer<DynamicObjectType>> propertyList = new ArrayList<Consumer<DynamicObjectType>>();
        private final String name;

        public EntityTypeBuilderImpl(String name, Class<? extends DynamicObjectType> entityTypeCls) {
            this.entityTypeCls = entityTypeCls;
            this.name = name;
        }

        @Override
        public EntityTypeBuilder addText(String name) {
            TextProp textProp = new TextProp();
            textProp.setName(name);
            textProp.setAlias(name);
            textProp.setDbIgnore(false);
            textProp.setAlias("f" + name);
            textProp.setDisplayName(new LocaleString(name));
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)textProp)));
            return this;
        }

        @Override
        public EntityTypeBuilderImpl addMuliLangText(String name) {
            MuliLangTextProp muliLangProp = new MuliLangTextProp();
            muliLangProp.setName(name);
            muliLangProp.setAlias(name);
            muliLangProp.setAlias("");
            DynamicObjectType localeDt = new DynamicObjectType("locale");
            String pkName = "pkid";
            DynamicSimpleProperty prop = new DynamicSimpleProperty("pkid", String.class, null);
            prop.setName(pkName);
            prop.setPrimaryKey(true);
            prop.setAlias("F" + pkName);
            localeDt.registerSimpleProperty(prop);
            prop = new DynamicSimpleProperty("localeid", String.class, (Object)"zh_CN");
            prop.setName("localeid");
            prop.setAlias("FLocaleId");
            localeDt.registerSimpleProperty(prop);
            DynamicLocaleProperty cp = new DynamicLocaleProperty("multilanguagetext", localeDt);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)arg_0 -> EntityTypeBuilderImpl.lambda$addMuliLangText$1((DynamicCollectionProperty)cp, arg_0)));
            TextProp muliLange_textProp = new TextProp();
            muliLange_textProp.setName(name);
            muliLange_textProp.setDbIgnore(true);
            muliLange_textProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"EntityTypeBuilder_3", (String)EntityTypeBuilder.BOS_ENTITY_METADATA, (Object[])new Object[0])));
            muliLange_textProp.setAlias("");
            localeDt.registerSimpleProperty((DynamicSimpleProperty)muliLange_textProp);
            muliLangProp.setLocaleProperty((IDataEntityProperty)cp, muliLange_textProp);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)muliLangProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addAmount(String amountPropName, String currencyPropName) {
            AmountProp amountProp = new AmountProp();
            amountProp.setName(amountPropName);
            amountProp.setControlPropName(currencyPropName);
            amountProp.setAlias(amountPropName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)amountProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addDecimal(String decimalPropName) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(decimalPropName);
            decimalProp.setAlias(decimalPropName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)decimalProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addGeoPoint(String geoPointPropName) {
            GeoPointProp geoPointProp = new GeoPointProp();
            geoPointProp.setName(geoPointPropName);
            geoPointProp.setAlias(geoPointPropName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)geoPointProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addUnit(String unit, String materielFieldId) {
            UnitProp unitProp = new UnitProp();
            if (kd.bos.util.StringUtils.isNotEmpty((String)materielFieldId)) {
                unitProp.setMaterielField(materielFieldId);
            }
            this.setBaseDataProp(unit, "unit", unitProp);
            return this;
        }

        @Override
        public EntityTypeBuilder addMateriel(String materiel) {
            MaterielProp materielPropProp = new MaterielProp();
            this.setBaseDataProp(materiel, "materiel", materielPropProp);
            return this;
        }

        @Override
        public EntityTypeBuilder addCurrency(String currency) {
            CurrencyProp currencyProp = new CurrencyProp();
            this.setBaseDataProp(currency, "currency", currencyProp);
            return this;
        }

        @Override
        public EntityTypeBuilder addBaseData(String baseDataName, String baseEntityTypeName) {
            BasedataProp basedataProp = new BasedataProp();
            this.setBaseDataProp(baseDataName, baseEntityTypeName, basedataProp);
            return this;
        }

        @Override
        public EntityTypeBuilder addBaseData(String baseDataPropName, BasedataEntityType baseEntityType) {
            BasedataProp basedataProp = new BasedataProp();
            baseEntityType.setPermissionControlType(new PermissionControlType());
            basedataProp.setName(baseDataPropName);
            basedataProp.setComplexType((IDataEntityType)baseEntityType);
            basedataProp.setBaseEntityId(baseEntityType.getName());
            basedataProp.setAlias(baseDataPropName);
            LongProp refIdProp = new LongProp();
            refIdProp.setName(baseDataPropName + "_id");
            refIdProp.setPrimaryKey(false);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)refIdProp)));
            basedataProp.setRefIdProp((IDataEntityProperty)refIdProp);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)basedataProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addItemClassProp(String baseDataPropName, String typePropName) {
            ItemClassProp itemClassProp = new ItemClassProp();
            itemClassProp.setTypePropName(typePropName);
            itemClassProp.setName(baseDataPropName);
            itemClassProp.setAlias(baseDataPropName);
            itemClassProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599", (String)"EntityTypeBuilder_4", (String)EntityTypeBuilder.BOS_ENTITY_METADATA, (Object[])new Object[0])));
            LongProp pRefId = new LongProp(true);
            if (StringUtils.isBlank((CharSequence)itemClassProp.getAlias())) {
                pRefId.setDbIgnore(true);
            } else {
                pRefId.setAlias(itemClassProp.getAlias());
                pRefId.setTableGroup(itemClassProp.getTableGroup());
            }
            pRefId.setPrimaryKey(false);
            pRefId.setName(itemClassProp.getName() + "_id");
            itemClassProp.setRefIdPropName(itemClassProp.getName() + "_id");
            itemClassProp.setRefIdProp((IDataEntityProperty)pRefId);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.addProperty((DynamicProperty)itemClassProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addItemClassTypeProp(String baseDataPropName, List<String> baseEntityTypeNames) {
            ItemClassTypeProp itemClassTypeProp = new ItemClassTypeProp();
            itemClassTypeProp.setName(baseDataPropName);
            itemClassTypeProp.setAlias(baseDataPropName);
            itemClassTypeProp.setDbType(-5);
            ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>(2);
            for (String baseEntityTypeName : baseEntityTypeNames) {
                comboItems.add(new ValueMapItem("", baseEntityTypeName, new LocaleString(baseEntityTypeName)));
                itemClassTypeProp.setItemType(EntityTypeBuilder.buildBaseDataType(baseEntityTypeName));
            }
            itemClassTypeProp.setBaseEntityIds(baseEntityTypeNames);
            itemClassTypeProp.setComboItems(comboItems);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)itemClassTypeProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addMulBaseData(String baseDataPropName, String baseEntityTypeName) {
            DynamicObjectType dynamicObjectType = new DynamicObjectType(baseDataPropName);
            dynamicObjectType.setAlias(baseDataPropName);
            dynamicObjectType.setDbIgnore(false);
            String pkName = "pkid";
            LongProp pkProp = new LongProp();
            pkProp.setName(pkName);
            pkProp.setPrimaryKey(true);
            pkProp.setAlias("F" + pkName);
            dynamicObjectType.registerSimpleProperty((DynamicSimpleProperty)pkProp);
            BasedataProp baseProp = new BasedataProp();
            baseProp.setBaseEntityId(baseEntityTypeName);
            baseProp.setAlias("FBasedataId");
            baseProp.setName("fbasedataid");
            this.setBaseDataProp("fbasedataid", baseEntityTypeName, baseProp);
            baseProp.setDbIgnore(true);
            dynamicObjectType.registerComplexProperty((DynamicComplexProperty)baseProp);
            MulBasedataProp mulBasedataProp = new MulBasedataProp(baseDataPropName, dynamicObjectType);
            mulBasedataProp.setBaseEntityId(baseEntityTypeName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerCollectionProperty((DynamicCollectionProperty)mulBasedataProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addUser(String userPropName) {
            UserProp userProp = new UserProp();
            userProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u7528\u6237", (String)"EntityTypeBuilder_5", (String)EntityTypeBuilder.BOS_ENTITY_METADATA, (Object[])new Object[0])));
            this.setBaseDataProp(userPropName, "bos_user", userProp);
            return this;
        }

        @Override
        public EntityTypeBuilder addMainOrg(String mainOrgPropName) {
            MainOrgProp mainOrgProp = new MainOrgProp();
            mainOrgProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"EntityTypeBuilder_6", (String)EntityTypeBuilder.BOS_ENTITY_METADATA, (Object[])new Object[0])));
            this.setBaseDataProp(mainOrgPropName, "bos_org", mainOrgProp);
            return this;
        }

        @Override
        public EntityTypeBuilder addMainOrg(String mainOrgPropName, BasedataEntityType baseEntityType) {
            MainOrgProp mainOrgProp = new MainOrgProp();
            mainOrgProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"EntityTypeBuilder_6", (String)EntityTypeBuilder.BOS_ENTITY_METADATA, (Object[])new Object[0])));
            baseEntityType.setPermissionControlType(new PermissionControlType());
            mainOrgProp.setName(mainOrgPropName);
            mainOrgProp.setComplexType((IDataEntityType)baseEntityType);
            mainOrgProp.setBaseEntityId(baseEntityType.getName());
            mainOrgProp.setAlias(mainOrgPropName);
            LongProp refIdProp = new LongProp();
            refIdProp.setName(mainOrgPropName + "_id");
            refIdProp.setPrimaryKey(false);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)refIdProp)));
            mainOrgProp.setRefIdProp((IDataEntityProperty)refIdProp);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)mainOrgProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addRefBillProp(String refBillPropName, String baseEntityTypeName) {
            RefBillProp refBillProp = new RefBillProp();
            refBillProp.setName(refBillPropName);
            refBillProp.setAlias(refBillPropName);
            refBillProp.setBillEntityId(baseEntityTypeName);
            EntityTypeBuilder billType = EntityTypeBuilder.builder(baseEntityTypeName, RefEntityType.class);
            billType.addPKProp("id");
            refBillProp.setComplexType((IDataEntityType)billType.build());
            LongProp refIdProp = new LongProp();
            refIdProp.setName(refBillPropName + "_id");
            refIdProp.setPrimaryKey(false);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)refIdProp)));
            refBillProp.setRefIdProp((IDataEntityProperty)refIdProp);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)refBillProp)));
            return this;
        }

        private void setBaseDataProp(String baseDataName, String baseEntityTypeName, BasedataProp basedataProp) {
            BasedataEntityType baseEntityType = EntityTypeBuilder.buildBaseDataType(baseEntityTypeName);
            baseEntityType.setPermissionControlType(new PermissionControlType());
            basedataProp.setName(baseDataName);
            basedataProp.setComplexType((IDataEntityType)baseEntityType);
            basedataProp.setBaseEntityId(baseEntityTypeName);
            basedataProp.setAlias(baseDataName);
            LongProp refIdProp = new LongProp();
            refIdProp.setName(baseDataName + "_id");
            refIdProp.setPrimaryKey(false);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)refIdProp)));
            basedataProp.setRefIdProp((IDataEntityProperty)refIdProp);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)basedataProp)));
        }

        @Override
        public EntityTypeBuilder addEntry(String fieldName, String entryEntityName) {
            return this.createEntryEntityTypeBuilder(fieldName, entryEntityName, new EntryProp(), EntryType.class);
        }

        @Override
        public EntityTypeBuilder addLinkEntry(String propName, String linkEntryEntityName) {
            return this.createEntryEntityTypeBuilder(propName, linkEntryEntityName, new LinkEntryProp(), LinkEntryType.class);
        }

        @Override
        public EntityTypeBuilder addAttachmentProp(DynamicCollectionProperty attachmentProp) {
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerCollectionProperty(attachmentProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addSubEntry(String fieldName, String subEntryEntityName) {
            return this.createEntryEntityTypeBuilder(fieldName, subEntryEntityName, new SubEntryProp(), SubEntryType.class);
        }

        @NotNull
        private EntryEntityTypeBuilderImpl createEntryEntityTypeBuilder(String fieldName, String entryEntityName, EntryProp property, Class<? extends EntryType> entryTypeClaz) {
            EntryEntityTypeBuilderImpl entryTypeBuilder = new EntryEntityTypeBuilderImpl(entryEntityName, entryTypeClaz, fieldName, this);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> {
                EntryType entryType = (EntryType)((Object)((Object)entryTypeBuilder.innerBuild()));
                entryType.setAlias(entryEntityName);
                property.setName(entryTypeBuilder.getFieldName());
                LongProp pk = new LongProp();
                pk.setName("id");
                pk.setAlias("fentryid");
                pk.setPrimaryKey(true);
                entryType.addProperty((DynamicProperty)pk);
                IntegerProp seqProp = new IntegerProp();
                seqProp.setName("seq");
                LocaleString seqDisplayName = ResManager.getLocaleString((String)"\u5206\u5f55\u884c\u53f7", (String)"EntityTypeBuilder_2", (String)EntityTypeBuilder.BOS_ENTITY_METADATA);
                seqProp.setDisplayName(seqDisplayName);
                seqProp.setDbType(4);
                seqProp.setAlias("fseq");
                seqProp.setSysField(true);
                entryType.addProperty((DynamicProperty)seqProp);
                entryType.getSortProperties().add(seqProp);
                property.setItemType((IDataEntityType)entryType);
                type.registerCollectionProperty((DynamicCollectionProperty)property);
            }));
            return entryTypeBuilder;
        }

        @Override
        public EntityTypeBuilder addDate(String date) {
            DateProp prop = new DateProp();
            prop.setName(date);
            prop.setAlias(date);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addDateTime(String datetime) {
            DateTimeProp prop = new DateTimeProp();
            prop.setName(datetime);
            prop.setAlias(datetime);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addLong(String longProp) {
            LongProp prop = new LongProp();
            prop.setName(longProp);
            prop.setAlias(longProp);
            prop.setPrimaryKey(false);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addFlexProp(String flexPropName) {
            FlexProp flexProp = new FlexProp();
            flexProp.setName(flexPropName);
            flexProp.setAlias(flexPropName);
            String baseDataName = flexPropName + "_basedata";
            String baseEntityTypeName = flexPropName + "_testbasedata";
            BasedataProp basedataProp = new BasedataProp();
            BasedataEntityType baseEntityType = EntityTypeBuilder.buildBaseDataType(baseEntityTypeName);
            baseEntityType.setPermissionControlType(new PermissionControlType());
            basedataProp.setName(baseDataName);
            basedataProp.setComplexType((IDataEntityType)baseEntityType);
            basedataProp.setBaseEntityId(baseEntityTypeName);
            basedataProp.setAlias(baseDataName);
            LongProp refIdProp = new LongProp();
            refIdProp.setName(baseDataName + "_id");
            refIdProp.setPrimaryKey(false);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)refIdProp)));
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)basedataProp)));
            basedataProp.setRefIdProp((IDataEntityProperty)refIdProp);
            flexProp.setBasePropertyKey(baseDataName);
            flexProp.setComplexType((IDataEntityType)baseEntityType);
            flexProp.setFlexTypeId(1);
            LongProp pRefId = new LongProp(true);
            if (StringUtils.isBlank((CharSequence)flexProp.getAlias())) {
                pRefId.setDbIgnore(true);
            } else {
                pRefId.setAlias(flexProp.getAlias());
                pRefId.setTableGroup(flexProp.getTableGroup());
            }
            pRefId.setPrimaryKey(false);
            pRefId.setName(flexProp.getName() + "_id");
            flexProp.setRefIdPropName(flexProp.getName() + "_id");
            flexProp.setRefIdProp((IDataEntityProperty)pRefId);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty(pRefId)));
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)flexProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addPKProp(String idPropName) {
            LongProp pkProp = new LongProp();
            pkProp.setName(idPropName);
            pkProp.setAlias("fid");
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)pkProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addInteger(String propName) {
            IntegerProp prop = new IntegerProp();
            prop.setName(propName);
            prop.setAlias(propName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addFlexProp(String flexPropName, DynamicObjectType flexDataType) {
            FlexProp flexProp = new FlexProp();
            flexProp.setName(flexPropName);
            flexProp.setAlias(flexPropName);
            flexProp.setComplexType((IDataEntityType)flexDataType);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerComplexProperty((DynamicComplexProperty)flexProp)));
            return this;
        }

        @Override
        public EntityTypeBuilder addSubEntryTextProp(String propName, String subEntryPropName) {
            SubEntryTextProp prop = new SubEntryTextProp();
            prop.setName(propName);
            prop.setAlias("f" + propName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addJsonSubEntry(String fieldName, String subEntryEntityName) {
            SubEntryProp entryProp = new SubEntryProp();
            EntryEntityTypeBuilderImpl entryTypeBuilder = new EntryEntityTypeBuilderImpl(subEntryEntityName, JsonSubEntryType.class, fieldName, this);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> {
                EntryType entryType = (EntryType)((Object)((Object)entryTypeBuilder.innerBuild()));
                entryType.setDbIgnore(false);
                entryProp.setName(entryTypeBuilder.getFieldName());
                entryProp.setItemType((IDataEntityType)entryType);
                type.registerCollectionProperty((DynamicCollectionProperty)entryProp);
            }));
            return entryTypeBuilder;
        }

        @Override
        public EntityTypeBuilder getHeader() {
            return this;
        }

        @Override
        public EntityTypeBuilder addCheck(String propName) {
            BooleanProp prop = new BooleanProp();
            prop.setName(propName);
            prop.setAlias(propName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addCombo(String propName, List<ValueMapItem> comboItems) {
            ComboProp prop = new ComboProp();
            prop.setName(propName);
            prop.setAlias(propName);
            prop.setComboItems(comboItems);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addMulCombo(String propName, List<ValueMapItem> comboItems) {
            MulComboProp prop = new MulComboProp();
            prop.setName(propName);
            prop.setAlias(propName);
            prop.setComboItems(comboItems);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addVarcharPKProp(String idPropName) {
            VarcharProp prop = new VarcharProp();
            prop.setName(idPropName);
            prop.setAlias("fid");
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addCreatorProp(String propName) {
            CreaterProp prop = new CreaterProp();
            prop.setName(propName);
            prop.setAlias(propName);
            this.setBaseDataProp(propName, "creater", prop);
            return this;
        }

        @Override
        public EntityTypeBuilder addBillStatusProp(String propName) {
            BillStatusProp prop = new BillStatusProp();
            prop.setName(propName);
            prop.setAlias(propName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public EntityTypeBuilder addBoolean(String propName) {
            BooleanProp prop = new BooleanProp();
            prop.setName(propName);
            prop.setAlias(propName);
            this.propertyList.add((Consumer<DynamicObjectType>)((Consumer)type -> type.registerSimpleProperty((DynamicSimpleProperty)prop)));
            return this;
        }

        @Override
        public <T extends EntityType> T build() {
            try {
                EntityType entityType = (EntityType)this.entityTypeCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                entityType.setAlias("t_test_" + this.name);
                entityType.setName(this.name);
                entityType.setDBRouteKey(DBRoute.base.getRouteKey());
                entityType.setDisplayName(new LocaleString(this.name));
                this.propertyList.forEach(o -> o.accept((Object)entityType));
                return (T)((Object)entityType);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void lambda$addMuliLangText$1(DynamicCollectionProperty cp, DynamicObjectType type) {
            type.registerCollectionProperty(cp);
        }

        static {
            EntityItemTypes.register(DynamicSimpleProperty.class);
        }
    }
}

