/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DBDateUtil {
    private static long dateOffset = 0L;
    private static AtomicBoolean hasFeatched = new AtomicBoolean(false);
    private static Log log = LogFactory.getLog(DBDateUtil.class);

    private static void initDBTime() {
        if (hasFeatched.compareAndSet(false, true)) {
            try {
                long sqlTime = DBDateUtil.getDBDate().getTime();
                dateOffset = new Date().getTime() - sqlTime;
            }
            catch (Exception e) {
                log.error("DBDateUtil.initDBTime error.", (Throwable)e);
                hasFeatched.set(false);
            }
        }
    }

    public static long getTimeMillis() {
        DBDateUtil.initDBTime();
        return new Date().getTime() - dateOffset;
    }

    public static Date getDate() {
        return new Date(DBDateUtil.getTimeMillis());
    }

    private static Date getDBDate() {
        Timestamp sqlDate = (Timestamp)DB.query((DBRoute)DBRoute.meta, (String)"SELECT top 1 now() from t_bas_version", (ResultSetHandler)new ResultSetHandler<Timestamp>(){

            public Timestamp handle(ResultSet rs) throws Exception {
                rs.next();
                return rs.getTimestamp(1);
            }
        });
        return new Date(sqlDate.getTime());
    }
}

