/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;

public class LocaleBuildUtils {
    private static final Log log = LogFactory.getLog(LocaleBuildUtils.class);
    private static String splitStr = "],[";
    private static String startStr = "$@{[";
    private static String endStr = "]}@";
    private static String replaceStart = "$@{";
    private static String replaceEnd = "}@";
    private static String matchPattern = "\\$\\@\\{([^@]+)\\}@";
    private static Set<String> literals = new HashSet<String>(10);

    private static String saveConvert(String theString) {
        return LocaleBuildUtils.saveConvert(theString, true);
    }

    private static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static File writeProperties(String fileName, Map<String, String> localeMap) {
        if (localeMap == null || localeMap.size() <= 0) {
            return null;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String[] leftStrs = o1.split("_");
                String[] rightStrs = o2.split("_");
                int left = Integer.parseInt(leftStrs[leftStrs.length - 1]);
                int right = Integer.parseInt(rightStrs[rightStrs.length - 1]);
                return left - right;
            }
        }));
        sortedMap.putAll(localeMap);
        localeMap = sortedMap;
        Properties props = new Properties();
        File file = null;
        try {
            fileName = fileName.split("\\.")[0];
            String filePath = LocaleBuildUtils.getDictDir() + File.separatorChar + fileName + "_zh_CN.properties";
            file = new File(filePath);
            file.deleteOnExit();
            file.createNewFile();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
                 BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                 FileOutputStream fos = new FileOutputStream(filePath);){
                props.load(bf);
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, String> entry : localeMap.entrySet()) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
                }
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = LocaleBuildUtils.saveConvert(String.valueOf(entry.getKey()));
                    String value = LocaleBuildUtils.saveConvert(String.valueOf(entry.getValue()));
                    if (localeMap.containsKey(key)) continue;
                    sb.append(key).append("=").append(value).append("\n");
                }
                ((OutputStream)fos).write(sb.toString().getBytes("UTF-8"));
            }
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (file != null) {
                file.deleteOnExit();
            }
        }
    }

    private static String getDictDir() {
        File file;
        String dir = System.getProperty("java.io.tmpdir");
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(file = new File(dir = dir + "domaintrans")).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    public static SAXReader getSaxReader() {
        SAXReader saxReader = new SAXReader();
        try {
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException e) {
            log.error((Throwable)e);
        }
        return saxReader;
    }

    private static List<File> buildFile(HashMap<String, String> localeMap, String fileName, Document doc, String localeId) {
        ArrayList<File> files = new ArrayList<File>();
        File resource = LocaleBuildUtils.writeProperties(fileName, localeMap);
        File newDoc = LocaleBuildUtils.wirteModelXml(fileName, doc);
        if (resource != null) {
            files.add(resource);
        }
        if (newDoc != null) {
            files.add(newDoc);
        }
        return files;
    }

    private static File wirteModelXml(String fileName, Document doc) {
        File file = null;
        try {
            fileName = fileName.split("\\.")[0];
            String filePath = LocaleBuildUtils.getDictDir() + File.separatorChar + fileName + ".xml";
            file = new File(filePath);
            file.deleteOnExit();
            file.createNewFile();
            OutputStreamWriter osWrite = new OutputStreamWriter(new FileOutputStream(file));
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            format.setIndent(true);
            format.setNewlines(true);
            XMLWriter writer = new XMLWriter((Writer)osWrite, format);
            writer.write(doc);
            writer.flush();
            writer.close();
            ((Writer)osWrite).close();
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (file != null) {
                file.deleteOnExit();
            }
        }
    }

    public static File wirteTempFile(String fileName, Document doc) {
        try {
            fileName = fileName.split("\\.")[0];
            File file = File.createTempFile("tpl-" + fileName, ".xml");
            file.deleteOnExit();
            file.createNewFile();
            OutputStreamWriter osWrite = new OutputStreamWriter(new FileOutputStream(file));
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            format.setIndent(true);
            format.setNewlines(true);
            XMLWriter writer = new XMLWriter((Writer)osWrite, format);
            writer.write(doc);
            writer.flush();
            writer.close();
            ((Writer)osWrite).close();
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> buildXmlAndProperties(String fileName, InputStream xmlInputStream) {
        SAXReader reader = LocaleBuildUtils.getSaxReader();
        try {
            LinkedHashMap<String, String> localeMap = new LinkedHashMap<String, String>();
            Document doc = reader.read(xmlInputStream);
            TransContext context = new TransContext(fileName, doc);
            localeMap.putAll(context.getExistsRes());
            LocaleBuildUtils.parserEntry(localeMap, fileName, fileName, doc, context);
            List<File> files = LocaleBuildUtils.buildFile(localeMap, fileName, doc, Lang.zh_CN.toString());
            String[] urls = new String[files.size()];
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = Math.min(180 + files.size() * 60, 600);
            int i = 0;
            for (File file : files) {
                FileInputStream fileInputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    urls[i++] = fileCache.saveAsUrl(file.getName(), (InputStream)fileInputStream, timeout);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
            ((HashMap)localeMap).clear();
            return Arrays.asList(urls);
        }
        catch (FileNotFoundException | DocumentException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] buildTemplate(String fileName) throws UnsupportedEncodingException, DocumentException {
        String[] result = new String[2];
        SAXReader reader = LocaleBuildUtils.getSaxReader();
        URL xmlTemplate = LocaleBuildUtils.class.getResource("/" + fileName + ".xml");
        Document doc = reader.read(xmlTemplate);
        TransContext context = new TransContext(fileName, doc);
        result[0] = doc.asXML();
        HashMap<String, String> localeMap = new HashMap<String, String>();
        LocaleBuildUtils.parserEntry(localeMap, "bos", fileName, doc, context);
        result[1] = doc.asXML();
        return result;
    }

    public static Document[] buildTemplateDocument(String fileName) throws UnsupportedEncodingException, DocumentException {
        Document[] result = new Document[2];
        SAXReader reader = LocaleBuildUtils.getSaxReader();
        URL xmlTemplate = LocaleBuildUtils.class.getResource("/" + fileName + ".xml");
        Document doc = reader.read(xmlTemplate);
        TransContext context = new TransContext(fileName, doc);
        result[0] = (Document)doc.clone();
        HashMap<String, String> localeMap = new HashMap<String, String>();
        LocaleBuildUtils.parserEntry(localeMap, "bos", fileName, doc, context);
        result[1] = doc;
        return result;
    }

    private static void parserEntry(HashMap<String, String> localeMap, String region, String fileName, Document doc, TransContext context) {
        Iterator it = doc.getRootElement().elementIterator();
        while (it.hasNext()) {
            Element style = (Element)it.next();
            LocaleBuildUtils.parserStyle(localeMap, fileName, style, region, context);
        }
    }

    private static void genEntry(Element sub, HashMap<String, String> localeMap, String fileName, String region, TransContext context) {
        String id = "NULL";
        if (sub.getParent().getName().equals("Property")) {
            id = sub.getParent().attributeValue("oid");
            if (StringUtils.isEmpty((CharSequence)id)) {
                id = sub.getParent().attributeValue("style");
            }
        } else if (sub.getParent().getName().equals("Style")) {
            id = sub.getParent().attributeValue("Id");
        } else if (sub.getParent().getName().equals("ValidationType") || sub.getParent().getName().equals("OpBizRuleType")) {
            id = sub.getParent().element("Id").getText();
        }
        if (sub.getName().equals("Editor")) {
            if (LocaleBuildUtils.hasChineseCharacters(sub.getText()) && sub.getText().indexOf(startStr) < 0) {
                JSONObject root = (JSONObject)JSONObject.parseObject((String)sub.getText(), JSONObject.class, (Feature[])new Feature[]{Feature.OrderedField});
                LocaleBuildUtils.analysisJson(sub, fileName, id, localeMap, root, region, context);
            }
        } else if (sub.getName().equals("Validator")) {
            if (LocaleBuildUtils.hasChineseCharacters(sub.getText()) && sub.getText().indexOf(startStr) < 0 && sub.getText().startsWith("[") && sub.getText().endsWith("]")) {
                JSONObject rootValidator = (JSONObject)JSONObject.parseObject((String)sub.getText().substring(1, sub.getText().length() - 1), JSONObject.class, (Feature[])new Feature[]{Feature.OrderedField});
                LocaleBuildUtils.analysisJson(sub, fileName, id, localeMap, rootValidator, region, context);
            }
        } else if (LocaleBuildUtils.hasChineseCharacters(sub.getData().toString()) && sub.getText().indexOf(startStr) < 0) {
            String resId = context.getNextResId();
            localeMap.put(resId, sub.getData().toString());
            sub.getParent().element(sub.getName()).setText(startStr + resId + splitStr + sub.getData().toString() + endStr);
        }
    }

    private static void analysisJson(Element sub, String fileName, String propertyName, HashMap<String, String> localeMap, JSONObject jsonObject, String region, TransContext context) {
        Set set = jsonObject.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object value = jsonObject.get((Object)key);
            if (value instanceof String) {
                if (!LocaleBuildUtils.hasChineseCharacters((String)value)) continue;
                String resId = context.getNextResId();
                localeMap.put(resId, (String)value);
                String newValue = Matcher.quoteReplacement(startStr + resId + splitStr + value + endStr);
                sub.setText(sub.getText().replaceAll("\"" + LocaleBuildUtils.quoteReplacement((String)value) + "\"", "\"" + newValue + "\""));
                continue;
            }
            if (value instanceof JSONObject) {
                LocaleBuildUtils.analysisJson(sub, fileName, propertyName, localeMap, (JSONObject)value, region, context);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)value;
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (jsonArray.get(i) instanceof String && LocaleBuildUtils.hasChineseCharacters((String)jsonArray.get(i))) {
                    String resId = context.getNextResId();
                    localeMap.put(resId, (String)jsonArray.get(i));
                    String newValue = Matcher.quoteReplacement(startStr + resId + splitStr + (String)jsonArray.get(i) + endStr);
                    sub.setText(sub.getText().replaceAll("\"" + LocaleBuildUtils.quoteReplacement((String)jsonArray.get(i)) + "\"", "\"" + newValue + "\""));
                    continue;
                }
                if (!(jsonArray.get(i) instanceof JSONObject)) continue;
                LocaleBuildUtils.analysisJson(sub, fileName, propertyName, localeMap, (JSONObject)jsonArray.get(i), region, context);
            }
        }
    }

    private static String quoteReplacement(String replaceStr) {
        if (replaceStr.indexOf("\\") != -1) {
            return replaceStr;
        }
        boolean trans = false;
        for (String it : literals) {
            if (it.indexOf(it) == -1) continue;
            trans = true;
            break;
        }
        if (!trans) {
            return replaceStr;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < replaceStr.length(); ++i) {
            char c = replaceStr.charAt(i);
            if (literals.contains(String.valueOf(c))) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void parserStyle(HashMap<String, String> localeMap, String fileName, Element style, String region, TransContext context) {
        for (Element sub : style.elements()) {
            if ("Properties".equals(sub.getName()) || "ElementTypes".equals(sub.getName()) || "ValidationTypes".equals(sub.getName()) || "Property".equals(sub.getName()) || "Types".equals(sub.getName()) || "ValidationType".equals(sub.getName()) || "Categories".equals(sub.getName()) || "Category".equals(sub.getName()) || "ElementType".equals(sub.getName()) || "OpBizRuleTypes".equals(sub.getName()) || "RuleTypes".equals(sub.getName()) || "OpBizRuleType".equals(sub.getName()) || "OperationTypes".equals(sub.getName()) || "OperationType".equals(sub.getName()) || "OpTypes".equals(sub.getName()) || "FormRuleActionTypes".equals(sub.getName()) || "FormRuleActionType".equals(sub.getName()) || "FunctionTypes".equals(sub.getName()) || "FunctionType".equals(sub.getName()) || "FunctionGroups".equals(sub.getName()) || "FunctionGroup".equals(sub.getName())) {
                LocaleBuildUtils.parserStyle(localeMap, fileName, sub, region, context);
            }
            if (!"Name".equals(sub.getName()) && !"Description".equals(sub.getName()) && !"Editor".equals(sub.getName()) && !"Validator".equals(sub.getName()) && !"ApplyForm".equals(sub.getName()) && !"Desc".equals(sub.getName()) && !"RunClass".equals(sub.getName()) && !"SettingFormId".equals(sub.getName()) && !"AppNumbers".equals(sub.getName()) && !"EntityNumber".equals(sub.getName()) && !"OpWhiteList".equals(sub.getName()) && !"OpBlackList".equals(sub.getName()) && !"desc".equals(sub.getName()) && !"title".equals(sub.getName()) && !"tips".equals(sub.getName()) && !"Desc".equals(sub.getName())) continue;
            LocaleBuildUtils.genEntry(sub, localeMap, fileName, region, context);
        }
    }

    public static boolean hasChineseCharacters(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!LocaleBuildUtils.isChineseCharacter(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChineseCharacter(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private static List<String> getVariables(String str) {
        ArrayList<String> variables = new ArrayList<String>();
        Pattern pattern = Pattern.compile(matchPattern);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        return variables;
    }

    private static List<String> getVariables(Element sub) {
        ArrayList<String> variables = new ArrayList<String>();
        Pattern pattern = Pattern.compile(matchPattern);
        Matcher matcher = pattern.matcher(sub.getText());
        while (matcher.find()) {
            variables.add(matcher.group(1));
        }
        Iterator it = sub.elementIterator();
        while (it.hasNext()) {
            variables.addAll(LocaleBuildUtils.getVariables((Element)it.next()));
        }
        return variables;
    }

    public static void replaceLocaleVars(String fileName, Document doc, String lang) {
        LocaleBuildUtils.replaceLocaleVars(fileName, doc.getRootElement(), lang);
    }

    private static void replaceLocaleVars(String fileName, Element sub, String lang) {
        if (sub.getText().indexOf(startStr) >= 0) {
            String result = "";
            fileName = fileName.split("\\.")[0];
            String[] paths = fileName.split("\\\\");
            fileName = paths[paths.length - 1];
            paths = fileName.split("/");
            fileName = paths[paths.length - 1];
            List<String> vars = LocaleBuildUtils.getVariables(sub.getText());
            Iterator<String> iterator = vars.iterator();
            while (iterator.hasNext()) {
                String var;
                result = var = iterator.next();
                result = result.substring(1, var.length() - 1);
                String[] trg = result.split("\\],\\[");
                if (lang.equals(Lang.zh_CN.name())) {
                    sub.setText(sub.getText().replace(replaceStart + var + replaceEnd, trg[1]));
                    continue;
                }
                String v = (String)ResManager.getLocaleString((String)trg[1], (String)trg[0], (String)fileName).getOrDefault((Object)lang, (Object)trg[1]);
                if (StringUtils.isBlank((CharSequence)v)) {
                    sub.setText(sub.getText().replace(replaceStart + var + replaceEnd, trg[1]));
                    continue;
                }
                sub.setText(sub.getText().replace(replaceStart + var + replaceEnd, v));
            }
        }
        Iterator it = sub.elementIterator();
        while (it.hasNext()) {
            LocaleBuildUtils.replaceLocaleVars(fileName, (Element)it.next(), lang);
        }
    }

    public static String replaceLocaleVars(String fileName, String src, String lang) {
        if (src.indexOf(startStr) >= 0) {
            String result = "";
            fileName = fileName.split("\\.")[0];
            List<String> vars = LocaleBuildUtils.getVariables(src);
            Iterator<String> iterator = vars.iterator();
            while (iterator.hasNext()) {
                String var;
                result = var = iterator.next();
                result = result.substring(1, var.length() - 1);
                String[] trg = result.split("\\],\\[");
                if (lang.equals(Lang.zh_CN.name())) {
                    src = src.replace(replaceStart + var + replaceEnd, trg[1]);
                    continue;
                }
                String v = (String)ResManager.getLocaleString((String)trg[1], (String)trg[0], (String)fileName).getOrDefault((Object)lang, (Object)trg[1]);
                if (StringUtils.isBlank((CharSequence)v)) {
                    src = src.replace(replaceStart + var + replaceEnd, trg[1]);
                    continue;
                }
                src = src.replace(replaceStart + var + replaceEnd, v);
            }
        }
        return src;
    }

    public static void main(String[] args) throws DocumentException, UnsupportedEncodingException {
        LocaleBuildUtils.buildTemplateDocument("FormItemProperty");
    }

    static {
        literals.add("$");
        literals.add("{");
        literals.add("[");
        literals.add("(");
        literals.add(")");
        literals.add("}");
    }

    static class TransContext {
        private String prefix;
        private int index = 0;
        private Map<String, String> resMap = new LinkedHashMap<String, String>(3);

        public TransContext(String fileName, Document doc) {
            this.prefix = fileName.split("\\.")[0];
            List vars = LocaleBuildUtils.getVariables(doc.getRootElement());
            if (vars.isEmpty()) {
                this.index = 0;
            } else {
                for (String var : vars) {
                    var = var.substring(1, var.length() - 1);
                    String[] trg = var.split("\\],\\[");
                    this.resMap.put(trg[0], trg[1]);
                    String propIndex = trg[0].substring(trg[0].lastIndexOf("_") + 1);
                    this.index = Math.max(this.index, Integer.parseInt(propIndex));
                }
            }
        }

        public Map<String, String> getExistsRes() {
            return this.resMap;
        }

        public String getNextResId() {
            ++this.index;
            return this.prefix + "_" + this.index;
        }
    }
}

