/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.utils.SecurityTypeEnum;

public class LogPrintUtil {
    private static Log log = LogFactory.getLog(LogPrintUtil.class);

    private LogPrintUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void printExceptionMessage(Exception e, String msg) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            e.printStackTrace(new PrintStream(baos));
            String exception = baos.toString();
            log.warn(msg + exception);
        }
        catch (IOException e1) {
            log.warn((Throwable)e1);
        }
    }

    public static void writeLog(SecurityTypeEnum type, AppLogInfo logInfo) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logInfo.setOpDescription(type.getName() + ":" + logInfo.getOpDescription());
        logService.addLog(logInfo);
    }

    public static void writeLog(SecurityTypeEnum type, String msg) {
        LogPrintUtil.writeLog(type, msg, null, null, null, null, null);
    }

    public static void writeLog(SecurityTypeEnum type, String msg, String opName, String bizObjId, Long orgId, String clientType, String appId) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(bizObjId);
        if (orgId != null && Long.compare(0L, orgId) != 0) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        if (StringUtils.isBlank((CharSequence)clientType)) {
            logInfo.setClientType(RequestContext.get().getClient());
        } else {
            logInfo.setClientType(clientType);
        }
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(type.getName() + ":" + msg);
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        logService.addLog(logInfo);
    }
}

