/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BaseDataCtrlCache {
    private static final int TIMEOUT = 30;

    private BaseDataCtrlCache() {
    }

    public static String getCtrlStrgy(String key) {
        String ctrlStrgy = null;
        String type = BaseDataCtrlCacheMrg.getType4CtrlStrgy();
        ctrlStrgy = BaseDataCtrlCacheMrg.getCache(type, key);
        return ctrlStrgy;
    }

    private static String loadCtrlStrgyCache(String key) {
        String ctrlStrgy = null;
        String type = BaseDataCtrlCacheMrg.getType4CtrlStrgy();
        ctrlStrgy = BaseDataCtrlCacheMrg.getCache(type, key);
        if (BaseDataCtrlCacheMrg.isLoaded(ctrlStrgy) && BaseDataCtrlCacheMrg.isData(ctrlStrgy)) {
            return ctrlStrgy;
        }
        return null;
    }

    public static void updateCrtlStrgyCache(String key, String ctrlStrgy) {
        String type = BaseDataCtrlCacheMrg.getType4CtrlStrgy();
        if (StringUtils.isEmpty((Object)ctrlStrgy)) {
            BaseDataCtrlCacheMrg.loaded(type, key);
        } else {
            BaseDataCtrlCacheMrg.putCache(type, key, ctrlStrgy);
        }
    }

    public static String getVerifyOrgProperty(String key) {
        String orgProperty = null;
        String type = BaseDataCtrlCacheMrg.getType4VerifyOrgProperty();
        orgProperty = BaseDataCtrlCacheMrg.getCache(type, key);
        return orgProperty;
    }

    public static void updateVerifyOrgPropertyCache(String key, String orgProperty) {
        String type = BaseDataCtrlCacheMrg.getType4VerifyOrgProperty();
        if (StringUtils.isEmpty((Object)orgProperty)) {
            BaseDataCtrlCacheMrg.loaded(type, key);
        } else {
            BaseDataCtrlCacheMrg.putCache(type, key, orgProperty);
        }
    }

    public static String getBaseDataCtrlPlugin(String entityType) {
        String baseDataCtrlPluginStr = null;
        String type = BaseDataCtrlCacheMrg.getType4BaseDataCtrlPlugin();
        baseDataCtrlPluginStr = BaseDataCtrlCacheMrg.getCache(type, entityType);
        return baseDataCtrlPluginStr;
    }

    public static void updateBaseDataCtrlPlugin(String entityType, String baseDataCtrlPluginStr) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataCtrlPlugin();
        if (StringUtils.isEmpty((Object)baseDataCtrlPluginStr)) {
            BaseDataCtrlCacheMrg.loaded(type, entityType);
        } else {
            BaseDataCtrlCacheMrg.putCache(type, entityType, baseDataCtrlPluginStr);
        }
    }

    public static String getBaseDataFilter(String key) {
        String baseDataFilterCache = null;
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        baseDataFilterCache = BaseDataCtrlCacheMrg.getCache(type, key);
        return baseDataFilterCache;
    }

    public static void updateBaseDataFilter(String key, String baseDataIdsFilter) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        if (StringUtils.isEmpty((Object)baseDataIdsFilter)) {
            BaseDataCtrlCacheMrg.loaded(type, key);
        } else {
            BaseDataCtrlCacheMrg.putCache(type, key, baseDataIdsFilter);
        }
    }

    public static boolean hasBaseDataUseRange(String key) {
        boolean baseDataUseRangeCacheFlag = false;
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        String baseDataUseRangeCacheFlagStr = BaseDataCtrlCacheMrg.getCache(type, key);
        baseDataUseRangeCacheFlag = "true".equals(baseDataUseRangeCacheFlagStr) || BaseDataCtrlCacheMrg.isLoaded(baseDataUseRangeCacheFlagStr);
        return baseDataUseRangeCacheFlag;
    }

    public static Map<String, Boolean> hasBaseDataUseRangeBatch(String entityID) {
        Boolean baseDataUseRangeCacheFlag = Boolean.FALSE;
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        Map<String, String> cacheMap = BaseDataCtrlCacheMrg.getCache(type);
        if (!CollectionUtils.isEmpty(cacheMap)) {
            HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(cacheMap.size());
            Set<Map.Entry<String, String>> enrtrySet = cacheMap.entrySet();
            for (Map.Entry<String, String> enrtry : enrtrySet) {
                String key = enrtry.getKey();
                if (!key.contains(entityID)) continue;
                String baseDataUseRangeCacheFlagStr = enrtry.getValue();
                baseDataUseRangeCacheFlag = "true".equals(baseDataUseRangeCacheFlagStr) || BaseDataCtrlCacheMrg.isLoaded(baseDataUseRangeCacheFlagStr) ? Boolean.TRUE : Boolean.FALSE;
                resultMap.put(key, baseDataUseRangeCacheFlag);
            }
            return resultMap;
        }
        return new HashMap<String, Boolean>(1);
    }

    public static void updateBaseDataUseRange(String key, String baseDataUseRangeCacheFlag) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        if (StringUtils.isEmpty((Object)baseDataUseRangeCacheFlag)) {
            BaseDataCtrlCacheMrg.loaded(type, key);
        } else {
            BaseDataCtrlCacheMrg.putCache(type, key, baseDataUseRangeCacheFlag);
        }
    }

    public static void updateBaseDataUseRangeBatch(Map<String, String> paramMap) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        if (CollectionUtils.isEmpty(paramMap)) {
            return;
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>(paramMap.size());
        Set<Map.Entry<String, String>> entrySet = paramMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String baseDataUseRangeCacheFlag = entry.getValue();
            if (StringUtils.isEmpty((Object)baseDataUseRangeCacheFlag)) {
                baseDataUseRangeCacheFlag = "DATA_LOADED";
            }
            cacheMap.put(key, baseDataUseRangeCacheFlag);
        }
        BaseDataCtrlCacheMrg.putCache(type, cacheMap);
    }

    public static void clearBaseDataUseRange(String entityID, Long orgID) {
        if (orgID == null) {
            return;
        }
        if (orgID == 0L) {
            BaseDataCtrlCache.clearWithPrefixBaseDataUseRange(entityID);
            return;
        }
        String key = entityID + orgID;
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        BaseDataCtrlCacheMrg.clearCache(type, key);
    }

    public static void clearBaseDataUseRange(String entityID, Set<Long> clearOrgSet) {
        HashSet<String> keySet = new HashSet<String>(clearOrgSet.size());
        for (Long orgID : clearOrgSet) {
            keySet.add(entityID + orgID);
        }
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        if (keySet.size() > 0) {
            BaseDataCtrlCacheMrg.clearCache(type, keySet.toArray(new String[0]));
        }
    }

    public static void clearBaseDataFilter(String entityID, Set<Long> clearOrgSet) {
        HashSet<String> keySet = new HashSet<String>(clearOrgSet.size());
        for (Long orgID : clearOrgSet) {
            keySet.add(entityID + orgID);
        }
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        if (keySet.size() > 0) {
            BaseDataCtrlCacheMrg.clearCache(type, keySet.toArray(new String[0]));
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityID);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
        cacheManager.removeByDt();
    }

    public static void clearWithPrefixBaseDataUseRange(String entityID) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataUseRange();
        BaseDataCtrlCacheMrg.clearCacheWithPrefix(type, entityID);
    }

    private static DBRoute getDBRouteByEntityID(String entityID) {
        DBRoute dbRoute = null;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityID);
        String dbRouteKey = entityType.getDBRouteKey();
        dbRoute = DBRoute.of((String)dbRouteKey);
        return dbRoute;
    }

    public static Boolean hasGlobalShareData(String entityID) {
        Boolean hasGlobalShareData = null;
        String type = BaseDataCtrlCacheMrg.getType4HasGlobalShareData();
        String hasGlobalShareDataCache = BaseDataCtrlCacheMrg.getCache(type, entityID);
        if (null != hasGlobalShareDataCache) {
            hasGlobalShareData = Boolean.valueOf(hasGlobalShareDataCache);
        }
        return hasGlobalShareData;
    }

    public static void updateHasGlobalShareData(String entityID, Boolean value) {
        String type = BaseDataCtrlCacheMrg.getType4HasGlobalShareData();
        if (null != value) {
            BaseDataCtrlCacheMrg.putCache(type, entityID, String.valueOf(value), 30);
        }
    }

    public static void cleanHasGlobalShareData(String entityID) {
        String type = BaseDataCtrlCacheMrg.getType4HasGlobalShareData();
        BaseDataCtrlCacheMrg.clearCache(type, entityID);
    }

    public static Boolean hasNonGlobalShareData(String entityID) {
        Boolean hasGlobalShareData = null;
        String type = BaseDataCtrlCacheMrg.getType4HasNonGlobalShareData();
        String hasGlobalShareDataCache = BaseDataCtrlCacheMrg.getCache(type, entityID);
        if (null != hasGlobalShareDataCache) {
            hasGlobalShareData = Boolean.valueOf(hasGlobalShareDataCache);
        }
        return hasGlobalShareData;
    }

    public static void updateHasNonGlobalShareData(String entityID, Boolean value) {
        String type = BaseDataCtrlCacheMrg.getType4HasNonGlobalShareData();
        if (null != value) {
            BaseDataCtrlCacheMrg.putCache(type, entityID, String.valueOf(value), 30);
        }
    }

    public static void cleanHasNonGlobalShareData(String entityID) {
        String type = BaseDataCtrlCacheMrg.getType4HasNonGlobalShareData();
        BaseDataCtrlCacheMrg.clearCache(type, entityID);
    }

    public static Boolean isHasBaseDataUseRange(String entityID, Long orgID) {
        String key;
        Boolean isHasBaseDataUseRange = null;
        String type = BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityID;
        String isHasBaseDataUseRangeCache = BaseDataCtrlCacheMrg.getCache(type, key = String.valueOf(orgID));
        if (null != isHasBaseDataUseRangeCache) {
            isHasBaseDataUseRange = Boolean.valueOf(isHasBaseDataUseRangeCache);
        }
        return isHasBaseDataUseRange;
    }

    public static Map<Long, Boolean> isHasBaseDataUseRangeBatch(String entityID, List<Long> orgIds) {
        if (StringUtils.isEmpty((Object)entityID) || CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, Boolean>(1);
        }
        HashMap<Long, Boolean> orgBDUseRangeMap = new HashMap<Long, Boolean>(orgIds.size());
        String type = BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityID;
        Map<String, String> orgBDUseRangeCache = BaseDataCtrlCacheMrg.getCache(type);
        for (Long orgID : orgIds) {
            String isHasBaseDataUseRangeCache = orgBDUseRangeCache.get(String.valueOf(orgID));
            if (null == isHasBaseDataUseRangeCache) continue;
            Boolean isHasBaseDataUseRange = Boolean.valueOf(isHasBaseDataUseRangeCache);
            orgBDUseRangeMap.put(orgID, isHasBaseDataUseRange);
        }
        return orgBDUseRangeMap;
    }

    public static void updateIsHasBaseDataUseRange(String entityID, Long orgID, Boolean value) {
        String type = BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityID;
        if (null != value) {
            String key = String.valueOf(orgID);
            BaseDataCtrlCacheMrg.putCache(type, key, String.valueOf(value), 30);
        }
    }

    public static void updateIsHasBaseDataUseRangeBatch(String entityID, Map<Long, Boolean> paramMap) {
        String type = BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityID;
        if (!CollectionUtils.isEmpty(paramMap)) {
            HashMap<String, String> cacheMap = new HashMap<String, String>(paramMap.size());
            Set<Map.Entry<Long, Boolean>> entrySet = paramMap.entrySet();
            for (Map.Entry<Long, Boolean> entry : entrySet) {
                cacheMap.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            BaseDataCtrlCacheMrg.putCache(type, cacheMap, 30);
        }
    }

    public static void cleanIsHasBaseDataUseRange(String entityID) {
        String type = BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityID;
        BaseDataCtrlCacheMrg.clearCache(type, entityID);
    }

    public static void cleanIsHasBaseDataUseRange(String entityID, Collection<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        String type = BaseDataCtrlCacheMrg.getType4isHasBaseDataUseRange() + entityID;
        String[] keys = (String[])orgIds.stream().map(String::valueOf).distinct().toArray(String[]::new);
        BaseDataCtrlCacheMrg.clearCache(type, keys);
    }

    public static List<Long> getGlobalShareDataCreateOrg(String entityID) {
        String type = BaseDataCtrlCacheMrg.getType4GlobalShareDataCreateOrg();
        String[] orgArr = BaseDataCtrlCacheMrg.getListCache(type, entityID);
        return null != orgArr ? Stream.of(orgArr).filter(Objects::nonNull).map(Long::valueOf).collect(Collectors.toList()) : Collections.emptyList();
    }

    public static void updateGlobalShareDataCreateOrg(String entityID, List<Long> createOrgIds) {
        String type = BaseDataCtrlCacheMrg.getType4GlobalShareDataCreateOrg();
        String[] value = null != createOrgIds ? (String[])createOrgIds.stream().map(String::valueOf).toArray(String[]::new) : new String[]{};
        BaseDataCtrlCacheMrg.putListCache(type, entityID, value, 30);
    }

    public static Boolean isHasIndividualData(String entityID) {
        Boolean isHasBaseDataUseRange = null;
        String type = BaseDataCtrlCacheMrg.getType4isHasIndividualData();
        String isHasBaseDataUseRangeCache = BaseDataCtrlCacheMrg.getCache(type, entityID);
        if (null != isHasBaseDataUseRangeCache) {
            isHasBaseDataUseRange = Boolean.valueOf(isHasBaseDataUseRangeCache);
        }
        return isHasBaseDataUseRange;
    }

    public static void updateIsHasIndividualData(String entityID, Boolean value) {
        String type = BaseDataCtrlCacheMrg.getType4isHasIndividualData();
        if (null != value) {
            BaseDataCtrlCacheMrg.putCache(type, entityID, String.valueOf(value), 30);
        }
    }
}

