/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.cache;

import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BaseDataCtrlCacheMrg {
    private static final String BD_CTRL_REGION = "BD_CTRL";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BD_CTRL", new DistributeCacheHAPolicy());
    private static final String BD_CTRL = "BD_CTRL_";
    public static final String DATA_BD_CTRL_STRGY = "BD_CTRL_STRGY";
    public static final String DATA_BD_VERIFY_ORG_PROPERTY = "BD_CTRL_VERIFY_ORG_PROPERTY";
    public static final String DATA_BD_CTRL_PLUGIN = "BD_CTRL_PLUGIN";
    public static final String DATA_BD_FILTER = "BD_CTRL_FILTER";
    public static final String DATA_BD_USE_RANGE = "BD_CTRL_USE_RANGE";
    public static final String DATA_LOADED = "DATA_LOADED";
    private static final String HAS_GLOBALSHAREDATA = "BD_CTRL_HAS_GLOBALSHAREDATA";
    private static final String HAS_NONGLOBALSHAREDATA = "BD_CTRL_HAS_NONGLOBALSHAREDATA";
    private static final String IS_HAS_BASEDATAUSERANGE = "BD_CTRL_IS_HAS_BASEDATAUSERANGE";
    private static final String GLOBAL_SHARE_DATA_CREATE_ORG = "BD_CTRL_GLOBAL_SHARE_DATA_CREATE_ORG";
    private static final String IS_HAS_INDIVIDUAL_DATA = "BD_CTRL_IS_HAS_INDIVIDUAL_DATA";

    private BaseDataCtrlCacheMrg() {
    }

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u4e3a\u7a7a.", (String)"BaseDataCtrlCacheMrg_0", (String)"bos-business-dao", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static LocalMemoryCache getLocalCtrlCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1200);
        info.setMaxMemSize(10000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(BaseDataCtrlCacheMrg.getAcctId(), BD_CTRL_REGION, info);
    }

    public static String getType4CtrlStrgy() {
        return "BD_CTRL_STRGY_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static void clearAllCache() {
        cache.removeType(BaseDataCtrlCacheMrg.getType4CtrlStrgy());
    }

    public static void clearCache(String type) {
        cache.removeType(type);
    }

    public static void clearCache(String type, String key) {
        cache.remove(type, key);
    }

    public static void clearCache(String type, String[] keys) {
        cache.remove(type, keys);
    }

    public static void clearCacheWithPrefix(String type, String keyPrefix) {
        List keyList = cache.getKeysWithPrefix(type, keyPrefix);
        if (keyList.size() > 0) {
            cache.remove(type, keyList.toArray(new String[0]));
        }
    }

    private static void cacheRemove(String type, String key) {
        cache.remove(type, key);
    }

    public static String getCache(String type, String key) {
        return (String)cache.get(type, key);
    }

    public static void putCache(String type, String key, String value) {
        cache.put(type, key, (Object)value);
    }

    public static void putCache(String type, Map<String, String> values) {
        cache.put(type, values);
    }

    public static Map<String, String> getCache(String type) {
        return cache.getAll(type);
    }

    public static void loaded(String type, String key) {
        cache.put(type, key, (Object)DATA_LOADED);
    }

    public static void putCache(String type, String key, String value, int timeout) {
        cache.put(type, key, value, timeout);
    }

    public static void putCache(String type, Map<String, String> values, int timeout) {
        cache.put(type, values, timeout);
    }

    public static String[] getListCache(String type, String key) {
        return cache.getList(type + key);
    }

    public static void putListCache(String type, String key, String[] value, int timeout) {
        cache.addList(type + key, value, timeout);
    }

    public static boolean isData(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        return !value.equals(DATA_LOADED);
    }

    public static boolean isLoaded(String value) {
        return value != null && value.length() != 0;
    }

    public static String getType4VerifyOrgProperty() {
        return "BD_CTRL_VERIFY_ORG_PROPERTY_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4BaseDataCtrlPlugin() {
        return "BD_CTRL_PLUGIN_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4BaseDataFilter() {
        return "BD_CTRL_FILTER_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4BaseDataUseRange() {
        return "BD_CTRL_USE_RANGE_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4HasGlobalShareData() {
        return "BD_CTRL_HAS_GLOBALSHAREDATA_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4HasNonGlobalShareData() {
        return "BD_CTRL_HAS_NONGLOBALSHAREDATA_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4isHasBaseDataUseRange() {
        return "BD_CTRL_IS_HAS_BASEDATAUSERANGE_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4GlobalShareDataCreateOrg() {
        return "BD_CTRL_GLOBAL_SHARE_DATA_CREATE_ORG_" + BaseDataCtrlCacheMrg.getAcctId();
    }

    public static String getType4isHasIndividualData() {
        return "BD_CTRL_IS_HAS_INDIVIDUAL_DATA_" + BaseDataCtrlCacheMrg.getAcctId();
    }
}

