/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import org.apache.commons.beanutils.ConvertUtils;

public class BasedataGroupManager {
    private static String ERROR = "Error:%s";
    private static final String FNAME = "fname";
    private static final String FNUMBER = "fnumber";
    private static final String FPARENTID = "fparentid";
    private static final String PROJECTNAME = "bos-business-dao";

    public static void getGroupInfo(String pk, DynamicObjectType dt) {
        BusinessDataReader.loadFromCache(new String[]{pk}, dt);
    }

    public static void save(DynamicObject[] dataEntities) {
        BusinessDataWriter.save(null, dataEntities);
    }

    public static boolean createGroupTable(String groupTableName, String dbRouteKey) {
        if (StringUtils.isBlank((CharSequence)groupTableName) || groupTableName.length() > 30 || !BasedataGroupManager.isJavaIdentifier(groupTableName)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"groupTableName:", groupTableName});
        }
        if (StringUtils.isBlank((CharSequence)groupTableName)) {
            return false;
        }
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        String sql = String.format("IF NOT EXISTS(SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s (FID\tINT NOT NULL, FNUMBER\tnvarchar(50) NOT NULL,\tFPARENTID\tint default 0,\tFFULLNUMBER\tnvarchar(300),\tFLEVEL\tint, FISLEAF\tCHAR(1) )", groupTableName.toUpperCase(), groupTableName.toUpperCase());
        DB.execute((DBRoute)dbRoute, (String)sql, null);
        String langSql = String.format("IF NOT EXISTS(SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s (FPKID\tvarchar(36) NOT NULL,\tFID\tint NOT NULL, FLOCALEID\tvarchar(10) NOT NULL,\tFNAME\tnvarchar(80),\tFFULLNAME\tnvarchar(500),\tFDESCRIPTION\tnvarchar(300))", groupTableName.toUpperCase() + "_L", groupTableName.toUpperCase() + "_L");
        return DB.execute((DBRoute)dbRoute, (String)langSql, null);
    }

    public static boolean existsGroupTable(String groupTableName, String dbRouteKey) {
        ResultSetHandler<Object> callBackHanlder;
        Object[] sqlParas;
        if (StringUtils.isBlank((CharSequence)groupTableName) || groupTableName.length() > 30 || !BasedataGroupManager.isJavaIdentifier(groupTableName)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"groupTableName:", groupTableName});
        }
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        String sql = String.format("SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s'", groupTableName.toUpperCase());
        int ret = (Integer)DB.query((DBRoute)dbRoute, (String)sql, (Object[])(sqlParas = new SqlParameter[0]), (ResultSetHandler)(callBackHanlder = new ResultSetHandler<Object>(){

            public Object handle(ResultSet rs) throws KDException {
                int iRet = 0;
                try {
                    if (rs.next() && rs.getInt(1) != 0) {
                        iRet = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR, e.getMessage())});
                }
                return iRet;
            }
        }));
        if (StringUtils.isBlank((Object)ret)) {
            ret = 0;
        }
        return ret == 1;
    }

    public static List<Map<String, Object>> getTableData(String tableName) {
        List formList;
        Object[] params = new SqlParameter[]{};
        if (StringUtils.isBlank((CharSequence)tableName) || tableName.length() > 30 || !BasedataGroupManager.isJavaIdentifier(tableName)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"tableName:", tableName});
        }
        String sql = "select b.FID, a.FNAME, b.FNUMBER,a.FDESCRIPTION,b.FPARENTID from " + tableName.toUpperCase() + "_L a inner join " + tableName.toUpperCase() + " b on a.FID = b.FID and a.FLOCALEID='zh_CN'";
        try {
            ResultSetHandler<Object> callBackHanlder = new ResultSetHandler<Object>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws KDException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                    try {
                        while (rs.next()) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("fid", rs.getString(1));
                            map.put(BasedataGroupManager.FNAME, rs.getString(2));
                            map.put(BasedataGroupManager.FNUMBER, rs.getString(3));
                            map.put("fdescription", rs.getString(4));
                            map.put(BasedataGroupManager.FPARENTID, rs.getString(5));
                            list.add(map);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR, e.getMessage())});
                    }
                    return list;
                }
            };
            formList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return formList;
    }

    public static Map<String, Object> getTableColumnValue(List<Map<String, Object>> list, String fid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (list == null || list.size() < 1) {
            return map;
        }
        for (Map<String, Object> para : list) {
            if (!fid.equals(para.get("fid"))) continue;
            map.putAll(para);
        }
        return map;
    }

    public static TreeNode getTreeNode(List<Map<String, Object>> list) {
        TreeNode node;
        HashMap<String, TreeNode> nodeList = new HashMap<String, TreeNode>(16);
        TreeNode root = null;
        TreeNode parentNode = new TreeNode();
        parentNode.setParentid("");
        parentNode.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BasedataGroupManager_0", (String)PROJECTNAME, (Object[])new Object[0]));
        parentNode.setId("0");
        if (list == null || list.size() < 1) {
            return parentNode;
        }
        nodeList.put(parentNode.getId(), parentNode);
        for (Map<String, Object> dataRecord : list) {
            node = new TreeNode();
            node.setId((String)dataRecord.get("fid"));
            node.setText((String)dataRecord.get(FNAME) + "(" + (String)dataRecord.get(FNUMBER) + ")");
            node.setParentid((String)dataRecord.get(FPARENTID));
            nodeList.put(node.getId(), node);
        }
        Set entrySet = nodeList.entrySet();
        Iterator it = entrySet.iterator();
        while (it.hasNext()) {
            node = (TreeNode)it.next().getValue();
            if (node.getParentid() == null || node.getParentid().equals("")) {
                root = node;
                continue;
            }
            ((TreeNode)nodeList.get(node.getParentid())).addChild(node);
        }
        return root;
    }

    public static TreeNode keywordTree(List<Map<String, Object>> formList, List<String> listId) {
        TreeNode root = null;
        if (!listId.isEmpty()) {
            HashMap<String, Map<String, Object>> mapNode = new HashMap<String, Map<String, Object>>(16);
            HashMap resultMap = new HashMap(16);
            for (Map<String, Object> map : formList) {
                mapNode.put((String)map.get("fid"), map);
            }
            for (String str : listId) {
                resultMap.put(str, mapNode.get(str));
                String parentid = ((Map)mapNode.get(str)).get(FPARENTID).toString();
                for (int i = 0; i < formList.size() && mapNode.get(parentid) != null; ++i) {
                    resultMap.put(parentid, mapNode.get(parentid));
                    parentid = ((Map)mapNode.get(parentid)).get(FPARENTID).toString();
                }
            }
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(16);
            for (Map map : resultMap.values()) {
                resultList.add(map);
            }
            root = BasedataGroupManager.getTreeNode(resultList);
        }
        return root;
    }

    public static Boolean saveGroup(Map<String, Object> colunmMap, String dbRouteKey) {
        int fparentid = Integer.parseInt((String)colunmMap.get(FPARENTID));
        String fnumber = colunmMap.get(FNUMBER).toString();
        String fname = colunmMap.get(FNAME).toString();
        String fdescription = colunmMap.get("fdescription").toString();
        String tableName = colunmMap.get("tableName").toString().toUpperCase();
        String update = "";
        String update_l = "";
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        Object fid = colunmMap.get("fid");
        if (fid != null && !fid.toString().isEmpty()) {
            int id = Integer.parseInt((String)fid);
            update = String.format("update %s set(FPARENTID, FNUMBER) = (%s, '%s') where FID = %s;", tableName, fparentid, fnumber, id);
            if (!DB.execute((DBRoute)dbRoute, (String)update, null)) {
                return Boolean.FALSE;
            }
            update_l = String.format("update %s set(FNAME, FDESCRIPTION) = ('%s', '%s') where FPKID = %s;", tableName, fname, fnumber, id);
        } else {
            List formList;
            update = String.format("insert into %s (FPARENTID, FNUMBER) values(%s, '%s')", tableName, fparentid, fnumber);
            if (!DB.execute((DBRoute)dbRoute, (String)update, null)) {
                return Boolean.FALSE;
            }
            Object[] params = new SqlParameter[]{};
            String sql = "select FID from " + tableName + " where FPARENTID = " + fparentid + " and FNUMBER = " + fnumber;
            try {
                ResultSetHandler<List<Map<String, Object>>> callBackHanlder = new ResultSetHandler<List<Map<String, Object>>>(){

                    public List<Map<String, Object>> handle(ResultSet rs) throws KDException {
                        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                        try {
                            while (rs.next()) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("fid", rs.getString(1));
                                list.add(map);
                            }
                        }
                        catch (SQLException e) {
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(ERROR, e.getMessage())});
                        }
                        return list;
                    }
                };
                formList = (List)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, (ResultSetHandler)callBackHanlder);
            }
            catch (Exception e) {
                String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            update_l = String.format("insert into %s (FPKID, FNAME, FDESCRIPTION) values(%s, '%s', '%s');", tableName + "_L", formList.get(0), fname, fdescription);
        }
        return DB.execute((DBRoute)dbRoute, (String)update_l, null);
    }

    private static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public IOperationResult deleteFormGroup(Object[] ids, GroupProp prop) {
        OperationResult operRes = new OperationResult();
        for (int i = 0; i < ids.length; ++i) {
            Class type = prop.getDynamicComplexPropertyType().getPrimaryKey().getPropertyType();
            if (ids[i].getClass() == type) continue;
            ids[i] = ConvertUtils.convert((Object)ids[i], (Class)type);
        }
        ArrayList pkIdList = new ArrayList(ids.length);
        Collections.addAll(pkIdList, ids);
        operRes.setSuccessPkIds(pkIdList);
        ORM orm = ORM.create();
        String group = prop.getName();
        String id = prop.getComplexType().getPrimaryKey().getName();
        String name = prop.getDisplayProp();
        String groupId = group + "." + id;
        String groupName = group + "." + name;
        for (IDataEntityProperty pro : prop.getEntityType().getProperties()) {
            if (!(pro instanceof ParentBasedataProp)) continue;
            String parent = pro.getName();
            String parentId = parent + "." + id;
            String parentName = parent + "." + name;
            QFilter p = new QFilter(parent, "in", (Object)ids);
            QFilter[] a = new QFilter[]{p};
            StringBuilder stringBuilder = new StringBuilder();
            String strs = stringBuilder.append(id).append(',').append(name).append(',').append(parentId).append(',').append(parentName).toString();
            DynamicObjectCollection doc = orm.query(prop.getBaseEntityId(), strs, a);
            for (DynamicObject dy : doc) {
                Object childNodeText = dy.get(name);
                Object currentNodeId = ((DynamicObject)dy.get(parent)).get(id);
                Object currentNodeText = ((DynamicObject)dy.get(parent)).get(name);
                String message = String.format(ResManager.loadKDString((String)"\u8be5\u5206\u7ec4\u4e0b\u5177\u6709\u5b50\u5206\u7ec4%s\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"BasedataGroupManager_1", (String)PROJECTNAME, (Object[])new Object[0]), childNodeText);
                OperateErrorInfo info = new OperateErrorInfo("error_001", ErrorLevel.Error, currentNodeId);
                info.setPkValue(currentNodeId);
                info.setTitle(currentNodeText == null ? "" : currentNodeText.toString());
                info.setMessage(message);
                pkIdList.remove(currentNodeId);
                operRes.addErrorInfo(info);
            }
        }
        QFilter f = new QFilter(group, "in", (Object)ids);
        QFilter[] q = new QFilter[]{f};
        StringBuilder stringBuilder = new StringBuilder();
        String strs = stringBuilder.append(id).append(',').append(groupId).append(',').append(groupName).toString();
        DynamicObjectCollection doc = orm.query(prop.getParent().getName(), strs, q);
        for (DynamicObject dy : doc) {
            Object nodeId = dy.get(groupId);
            Object nodeText = dy.get(groupName);
            String message = String.format(ResManager.loadKDString((String)"%s\u4e0b\u5df2\u6709\u660e\u7ec6\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01", (String)"BasedataGroupManager_2", (String)PROJECTNAME, (Object[])new Object[0]), nodeText);
            OperateErrorInfo info = new OperateErrorInfo("error_001", ErrorLevel.Error, nodeId);
            info.setPkValue(nodeId);
            info.setTitle(nodeText == null ? "" : nodeText.toString());
            info.setMessage(message);
            pkIdList.remove(nodeId);
            operRes.addErrorInfo(info);
        }
        if (pkIdList != null && !pkIdList.isEmpty()) {
            f = new QFilter(id, "in", (Object)pkIdList.toArray());
            q = new QFilter[]{f};
            doc = orm.query(prop.getBaseEntityId(), id + "," + name, q);
            orm.delete(prop.getBaseEntityId(), q);
        }
        return operRes;
    }

    public boolean treeNodeUpdate(Object currentId, Object newParentId, GroupProp prop) {
        Class type = prop.getDynamicComplexPropertyType().getPrimaryKey().getPropertyType();
        Object id = currentId;
        if (currentId != type) {
            id = ConvertUtils.convert((Object)currentId, (Class)type);
        }
        ORM orm = ORM.create();
        QFilter f = new QFilter("id", "=", id);
        QFilter[] q = new QFilter[]{f};
        DynamicObjectCollection obj = orm.query(prop.getBaseEntityId(), q);
        for (DynamicObject dynamicObject : obj) {
            dynamicObject.set("parent", newParentId);
        }
        return orm.update((List)obj) > 0;
    }
}

