/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedataref;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.basedataref.BaseDataRefrenceTable;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BaseDataCheckRefrence {
    private static final Log log = LogFactory.getLog(BaseDataCheckRefrence.class);
    private static final String ENTITY_BD_IGNORE_REF_CHECK = "bd_ignorerefcheck";
    private static final String SQL_EXISTED_BILL = "select %s from %s where %s in (%s) ";
    private static final String SQL_EXISTED_FLEX = "select %s, fid from %s where fflexfield = '%s' and fvalue in (%s) ";
    private static final String SQL_READSAMETABLEOBJECTTYPES = "select fid from t_meta_mainentityinfo where ftablename = ? and fpkfieldname = ?  ";
    private static final String SQL_READOBJECTTYPEREF = "select t1.FObjectTypeId, t1.FTableName, t1.FFieldName, t3.FDBRoute, t4.ftablename as fmaintable, t1.fassttypeid, t1.FSqlLoadIdByTime  from t_meta_objecttyperef t1 inner join t_meta_entitydesign t2 on (t1.FObjectTypeId = t2.FNumber) left join t_meta_bizapp t3 on (t2.fbizappid = t3.fid) left join t_meta_mainentityinfo t4 on (t1.FObjectTypeId = t4.fid) ";
    private static final String SQL_READFLEXTYPEREF = "select t0.fformid, t1.fflexfield, t1.fassistanttype from t_bas_flex t0 inner join t_bas_flex_property t1 on (t0.fid = t1.fid) where t1.fvaluesource in (%s) ";
    Map<String, DBRoute> dbRouteMap = new HashMap<String, DBRoute>();
    Set<String> ignoreRefEntityIds = new HashSet<String>();
    Set<String> checkRefEntityIds = new HashSet<String>();
    private boolean draftValidReference = false;
    private Set<String> asstTypeIds = new HashSet<String>(1);
    private Date bdCreateTime = null;

    public void createRefTable(DBRoute dbRoute, BaseDataRefenceKey refKey) {
        BaseDataRefrenceTable.createRefTable(dbRoute, refKey);
    }

    public void createOrUpdateRefStatus(Collection<BaseDataRefenceKey> refKeys) {
        BaseDataRefrenceTable.createOrUpdateRefStatus(refKeys);
    }

    public void deleteRefStatus(Collection<BaseDataRefenceKey> refKeys) {
        BaseDataRefrenceTable.deleteRefStatus(refKeys);
    }

    public Set<String> getIgnoreRefEntityIds() {
        return this.ignoreRefEntityIds;
    }

    public Set<String> getCheckRefEntityIds() {
        return this.checkRefEntityIds;
    }

    public boolean isDraftValidReference() {
        return this.draftValidReference;
    }

    public void setDraftValidReference(boolean draftValidReference) {
        this.draftValidReference = draftValidReference;
    }

    public Set<String> getAsstTypeIds() {
        return this.asstTypeIds;
    }

    public Date getBdCreateTime() {
        return this.bdCreateTime;
    }

    public void setBdCreateTime(Date bdCreateTime) {
        this.bdCreateTime = bdCreateTime;
    }

    public List<BaseDataRefenceKey> getAllRefs(BasedataEntityType baseEntityType, Object objId) {
        ArrayList<BaseDataRefenceKey> list = new ArrayList<BaseDataRefenceKey>();
        List<BaseDataRefenceKey> refKeys = this.getAllRefKeys(baseEntityType);
        if (refKeys != null && !refKeys.isEmpty()) {
            HashSet<Object> idSet = new HashSet<Object>();
            idSet.add(objId);
            for (BaseDataRefenceKey refKey : refKeys) {
                Map<Object, BaseDataCheckRefrenceResult> result = this.checkRef(baseEntityType, refKey, idSet);
                for (Map.Entry<Object, BaseDataCheckRefrenceResult> entry : result.entrySet()) {
                    if (!entry.getValue().isRefence()) continue;
                    list.add(refKey);
                }
            }
        }
        return list;
    }

    public boolean isRefrenced(BasedataEntityType baseEntityType, Object objId) {
        return this.checkRef(baseEntityType, objId).isRefence();
    }

    public BaseDataCheckRefrenceResult checkRef(BasedataEntityType baseEntityType, Object objId) {
        Map<Object, BaseDataCheckRefrenceResult> result = this.checkRef(baseEntityType, new Object[]{objId});
        BaseDataCheckRefrenceResult baseDataCheckRefrenceResult = result.get(objId);
        if (baseDataCheckRefrenceResult != null) {
            return baseDataCheckRefrenceResult;
        }
        return new BaseDataCheckRefrenceResult();
    }

    public Map<Object, BaseDataCheckRefrenceResult> checkRef(BasedataEntityType baseEntityType, Object[] objIds) {
        return this.checkRef(baseEntityType, objIds, false);
    }

    private Map<Object, BaseDataCheckRefrenceResult> checkRef(BasedataEntityType baseEntityType, Object[] objIds, boolean isFlexRef) {
        try (TraceSpan span = Tracer.create((String)"BaseDataCheckRefrence", (String)"isRefrenced");){
            span.addTag("baseEntity", baseEntityType.getName());
            span.addTag("baseEntityTable", baseEntityType.getAlias());
            HashMap<Object, BaseDataCheckRefrenceResult> result = new HashMap<Object, BaseDataCheckRefrenceResult>(objIds.length);
            Set<Object> existRefStatusIds = this.existsRefStatus(baseEntityType, objIds);
            HashSet<Object> draftIdSet = new HashSet<Object>(objIds.length);
            HashSet<Object> currCheckIdSet = new HashSet<Object>(existRefStatusIds.size());
            for (Object id : objIds) {
                if (existRefStatusIds.contains(id)) {
                    currCheckIdSet.add(id);
                    continue;
                }
                draftIdSet.add(id);
            }
            if (currCheckIdSet.isEmpty()) {
                HashMap<Object, BaseDataCheckRefrenceResult> hashMap = result;
                return hashMap;
            }
            List<BaseDataRefenceKey> list = this.getAllRefKeys(baseEntityType);
            if (list == null || list.isEmpty()) {
                HashMap<Object, BaseDataCheckRefrenceResult> hashMap = result;
                return hashMap;
            }
            ArrayList<BaseDataRefenceKey> refSelfs = new ArrayList<BaseDataRefenceKey>(1);
            for (BaseDataRefenceKey refKey : list) {
                if (currCheckIdSet.isEmpty()) break;
                if (this.isSelfRefKey(baseEntityType, refKey)) {
                    refSelfs.add(refKey);
                    continue;
                }
                if (isFlexRef && this.isFlexVertialTableRef((MainEntityType)baseEntityType, refKey)) continue;
                Map<Object, BaseDataCheckRefrenceResult> currResult = this.checkRef(baseEntityType, refKey, currCheckIdSet);
                for (Map.Entry<Object, BaseDataCheckRefrenceResult> entry : currResult.entrySet()) {
                    if (!entry.getValue().isRefence()) continue;
                    result.put(entry.getKey(), entry.getValue());
                    currCheckIdSet.remove(entry.getKey());
                }
            }
            for (BaseDataRefenceKey refKey : refSelfs) {
                if (currCheckIdSet.isEmpty()) break;
                HashSet<Object> checkSelfRefIds = new HashSet<Object>(draftIdSet);
                checkSelfRefIds.addAll(currCheckIdSet);
                Set<Object> existSelfRefIds = this.readSelfRefIds(baseEntityType, refKey, checkSelfRefIds.toArray());
                for (Object existSelfRefId : existSelfRefIds) {
                    BaseDataCheckRefrenceResult checkRefResult = new BaseDataCheckRefrenceResult();
                    checkRefResult.setRefenceKey(refKey);
                    result.put(existSelfRefId, checkRefResult);
                    draftIdSet.remove(existSelfRefId);
                    currCheckIdSet.remove(existSelfRefId);
                }
            }
            HashMap<Object, BaseDataCheckRefrenceResult> hashMap = result;
            return hashMap;
        }
    }

    private boolean isFlexVertialTableRef(MainEntityType baseEntityType, BaseDataRefenceKey refKey) {
        if (refKey.getRefTable().equals(baseEntityType.getAlias() + "_bd")) {
            return true;
        }
        return refKey.getRefTable().equals(baseEntityType.getAlias() + "_txt");
    }

    private Map<Object, BaseDataCheckRefrenceResult> checkRef(BasedataEntityType baseEntityType, BaseDataRefenceKey refKey, Set<Object> ObjIdSet) {
        Map<Object, Set<Object>> existedIds = this.readExistRefIds(baseEntityType, refKey, ObjIdSet);
        HashMap<Object, BaseDataCheckRefrenceResult> result = new HashMap<Object, BaseDataCheckRefrenceResult>(16);
        if (!existedIds.isEmpty() && refKey.isRefFlexProperty()) {
            BasedataEntityType bet = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)refKey.getRefEntityKey());
            String refTabNamebd = refKey.getRefTable();
            String refTabNametxt = refKey.getRefTable().substring(0, refKey.getRefTable().length() - 3) + "_txt";
            HashSet flexIds = new HashSet();
            HashMap<Object, Object> flexIdTobdIds = new HashMap<Object, Object>();
            for (Map.Entry<Object, Set<Object>> s : existedIds.entrySet()) {
                flexIds.addAll(s.getValue());
                for (Object flexId : s.getValue()) {
                    flexIdTobdIds.put(flexId, s.getKey());
                }
            }
            Map<Object, BaseDataCheckRefrenceResult> refFlexIdResult = this.checkRef(bet, flexIds.toArray(), refKey.isRefFlexProperty());
            for (Map.Entry<Object, BaseDataCheckRefrenceResult> es : refFlexIdResult.entrySet()) {
                String refTabName;
                Object bdId;
                Object flexId;
                if (!es.getValue().isRefence() || (bdId = flexIdTobdIds.get(flexId = es.getKey())) == null || (refTabName = es.getValue().getRefenceKey().getRefTable()).equals(refTabNamebd) || refTabName.equals(refTabNametxt)) continue;
                result.put(bdId, es.getValue());
            }
            return result;
        }
        for (Object objId : existedIds.keySet()) {
            BaseDataCheckRefrenceResult refCheckResult = new BaseDataCheckRefrenceResult();
            refCheckResult.setRefenceKey(refKey);
            result.put(objId, refCheckResult);
        }
        return result;
    }

    private String getCheckSql(BaseDataRefenceKey refKey, List<String> paramNames) {
        String sql = refKey.isRefFlexProperty() ? String.format(SQL_EXISTED_FLEX, refKey.getRefCol(), refKey.getRefTable(), refKey.getRefFlexField(), StringUtils.join((Object[])paramNames.toArray(), (String)",")) : String.format(SQL_EXISTED_BILL, refKey.getRefCol(), refKey.getRefTable(), refKey.getRefCol(), StringUtils.join((Object[])paramNames.toArray(), (String)","));
        return sql;
    }

    private Map<Object, Set<Object>> readExistRefIds(BasedataEntityType baseEntityType, final BaseDataRefenceKey refKey, final Set<Object> ObjIdSet) {
        Map<Object, Set<Object>> existedIds = new HashMap<Object, Set<Object>>(ObjIdSet.size());
        if (StringUtils.equals((CharSequence)"t_isv_xxx", (CharSequence)refKey.getRefTable())) {
            return existedIds;
        }
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(16);
        ArrayList<String> paramNames = new ArrayList<String>(16);
        int i = 0;
        for (Object objId : ObjIdSet) {
            if (refKey.getBasePKFieldType() == 0) {
                sqlParams.add(new SqlParameter("fobjectid" + String.valueOf(i), 12, (Object)String.valueOf(objId)));
            } else {
                sqlParams.add(new SqlParameter("fobjectid" + String.valueOf(i), -5, (Object)Long.valueOf(objId.toString())));
            }
            paramNames.add("?");
            ++i;
        }
        if (paramNames.isEmpty()) {
            return existedIds;
        }
        if (this.ignoreRefEntityIds.contains(refKey.getRefEntityKey())) {
            return existedIds;
        }
        if (!this.checkRefEntityIds.isEmpty() && !this.checkRefEntityIds.contains(refKey.getRefEntityKey())) {
            return existedIds;
        }
        final boolean onlyOne = ObjIdSet.size() == 1;
        String sql = this.getCheckSql(refKey, paramNames);
        try {
            DBRoute dbRouteKey = this.getDbRouteByEntityKey(refKey);
            try (TXHandle th = TX.requiresNew((String)"readExistRefIds");){
                try {
                    String exist = String.format("select top 1 %s from %s ;", refKey.getRefCol(), refKey.getRefTable());
                    DB.query((DBRoute)dbRouteKey, (String)exist, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

                        public Boolean handle(ResultSet rs) throws Exception {
                            return true;
                        }
                    });
                }
                catch (Exception e) {
                    th.markRollback();
                    log.warn(String.format("readExistRefIds.table not exist\uff1arefTable:%s, refCol:%s", refKey.getRefTable(), refKey.getRefCol()));
                    HashMap<Object, Set<Object>> hashMap = existedIds;
                    if (th != null) {
                        if (var12_14 != null) {
                            try {
                                th.close();
                            }
                            catch (Throwable throwable) {
                                var12_14.addSuppressed(throwable);
                            }
                        } else {
                            th.close();
                        }
                    }
                    return hashMap;
                }
            }
            existedIds = (Map)DB.query((DBRoute)dbRouteKey, (String)sql, (Object[])sqlParams.toArray(new SqlParameter[sqlParams.size()]), (ResultSetHandler)new ResultSetHandler<Map<Object, Set<Object>>>(){

                public Map<Object, Set<Object>> handle(ResultSet rs) throws SQLException {
                    HashMap<Object, Set<Object>> idSet = new HashMap<Object, Set<Object>>(16);
                    while (rs.next()) {
                        Object id = null;
                        id = refKey.getBasePKFieldType() == 0 ? rs.getString(1) : Long.valueOf(rs.getLong(1));
                        HashSet<Object> list = (HashSet<Object>)idSet.get(id);
                        if (list == null) {
                            list = new HashSet<Object>();
                        }
                        Object value = id;
                        if (refKey.isRefFlexProperty()) {
                            value = rs.getLong(2);
                        }
                        list.add(value);
                        idSet.put(id, list);
                        if (!onlyOne || refKey.isRefFlexProperty() || !ObjIdSet.contains(id)) continue;
                        break;
                    }
                    return idSet;
                }
            });
        }
        finally {
            return existedIds;
        }
    }

    private boolean isSelfRefKey(BasedataEntityType baseEntityType, BaseDataRefenceKey refKey) {
        if (refKey.isRefFlexProperty()) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)baseEntityType.getAlias(), (CharSequence)refKey.getRefMainTable());
    }

    private Set<Object> readSelfRefIds(BasedataEntityType baseEntityType, BaseDataRefenceKey refKey, Object[] checkIds) {
        HashSet<Object> existRefIds = new HashSet<Object>(checkIds.length);
        try {
            Row row;
            Throwable throwable;
            DataSet dSet;
            if (checkIds.length == 0) {
                return existRefIds;
            }
            if (refKey.isRefFlexProperty()) {
                return existRefIds;
            }
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refKey.getRefEntityKey());
            if (!StringUtils.equalsIgnoreCase((CharSequence)baseEntityType.getAlias(), (CharSequence)refMainType.getAlias())) {
                return existRefIds;
            }
            String refFieldKey = null;
            for (Map.Entry entry : refMainType.getAllFields().entrySet()) {
                IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
                if (!StringUtils.equalsIgnoreCase((CharSequence)refKey.getRefCol(), (CharSequence)prop.getAlias())) continue;
                if (prop.getParent().getAlias().equals(refMainType.getAlias())) {
                    refFieldKey = prop.getName();
                    break;
                }
                refFieldKey = String.format("%s.%s", prop.getParent().getName(), prop.getName());
                break;
            }
            if (StringUtils.isBlank(refFieldKey) || StringUtils.equals((CharSequence)"id", refFieldKey)) {
                return existRefIds;
            }
            HashMap childIds = new HashMap(checkIds.length);
            if (checkIds.length > 1) {
                QFilter[] filterChildren = new QFilter[]{new QFilter("id", "in", (Object)checkIds), new QFilter(refFieldKey, "in", (Object)checkIds)};
                dSet = ORM.create().queryDataSet("BaseDataCheckRefrence.readSelfRefIds(1)", refMainType.getName(), "id," + refFieldKey, filterChildren);
                throwable = null;
                try {
                    while (dSet.hasNext()) {
                        row = dSet.next();
                        Object childId = row.get("id");
                        Object parendId = row.get(refFieldKey);
                        if (parendId == null) continue;
                        if (!childIds.containsKey(parendId)) {
                            childIds.put(parendId, new HashSet(1));
                        }
                        ((Set)childIds.get(parendId)).add(childId);
                    }
                }
                catch (Throwable row2) {
                    throwable = row2;
                    throw row2;
                }
                finally {
                    if (dSet != null) {
                        if (throwable != null) {
                            try {
                                dSet.close();
                            }
                            catch (Throwable row2) {
                                throwable.addSuppressed(row2);
                            }
                        } else {
                            dSet.close();
                        }
                    }
                }
            }
            QFilter[] filterOthers = new QFilter[]{new QFilter("id", "not in", (Object)checkIds), new QFilter(refFieldKey, "in", (Object)checkIds)};
            dSet = ORM.create().queryDataSet("BaseDataCheckRefrence.readSelfRefIds(2)", refMainType.getName(), refFieldKey, filterOthers);
            throwable = null;
            try {
                while (dSet.hasNext()) {
                    row = dSet.next();
                    Object parendId = row.get(refFieldKey);
                    existRefIds.add(parendId);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dSet != null) {
                    if (throwable != null) {
                        try {
                            dSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        dSet.close();
                    }
                }
            }
            boolean existRef = !existRefIds.isEmpty();
            int count = 0;
            while (existRef && count < checkIds.length) {
                ++count;
                existRef = false;
                block24: for (Object parentId : checkIds) {
                    Set parentSet = (Set)childIds.get(parentId);
                    if (existRefIds.contains(parentId) || parentSet == null) continue;
                    for (Object childId : parentSet) {
                        if (!existRefIds.contains(childId)) continue;
                        existRef = true;
                        existRefIds.add(parentId);
                        continue block24;
                    }
                }
            }
            return existRefIds;
        }
        catch (Throwable e) {
            return existRefIds;
        }
    }

    private DBRoute getDbRouteByEntityKey(BaseDataRefenceKey refKey) {
        DBRoute dbRoute = this.dbRouteMap.get(refKey.getRefEntityKey());
        if (dbRoute == null) {
            if (StringUtils.isNotBlank((CharSequence)refKey.getRefDBRouteKey())) {
                dbRoute = new DBRoute(refKey.getRefDBRouteKey());
            } else {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)refKey.getRefEntityKey());
                dbRoute = new DBRoute(entityType.getDBRouteKey());
            }
            this.dbRouteMap.put(refKey.getRefEntityKey(), dbRoute);
        }
        return dbRoute;
    }

    private List<BaseDataRefenceKey> getAllRefKeys(BasedataEntityType baseEntityType) {
        ArrayList<BaseDataRefenceKey> list = new ArrayList<BaseDataRefenceKey>();
        List<String> bdEntityNumbers = this.loadSameTableObjectTypes(baseEntityType);
        if (bdEntityNumbers.isEmpty()) {
            return list;
        }
        Set<String> ignoreRefs = this.loadIgnoreRefCheckSetting(baseEntityType, new HashSet<String>(bdEntityNumbers));
        if (this.ignoreRefEntityIds == null) {
            this.ignoreRefEntityIds = new HashSet<String>();
        }
        this.ignoreRefEntityIds.addAll(ignoreRefs);
        list.addAll(this.loadObjectTypeRefs(baseEntityType, bdEntityNumbers));
        list.addAll(this.loadFlexTypeRefs(baseEntityType, bdEntityNumbers));
        return list;
    }

    private List<String> loadSameTableObjectTypes(BasedataEntityType baseEntityType) {
        if (StringUtils.isBlank((CharSequence)baseEntityType.getAlias()) || baseEntityType.getPrimaryKey() == null || StringUtils.isBlank((CharSequence)baseEntityType.getPrimaryKey().getAlias())) {
            return new ArrayList<String>();
        }
        Object[] selectParams = new SqlParameter[]{new SqlParameter("FTableName", 12, (Object)String.valueOf(baseEntityType.getAlias().toLowerCase())), new SqlParameter("FPkFieldName", 12, (Object)String.valueOf(baseEntityType.getPrimaryKey().getAlias().toLowerCase()))};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_READSAMETABLEOBJECTTYPES, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> entityNumbers = new ArrayList<String>(16);
                while (rs.next()) {
                    entityNumbers.add(rs.getString("FId"));
                }
                return entityNumbers;
            }
        });
    }

    private List<BaseDataRefenceKey> loadObjectTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FRefObjectTypeId" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = SQL_READOBJECTTYPEREF;
        if (strParams.size() == 1) {
            sql = sql + "where t1.FRefObjectTypeId = ? ";
        } else {
            sql = sql + "where t1.FRefObjectTypeId in (%s)";
            sql = String.format(sql, StringUtils.join((Object[])strParams.toArray(), (String)","));
        }
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

            public List<BaseDataRefenceKey> handle(ResultSet rs) throws SQLException {
                ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>();
                while (rs.next()) {
                    String tableName = rs.getString("FTableName");
                    String refAsstType = rs.getString("FAsstTypeId");
                    if (!BaseDataCheckRefrence.this.getAsstTypeIds().isEmpty() && StringUtils.isNotBlank((CharSequence)refAsstType) && !BaseDataCheckRefrence.this.getAsstTypeIds().contains(refAsstType)) continue;
                    String objectTypeId = rs.getString("FObjectTypeId");
                    if (BaseDataCheckRefrence.this.getIgnoreRefEntityIds().contains(objectTypeId) || !StringUtils.isNotBlank((CharSequence)tableName)) continue;
                    BaseDataRefenceKey ref = BaseDataRefenceKey.create(baseEntityType, null);
                    ref.setRefDBRouteKey(rs.getString("FDBRoute"));
                    ref.setRefEntityKey(rs.getString("FObjectTypeId"));
                    ref.setRefMainTable(rs.getString("FMainTable"));
                    ref.setRefTable(tableName);
                    ref.setRefCol(rs.getString("FFieldName"));
                    ref.setSqlLoadIdByTime(rs.getString("FSqlLoadIdByTime"));
                    refs.add(ref);
                }
                return refs;
            }
        });
    }

    private Set<String> loadIgnoreRefCheckSetting(BasedataEntityType baseEntityType, Set<String> refBDTypeNames) {
        HashSet<String> ignoreRefs = new HashSet<String>(0);
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet(this.getClass().getSimpleName() + ".loadIgnoreRefCheckSetting", ENTITY_BD_IGNORE_REF_CHECK, "id, entitynumber, ignoreall, baseentitynumber", qFilters);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String refEntity = row.getString("entitynumber");
                Boolean ignoreall = row.getBoolean("ignoreall");
                String baseEntity = row.getString("baseentitynumber");
                if (ignoreall.booleanValue()) {
                    ignoreRefs.add(refEntity);
                    continue;
                }
                if (!refBDTypeNames.contains(baseEntity)) continue;
                ignoreRefs.add(refEntity);
            }
        }
        catch (Throwable exp) {
            log.error(exp);
        }
        return ignoreRefs;
    }

    private List<BaseDataRefenceKey> loadFlexTypeRefs(final BasedataEntityType baseEntityType, List<String> refBDTypeNames) {
        ArrayList<String> strParams = new ArrayList<String>(16);
        Object[] selectParams = new SqlParameter[refBDTypeNames.size()];
        for (int i = 0; i < refBDTypeNames.size(); ++i) {
            selectParams[i] = new SqlParameter("FValueSource" + String.valueOf(i), 12, (Object)refBDTypeNames.get(i));
            strParams.add("?");
        }
        String sql = String.format(SQL_READFLEXTYPEREF, StringUtils.join((Object[])strParams.toArray(), (String)","));
        try {
            List bdrList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])selectParams, (ResultSetHandler)new ResultSetHandler<List<BaseDataRefenceKey>>(){

                public List<BaseDataRefenceKey> handle(ResultSet rs) throws SQLException {
                    ArrayList<BaseDataRefenceKey> refs = new ArrayList<BaseDataRefenceKey>();
                    while (rs.next()) {
                        String refAsstType = rs.getString("fassistanttype");
                        if (!BaseDataCheckRefrence.this.getAsstTypeIds().isEmpty() && StringUtils.isNotBlank((CharSequence)refAsstType) && !BaseDataCheckRefrence.this.getAsstTypeIds().contains(refAsstType)) continue;
                        BaseDataRefenceKey ref = BaseDataRefenceKey.create(baseEntityType, null);
                        ref.setRefEntityKey(rs.getString("fformid"));
                        ref.setRefCol("FValue");
                        ref.setRefFlexProperty(true);
                        ref.setRefFlexField(rs.getString("FFlexField"));
                        if (!StringUtils.isNotBlank((CharSequence)ref.getRefFlexField())) continue;
                        refs.add(ref);
                    }
                    return refs;
                }
            });
            Object[] ids = new String[bdrList.size()];
            int i = 0;
            for (BaseDataRefenceKey baseDataRefenceKey : bdrList) {
                ids[i++] = baseDataRefenceKey.getRefEntityKey();
            }
            String inStr = StringUtils.join((Object[])ids, (String)"','");
            String sql1 = String.format("select fid, ftablename from t_meta_mainentityinfo where fid in ('%s')", inStr);
            Map refs = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql1, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> refs = new HashMap<String, String>(16);
                    while (rs.next()) {
                        refs.put(rs.getString(1), rs.getString(2));
                    }
                    return refs;
                }
            });
            for (BaseDataRefenceKey ref : bdrList) {
                String tab = (String)refs.get(ref.getRefEntityKey());
                ref.setRefTable(tab + "_bd");
            }
            return bdrList;
        }
        catch (Exception exp) {
            return new ArrayList<BaseDataRefenceKey>(0);
        }
    }

    private Set<Object> existsRefStatus(BasedataEntityType baseEntityType, Object[] ids) {
        HashSet<Object> idSet = new HashSet<Object>(16);
        idSet.addAll(Arrays.asList(ids));
        if (this.isDraftValidReference()) {
            return idSet;
        }
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)baseEntityType.getName());
        if (ops == null || StringUtils.isBlank((CharSequence)ops.getAudit())) {
            return idSet;
        }
        Map opMeta = EntityMetadataCache.getDataEntityOperate((String)baseEntityType.getName(), (String)ops.getAudit());
        if (opMeta == null || !opMeta.containsKey("parameter")) {
            return idSet;
        }
        Map opParam = (Map)opMeta.get("parameter");
        if (opParam == null || !opParam.containsKey("statusProp") || !opParam.containsKey("value")) {
            return idSet;
        }
        String statusFieldKey = (String)opParam.get("statusProp");
        BillStatusProp statusProperty = null;
        if (StringUtils.isNotBlank((CharSequence)statusFieldKey)) {
            statusProperty = (BillStatusProp)baseEntityType.getProperty(statusFieldKey);
        }
        if (statusProperty == null) {
            return idSet;
        }
        String val = (String)opParam.get("value");
        if (StringUtils.isBlank((CharSequence)statusProperty.getAlias()) || StringUtils.equalsIgnoreCase((CharSequence)val, (CharSequence)((String)statusProperty.getDefValue())) || BillStatus.C.getValue().equalsIgnoreCase((String)statusProperty.getDefValue())) {
            return idSet;
        }
        return BaseDataRefrenceTable.existsRefStatus(baseEntityType, idSet);
    }
}

