/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedataref;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.FieldInfo;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class BaseDataRefrenceTable {
    private static final Log log = LogFactory.getLog(BaseDataRefrenceTable.class);
    private static final int TABLE_NAME_MAX_LENGTH = 22;
    private static final String CREATE_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s (  %s                  \t%s               \t not null,  FRefStatus           CHAR(1)              not null default '0',  constraint PK_%s primary key (%s) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String UPDATE_HISTORYDATA_SQL = "insert into %s (%s, FRefStatus) select %s, '1' as FRefStatus from %s where %s not in (select %s from %s)";
    private static final String INSERT_SQL = "insert into %s (%s, FRefStatus) values (?,?) ";
    private static final String UPDATE_SQL = "update %s set FRefStatus = ? where %s = ? ";
    private static final String DELETE_SQL = "delete from %s ";
    private static final String SELECT_SQL = "select %s, FRefStatus from %s where %s in (%s) ";

    BaseDataRefrenceTable() {
    }

    public static String buildRefTableName(String bdTableName) {
        if (StringUtils.isBlank((CharSequence)bdTableName)) {
            return "";
        }
        if (bdTableName.length() > 22) {
            return bdTableName.substring(0, 22) + "_r3";
        }
        return bdTableName + "_r3";
    }

    public static void createRefTable(DBRoute dbRoute, BaseDataRefenceKey refKey) {
        if (StringUtils.isBlank((CharSequence)refKey.getBaseTableName())) {
            return;
        }
        String refTableName = BaseDataRefrenceTable.buildRefTableName(refKey.getBaseTableName());
        if (BaseDataRefrenceTable.tableIsExisted(dbRoute, refTableName)) {
            return;
        }
        long dataLength = 36L;
        if (refKey.getBasePKFieldType() == 0 && BaseDataRefrenceTable.tableIsExisted(dbRoute, refKey.getBaseTableName())) {
            List fieldInfo = DB.getFieldInfo((DBRoute)dbRoute, (String)refKey.getBaseTableName());
            for (FieldInfo info : fieldInfo) {
                if (!StringUtils.equals((CharSequence)info.getFieldName(), (CharSequence)refKey.getBasePKFieldName())) continue;
                dataLength = info.getDataLength();
                break;
            }
        }
        String create_table = String.format(CREATE_TABLE_SQL, refTableName, refTableName, refKey.getBasePKFieldName(), refKey.getBasePKFieldType() == 0 ? String.format("VARCHAR(%s) DEFAULT(' ') ", dataLength) : "BIGINT DEFAULT(0) ", refTableName, refKey.getBasePKFieldName());
        String update_history_data = String.format(UPDATE_HISTORYDATA_SQL, refTableName, refKey.getBasePKFieldName(), refKey.getBasePKFieldName(), refKey.getBaseTableName(), refKey.getBasePKFieldName(), refKey.getBasePKFieldName(), refTableName);
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)create_table);
                if (BaseDataRefrenceTable.tableIsExisted(dbRoute, refKey.getBaseTableName())) {
                    DB.execute((DBRoute)dbRoute, (String)update_history_data);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                if (log.isErrorEnabled()) {
                    log.error(e);
                }
            }
        }
    }

    public static boolean tableIsExisted(DBRoute dbRoute, String tableName) {
        String sql = String.format(TABLE_IS_EXISTED_SQL, tableName);
        boolean isExisted = (Boolean)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        return isExisted;
    }

    public static void createOrUpdateRefStatus(Collection<BaseDataRefenceKey> refKeys) {
        if (refKeys == null || refKeys.isEmpty()) {
            return;
        }
        HashMap group = new HashMap();
        for (BaseDataRefenceKey refenceKey : refKeys) {
            String bdTypeName = refenceKey.getBaseEntityKey();
            if (!group.containsKey(bdTypeName)) {
                group.put(bdTypeName, new ArrayList());
            }
            ((List)group.get(bdTypeName)).add(refenceKey);
        }
        try (TXHandle h = TX.requiresNew();){
            for (Map.Entry groupItem : group.entrySet()) {
                List list = (List)groupItem.getValue();
                BaseDataRefrenceTable.createOrUpdateRefStatus(new DBRoute(((BaseDataRefenceKey)list.get(0)).getBaseDBRouteKey()), list, 0);
            }
        }
    }

    public static void deleteRefStatus(Collection<BaseDataRefenceKey> refKeys) {
        if (refKeys == null || refKeys.isEmpty()) {
            return;
        }
        HashMap group = new HashMap();
        for (BaseDataRefenceKey refenceKey : refKeys) {
            String bdTypeName = refenceKey.getBaseEntityKey();
            if (!group.containsKey(bdTypeName)) {
                group.put(bdTypeName, new ArrayList());
            }
            ((List)group.get(bdTypeName)).add(refenceKey);
        }
        try (TXHandle h = TX.requiresNew();){
            for (Map.Entry groupItem : group.entrySet()) {
                List list = (List)groupItem.getValue();
                BaseDataRefrenceTable.delete(new DBRoute(((BaseDataRefenceKey)list.get(0)).getBaseDBRouteKey()), list);
            }
        }
    }

    private static void createOrUpdateRefStatus(DBRoute dbRoute, List<BaseDataRefenceKey> refKeys, int tryCount) {
        if (tryCount > 2) {
            return;
        }
        if (refKeys.isEmpty() || StringUtils.isBlank((CharSequence)refKeys.get(0).getBaseTableName())) {
            return;
        }
        ++tryCount;
        HashSet<Object> idSet = new HashSet<Object>(16);
        for (BaseDataRefenceKey refKey : refKeys) {
            idSet.add(refKey.getBasePKValue());
        }
        Map<Object, String> refStatus = BaseDataRefrenceTable.readRefStatus(refKeys.get(0), idSet);
        ArrayList<BaseDataRefenceKey> updateList = new ArrayList<BaseDataRefenceKey>();
        ArrayList<BaseDataRefenceKey> insertList = new ArrayList<BaseDataRefenceKey>();
        for (BaseDataRefenceKey refKey : refKeys) {
            if (!refStatus.containsKey(refKey.getBasePKValue())) {
                insertList.add(refKey);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)refStatus.get(refKey.getBasePKValue()), (CharSequence)"1")) continue;
            updateList.add(refKey);
        }
        if (!updateList.isEmpty()) {
            BaseDataRefrenceTable.update(dbRoute, updateList, tryCount);
        }
        if (!insertList.isEmpty()) {
            BaseDataRefrenceTable.create(dbRoute, insertList, tryCount);
        }
    }

    private static void create(DBRoute dbRoute, List<BaseDataRefenceKey> refKeys, int tryCount) {
        boolean success;
        BaseDataRefenceKey firstKey;
        block5: {
            firstKey = refKeys.get(0);
            String refTableName = BaseDataRefrenceTable.buildRefTableName(firstKey.getBaseTableName());
            if (StringUtils.isBlank((CharSequence)refTableName)) {
                return;
            }
            String sql = String.format(INSERT_SQL, refTableName, firstKey.getBasePKFieldName());
            ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(16);
            for (BaseDataRefenceKey refKey : refKeys) {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FId", refKey.getBasePKFieldType() == 0 ? 12 : -5, refKey.getBasePKValue()), new SqlParameter(":FRefStatus", 1, (Object)"1")};
                paramList.add(params);
            }
            success = true;
            try {
                DB.executeBatch((DBRoute)new DBRoute(firstKey.getBaseDBRouteKey()), (String)sql, paramList);
            }
            catch (Throwable e) {
                success = false;
                if (!log.isErrorEnabled()) break block5;
                log.error(e);
            }
        }
        if (!success) {
            BaseDataRefrenceTable.createRefTable(dbRoute, firstKey);
            BaseDataRefrenceTable.createOrUpdateRefStatus(dbRoute, refKeys, tryCount);
        }
    }

    private static void update(DBRoute dbRoute, List<BaseDataRefenceKey> refKeys, int tryCount) {
        BaseDataRefenceKey firstKey = refKeys.get(0);
        String refTableName = BaseDataRefrenceTable.buildRefTableName(firstKey.getBaseTableName());
        String sql = String.format(UPDATE_SQL, refTableName, firstKey.getBasePKFieldName());
        ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(16);
        for (BaseDataRefenceKey refKey : refKeys) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FRefStatus", 1, (Object)"1"), new SqlParameter(":FId", refKey.getBasePKFieldType() == 0 ? 12 : -5, refKey.getBasePKValue())};
            paramList.add(params);
        }
        DB.executeBatch((DBRoute)new DBRoute(firstKey.getBaseDBRouteKey()), (String)sql, paramList);
    }

    private static void delete(DBRoute dbRoute, List<BaseDataRefenceKey> refKeys) {
        BaseDataRefenceKey firstKey = refKeys.get(0);
        String refTableName = BaseDataRefrenceTable.buildRefTableName(firstKey.getBaseTableName());
        HashSet<Object> ids = new HashSet<Object>(refKeys.size());
        for (BaseDataRefenceKey refKey : refKeys) {
            ids.add(refKey.getBasePKValue());
        }
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format(DELETE_SQL, refTableName), new Object[0]);
        sqlBuilder.append(" where ", new Object[0]);
        if (ids.isEmpty()) {
            return;
        }
        if (ids.size() == 1) {
            sqlBuilder.append(firstKey.getBasePKFieldName(), new Object[0]);
            sqlBuilder.append(" = ?", new Object[0]);
            params.add(new SqlParameter("FID", firstKey.getBasePKFieldType() == 0 ? 12 : -5, ids.iterator().next()));
        } else {
            sqlBuilder.appendIn(firstKey.getBasePKFieldName(), ids.toArray());
        }
        sqlBuilder.append(" ", params.toArray(new Object[params.size()]));
        try {
            DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Set<Object> existsRefStatus(BasedataEntityType baseEntityType, Set<Object> idSet) {
        if (idSet == null || idSet.isEmpty()) {
            return new HashSet<Object>();
        }
        BaseDataRefenceKey refKey = BaseDataRefenceKey.create(baseEntityType, null);
        Map<Object, String> refStatus = BaseDataRefrenceTable.readRefStatus(refKey, idSet);
        HashSet<Object> set = new HashSet<Object>();
        for (Object id : idSet) {
            if (!refStatus.containsKey(id) || !StringUtils.equalsIgnoreCase((CharSequence)refStatus.get(id), (CharSequence)"1")) continue;
            set.add(id);
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<Object, String> readRefStatus(final BaseDataRefenceKey refKey, Set<Object> idSet) {
        String refTableName;
        ArrayList<SqlParameter> paramList;
        ArrayList<String> idStrings;
        HashMap<Object, String> defRefStatus;
        block18: {
            HashMap<Object, String> hashMap;
            TXHandle th;
            block19: {
                if (idSet == null) return new HashMap<Object, String>(0);
                if (idSet.isEmpty()) {
                    return new HashMap<Object, String>(0);
                }
                defRefStatus = new HashMap<Object, String>(idSet.size());
                idStrings = new ArrayList<String>(idSet.size());
                paramList = new ArrayList<SqlParameter>(idSet.size());
                int i = 1;
                for (Object id : idSet) {
                    defRefStatus.put(id, "1");
                    idStrings.add("?");
                    paramList.add(new SqlParameter(":FId" + String.valueOf(i), refKey.getBasePKFieldType() == 0 ? 12 : -5, id));
                }
                if (StringUtils.isBlank((CharSequence)refKey.getBaseTableName())) {
                    return defRefStatus;
                }
                refTableName = BaseDataRefrenceTable.buildRefTableName(refKey.getBaseTableName());
                th = TX.requiresNew((String)"tableIsExisted");
                Throwable throwable = null;
                try {
                    if (BaseDataRefrenceTable.tableIsExisted(new DBRoute(refKey.getBaseDBRouteKey()), refTableName)) break block18;
                    hashMap = defRefStatus;
                    if (th == null) return hashMap;
                    if (throwable == null) break block19;
                }
                catch (Exception e) {
                    th.markRollback();
                    log.error((Throwable)e);
                    break block18;
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                try {
                    th.close();
                    return hashMap;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return hashMap;
                }
            }
            th.close();
            return hashMap;
        }
        String sql = String.format(SELECT_SQL, refKey.getBasePKFieldName(), refTableName, refKey.getBasePKFieldName(), StringUtils.join((Object[])idStrings.toArray(), (String)","));
        ResultSetHandler<Map<Object, String>> action = new ResultSetHandler<Map<Object, String>>(){

            public Map<Object, String> handle(ResultSet rs) throws SQLException {
                HashMap<Object, String> map = new HashMap<Object, String>();
                while (rs.next()) {
                    Object id;
                    if (refKey.getBasePKFieldType() == 0) {
                        id = rs.getString(1);
                        map.put(id, rs.getString(2));
                        continue;
                    }
                    id = rs.getLong(1);
                    map.put(id, rs.getString(2));
                }
                return map;
            }
        };
        try {
            return (Map)DB.query((DBRoute)new DBRoute(refKey.getBaseDBRouteKey()), (String)sql, (Object[])paramList.toArray(new SqlParameter[0]), (ResultSetHandler)action);
        }
        catch (Throwable e) {
            return defRefStatus;
        }
    }
}

