/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bill;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;

public class BillLayoutSchemeService {
    private static final Log log = LogFactory.getLog(BillLayoutSchemeService.class);
    private static final String LAYOUTSCHEMEID = ", layoutschemeid:";
    private static final String BILLTYPE = ", billtype:";
    private static final String SCEMEID = ", scemeid:";

    public static String getLayoutFormNumber(String entityNumber, BillLayoutParameter blp) {
        String layout;
        BillLayoutSchemeAssignEntity blsae = BillLayoutSchemeService.getLayoutScheme(entityNumber, blp);
        if (blsae != null && StringUtils.isNotBlank((CharSequence)(layout = blsae.getLayoutNumber()))) {
            return layout;
        }
        return null;
    }

    public static BillLayoutSchemeAssignEntity getLayoutScheme(String entityNumber, BillLayoutParameter blp) {
        String orgFunction = blp.getOrgFunc();
        long mainOrgId = blp.getOrgId();
        long billType = blp.getBillTypeId();
        if (mainOrgId == 0L && billType == 0L) {
            return null;
        }
        BillLayoutSchemeAssignEntity[] billAssigns = BillLayoutSchemeService.getLayoutSchemeAssignEntityFromCache(entityNumber);
        return BillLayoutSchemeService.getLayoutSchemeAssignEntity(orgFunction, mainOrgId, billType, billAssigns);
    }

    public static BillLayoutSchemeAssignEntity[] getLayoutSchemeAssignEntityFromCache(String entityNumber) {
        IDataEntityType type = OrmUtils.getDataEntityType(BillLayoutSchemeAssignEntity.class);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        QFilter[] filters = new QFilter[]{new QFilter("formnumber", "=", (Object)entityNumber)};
        Object[] billAssigns = (BillLayoutSchemeAssignEntity[])cacheManager.getCachePks(filters);
        StringBuilder sb = new StringBuilder();
        if (LayoutControlInfo.isOutLog()) {
            sb.append("layoutlog - BillLayoutSchemeService.getLayoutScheme  ");
        }
        if (billAssigns == null) {
            billAssigns = BillLayoutSchemeService.queryLayoutSchemeAssign(entityNumber);
            cacheManager.putCachePks(filters, billAssigns);
            if (LayoutControlInfo.isOutLog()) {
                sb.append(" query layout by ").append(entityNumber).append(':');
                for (Object blsa : billAssigns) {
                    sb.append(blsa.getId()).append(',');
                }
                sb.append(System.lineSeparator());
                log.info(sb.toString());
            }
        }
        return billAssigns;
    }

    private static BillLayoutSchemeAssignEntity getLayoutSchemeAssignEntity(String orgFunction, long mainOrgId, long billType, BillLayoutSchemeAssignEntity[] billAssigns) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (LayoutControlInfo.isOutLog()) {
            sb.append("layoutlog - BillLayoutSchemeService.getLayoutScheme  ");
        }
        if (mainOrgId == 0L && billType == 0L) {
            if (LayoutControlInfo.isOutLog()) {
                sb.append(" return  null, orgid=0, billtype=0");
                log.info(sb.toString());
            }
            return null;
        }
        boolean byorg = false;
        boolean bybilltype = false;
        boolean byorgbilltype = false;
        if (mainOrgId != 0L && billType != 0L) {
            byorgbilltype = true;
        } else if (billType == 0L) {
            byorg = true;
        } else if (mainOrgId == 0L) {
            bybilltype = true;
        }
        HashMap<Long, ArrayList<BillLayoutSchemeAssignEntity>> orgBilltypeLayoutMapping = new HashMap<Long, ArrayList<BillLayoutSchemeAssignEntity>>();
        HashMap<Long, ArrayList<BillLayoutSchemeAssignEntity>> orgLayoutMapping = new HashMap<Long, ArrayList<BillLayoutSchemeAssignEntity>>();
        BillLayoutSchemeAssignEntity billtypeLayoutScheme = null;
        BillLayoutSchemeAssignEntity orgtypeLayoutScheme = null;
        for (BillLayoutSchemeAssignEntity bls : billAssigns) {
            ArrayList<BillLayoutSchemeAssignEntity> list;
            if (bls.getOrg() != 0L && bls.getBillType() != 0L) {
                if (byorgbilltype && bls.getOrg() == mainOrgId && bls.getBillType() == billType) {
                    if (LayoutControlInfo.isOutLog()) {
                        sb.append(" return matched. org : ").append(mainOrgId).append("  billType :").append(billType).append(LAYOUTSCHEMEID).append(bls.getId());
                        log.info(sb.toString());
                    }
                    return bls;
                }
                list = (ArrayList<BillLayoutSchemeAssignEntity>)orgBilltypeLayoutMapping.get(bls.getOrg());
                if (list == null) {
                    list = new ArrayList<BillLayoutSchemeAssignEntity>();
                    orgBilltypeLayoutMapping.put(bls.getOrg(), list);
                }
                list.add(bls);
                continue;
            }
            if (bls.getBillType() == 0L) {
                if (mainOrgId == bls.getOrg()) {
                    orgtypeLayoutScheme = bls;
                    if (byorg) {
                        if (LayoutControlInfo.isOutLog()) {
                            sb.append(" return orgid match, billtype not matched requestbilltype=0, orgid:").append(bls.getOrg()).append(BILLTYPE).append(billType).append(SCEMEID).append(bls.getId());
                            log.info(sb.toString());
                        }
                        return bls;
                    }
                }
                if ((list = (List)orgLayoutMapping.get(bls.getOrg())) == null) {
                    list = new ArrayList();
                    orgLayoutMapping.put(bls.getOrg(), list);
                }
                list.add(bls);
                continue;
            }
            if (bls.getOrg() != 0L) continue;
            if (bybilltype && billType == bls.getBillType()) {
                if (LayoutControlInfo.isOutLog()) {
                    sb.append(" return orgid=0, billtype matched, billtype:").append(billType).append(SCEMEID).append(bls.getId());
                    log.info(sb.toString());
                }
                return bls;
            }
            if (billType != bls.getBillType()) continue;
            billtypeLayoutScheme = bls;
        }
        if (StringUtils.isBlank((CharSequence)orgFunction)) {
            if (orgtypeLayoutScheme != null) {
                if (LayoutControlInfo.isOutLog()) {
                    sb.append("  return orgfunc null ---- ").append(" org matched,billtype not matched").append("requestbilltype=").append(billType).append(LAYOUTSCHEMEID).append(orgtypeLayoutScheme.getId());
                    log.info(sb.toString());
                }
                return orgtypeLayoutScheme;
            }
            if (LayoutControlInfo.isOutLog()) {
                sb.append("  return orgfunc null ---- ").append(" org not matched,").append("requestbilltype=").append(billType).append(billtypeLayoutScheme == null ? "billtype not matched" : "billtype match , scemeid:" + billtypeLayoutScheme.getId());
                log.info(sb.toString());
            }
            return billtypeLayoutScheme;
        }
        List orgs = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSuperiorOrgs(orgFunction, mainOrgId);
        if (byorgbilltype) {
            if (orgs != null) {
                for (i = orgs.size() - 1; i >= 0; --i) {
                    Long orgid = (Long)orgs.get(i);
                    if (orgBilltypeLayoutMapping.get(orgid) == null) continue;
                    for (BillLayoutSchemeAssignEntity bls : (List)orgBilltypeLayoutMapping.get(orgid)) {
                        if (!bls.isIncludeSubOrg() || billType != bls.getBillType()) continue;
                        if (LayoutControlInfo.isOutLog()) {
                            sb.append("  return superorg billtype match, orgid :").append(orgid).append(BILLTYPE).append(billType).append(LAYOUTSCHEMEID).append(bls.getId());
                            log.info(sb.toString());
                        }
                        return bls;
                    }
                }
            }
            if (orgtypeLayoutScheme != null) {
                if (LayoutControlInfo.isOutLog()) {
                    sb.append("  return org match schemebilltype=0, orgid :").append(mainOrgId).append(BILLTYPE).append(billType).append(LAYOUTSCHEMEID).append(orgtypeLayoutScheme.getId());
                    log.info(sb.toString());
                }
                return orgtypeLayoutScheme;
            }
        }
        if (orgs != null) {
            for (i = orgs.size() - 1; i >= 0; --i) {
                Long orgid = (Long)orgs.get(i);
                if (orgLayoutMapping.get(orgid) == null) continue;
                for (BillLayoutSchemeAssignEntity bls : (List)orgLayoutMapping.get(orgid)) {
                    if (!bls.isIncludeSubOrg()) continue;
                    if (LayoutControlInfo.isOutLog()) {
                        sb.append("  return superorg match billtype no match  schemebilltype=0, orgid :").append(bls.getOrg()).append(BILLTYPE).append(billType).append(LAYOUTSCHEMEID).append(bls.getId());
                        log.info(sb.toString());
                    }
                    return bls;
                }
            }
        }
        return billtypeLayoutScheme;
    }

    private static BillLayoutSchemeAssignEntity[] queryLayoutSchemeAssign(String entityNumber) {
        String sql = "select a.fid, a.flayoutnumber, b.forgid, b.fbilltypeid, b.ftype, a.fformnumber, b.fincludesuborg from t_cts_layoutscheme a inner join t_cts_layoutschemeassign b on a.fid = b.flayoutschemeid where a.fformnumber = ? and a.fenable = '1' ";
        Object[] paras = new Object[]{entityNumber};
        return (BillLayoutSchemeAssignEntity[])DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])paras, (ResultSetHandler)new ResultSetHandler<BillLayoutSchemeAssignEntity[]>(){

            public BillLayoutSchemeAssignEntity[] handle(ResultSet rs) throws Exception {
                ArrayList<BillLayoutSchemeAssignEntity> orgAssignList = new ArrayList<BillLayoutSchemeAssignEntity>(16);
                while (rs.next()) {
                    BillLayoutSchemeAssignEntity lsa = new BillLayoutSchemeAssignEntity();
                    lsa.setId(rs.getLong(1));
                    lsa.setLayoutNumber(rs.getString(2));
                    lsa.setOrg(rs.getLong(3));
                    lsa.setBillType(rs.getLong(4));
                    lsa.setFormNumber(rs.getString(6));
                    lsa.setIncludeSubOrg(rs.getBoolean(7));
                    orgAssignList.add(lsa);
                }
                return orgAssignList.toArray(new BillLayoutSchemeAssignEntity[0]);
            }
        });
    }
}

