/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.DataEntityCacheType;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.CachedLoadReferenceObjectManager;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BusinessDataReader {
    private static final String SPAN_TYPE_READER = "datareader";
    private static final String LOAD = "load";
    private static final String LOADSINGLE = "loadSingle";
    private static final String LOADHEAD = "loadHead";
    private static final String LOADFROMCACHE = "loadFromCache";
    private static final String LOADREFENCE = "loadRefence";
    private static final String READ = "read";
    private static final String PARAM_PK = "pk";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_DT = "dt";
    private static final String PARAM_PKARRAY = "pkArray";
    private static final String PARAM_SELECTFIELDS = "selectFields";
    private static final String PARAM_FILTERS = "filters";
    private static final String PARAM_START = "start";
    private static final String PARAM_LIMIT = "limit";
    private static final String PARAM_LOADREFENCE = "loadRefence";
    private static final String PARAM_RESULT = "result";
    private static List<String> basedataCacheBlackList;
    private static String[] defaultBasedataCacheBlankList;
    private static Log log;
    private static String[] grayFeatureMetaEntities;

    private static void readBasedataCacheBlackList() {
        String cacheBlackList = System.getProperty("basedata.loadfromcache.blacklist");
        basedataCacheBlackList = StringUtils.isNotBlank((CharSequence)cacheBlackList) ? (List<Object>)SerializationUtils.fromJsonString((String)cacheBlackList, List.class) : new ArrayList<String>();
        basedataCacheBlackList.addAll(Arrays.asList(defaultBasedataCacheBlankList));
    }

    public static DynamicObject loadSingle(Object pk, @Nonnull DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADSINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addTag(PARAM_PK, String.valueOf(pk));
            }
            DynamicObject result = (DynamicObject)BusinessDataReader.read(pk, (IDataEntityType)type, Boolean.TRUE, Boolean.FALSE);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, (Object)result);
            }
            DynamicObject dynamicObject = result;
            return dynamicObject;
        }
    }

    public static DynamicObject loadSingle(Object pk, DynamicObjectType type, int start, int limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADSINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addTag(PARAM_PK, String.valueOf(pk));
                span.addTag(PARAM_START, String.valueOf(start));
                span.addTag(PARAM_LIMIT, String.valueOf(limit));
            }
            DynamicObject result = (DynamicObject)BusinessDataReader.read(pk, (IDataEntityType)type, Boolean.TRUE, start, limit);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, (Object)result);
            }
            DynamicObject dynamicObject = result;
            return dynamicObject;
        }
    }

    private static Object read(Object pk, IDataEntityType type, Boolean loadReferenceData, int start, int limit) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        if (start > 0) {
            dataManager.setStartRowIndex(start);
        }
        if (limit > 0) {
            dataManager.setPageSize(Integer.valueOf(limit));
        }
        Object obj = dataManager.read(pk);
        if (loadReferenceData.booleanValue() && obj != null) {
            BusinessDataReader.loadRefence(new Object[]{obj}, type);
        }
        return obj;
    }

    public static DynamicObject loadSingle(Object pk, DynamicObjectType type, Boolean loadReferenceData) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADSINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addTag(PARAM_PK, String.valueOf(pk));
                span.addTag("loadRefence", String.valueOf(loadReferenceData));
            }
            DynamicObject result = (DynamicObject)BusinessDataReader.read(pk, (IDataEntityType)type, loadReferenceData, Boolean.FALSE);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, (Object)result);
            }
            DynamicObject dynamicObject = result;
            return dynamicObject;
        }
    }

    public static DynamicObject loadHead(Object pk, DynamicObjectType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADHEAD);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addTag(PARAM_PK, String.valueOf(pk));
            }
            DynamicObject result = (DynamicObject)BusinessDataReader.read(pk, (IDataEntityType)type, Boolean.TRUE, Boolean.TRUE);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, (Object)result);
            }
            DynamicObject dynamicObject = result;
            return dynamicObject;
        }
    }

    public static Object[] load(Object[] pkArray, IDataEntityType type) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOAD);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
            }
            Object[] result = BusinessDataReader.read(type, pkArray, (boolean)Boolean.FALSE, 0, 0);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_PKARRAY, (Object)pkArray);
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, (Object)result);
            }
            Object[] objectArray = result;
            return objectArray;
        }
    }

    public static DynamicObject[] load(Object[] pkArray, DynamicObjectType type, Boolean loadReferenceData) {
        return BusinessDataReader.load(pkArray, type, loadReferenceData, 0, 0);
    }

    public static DynamicObject[] load(@Nonnull Object[] pkArray, @Nonnull DynamicObjectType type, Boolean loadReferenceData, int start, int limit) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOAD);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addLocaleTag(PARAM_PKARRAY, (Object)pkArray);
                span.addTag("loadRefence", String.valueOf(loadReferenceData));
                span.addTag(PARAM_START, String.valueOf(start));
                span.addTag(PARAM_LIMIT, String.valueOf(limit));
            }
            DynamicObject[] result = (DynamicObject[])BusinessDataReader.read((IDataEntityType)type, pkArray, (boolean)loadReferenceData, start, limit);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, (Object)result);
            }
            DynamicObject[] dynamicObjectArray = result;
            return dynamicObjectArray;
        }
    }

    public static Map<Object, DynamicObject> loadFromCache(Object[] pkArray, DynamicObjectType dt) {
        return BusinessDataReader.loadFromCache(pkArray, dt, Boolean.TRUE);
    }

    public static Map<Object, DynamicObject> loadFromCache(DynamicObjectType type, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADFROMCACHE);){
            boolean filtersNotNull;
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            ArrayList idList = new ArrayList();
            Object[] pks = null;
            boolean bl = filtersNotNull = filters != null && filters.length == 1 && filters[0] != null && filters[0].getProperty().equals("id") && filters[0].getNests(false).isEmpty();
            if (filtersNotNull) {
                if ("in".equals(filters[0].getCP()) && !filters[0].isExpressValue()) {
                    pks = QFilterUtil.getWithoutDuplicateInValues((Object)filters[0].getValue());
                } else if ("=".equals(filters[0].getCP()) && !filters[0].isExpressValue()) {
                    pks = new Object[]{filters[0].getValue()};
                }
            }
            if (pks == null) {
                DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
                pks = cacheManager.getCachePks(filters);
                if (pks == null) {
                    try (DataSet ds = ORM.create().queryDataSet("BusinessDataServiceHelper.LoadFromCache", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                        ds.forEach(row -> idList.add(row.get(0)));
                    }
                    pks = idList.toArray();
                    cacheManager.putCachePks(filters, pks);
                }
                BusinessDataReader.outDebugLog(type, filters, pks);
            }
            Map<Object, DynamicObject> map = BusinessDataReader.loadFromCache(pks, type);
            return map;
        }
    }

    private static void outDebugLog(DynamicObjectType type, QFilter[] filters, Object[] pks) {
        String loadCacheEnable = SystemPropertyUtils.getProptyByTenant((String)"businessdatareader.loadfromcache.log", (String)RequestContext.get().getTenantId());
        if ("true".equalsIgnoreCase(loadCacheEnable)) {
            int i;
            StringBuilder sb = new StringBuilder(32);
            sb.append("loadfromcache.log:");
            sb.append(" type.getExtendName():").append(type.getExtendName());
            sb.append(" | type.getProperties().size():").append(type.getProperties().size());
            StringBuilder filterKey = new StringBuilder(16);
            if (filters == null || filters.length == 0) {
                filterKey.append("null");
            } else {
                for (i = 0; i < filters.length; ++i) {
                    if (filters[0] == null) continue;
                    filterKey.append(filters[i]).append(',');
                }
                if (filterKey.length() > 1) {
                    filterKey.deleteCharAt(filterKey.length() - 1);
                }
            }
            sb.append(" | filterlocalcachekey: ").append((CharSequence)filterKey);
            sb.append(" | pks[10]:");
            i = 1;
            for (Object pk : pks) {
                if (i > 10) break;
                sb.append(pk.toString()).append(",");
                ++i;
            }
            String rootType = type.getAlias().toLowerCase();
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy());
            RequestContext context = RequestContext.get();
            String rootCacheKey = context.getAccountId() + "." + rootType.toLowerCase();
            Map subTypes = cache.getAll(rootCacheKey);
            sb.append(" | subtype keys: ");
            for (String key : subTypes.keySet()) {
                sb.append(key).append(",");
            }
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(3600);
            info.setMaxMemSize(300);
            LocalMemoryCache rootCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.get().getAccountId(), "bd", info);
            String rootFilterType = rootType + ".filter";
            Map filterCache = (Map)rootCache.get(rootFilterType);
            sb.append(" | localcacheKey(rootTYpe) - ").append(rootFilterType).append(":");
            if (filterCache != null) {
                i = 0;
                for (Object pk : pks) {
                    if (i > 10) break;
                    sb.append(pk.toString()).append("-").append(filterCache.get(pk));
                    ++i;
                }
            }
            rootFilterType = type.getExtendName() + ".filter";
            filterCache = (Map)rootCache.get(rootFilterType);
            sb.append(" | localcacheKey(subType) - ").append(rootFilterType).append(":");
            if (filterCache != null) {
                for (Object pk : pks) {
                    if (i > 10) break;
                    sb.append(pk.toString()).append("-").append(filterCache.get(pk));
                }
            }
            sb.append("check rootType and subType are the same");
            log.info(sb.toString());
        }
    }

    public static DynamicObject loadSingle(Object pk, String entityName, String selectProperties) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADSINGLE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, entityName);
                span.addTag(PARAM_PK, String.valueOf(pk));
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
            }
            DynamicObjectType type = BusinessDataReader.getSubEntityType(entityName, selectProperties);
            DynamicObject dynamicObject = BusinessDataReader.loadSingle(pk, type);
            return dynamicObject;
        }
    }

    public static Map<Object, DynamicObject> loadFromCache(String entityName, String selectProperties, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADFROMCACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, entityName);
                span.addTag(PARAM_SELECTFIELDS, selectProperties);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            DynamicObjectType type = BusinessDataReader.getSubEntityType(entityName, selectProperties);
            Map<Object, DynamicObject> map = BusinessDataReader.loadFromCache(type, filters);
            return map;
        }
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop.trim());
        }
        return EntityMetadataCache.getSubDataEntityType((String)entityName, select);
    }

    public static Map<Object, DynamicObject> loadFromCache(@Nonnull Object[] pkArray, @Nonnull DynamicObjectType dt, boolean loadReferenceData) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADFROMCACHE);){
            DynamicObject[] data;
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, dt.getName());
                span.addLocaleTag(PARAM_PKARRAY, (Object)pkArray);
                span.addTag("loadRefence", String.valueOf(loadReferenceData));
            }
            HashMap<String, DynamicObject> oDynamicObject = new HashMap<String, DynamicObject>();
            ISimpleProperty pkProp = dt.getPrimaryKey();
            if (dt instanceof BillEntityType && !(dt instanceof BasedataEntityType)) {
                DynamicObject[] objects = BusinessDataReader.load(pkArray, dt, Boolean.FALSE);
                BusinessDataReader.putDynamicObjectToMap(dt, oDynamicObject, objects);
            } else if (basedataCacheBlackList != null && basedataCacheBlackList.contains(dt.getAlias().toLowerCase())) {
                data = BusinessDataReader.load(pkArray, dt, Boolean.FALSE);
                BusinessDataReader.putDynamicObjectToMap(dt, oDynamicObject, data);
            } else if (BusinessDataReader.isCacheFlowControl(dt, pkArray)) {
                data = BusinessDataReader.load(pkArray, dt, Boolean.FALSE);
                BusinessDataReader.putDynamicObjectToMap(dt, oDynamicObject, data);
                log.info(String.format("load data %s(%s) exceeds the cache configured limit.", dt.getName(), pkArray.length));
            } else {
                if (dt instanceof BasedataEntityType) {
                    ((BasedataEntityType)dt).createRefPropsHashValue(false);
                }
                ArrayList<Object> notFindFromCachePkArray = new ArrayList<Object>();
                Object[] cacheManager = new DataEntityCacheManager((IDataEntityType)dt);
                Map cacheMap = cacheManager.get(pkArray);
                for (Object pk : pkArray) {
                    DynamicObject dataEntity = (DynamicObject)cacheMap.get(pk);
                    if (dataEntity != null && !dataEntity.getDataEntityState().isChanged()) {
                        boolean bShare = dt.getCacheType().equals((Object)DataEntityCacheType.Share);
                        Object pkValue = pkProp.getValueFast((Object)dataEntity);
                        if (bShare && pkValue != null) {
                            oDynamicObject.put(pkValue.toString(), dataEntity);
                            continue;
                        }
                        DynamicObject newobj = (DynamicObject)dt.createInstance();
                        for (IDataEntityProperty prop : dt.getProperties()) {
                            Object val = prop.getValue((Object)dataEntity);
                            prop.setValue((Object)newobj, val);
                        }
                        pkValue = pkProp.getValueFast((Object)newobj);
                        if (pkValue == null) continue;
                        oDynamicObject.put(pkValue.toString(), newobj);
                        continue;
                    }
                    if (pk == null || cacheManager.isNotExistPK(pk)) continue;
                    notFindFromCachePkArray.add(pk);
                }
                if (!notFindFromCachePkArray.isEmpty()) {
                    Object[] notCacheObjecs = BusinessDataReader.load(notFindFromCachePkArray.toArray(), dt, Boolean.FALSE);
                    BusinessDataReader.putDynamicObjectToMap(dt, oDynamicObject, (DynamicObject[])notCacheObjecs);
                    cacheManager.put(notCacheObjecs);
                    if (notCacheObjecs == null || notFindFromCachePkArray.size() > notCacheObjecs.length) {
                        cacheManager.putNotExistPKs(notFindFromCachePkArray.toArray(), notCacheObjecs);
                    }
                }
            }
            LinkedHashMap<Object, DynamicObject> orderedDynamicObject = new LinkedHashMap<Object, DynamicObject>();
            for (Object pk : pkArray) {
                DynamicObject dynamicObject;
                if (pk == null || (dynamicObject = (DynamicObject)oDynamicObject.get(pk.toString())) == null) continue;
                orderedDynamicObject.put(pkProp.getValueFast((Object)dynamicObject), dynamicObject);
            }
            Object[] results = orderedDynamicObject.values().toArray(new DynamicObject[0]);
            if (loadReferenceData && results.length > 0) {
                BusinessDataReader.loadRefence(results, (IDataEntityType)dt);
            }
            String loadCacheEnable = SystemPropertyUtils.getProptyByTenant((String)"businessdatareader.loadfromcache.log", (String)RequestContext.get().getTenantId());
            if (results.length > 0 && "true".equalsIgnoreCase(loadCacheEnable)) {
                DynamicObjectType dataType = results[0].getDynamicObjectType();
                StringBuilder sb = new StringBuilder(30);
                if (!dataType.getExtendName().equals(dt.getExtendName())) {
                    sb.append("dataType.getName():").append(dataType.getName()).append("   -   type.getName():").append(dt.getName());
                    sb.append(" | dataType.getExtendName():").append(dataType.getExtendName()).append("   -   type.getExtendName():").append(dt.getExtendName());
                }
                if (dataType.getProperties().size() != dt.getProperties().size()) {
                    sb.append(" dataType.getProperties().size():").append(dataType.getProperties().size());
                    sb.append("   dt.getProperties().size():").append(dt.getProperties().size());
                }
                sb.append(" properties: ");
                for (int i = 0; i < dt.getProperties().size(); ++i) {
                    IDataEntityProperty property = (IDataEntityProperty)dt.getProperties().get(i);
                    if (dataType.getProperties().contains((Object)property)) {
                        sb.append(property.getName()).append("-").append(((IDataEntityProperty)dataType.getProperties().get(i)).getName()).append(",");
                        continue;
                    }
                    sb.append(property.getName()).append("-").append(" null ").append(",");
                }
                log.info(sb.toString());
            }
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)dt);
                span.addLocaleTag("result.size", (Object)orderedDynamicObject.size());
                span.addLocaleTag(PARAM_RESULT, orderedDynamicObject);
            }
            LinkedHashMap<Object, DynamicObject> linkedHashMap = orderedDynamicObject;
            return linkedHashMap;
        }
    }

    public static Map<Object, DynamicObject> loadFromCache(String entityName, QFilter[] filters) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)LOADFROMCACHE);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, entityName);
                span.addLocaleTag(PARAM_FILTERS, (Object)filters);
            }
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
            ArrayList idList = new ArrayList();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)type);
            Object[] pks = cacheManager.getCachePks(filters);
            if (pks == null) {
                try (DataSet ds = ORM.create().queryDataSet("BusinessDataReader.LoadFromCache", entityName, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                    ds.forEach(row -> idList.add(row.get(0)));
                }
                pks = idList.toArray();
                cacheManager.putCachePks(filters, pks);
            }
            Map<Object, DynamicObject> map = BusinessDataReader.loadFromCache(pks, (DynamicObjectType)type);
            return map;
        }
    }

    public static Object read(Object pk, @Nonnull IDataEntityType type, Boolean loadReferenceData) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_READER, (String)READ);){
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addTag(PARAM_PK, String.valueOf(pk));
                span.addTag("loadRefence", String.valueOf(loadReferenceData));
            }
            Object result = BusinessDataReader.read(pk, type, loadReferenceData, Boolean.FALSE);
            if (span.isRealtime()) {
                span.addLocaleTag(PARAM_DT, (Object)type);
                span.addLocaleTag(PARAM_RESULT, result);
            }
            Object object = result;
            return object;
        }
    }

    private static void putDynamicObjectToMap(DynamicObjectType dt, Map<String, DynamicObject> oDynamicObject, DynamicObject[] objects) {
        ISimpleProperty pkProp = dt.getPrimaryKey();
        for (DynamicObject o : objects) {
            Object pkValue = pkProp.getValueFast((Object)o);
            if (pkValue == null) continue;
            oDynamicObject.put(pkValue.toString(), o);
        }
    }

    private static Object read(Object pk, IDataEntityType type, Boolean loadReferenceData, boolean selectHeadOnly) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        dataManager.setSelectHeadOnly(selectHeadOnly);
        Object obj = dataManager.read(pk);
        if (loadReferenceData.booleanValue() && obj != null) {
            BusinessDataReader.loadRefence(new Object[]{obj}, type);
        }
        return obj;
    }

    public static void loadRefence(Object[] dataEntitys, IDataEntityType type) {
        try (EntityTraceSpan span = null;){
            span = EntityTracer.create((String)SPAN_TYPE_READER, (String)"loadRefence");
            if (span.isRealtime()) {
                span.addTag(PARAM_TYPE, type.getName());
                span.addLocaleTag("dataEntitys", (Object)dataEntitys);
            }
            CachedLoadReferenceObjectManager manager = new CachedLoadReferenceObjectManager(type, Boolean.FALSE.booleanValue());
            manager.Load(dataEntitys);
        }
    }

    private static Object[] read(@Nonnull IDataEntityType type, Object[] pkArray, boolean loadReferenceData, int start, int limit) {
        Object[] objects = BusinessDataReader.readObject(pkArray, type, start, limit);
        IDataEntityType det = type;
        if (!BusinessDataReader.isGrayFeatureMetaType(type.getName())) {
            Object[] results = BusinessDataReader.sortObjectsByPks(type, pkArray, objects);
            if (loadReferenceData && results != null && results.length > 0) {
                BusinessDataReader.loadRefence(results, det);
            }
            return results;
        }
        try {
            det = (IDataEntityType)type.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        det.setAlias(BusinessDataReader.getGrayTableName(det.getAlias()));
        List collProperties = det.getProperties().getCollectionProperties(true);
        for (ICollectionProperty collProp : collProperties) {
            if (collProp.getItemType() == null) continue;
            IDataEntityType collEntityType = collProp.getItemType();
            collEntityType.setAlias(BusinessDataReader.getGrayTableName(collEntityType.getAlias()));
        }
        Object[] grayObjects = BusinessDataReader.readObject(pkArray, det, start, limit);
        Object[] newObjects = BusinessDataReader.mergeObject(objects, grayObjects);
        Object[] results = BusinessDataReader.sortObjectsByPks(type, pkArray, newObjects);
        if (loadReferenceData && results != null && results.length > 0) {
            BusinessDataReader.loadRefence(results, det);
        }
        return results;
    }

    private static Object[] sortObjectsByPks(IDataEntityType type, Object[] pkArray, Object[] newObjects) {
        if (pkArray.length <= 1 || newObjects.length <= 1) {
            return newObjects;
        }
        try {
            LinkedHashMap oDynamicObject = new LinkedHashMap();
            ISimpleProperty pkProp = type.getPrimaryKey();
            for (Object o : newObjects) {
                Object pkValue = pkProp.getValueFast(o);
                if (pkValue == null) continue;
                oDynamicObject.putIfAbsent(pkValue.toString(), new ArrayList());
                ((List)oDynamicObject.get(pkValue.toString())).add(o);
            }
            ArrayList orderDynamicObject = new ArrayList(newObjects.length);
            for (Object pk : pkArray) {
                List pkData;
                if (pk == null || (pkData = (List)oDynamicObject.get(pk.toString())) == null) continue;
                orderDynamicObject.addAll(pkData);
                oDynamicObject.remove(pk.toString());
            }
            Object[] returnObjects = (Object[])BusinessDataReader.createArray(newObjects[0].getClass(), orderDynamicObject.size());
            System.arraycopy(orderDynamicObject.toArray(), 0, returnObjects, 0, returnObjects.length);
            if (newObjects.length != returnObjects.length) {
                return newObjects;
            }
            return returnObjects;
        }
        catch (Exception e) {
            log.error("\u6839\u636epk\u6392\u5e8f\u51fa\u73b0\u5f02\u5e38\uff0cpkArray = {}", (Object)Arrays.toString(pkArray), (Object)e);
            return newObjects;
        }
    }

    private static Object createArray(Class obj, int size) {
        return Array.newInstance(obj, size);
    }

    private static Object[] mergeObject(Object[] objects, Object[] grayObjects) {
        if (objects == null && grayObjects == null) {
            return null;
        }
        if (grayObjects == null || grayObjects.length == 0) {
            return objects;
        }
        if (objects == null || objects.length == 0) {
            return grayObjects;
        }
        HashMap<Object, IDataEntityBase> grayObjMap = new HashMap<Object, IDataEntityBase>(30);
        for (Object grayObject : grayObjects) {
            IDataEntityBase dataEntity = (IDataEntityBase)grayObject;
            grayObjMap.put(dataEntity.getPkValue(), dataEntity);
        }
        for (int i = 0; i < objects.length; ++i) {
            IDataEntityBase dataEntity = (IDataEntityBase)objects[i];
            Object pk = dataEntity.getPkValue();
            if (!grayObjMap.containsKey(pk)) continue;
            objects[i] = grayObjMap.remove(pk);
        }
        if (grayObjMap.size() == 0) {
            return objects;
        }
        Object[] newObjs = Arrays.copyOf(objects, objects.length + grayObjMap.size());
        int i = objects.length;
        for (Object obj : grayObjMap.values()) {
            newObjs[i] = obj;
            ++i;
        }
        return newObjs;
    }

    private static Object[] readObject(Object[] pkArray, IDataEntityType det, int start, int limit) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)det);
        if (start > 0) {
            dataManager.setStartRowIndex(start);
        }
        if (limit > 0) {
            dataManager.setPageSize(Integer.valueOf(limit));
        }
        return dataManager.read(pkArray);
    }

    private static boolean isGrayFeatureMetaType(String entityNumber) {
        if (AppGroupUtils.isGrayGroup()) {
            for (String gfEntityNumber : grayFeatureMetaEntities) {
                if (!gfEntityNumber.equals(entityNumber)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private static String getGrayTableName(String tabName) {
        if (AppGroupUtils.isGrayGroup()) {
            return String.format("%s_%s", tabName, AppGroupUtils.getCurrentAppGroup());
        }
        return tabName;
    }

    private static boolean isCacheFlowControl(DynamicObjectType dt, Object[] pkArray) {
        String cacheLimitStr = SystemPropertyUtils.getProptyByTenant((String)"basedata.rediscache.limit", (String)RequestContext.get().getTenantId());
        int cacheLimit = 200000;
        if (StringUtils.isNotBlank((CharSequence)cacheLimitStr)) {
            cacheLimit = Integer.parseInt(cacheLimitStr);
        }
        if (pkArray.length > cacheLimit) {
            StringBuilder sb = new StringBuilder();
            StackTraceElement[] stes = Thread.currentThread().getStackTrace();
            int size = stes.length > 50 ? 50 : stes.length;
            for (int i = 1; i < size; ++i) {
                sb.append("\tat ").append(stes[i]);
            }
            log.info("exceed max cache limit:\n{}", (Object)sb);
            return true;
        }
        return false;
    }

    static {
        defaultBasedataCacheBlankList = new String[]{"t_sch_job"};
        log = LogFactory.getLog(BusinessDataReader.class);
        BusinessDataReader.readBasedataCacheBlackList();
        ConfigurationUtil.observeChange((String)"basedata.loadfromcache.blacklist", (key, newValue) -> BusinessDataReader.readBasedataCacheBlackList());
        grayFeatureMetaEntities = new String[]{"bos_entityobject", "bos_devportal_bizapp", "bos_devportal_bizcloud", "bos_entitymeta", "bos_billmainentity", "bos_bizpolicyobject", "bos_entityobject_cache", "bos_entityobject_print", "bos_formmeta", "bos_objecttype", "bos_printtemplate", "bos_objecttyperef"};
    }
}

