/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.data;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.PkSnapshot;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BusinessDataWriter {
    private static final Log logger = LogFactory.getLog(BusinessDataWriter.class);
    private static final String SPAN_TYPE_WRITER = "datawriter";
    private static final String SPAN_METHOD_SAVE = "save";
    private static final String SPAN_METHOD_UPDATE = "update";
    private static final String SPAN_METHOD_DELETE = "delete";
    private static final String SPAN_PARAM_TYPENAME = "type.name";
    private static final String SPAN_PARAM_TYPE = "type";
    private static final String SPAN_PARAM_DATA = "data";
    private static final String SPAN_PARAM_DATA_SIZE = "data.size";
    private static final String SPAN_PARAM_OPTION = "option";

    public static void clearDataEntityCache(IDataEntityType type) {
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
        cacheManager.removeByDt();
    }

    public static Object[] save(IDataEntityType type, Object[] dataEntities, OperateOption option) {
        if (dataEntities == null) {
            throw new IllegalArgumentException("dataEntities");
        }
        if (dataEntities.length == 0) {
            return dataEntities;
        }
        if (StringUtils.isBlank((CharSequence)type.getAlias())) {
            throw new KDBizException(new ErrorCode("BusinessDataWriter_0", ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7269\u7406\u8868\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e\u3002", (String)"BusinessDataWriter_0", (String)"bos-dao", (Object[])new Object[0])), new Object[]{type.getName()});
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_WRITER, (String)SPAN_METHOD_SAVE);){
            if (span.isRealtime()) {
                span.addTag(SPAN_PARAM_TYPENAME, type.getName());
                span.addLocaleTag(SPAN_PARAM_DATA_SIZE, (Object)dataEntities.length);
                span.addLocaleTag(SPAN_PARAM_OPTION, (Object)option);
                span.addLocaleTag(SPAN_PARAM_TYPE, (Object)type);
                span.addLocaleTag(SPAN_PARAM_DATA, (Object)dataEntities);
            }
            RefObject opValue = new RefObject();
            boolean commitPkSnapshot = true;
            boolean removeDataCache = true;
            if (option != null) {
                if (option.tryGetVariableValue("orm_commitPkSnapshot", opValue)) {
                    commitPkSnapshot = Boolean.parseBoolean((String)opValue.getValue());
                }
                if (option.tryGetVariableValue("orm_removeDataCache", opValue)) {
                    removeDataCache = Boolean.parseBoolean((String)opValue.getValue());
                }
            }
            DBRoute rt = new DBRoute(type.getDBRouteKey());
            SequenceReader seqReader = new SequenceReader(rt);
            seqReader.autoSetPrimaryKey(dataEntities, type);
            Object[] updatePks = BusinessDataWriter.getUpdatePks(type, dataEntities);
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
            dataManager.setCurrentUserId((Object)RequestContext.get().getUserId());
            dataManager.setOption(option);
            dataManager.save(dataEntities, commitPkSnapshot);
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
            if (removeDataCache) {
                if (updatePks.length > 0) {
                    cacheManager.removeByPrimaryKey(updatePks);
                } else {
                    cacheManager.removeByFilterDt();
                }
                BusinessDataWriter.addTXDataEntityCacheListener(type, updatePks);
            }
            Object[] objectArray = dataEntities;
            return objectArray;
        }
    }

    public static Object[] save(IDataEntityType type, Object[] dataEntities, boolean commitPkSnapshot) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("orm_commitPkSnapshot", String.valueOf(commitPkSnapshot));
        option.setVariableValue("orm_removeDataCache", String.valueOf(true));
        return BusinessDataWriter.save(type, dataEntities, option);
    }

    public static Object[] save(IDataEntityType type, Object[] dataEntities) {
        return BusinessDataWriter.save(type, dataEntities, true);
    }

    public static void update(IDataEntityType type, Object[] dataEntities) {
        OperateOption option = OperateOption.create();
        BusinessDataWriter.update(type, dataEntities, option);
    }

    public static void update(IDataEntityType type, Object[] dataEntities, OperateOption option) {
        if (dataEntities == null) {
            throw new IllegalArgumentException("dataEntities");
        }
        if (dataEntities.length == 0) {
            return;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_WRITER, (String)SPAN_METHOD_UPDATE);){
            if (span.isRealtime()) {
                span.addTag(SPAN_PARAM_TYPENAME, type.getName());
                span.addLocaleTag(SPAN_PARAM_DATA_SIZE, (Object)dataEntities.length);
                span.addLocaleTag(SPAN_PARAM_OPTION, (Object)option);
                span.addLocaleTag(SPAN_PARAM_TYPE, (Object)type);
                span.addLocaleTag(SPAN_PARAM_DATA, (Object)dataEntities);
            }
            IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
            dataManager.setCurrentUserId((Object)RequestContext.get().getUserId());
            dataManager.setOption(option);
            dataManager.update(dataEntities);
            Object[] updatePks = BusinessDataWriter.getUpdatePks(type, dataEntities);
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
            if (updatePks.length > 0) {
                cacheManager.removeByPrimaryKey(updatePks);
            } else {
                cacheManager.removeByFilterDt();
            }
            BusinessDataWriter.addTXDataEntityCacheListener(type, updatePks);
        }
    }

    private static Object[] getUpdatePks(IDataEntityType dt, Object[] dataEntities) {
        ArrayList<Object> pks = new ArrayList<Object>();
        block0: for (int rowIndex = 0; rowIndex < dataEntities.length; ++rowIndex) {
            PkSnapshotSet snapshotSetTemp = dt.getPkSnapshot(dataEntities[rowIndex]);
            if (snapshotSetTemp == null) continue;
            for (PkSnapshot item : snapshotSetTemp.Snapshots) {
                if (!item.TableName.equalsIgnoreCase(dt.getAlias())) continue;
                if (item.Oids == null) continue block0;
                for (Object id : item.Oids) {
                    pks.add(id);
                }
            }
        }
        return pks.toArray();
    }

    public static void delete(IDataEntityType type, Object[] pks, boolean removeCache) {
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)type);
        try (TXHandle h = TX.beginRequired();
             EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_WRITER, (String)SPAN_METHOD_DELETE);){
            if (span.isRealtime()) {
                span.addTag(SPAN_PARAM_TYPENAME, type.getName());
                span.addLocaleTag("pks", (Object)pks);
                span.addLocaleTag(SPAN_PARAM_TYPE, (Object)type);
            }
            try {
                dataManager.delete(pks);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        if (removeCache) {
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
            cacheManager.removeByPrimaryKey(pks);
        }
    }

    public static void delete(IDataEntityType type, Object[] pks) {
        BusinessDataWriter.delete(type, pks, true);
    }

    public static int delete(String entityName, QFilter[] qFilters) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_WRITER, (String)SPAN_METHOD_DELETE);){
            if (span.isRealtime()) {
                span.addTag(SPAN_PARAM_TYPENAME, entityName);
                span.addLocaleTag("filter", (Object)qFilters);
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
            String queryEntityName = entityName;
            String pkProperty = dt.getPrimaryKey().getName();
            int size = 0;
            ORM orm = ORM.create();
            try (DataSet ds = orm.queryDataSet("DeleteServiceHelper." + entityName, queryEntityName, pkProperty, qFilters, null);){
                ArrayList<Object> pks = new ArrayList<Object>();
                Iterator iter = ds.iterator();
                while (iter.hasNext()) {
                    pks.add(((Row)iter.next()).get(0));
                    ++size;
                }
                BusinessDataWriter.delete((IDataEntityType)dt, pks.toArray());
            }
            int n = size;
            return n;
        }
    }

    private static void addTXDataEntityCacheListener(final IDataEntityType type, final Object[] updatePks) {
        if (TX.inTX() && type instanceof BasedataEntityType) {
            try {
                final DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        try {
                            if (updatePks.length > 0) {
                                cacheManager.removeByPrimaryKey(updatePks);
                            } else {
                                cacheManager.removeByFilterDt();
                            }
                        }
                        catch (Throwable e) {
                            logger.error(String.format("TXDataEntityCacheListener remove cache error,dbroute is %s,table is %s ,errormsg is %s", type.getDBRouteKey(), type.getAlias(), e.getMessage()), e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                logger.error(String.format("add TXDataEntityCacheListener error,dbroute is %s,table is %s ,errormsg is %s", type.getDBRouteKey(), type.getAlias(), e.getMessage()), e);
            }
        }
    }
}

