/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flex;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.exception.OrmException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexService {
    private static Log log = LogFactory.getLog(FlexService.class);
    private static final String FVALUE = "fvalue";

    public static long save(MainEntityType flexEntityType, DynamicObject flexObject) {
        FlexEntireData fet = new FlexEntireData();
        fet.setFlexData(flexEntityType, flexObject);
        long flexId = FlexService.saveFlexData(flexEntityType, fet);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)flexEntityType);
        cacheManager.removeByPrimaryKey(new Object[]{flexEntityType.getPrimaryKey().getValue((Object)flexObject)});
        return flexId;
    }

    @Deprecated
    public static void addRefrenceCount(FlexEntityType flexEntityType, DynamicObject[] flexObjects) {
    }

    public static long saveFlexData(MainEntityType flexEntityType, FlexEntireData flexEntireData) {
        String tableName = flexEntityType.getAlias();
        String concatData = flexEntireData.concatFlexData();
        if (StringUtils.isEmpty((String)concatData)) {
            return 0L;
        }
        String dbRouteKey = flexEntityType.getDBRouteKey();
        long id = FlexService.getFlexdataId(concatData, tableName, dbRouteKey);
        if (id != 0L) {
            flexEntireData.setId(id);
            return id;
        }
        long[] ids = DB.genLongIds((String)tableName, (int)1);
        ArrayList<SqlObject> sqlObjects = new ArrayList<SqlObject>(16);
        String sql = String.format("insert into %s (fid, fvalue, fcreatetime) values (?, ?, ?)", tableName);
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)ids[0]), new SqlParameter(FVALUE, 2011, (Object)concatData), new SqlParameter("fcreatetime", 91, (Object)new Date())};
        sqlObjects.add(new SqlObject(sql, params));
        long[] entryIds = DB.genLongIds((String)tableName, (int)flexEntireData.getFlexDatas().size());
        int i = 0;
        for (Object data : flexEntireData.getFlexDatas()) {
            SqlParameter valParameter = null;
            if (data.getDbType() == FlexEntireData.FlexFieldDataType.LONG) {
                if (Long.parseLong(String.valueOf(data.getValue())) == 0L) continue;
                sql = String.format("insert into %s_bd (fentryid, fid, fflexfield, fvalue) values (?, ?, ?, ?)", tableName);
                valParameter = new SqlParameter(FVALUE, -5, data.getValue());
            } else {
                if (StringUtils.isBlank((String)String.valueOf(data.getValue()))) continue;
                sql = String.format("insert into %s_txt (fentryid, fid, fflexfield, fvalue) values (?, ?, ?, ?)", tableName);
                valParameter = new SqlParameter(FVALUE, -9, data.getValue());
            }
            params = new SqlParameter[]{new SqlParameter("fentryid", -5, (Object)entryIds[i++]), new SqlParameter("fid", -5, (Object)ids[0]), new SqlParameter("fflexpropid", 12, (Object)data.getPropId()), valParameter};
            sqlObjects.add(new SqlObject(sql, params));
        }
        try {
            try {
                Object data;
                TXHandle h = TX.beginNew();
                data = null;
                try {
                    for (SqlObject sqlObject : sqlObjects) {
                        DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sqlObject.getSql(), (Object[])sqlObject.getParams());
                    }
                }
                catch (Throwable throwable) {
                    data = throwable;
                    throw throwable;
                }
                finally {
                    if (h != null) {
                        if (data != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)data).addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                if (e instanceof OrmException) {
                    throw (OrmException)e;
                }
                throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.id=%s,concatData=%s,tablename=%s", e.getMessage(), id, concatData, tableName)});
            }
        }
        catch (KDException e) {
            FlexService.outSaveErrorLog(dbRouteKey, tableName, sqlObjects, e);
            throw e;
        }
        for (FlexEntireData.FlexData flexData : flexEntireData.getFlexDatas()) {
            flexData.setId(ids[0]);
        }
        return ids[0];
    }

    public static List<Long> batchSaveFlexData(int flexTypeId, List<FlexEntireData> flexEntireDatas) {
        FlexType ft = FlexEntityMetaUtils.getFlexType((int)flexTypeId);
        MainEntityType et = EntityMetadataCache.getDataEntityType((String)ft.getFormNumber());
        return FlexService.batchSaveFlexData(et.getDBRouteKey(), et.getAlias(), flexEntireDatas);
    }

    @Deprecated
    public static List<Long> batchSaveFlexData(MainEntityType flexEntityType, List<FlexEntireData> flexEntireDatas) {
        return FlexService.batchSaveFlexData(flexEntityType.getDBRouteKey(), flexEntityType.getAlias(), flexEntireDatas);
    }

    private static List<Long> batchSaveFlexData(String dbRouteKey, String tableName, List<FlexEntireData> flexEntireDatas) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (flexEntireDatas.size() <= 0) {
            return list;
        }
        HashMap<String, FlexEntireData> newFlexEntireDatas = new HashMap<String, FlexEntireData>();
        for (FlexEntireData flexEntireData : flexEntireDatas) {
            String concatData = flexEntireData.concatFlexData();
            if (StringUtils.isEmpty((String)concatData)) continue;
            newFlexEntireDatas.put(concatData, flexEntireData);
        }
        if (newFlexEntireDatas.size() <= 0) {
            return list;
        }
        Map<String, Long> valAndIdMap = FlexService.queryExistsValAndIdMap(newFlexEntireDatas, tableName, dbRouteKey);
        if (newFlexEntireDatas.size() > 0) {
            List<Object[]> horizontalParams = FlexService.getHorizontalParams(tableName, newFlexEntireDatas, valAndIdMap);
            Tuple<List<Object[]>, List<Object[]>> tpl = FlexService.getVerticalParams(tableName, newFlexEntireDatas, valAndIdMap);
            List verticalLongParams = (List)tpl.item1;
            List verticalStringParams = (List)tpl.item2;
            try {
                try (TXHandle h = TX.requiresNew();){
                    if (horizontalParams.size() > 0) {
                        String horizontalSql = String.format("insert into %s (fid, fvalue, fcreatetime) values (?, ?, ?)", tableName);
                        DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)horizontalSql, horizontalParams);
                    }
                    if (verticalLongParams.size() > 0) {
                        String verticalLongSql = String.format("insert into %s_bd (fentryid, fid, fflexfield, fvalue) values (?, ?, ?, ?)", tableName);
                        DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)verticalLongSql, (List)verticalLongParams);
                    }
                    if (verticalStringParams.size() > 0) {
                        String verticalStringSql = String.format("insert into %s_txt (fentryid, fid, fflexfield, fvalue) values (?, ?, ?, ?)", tableName);
                        DB.executeBatch((DBRoute)DBRoute.of((String)dbRouteKey), (String)verticalStringSql, (List)verticalStringParams);
                    }
                }
                catch (Throwable e) {
                    if (e instanceof KDException) {
                        throw (KDException)e;
                    }
                    if (e instanceof OrmException) {
                        throw (OrmException)e;
                    }
                    throw new KDException(e, BosErrorCode.sQL, new Object[]{String.format("Error:%s.", e.getMessage())});
                }
            }
            catch (KDException e) {
                FlexService.outBatchSaveErrorLog(dbRouteKey, tableName, horizontalParams, e);
                throw e;
            }
            for (FlexEntireData flexEntireData : newFlexEntireDatas.values()) {
                list.add(flexEntireData.getId());
            }
        }
        FlexService.setFlexEntireDataId(flexEntireDatas, valAndIdMap);
        return list;
    }

    private static Map<String, Long> queryExistsValAndIdMap(final Map<String, FlexEntireData> newFlexEntireMap, String tableName, String dbRouteKey) {
        Set<String> keys = newFlexEntireMap.keySet();
        if (keys.isEmpty()) {
            return new HashMap<String, Long>();
        }
        ArrayList<String> values = new ArrayList<String>(keys);
        SqlBuilder sql = new SqlBuilder();
        sql.append(String.format("select fid,fvalue from %s where ", tableName), new Object[0]).appendIn(FVALUE, values);
        Map resultMap = (Map)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws SQLException {
                HashMap<String, Long> map = new HashMap<String, Long>(16);
                while (rs.next()) {
                    String val = rs.getString(2);
                    long fid = rs.getLong(1);
                    newFlexEntireMap.remove(val);
                    map.put(val, fid);
                }
                return map;
            }
        });
        return resultMap;
    }

    private static List<Object[]> getHorizontalParams(String tableName, Map<String, FlexEntireData> newFlexEntireDatas, Map<String, Long> valAndIdMap) {
        ArrayList<Object[]> horizontalParams = new ArrayList<Object[]>(16);
        long[] ids = DB.genLongIds((String)tableName, (int)newFlexEntireDatas.size());
        Date createTime = new Date();
        int i = 0;
        for (Map.Entry<String, FlexEntireData> entry : newFlexEntireDatas.entrySet()) {
            String concatData = entry.getKey();
            Long id = ids[i++];
            entry.getValue().setId(id.longValue());
            valAndIdMap.put(concatData, id);
            Object[] params = new Object[]{id, concatData, createTime};
            horizontalParams.add(params);
        }
        return horizontalParams;
    }

    private static Tuple<List<Object[]>, List<Object[]>> getVerticalParams(String tableName, Map<String, FlexEntireData> newFlexEntireDatas, Map<String, Long> valAndIdMap) {
        int iRowCount = 0;
        for (FlexEntireData flexEntireData : newFlexEntireDatas.values()) {
            iRowCount += flexEntireData.getFlexDatas().size();
        }
        long[] entryIds = DB.genLongIds((String)tableName, (int)iRowCount);
        int i = 0;
        ArrayList<Object[]> verticalLongParams = new ArrayList<Object[]>();
        ArrayList<Object[]> verticalStringParams = new ArrayList<Object[]>();
        for (FlexEntireData flexEntireData : newFlexEntireDatas.values()) {
            Long id = flexEntireData.getId();
            if (id == null) continue;
            for (FlexEntireData.FlexData data : flexEntireData.getFlexDatas()) {
                Object[] params = new Object[]{entryIds[i++], id, data.getPropId(), data.getValue()};
                if (data.getDbType() == FlexEntireData.FlexFieldDataType.LONG) {
                    if (Long.parseLong(String.valueOf(data.getValue())) == 0L) continue;
                    verticalLongParams.add(params);
                    continue;
                }
                if (StringUtils.isBlank((String)String.valueOf(data.getValue()))) continue;
                verticalStringParams.add(params);
            }
        }
        return new Tuple(verticalLongParams, verticalStringParams);
    }

    private static void setFlexEntireDataId(List<FlexEntireData> flexEntireDatas, Map<String, Long> valAndIdMap) {
        for (FlexEntireData flexEntireData : flexEntireDatas) {
            String concatData = flexEntireData.concatFlexData();
            Long id = valAndIdMap.get(concatData);
            if (id == null) continue;
            flexEntireData.setId(id.longValue());
        }
    }

    private static long getFlexdataId(String val, String tableName, String dbRouteKey) {
        String debugVal;
        String sql = String.format("select fid from %s where fvalue = ?", tableName);
        Object[] params = new SqlParameter[]{new SqlParameter("fkey", -9, (Object)val)};
        long id = (Long)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws SQLException {
                Long ret = 0L;
                if (rs.next()) {
                    ret = rs.getLong(1);
                }
                return ret;
            }
        });
        if (id == 0L && val.equals(debugVal = System.getProperty("FlexService.getFlexDataId.debugVal"))) {
            log.error("FlexService.getFlexdataId({},{},{}), sql:{}", new Object[]{val, tableName, dbRouteKey, sql});
        }
        return id;
    }

    public static List<Long> getBaseUseFlexProperties(String entityNumber, Object basePKVal, String flexPropertyKey) {
        return FlexService.getBaseUseFlexProperties(entityNumber, basePKVal, flexPropertyKey, false);
    }

    public static Map<Object, List<Long>> getBaseUseFlexProperties(String entityNumber, String flexPropertyKey, Object[] basePKVals) {
        DynamicObjectType type;
        Map<Object, DynamicObject> dataMap;
        HashSet<String> select = new HashSet<String>();
        select.add(flexPropertyKey);
        BasedataEntityType fullType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty flexProp = (DynamicProperty)fullType.findProperty(flexPropertyKey);
        if (flexProp == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599%1$s\u7684\u5f39\u6027\u57df\u5c5e\u6027\u5b57\u6bb5%2$s\u4e0d\u5b58\u5728", (String)"FlexService_2", (String)"bos-dao", (Object[])new Object[0]), entityNumber, flexPropertyKey)});
        }
        DataEntityPropertyCollection dpc = flexProp.getParent().getProperties();
        boolean hasSeq = false;
        for (IDataEntityProperty dp : dpc) {
            if (!"seq".equals(dp.getName())) continue;
            select.add(flexProp.getParent().getName() + ".seq");
            hasSeq = true;
            break;
        }
        if ((dataMap = BusinessDataReader.loadFromCache(basePKVals, type = EntityMetadataCache.getSubDataEntityType((String)entityNumber, select), false)).isEmpty()) {
            StringBuilder ids = new StringBuilder();
            int size = 5;
            if (basePKVals.length < 5) {
                size = basePKVals.length;
            }
            for (int i = 0; i < size; ++i) {
                ids.append(basePKVals[i]).append(',');
            }
            ids.append("...");
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u57fa\u7840\u8d44\u6599id\uff1a %2$s\u5728\u8868%3$s\u4e2d\u4e0d\u5b58\u5728!", (String)"FlexService_3", (String)"bos-dao", (Object[])new Object[0]), entityNumber, ids, type.getAlias())});
        }
        HashMap<Object, List<Long>> map = new HashMap<Object, List<Long>>(16);
        for (Map.Entry<Object, DynamicObject> entry : dataMap.entrySet()) {
            Long pk;
            DynamicObject data = entry.getValue();
            DynamicObjectCollection flexPropertyCollection = (DynamicObjectCollection)data.get(flexProp.getParent().getName());
            ArrayList<Tuple> propertyTuples = new ArrayList<Tuple>(flexPropertyCollection.size());
            for (int i = 0; i < flexPropertyCollection.size(); ++i) {
                DynamicObject flexProperty = (DynamicObject)flexPropertyCollection.get(i);
                Integer seq = hasSeq ? flexProperty.getInt("seq") : i;
                pk = (Long)flexProperty.get(((BasedataProp)flexProp).getRefIdPropName());
                propertyTuples.add(new Tuple((Object)seq, (Object)pk));
            }
            propertyTuples.sort(Comparator.comparingInt(o -> (Integer)o.item1));
            ArrayList<Long> flexPropertyIds = new ArrayList<Long>();
            for (Tuple tuple : propertyTuples) {
                pk = (Long)tuple.item2;
                if (pk == null || flexPropertyIds.contains(pk)) continue;
                flexPropertyIds.add(pk);
            }
            map.put(entry.getKey(), flexPropertyIds);
        }
        return map;
    }

    @Deprecated
    public static List<Long> getBaseUseFlexProperties(String entityNumber, Object basePKVal, String flexPropertyKey, boolean fromDB) {
        HashSet<String> select = new HashSet<String>();
        select.add(flexPropertyKey);
        BasedataEntityType fullType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty flexProp = (DynamicProperty)fullType.findProperty(flexPropertyKey);
        if (flexProp == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599%1$s\u7684\u5f39\u6027\u57df\u5c5e\u6027\u5b57\u6bb5%2$s\u4e0d\u5b58\u5728", (String)"FlexService_2", (String)"bos-dao", (Object[])new Object[0]), entityNumber, flexPropertyKey)});
        }
        DataEntityPropertyCollection dpc = flexProp.getParent().getProperties();
        boolean hasSeq = false;
        for (IDataEntityProperty dp : dpc) {
            if (!"seq".equals(dp.getName())) continue;
            select.add(flexProp.getParent().getName() + ".seq");
            hasSeq = true;
            break;
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityNumber, select);
        DynamicObject data = null;
        if (fromDB) {
            data = BusinessDataReader.loadSingle(basePKVal, type, Boolean.FALSE);
        } else {
            Object[] pkVals = new Object[]{basePKVal};
            Map<Object, DynamicObject> dataMap = BusinessDataReader.loadFromCache(pkVals, type, false);
            if (!dataMap.isEmpty()) {
                data = dataMap.values().toArray(new DynamicObject[0])[0];
            }
        }
        if (data == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"%1$s\u57fa\u7840\u8d44\u6599id\uff1a %2$s\u5728\u8868%3$s\u4e2d\u4e0d\u5b58\u5728!", (String)"FlexService_3", (String)"bos-dao", (Object[])new Object[0]), entityNumber, basePKVal, type.getAlias())});
        }
        DynamicObjectCollection rows1 = (DynamicObjectCollection)data.get(flexProp.getParent().getName());
        DynamicObjectCollection rows = (DynamicObjectCollection)rows1.clone();
        if (hasSeq) {
            rows.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o1.getInt("seq") - o2.getInt("seq");
                }
            });
        }
        ArrayList<Long> flexPropertyIds = new ArrayList<Long>();
        for (DynamicObject dynamicObject : rows) {
            Long pk = (Long)dynamicObject.get(((BasedataProp)flexProp).getRefIdPropName());
            if (pk == null || flexPropertyIds.contains(pk)) continue;
            flexPropertyIds.add(pk);
        }
        return flexPropertyIds;
    }

    public static Map<Object, List<Long>> getFlexProperties(String entityNumber, Object[] pkVals) {
        String flexPropertyKey;
        BasedataEntityType fullType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty baseEnableFlex = (DynamicProperty)fullType.findProperty(flexPropertyKey = FlexService.getBDFlexPropertyKey(fullType));
        if (baseEnableFlex == null) {
            throw new KDException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599%1$s\u7684\u5f39\u6027\u57df\u5c5e\u6027\u5b57\u6bb5%2$s\u4e0d\u5b58\u5728", (String)"FlexService_2", (String)"bos-dao", (Object[])new Object[0]), entityNumber, flexPropertyKey)});
        }
        DataEntityPropertyCollection dpc = baseEnableFlex.getParent().getProperties();
        boolean hasSeq = false;
        HashSet<String> select = new HashSet<String>();
        select.add(flexPropertyKey);
        for (IDataEntityProperty dp : dpc) {
            if (!"seq".equals(dp.getName())) continue;
            select.add(baseEnableFlex.getParent().getName() + ".seq");
            hasSeq = true;
            break;
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityNumber, select);
        Map<Object, DynamicObject> dataMap = BusinessDataReader.loadFromCache(pkVals, type, false);
        HashMap<Object, List<Long>> ret = new HashMap<Object, List<Long>>(16);
        if (dataMap.isEmpty()) {
            return ret;
        }
        for (Map.Entry<Object, DynamicObject> entry : dataMap.entrySet()) {
            DynamicObjectCollection rows1 = (DynamicObjectCollection)entry.getValue().get(baseEnableFlex.getParent().getName());
            DynamicObjectCollection rows = (DynamicObjectCollection)rows1.clone();
            if (hasSeq) {
                rows.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        return o1.getInt("seq") - o2.getInt("seq");
                    }
                });
            }
            DynamicProperty refProp = rows.getDynamicObjectType().getProperty(((BasedataProp)baseEnableFlex).getRefIdPropName());
            ArrayList<Long> flexPropertyIds = new ArrayList<Long>(16);
            for (DynamicObject dynamicObject : rows) {
                Long pk = (Long)refProp.getDTValueFast(dynamicObject);
                if (pk == null || flexPropertyIds.contains(pk)) continue;
                flexPropertyIds.add(pk);
            }
            ret.put(entry.getKey(), flexPropertyIds);
        }
        return ret;
    }

    private static String getBDFlexPropertyKey(BasedataEntityType baseEntityType) {
        String baseDataFlexPropertyKey = baseEntityType.getFlexProperty();
        if (StringUtils.isBlank((String)baseDataFlexPropertyKey) && baseEntityType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
            baseDataFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
        }
        return baseDataFlexPropertyKey;
    }

    private static void outSaveErrorLog(String dbRouteKey, String tableName, List<SqlObject> sqlObjects, KDException e) {
        try {
            ErrorCode ec = e.getErrorCode();
            if (BosErrorCode.sQLDuplicateKey.getCode().equals(ec.getCode())) {
                ArrayList<Object[]> horizontalParams = new ArrayList<Object[]>();
                Object[] errParams = new Object[]{sqlObjects.get(0).getParams()[0].getValue(), sqlObjects.get(0).getParams()[1].getValue(), sqlObjects.get(0).getParams()[2].getValue()};
                horizontalParams.add(errParams);
                FlexService.logDuplicateKey(dbRouteKey, tableName, horizontalParams);
            }
        }
        catch (Exception ex) {
            log.error("out save log error.", (Throwable)ex);
        }
    }

    private static void outBatchSaveErrorLog(String dbRouteKey, String tableName, List<Object[]> horizontalParams, KDException e) {
        try {
            ErrorCode ec = e.getErrorCode();
            if (BosErrorCode.sQLDuplicateKey.getCode().equals(ec.getCode())) {
                FlexService.logDuplicateKey(dbRouteKey, tableName, horizontalParams);
            }
        }
        catch (Exception ex) {
            log.error("out save log error.", (Throwable)ex);
        }
    }

    private static void logDuplicateKey(String dbRouteKey, String tableName, List<Object[]> horizontalParams) {
        Object[] values = new Object[horizontalParams.size()];
        for (int i = 0; i < horizontalParams.size(); ++i) {
            Object[] params = horizontalParams.get(i);
            values[i] = params[1];
        }
        final StringBuilder msg = new StringBuilder();
        msg.append("FlexService save DuplicateKey error log. DB exists data:{");
        SqlBuilder sql = new SqlBuilder();
        sql.append(String.format("select fid,fvalue from %s where ", tableName), new Object[0]).appendIn(FVALUE, values);
        Map resultMap = (Map)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (SqlBuilder)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                while (rs.next() && msg.length() <= 1000) {
                    msg.append("id:").append(rs.getLong(1));
                    msg.append(",val:").append(rs.getString(2)).append(";");
                }
                return null;
            }
        });
        msg.append("}");
        log.warn(msg.toString());
    }
}

