/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.isv;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import javax.crypto.Cipher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.binary.Base64;

public class EncryptUtils {
    private static final Log LOG = LogFactory.getLog(EncryptUtils.class);
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String KEY_ALGORITHM = "RSA";
    private static final String KEY_ALG_SIGN = "sha256withRSA";
    protected static final String PUBLIC_KEY = EncryptUtils.getPublicKey();

    @Deprecated
    public static String sign(String data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(KEY_ALG_SIGN);
        signature.initSign((PrivateKey)EncryptUtils.getPrivateKey(privateKey));
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    @Deprecated
    public static boolean verify(String data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(KEY_ALG_SIGN);
        signature.initVerify((PublicKey)EncryptUtils.getPublicKey(publicKey));
        signature.update(data.getBytes(StandardCharsets.UTF_8));
        return signature.verify(Base64.decodeBase64((byte[])sign.getBytes(StandardCharsets.UTF_8)));
    }

    @Deprecated
    public static String publicEncrypt(String data, String publicKey) throws Exception {
        return EncryptUtils.encrypt(data, EncryptUtils.getPublicKey(publicKey));
    }

    @Deprecated
    public static String privateDecrypt(String data, String privateKey) throws Exception {
        return EncryptUtils.decrypt(data, EncryptUtils.getPrivateKey(privateKey));
    }

    public static String privateEncrypt(String data, String privateKey) throws Exception {
        return EncryptUtils.encrypt(data, EncryptUtils.getPrivateKey(privateKey));
    }

    public static String publicDecrypt(String data, String publicKey) throws Exception {
        return EncryptUtils.decrypt(data, EncryptUtils.getPublicKey(publicKey));
    }

    private static String encrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, key);
        int inputLen = data.getBytes(StandardCharsets.UTF_8).length;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes(StandardCharsets.UTF_8), offset, 117) : cipher.doFinal(data.getBytes(StandardCharsets.UTF_8), offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            String string = Base64.encodeBase64String((byte[])encryptedData);
            return string;
        }
    }

    private static String decrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, key);
        byte[] dataBytes = Base64.decodeBase64((String)data);
        int inputLen = dataBytes.length;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(dataBytes, offset, 128) : cipher.doFinal(dataBytes, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            String string = new String(decryptedData, StandardCharsets.UTF_8);
            return string;
        }
    }

    private static String byte2hex(byte[] b) {
        StringBuilder str = new StringBuilder();
        char zero = '0';
        for (int n = 0; b != null && n < b.length; ++n) {
            String tmp = Integer.toHexString(b[n] & 0xFF);
            if (tmp.length() == 1) {
                str.append(zero);
            }
            str.append(tmp);
        }
        return str.toString();
    }

    public static KeyPair getKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        generator.initialize(keySize);
        return generator.generateKeyPair();
    }

    public static String getPrivateKey(KeyPair keyPair) {
        return Base64.encodeBase64String((byte[])keyPair.getPrivate().getEncoded());
    }

    public static String getPublicKey(KeyPair keyPair) {
        return Base64.encodeBase64String((byte[])keyPair.getPublic().getEncoded());
    }

    private static Key getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64((byte[])privateKey.getBytes(StandardCharsets.UTF_8));
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    private static Key getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64((byte[])publicKey.getBytes(StandardCharsets.UTF_8));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPublicKey() {
        Properties properties = new Properties();
        try (InputStream is = EncryptUtils.class.getResourceAsStream("/resources/public.properties");){
            properties.load(is);
            String string = (String)properties.get("public");
            return string;
        }
        catch (IOException ioException) {
            LOG.error("EncryptUtils.getpublic \u83b7\u53d6publickey\u5931\u8d25\u3002");
            return "";
        }
    }
}

