/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.isv;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.ISVSignInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.EncryptUtils;
import kd.bos.isv.ISVSignUtils;
import kd.bos.isv.IsvParamCache;
import kd.bos.isv.api.IISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class ISVService
implements IISVService {
    private static final Log LOG = LogFactory.getLog(ISVService.class);
    private static final String META_SIGN_TABLE = "T_BAS_METASIGN";
    private static final String REBUILD_SYNC_METASIGN = "rebuild.sync.metasign";
    private static final String LICENSE_IS_NEED_SIGN = "license.isNeedSign";
    private static boolean syncMetaSign = true;
    private static boolean licenseIsNeedSign = true;
    private static final String KINGDEE = "kingdee";

    public static ISVInfo getISVInfo() {
        IDataEntityType dt = OrmUtils.getDataEntityType(ISVInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        boolean check = IsvParamCache.getIsvCheck();
        QFilter[] filters = new QFilter[]{check ? new QFilter("id", "!=", (Object)"") : new QFilter("id", "is not null", (Object)"")};
        Object[] cacheObjects = cacheMgr.getCachePks(filters);
        ISVInfo isv = null;
        if (cacheObjects != null) {
            isv = (ISVInfo)cacheObjects[0];
        }
        if (StringUtils.isBlank(isv)) {
            boolean checkIsv = true;
            IISVService service = (IISVService)ServiceFactory.getService(IISVService.class);
            Map currentISVInfo = service.getCurrentISVInfo();
            if (currentISVInfo != null) {
                isv = new ISVInfo();
                isv.setId((String)currentISVInfo.get("id"));
                isv.setType((String)currentISVInfo.get("type"));
                isv.setName((String)currentISVInfo.get("name"));
                isv.setIsvId((String)currentISVInfo.get("isvid"));
                checkIsv = false;
            } else {
                isv = (ISVInfo)DB.query((DBRoute)DBRoute.meta, (String)"select FISVID, FTYPE, FNAME, FID from T_BAS_ISV", (ResultSetHandler)new ResultSetHandler<ISVInfo>(){

                    public ISVInfo handle(ResultSet rs) throws SQLException {
                        ISVInfo isv = new ISVInfo();
                        if (rs.next()) {
                            isv.setId(rs.getString(1));
                            isv.setType(rs.getString(2));
                            isv.setName(rs.getString(3));
                            isv.setIsvId(rs.getString(4));
                        }
                        return isv;
                    }
                });
            }
            if (StringUtils.isNotBlank((Object)isv)) {
                ISVService.isvVerify(isv, checkIsv && check);
                cacheMgr.putCachePks(filters, (Object[])new ISVInfo[]{isv});
            }
        }
        return isv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean save(ISVInfo isvInfo) {
        String sql = "insert into T_BAS_ISV (FISVID, FTYPE, FNAME, FID) values(?, ?, ?, ?)";
        Object[] params = new SqlParameter[]{new SqlParameter("FISVID", 12, (Object)isvInfo.getId()), new SqlParameter("FTYPE", 12, (Object)isvInfo.getType()), new SqlParameter("FNAME", 12, (Object)isvInfo.getName()), new SqlParameter("FID", 1, (Object)isvInfo.getIsvId())};
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
            Integer isvcount = (Integer)DB.query((DBRoute)DBRoute.meta, (String)"select count(1) from T_BAS_ISV", (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet rs) throws SQLException {
                    int isvcount = 0;
                    if (rs.next()) {
                        isvcount = rs.getInt(1);
                    }
                    return isvcount;
                }
            });
            if (isvcount > 1) {
                h.markRollback();
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            h.markRollback();
            throw e;
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(ISVInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        cacheMgr.removeByDt();
        cacheMgr.removeByFilterDt();
        ISVService.saveSign(isvInfo);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveSign(ISVInfo isvInfo) {
        String sql = "insert into T_BAS_USERCONFIG (FUSERCONFIGID ,FKEY,FUSERID,FSETTING) values(?, ?, ?, ?)";
        Object[] params = new SqlParameter[]{new SqlParameter("FUSERCONFIGID", 12, (Object)DB.genStringId((String)"T_BAS_USERCONFIG")), new SqlParameter("FKEY", 12, (Object)"bos_isv_register"), new SqlParameter("FUSERID", -5, (Object)0), new SqlParameter("FSETTING", 12, (Object)isvInfo.getSign())};
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            Integer isvcount = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)"select count(1) from T_BAS_USERCONFIG where fkey = 'bos_isv_register'", (ResultSetHandler)new ResultSetHandler<Integer>(){

                public Integer handle(ResultSet rs) throws SQLException {
                    int isvcount = 0;
                    if (rs.next()) {
                        isvcount = rs.getInt(1);
                    }
                    return isvcount;
                }
            });
            if (isvcount <= 1) return true;
            h.markRollback();
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            h.markRollback();
            throw e;
        }
    }

    public static Map<String, String> decode(String license) throws Exception {
        String isvLicenseStr = EncryptUtils.publicDecrypt(license, EncryptUtils.PUBLIC_KEY);
        return (Map)SerializationUtils.fromJsonString((String)isvLicenseStr, Map.class);
    }

    public static String getIsvSign(String metaNumber) {
        if (!licenseIsNeedSign) {
            return "";
        }
        ISVInfo info = ISVService.getISVInfo();
        String isv = null;
        if (info != null) {
            isv = info.getId();
        }
        if (StringUtils.isBlank(isv) || !KINGDEE.equals(isv)) {
            return "";
        }
        return ISVSignUtils.getSignFromSignServer(metaNumber, isv);
    }

    public static void insertSign(String formNumber, String signStr) {
        Object[] params;
        if (!syncMetaSign) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)formNumber) || StringUtils.isBlank((CharSequence)signStr)) {
            LOG.warn(String.format("formNumebr : '%s' \u6216 sign \uff1a '%s'\u4e3a\u7a7a\uff0c\u9000\u51fa\u540c\u6b65\u7b7e\u540d", formNumber, signStr));
            return;
        }
        ISVSignInfo info = new ISVSignInfo(formNumber, signStr);
        IDataEntityType type = OrmUtils.getDataEntityType(ISVSignInfo.class);
        String sql = String.format("SELECT FID FROM %s WHERE FNUMBER = ?", META_SIGN_TABLE);
        String fid = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])(params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)formNumber)}), (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        });
        if (StringUtils.isBlank((CharSequence)fid)) {
            long id = DB.genGlobalLongId();
            info.setId(id);
            BusinessDataWriter.save(type, new Object[]{info});
        } else {
            String updSql = String.format("UPDATE %s SET FSIGN = ? WHERE FNUMBER = ?", META_SIGN_TABLE);
            Object[] updParams = new Object[]{signStr, formNumber};
            DB.execute((DBRoute)DBRoute.meta, (String)updSql, (Object[])updParams);
        }
    }

    private static void isvVerify(ISVInfo isv, boolean checkIsv) {
        if (!checkIsv) {
            return;
        }
        if (KINGDEE.equals(isv.getId())) {
            String sign = (String)DB.query((DBRoute)DBRoute.basedata, (String)"select FUSERCONFIGID ,FKEY,FUSERID,FSETTING from T_BAS_USERCONFIG where FKEY = 'bos_isv_register'", (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        return rs.getString(4);
                    }
                    return "";
                }
            });
            String errMsg = ResManager.loadKDString((String)"\u4e0d\u5408\u6cd5\u7684\u5f00\u53d1\u5546\u6807\u8bc6", (String)"ISVService_0", (String)"bos-dao", (Object[])new Object[0]);
            if (StringUtils.isBlank((CharSequence)sign)) {
                throw new KDException(new ErrorCode("bos.invalidisv", errMsg), new Object[]{errMsg});
            }
            Map<String, String> jsonObj = null;
            try {
                jsonObj = ISVService.decode(sign);
            }
            catch (Exception e) {
                String invalidsign = ResManager.loadKDString((String)"\u4e0d\u5408\u6cd5\u7684\u5f00\u53d1\u5546\u6807\u8bc6\u7b7e\u540d", (String)"ISVService_1", (String)"bos-dao", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("bos.invalidsign", invalidsign), new Object[]{invalidsign});
            }
            String signIsv = jsonObj.get("isv");
            if (!isv.getId().equals(signIsv)) {
                throw new KDException(new ErrorCode("bos.invalidisv", errMsg), new Object[]{errMsg});
            }
        }
    }

    public Map<String, String> getCurrentISVInfo() {
        return null;
    }

    static {
        syncMetaSign = Boolean.parseBoolean(System.getProperty(REBUILD_SYNC_METASIGN, "true"));
        ConfigurationUtil.observeChange((String)REBUILD_SYNC_METASIGN, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                syncMetaSign = Boolean.parseBoolean(System.getProperty(ISVService.REBUILD_SYNC_METASIGN, "true"));
            }
        });
        licenseIsNeedSign = Boolean.parseBoolean(System.getProperty(LICENSE_IS_NEED_SIGN, "true"));
        ConfigurationUtil.observeChange((String)LICENSE_IS_NEED_SIGN, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                licenseIsNeedSign = Boolean.parseBoolean(System.getProperty(ISVService.LICENSE_IS_NEED_SIGN, "true"));
            }
        });
    }
}

