/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.isv;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ISVSignUtils {
    private static Log log = LogFactory.getLog(ISVSignUtils.class);
    private static String UPGRADE_LOGIN_API = "/api/upgradeLogin.do";
    private static String SIGN_SERVER_API = "/kapi/app/mc/getMetaSign";
    private static final String ISV_SIGN_MC_TOKEN = "ISV_SIGN_MC_TOKEN";
    private static final String SUCCESS = "success";
    private static final int TOKEN_CACHE_TIMEOUT = 3600;
    private static int CONNECTION_TIMEOUT = 1000;
    private static int READ_TIMEOUT = 1000;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ISV_SIGN_MC_TOKEN", new DistributeCacheHAPolicy());

    protected static String getSignFromSignServer(String metaNumber, String isv) {
        String server = System.getProperty("mc.server.url");
        if (StringUtils.isBlank((CharSequence)server)) {
            log.info("\u672a\u914d\u7f6e\u7b7e\u540d\u670d\u52a1\u5668\u5730\u5740\uff0c\u8bf7\u5148\u5728MC\u516c\u5171\u914d\u7f6e\u9879\u4e2d\u914d\u7f6e\u3002");
            return "";
        }
        String accessToken = ISVSignUtils.getAccessToken(server);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            accessToken = ISVSignUtils.getAccessToken(server);
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.info("\u83b7\u53d6token\u5931\u8d25\uff0c\u9000\u51fa\u7b7e\u540d");
            return "";
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("api", "true");
        header.put("accessToken", accessToken);
        header.put("Content-Type", "application/json");
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("isv", isv);
        postData.put("formId", metaNumber);
        try {
            String resultStr = MCApiUtil.callMcApiService((String)SIGN_SERVER_API, (String)"text/json", header, postData, (int)CONNECTION_TIMEOUT);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                resultStr = MCApiUtil.callMcApiService((String)SIGN_SERVER_API, (String)"text/json", header, postData, (int)CONNECTION_TIMEOUT);
            }
            if (StringUtils.isNotBlank((CharSequence)resultStr)) {
                Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
                boolean success = false;
                Object obj = result.get(SUCCESS);
                if (obj instanceof String) {
                    success = Boolean.parseBoolean((String)obj);
                } else if (obj instanceof Boolean) {
                    success = (Boolean)obj;
                }
                if (success) {
                    Map data;
                    Map map = data = result.get("data") == null ? null : (Map)result.get("data");
                    if (data != null) {
                        boolean isSuccess;
                        boolean bl = isSuccess = data.get("isSuccess") == null ? false : (Boolean)data.get("isSuccess");
                        if (isSuccess) {
                            return data.get("sign") == null ? "" : (String)data.get("sign");
                        }
                    }
                }
                return "";
            }
            return "";
        }
        catch (Exception e) {
            log.error("\u8bbf\u95ee\u7b7e\u540d\u670d\u52a1\u5668\u6545\u969c", (Throwable)e);
            return "";
        }
    }

    private static String getAccessToken(String server) {
        String cacheToken = (String)cache.get(ISVSignUtils.getTokenCacheKey());
        if (StringUtils.isNotBlank((CharSequence)cacheToken)) {
            return cacheToken;
        }
        HashMap<String, String> postData = new HashMap<String, String>(2);
        postData.put("accountId", "");
        postData.put("tenantid", "");
        HashMap headers = new HashMap();
        try {
            String state;
            String resultStr = MCApiUtil.callMcApiService((String)UPGRADE_LOGIN_API, (String)"text/json", headers, postData, (int)READ_TIMEOUT);
            if (StringUtils.isBlank((CharSequence)resultStr)) {
                return "";
            }
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            String string = state = result.get("state") == null ? "" : (String)result.get("state");
            if (SUCCESS.equals(state)) {
                Map data;
                Map map = data = result.get("data") == null ? null : (Map)result.get("data");
                if (data != null) {
                    String accessToken = data.get("access_token") == null ? "" : (String)data.get("access_token");
                    cache.put(ISVSignUtils.getTokenCacheKey(), (Object)accessToken, 3600);
                    return accessToken;
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6MC token\u5931\u8d25,err:" + e.getMessage());
        }
        return "";
    }

    private static String getTokenCacheKey() {
        return String.format("%s_%s", CacheKeyUtil.getAcctId(), ISV_SIGN_MC_TOKEN);
    }
}

