/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.isv;

import java.sql.ResultSet;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.ISVSignInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isv.ISVService;
import kd.bos.isv.ISVSignUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public class MetaSignService {
    private static Log log = LogFactory.getLog(MetaSignService.class);
    private static String rebuild_sync_metasign = "rebuild.sync.metasign";
    private static String license_isNeedSign = "license.isNeedSign";
    private static boolean syncMetaSign = true;
    private static boolean licenseIsNeedSign = false;
    private String appGroup;

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    public String getIsvSign(String metaNumber) {
        if (!licenseIsNeedSign) {
            return "";
        }
        ISVInfo info = ISVService.getISVInfo();
        if (StringUtils.isBlank((CharSequence)info.getId())) {
            return "";
        }
        return ISVSignUtils.getSignFromSignServer(metaNumber, info.getId());
    }

    public void insertSign(String formNumber, String signStr) {
        Object[] params;
        if (!syncMetaSign) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)formNumber) || StringUtils.isBlank((CharSequence)signStr)) {
            log.info(String.format("formNumebr : '%s' \u6216 sign \uff1a '%s'\u4e3a\u7a7a\uff0c\u9000\u51fa\u540c\u6b65\u7b7e\u540d", formNumber, signStr));
            return;
        }
        ISVSignInfo info = new ISVSignInfo(formNumber, signStr);
        IDataEntityType type = this.getGrayDeataEntityType(OrmUtils.getDataEntityType(ISVSignInfo.class));
        String tableName = type.getAlias();
        String sql = String.format("SELECT FID FROM %s WHERE FNUMBER = ?", tableName);
        String fid = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])(params = new SqlParameter[]{new SqlParameter("FNUMBER", 12, (Object)formNumber)}), (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return "";
            }
        });
        if (StringUtils.isBlank((CharSequence)fid)) {
            long id = DB.genGlobalLongId();
            info.setId(id);
            BusinessDataWriter.save(type, new Object[]{info});
        } else {
            String updSql = String.format("UPDATE %s SET FSIGN = ? WHERE FNUMBER = ?", tableName);
            Object[] updParams = new Object[]{signStr, formNumber};
            DB.execute((DBRoute)DBRoute.meta, (String)updSql, (Object[])updParams);
        }
    }

    private IDataEntityType getGrayDeataEntityType(IDataEntityType designerMetaType) {
        IDataEntityType det;
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return designerMetaType;
        }
        try {
            det = (IDataEntityType)designerMetaType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        det.setAlias(String.format("%s_%s", det.getAlias(), this.appGroup));
        return det;
    }

    static {
        syncMetaSign = Boolean.parseBoolean(System.getProperty(rebuild_sync_metasign, "true"));
        ConfigurationUtil.observeChange((String)rebuild_sync_metasign, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                syncMetaSign = Boolean.parseBoolean(System.getProperty(rebuild_sync_metasign, "true"));
            }
        });
        licenseIsNeedSign = Boolean.parseBoolean(System.getProperty(license_isNeedSign));
        ConfigurationUtil.observeChange((String)license_isNeedSign, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                licenseIsNeedSign = Boolean.parseBoolean(System.getProperty(license_isNeedSign));
            }
        });
    }
}

