/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.list.query.impl.BaseData;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class BaseDataQuery {
    private static final String LONG_NUMBER = "longnumber";
    private static final String FULL_NAME = "fullname";

    private BaseDataQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> queryPkIdsByFilter(String entityId, QFilter[] qFilters) {
        ArrayList<Object> pkIds = new ArrayList<Object>();
        ArrayList<QFilter> thisQFilters = new ArrayList<QFilter>();
        thisQFilters.addAll(Arrays.asList(qFilters));
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("BaseDataQuery_queryPkIdsByField_" + entityId, entityId, "id", thisQFilters.toArray(new QFilter[0]), null);){
            try {
                Iterator iter = ds.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (++i > 10000) {
                        break;
                    }
                    Row next = (Row)iter.next();
                    pkIds.add(next.get(0));
                }
            }
            finally {
                ds.close();
            }
        }
        return pkIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> queryPkIdsByField(String entityId, String propKey, List<Object> filterValues, QFilter[] qFilters) {
        ArrayList<Object> pkIds = new ArrayList<Object>();
        ArrayList<QFilter> thisQFilters = new ArrayList<QFilter>();
        thisQFilters.addAll(Arrays.asList(qFilters));
        thisQFilters.add(new QFilter(propKey, "in", filterValues));
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("BaseDataQuery_queryPkIdsByField_" + entityId, entityId, "id", thisQFilters.toArray(new QFilter[0]), null);){
            try {
                Iterator iter = ds.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (++i > 10000) {
                        break;
                    }
                    Row next = (Row)iter.next();
                    pkIds.add(next.get(0));
                }
            }
            finally {
                ds.close();
            }
        }
        return pkIds;
    }

    public static List<BaseData> queryBaseDataByFilter(BasedataEntityType basedataEntityType, QFilter[] qFilters) {
        return BaseDataQuery.queryBaseDataByFilter(basedataEntityType, qFilters, false);
    }

    public static List<BaseData> queryBaseDataByFilter(BasedataEntityType basedataEntityType, QFilter[] qFilters, boolean isTreeBaseData) {
        String numberKey = basedataEntityType.getNumberProperty();
        String nameKey = basedataEntityType.getNameProperty();
        return BaseDataQuery.queryBaseData(basedataEntityType, numberKey, nameKey, qFilters, isTreeBaseData);
    }

    public static List<BaseData> queryBaseDataOrBizBaseData(BasedataEntityType basedataEntityType, QFilter[] qFilters, boolean isTreeBaseData) {
        IDataEntityProperty masteridProp;
        String numberKey = basedataEntityType.getNumberProperty();
        String nameKey = basedataEntityType.getNameProperty();
        if (StringUtils.isNotBlank((CharSequence)basedataEntityType.getMasteridPropName()) && basedataEntityType.getMasteridType() == 2 && (masteridProp = basedataEntityType.findProperty(basedataEntityType.getMasteridPropName())) instanceof MasterBasedataProp) {
            RefEntityType refDBType2 = (RefEntityType)((MasterBasedataProp)masteridProp).getComplexType();
            if (StringUtils.isNotBlank((CharSequence)refDBType2.getNumberProperty())) {
                numberKey = String.format("%s.%s", basedataEntityType.getMasteridPropName(), refDBType2.getNumberProperty());
            }
            if (StringUtils.isNotBlank((CharSequence)refDBType2.getNameProperty())) {
                nameKey = String.format("%s.%s", basedataEntityType.getMasteridPropName(), refDBType2.getNameProperty());
            }
        }
        return BaseDataQuery.queryBaseData(basedataEntityType, numberKey, nameKey, qFilters, isTreeBaseData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<BaseData> queryBaseData(BasedataEntityType basedataEntityType, String numberKey, String nameKey, QFilter[] qFilters, boolean isTreeBaseData) {
        ArrayList<BaseData> baseDatas = new ArrayList<BaseData>();
        String entityId = basedataEntityType.getName();
        DynamicProperty longNumberProp = null;
        DynamicProperty fullNameProp = null;
        HashSet<String> selectFieldList = new HashSet<String>(5);
        selectFieldList.add("id");
        if (StringUtils.isNotBlank((CharSequence)numberKey)) {
            selectFieldList.add(numberKey);
        }
        if (StringUtils.isNotBlank((CharSequence)nameKey)) {
            selectFieldList.add(nameKey);
        }
        if (isTreeBaseData) {
            longNumberProp = basedataEntityType.getProperty(LONG_NUMBER);
            if (longNumberProp != null) {
                selectFieldList.add(LONG_NUMBER);
            }
            if ((fullNameProp = basedataEntityType.getProperty(FULL_NAME)) != null) {
                selectFieldList.add(FULL_NAME);
            }
        }
        ArrayList<QFilter> thisQFilters = new ArrayList<QFilter>();
        thisQFilters.addAll(Arrays.asList(qFilters));
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("BaseDataQuery_queryBaseDataByFilter_" + entityId, entityId, StringUtils.join((Object[])selectFieldList.toArray(), (String)","), thisQFilters.toArray(new QFilter[0]), null);){
            try {
                for (Row next : ds) {
                    Object fid = next.get("id");
                    String number = null;
                    String name = null;
                    String longNumber = null;
                    String fullName = null;
                    if (StringUtils.isNotBlank((CharSequence)numberKey)) {
                        number = next.getString(numberKey);
                    }
                    if (StringUtils.isNotBlank((CharSequence)nameKey)) {
                        name = next.getString(nameKey);
                    }
                    if (longNumberProp != null) {
                        longNumber = next.getString(LONG_NUMBER);
                    }
                    if (fullNameProp != null) {
                        fullName = next.getString(FULL_NAME);
                    }
                    baseDatas.add(new BaseData(fid, number, name, longNumber, fullName));
                }
            }
            finally {
                ds.close();
            }
        }
        return baseDatas;
    }
}

