/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.list.query.impl.MulBaseData;
import kd.bos.list.query.impl.MulBaseDataQuery;
import kd.bos.list.query.impl.MulBaseDataQueryInfo;
import kd.bos.list.query.impl.MulBaseDataRow;

final class MulBaseDataMapper {
    private Map<MulBasedataProp, Map<Object, List<MulBaseData>>> mulBasedataDataMap;
    private MainEntityType mainEntityType;
    private Map<MulBasedataProp, LinkedHashSet<Object>> mulBaseDataObjectTypeMap = new HashMap<MulBasedataProp, LinkedHashSet<Object>>(16);
    private List<MulBaseDataRow> mulBaseDataRows = new ArrayList<MulBaseDataRow>(10);
    private int pkIndex;
    private List<Object> pkList;
    private List<MulBasedataProp> mulBasedataProps;

    int getPkIndex() {
        return this.pkIndex;
    }

    List<MulBasedataProp> getMulBasedataProps() {
        return this.mulBasedataProps;
    }

    MulBaseDataMapper(MainEntityType mainEntityType, List<Object> pkList, List<MulBasedataProp> mulBasedataProps, int pkIndex) {
        this.mainEntityType = mainEntityType;
        this.pkList = pkList;
        this.mulBasedataProps = mulBasedataProps;
        this.pkIndex = pkIndex;
        this.mulBasedataDataMap = new HashMap<MulBasedataProp, Map<Object, List<MulBaseData>>>();
    }

    void buildMulBasedataData() {
        for (MulBasedataProp mulBasedataProp : this.mulBasedataProps) {
            this.buildMulBasedataDataMap(mulBasedataProp);
        }
    }

    void addMulBaseDataRow(MulBasedataProp mulBasedataProp, Object pkValue, DynamicObject parent) {
        Object[] basedataPkList = this.getMulBasedataPkList((IDataEntityProperty)mulBasedataProp, pkValue);
        if (basedataPkList.length == 0) {
            return;
        }
        LinkedHashSet<Object> allBaseDataIdSet = this.mulBaseDataObjectTypeMap.get(mulBasedataProp);
        if (allBaseDataIdSet == null) {
            allBaseDataIdSet = new LinkedHashSet(10);
        }
        allBaseDataIdSet.addAll(Arrays.asList(basedataPkList));
        this.mulBaseDataObjectTypeMap.put(mulBasedataProp, allBaseDataIdSet);
        this.mulBaseDataRows.add(new MulBaseDataRow(mulBasedataProp, basedataPkList, parent));
    }

    void loadAndFillMulBaseDataRows() {
        for (Map.Entry<MulBasedataProp, LinkedHashSet<Object>> dynamicObjectTypeListEntry : this.mulBaseDataObjectTypeMap.entrySet()) {
            MulBasedataProp mulBasedataProp = dynamicObjectTypeListEntry.getKey();
            DynamicObjectType complexType = (DynamicObjectType)mulBasedataProp.getRefBaseProp().getComplexType();
            Map<Object, DynamicObject> refBaseDynObj = BusinessDataReader.loadFromCache(dynamicObjectTypeListEntry.getValue().toArray(), complexType);
            for (MulBaseDataRow mulBaseDataRow : this.mulBaseDataRows) {
                if (!mulBaseDataRow.getMulBasedataProp().equals((Object)mulBasedataProp)) continue;
                LinkedHashMap<Object, DynamicObject> rowRefBaseDynObj = new LinkedHashMap<Object, DynamicObject>(mulBaseDataRow.getPkList().length);
                for (Object o : mulBaseDataRow.getPkList()) {
                    DynamicObject dynamicObject = refBaseDynObj.get(o);
                    if (dynamicObject == null) continue;
                    rowRefBaseDynObj.put(o, dynamicObject);
                }
                if (rowRefBaseDynObj.isEmpty()) continue;
                mulBasedataProp.setValueFast((Object)mulBaseDataRow.getDynamicObject(), (Object)this.getMulBasedataPropValue(mulBasedataProp, rowRefBaseDynObj, mulBaseDataRow.getDynamicObject()));
            }
        }
    }

    private DynamicObjectCollection getMulBasedataPropValue(MulBasedataProp mulBasedataProp, Map<Object, DynamicObject> refBaseDynObj, DynamicObject parent) {
        DynamicObjectCollection objs = new DynamicObjectCollection(mulBasedataProp.getDynamicCollectionItemPropertyType(), (Object)parent);
        for (Map.Entry<Object, DynamicObject> entry : refBaseDynObj.entrySet()) {
            DynamicObject bsdObj = entry.getValue();
            DynamicObject newObj = new DynamicObject(mulBasedataProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)bsdObj);
            newObj.set("fbasedataid_id", entry.getKey());
            objs.add((Object)newObj);
        }
        return objs;
    }

    Object[] getMulBasedataPkList(IDataEntityProperty dataEntityProperty, Object pkValue) {
        Map<Object, List<MulBaseData>> map = this.mulBasedataDataMap.get(dataEntityProperty);
        if (map == null) {
            return new Object[0];
        }
        List<MulBaseData> mulBaseDataList = map.get(pkValue);
        if (mulBaseDataList == null) {
            return new Object[0];
        }
        Object[] baseDataIdList = new Object[mulBaseDataList.size()];
        int i = 0;
        for (MulBaseData mulBaseData : mulBaseDataList) {
            baseDataIdList[i++] = mulBaseData.getfBaseDataId();
        }
        return baseDataIdList;
    }

    private void buildMulBasedataDataMap(MulBasedataProp mulBasedataProp) {
        IDataEntityType complexType = mulBasedataProp.getComplexType();
        boolean isBaseDataPkLongType = complexType.getPrimaryKey() instanceof LongProp;
        boolean isPkLongType = this.mainEntityType.getPrimaryKey() instanceof LongProp;
        FilterField filterField = FilterField.create((MainEntityType)this.mainEntityType, (String)mulBasedataProp.getName());
        if (filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{this.mainEntityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"MulBaseDataMapper_0", (String)"bos-dao", (Object[])new Object[0]), mulBasedataProp.getName(), "FIELDNOTEXISTS000022")});
        }
        String dbRouteKey = this.mainEntityType.getDBRouteKey();
        String entryPKAlias = filterField.getFieldProp().getParent().getPrimaryKey().getAlias();
        MulBaseDataQueryInfo mulBaseDataQueryInfo = new MulBaseDataQueryInfo(dbRouteKey, mulBasedataProp.getItemType().getAlias(), entryPKAlias, isPkLongType, this.pkList, isBaseDataPkLongType);
        List<MulBaseData> mulBaseDataList = MulBaseDataQuery.getMulBaseData(mulBaseDataQueryInfo);
        HashMap<Object, ArrayList<MulBaseData>> billPkToMulbaseDataPkMap = new HashMap<Object, ArrayList<MulBaseData>>(16);
        for (MulBaseData mulBaseData2 : mulBaseDataList) {
            ArrayList<MulBaseData> list = (ArrayList<MulBaseData>)billPkToMulbaseDataPkMap.get(mulBaseData2.getFid());
            if (list == null) {
                list = new ArrayList<MulBaseData>();
            }
            list.add(mulBaseData2);
            billPkToMulbaseDataPkMap.put(mulBaseData2.getFid(), list);
        }
        this.mulBasedataDataMap.put(mulBasedataProp, billPkToMulbaseDataPkMap);
    }
}

