/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.list.query.impl.MulBaseData;
import kd.bos.list.query.impl.MulBaseDataQueryInfo;

class MulBaseDataQuery {
    private MulBaseDataQuery() {
    }

    static List<MulBaseData> getMulBaseData(final MulBaseDataQueryInfo mulBaseDataQueryInfo) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT FPKID, " + mulBaseDataQueryInfo.getFieldName() + " , FBASEDATAID FROM " + mulBaseDataQueryInfo.getTableName() + "  where ", new Object[0]).appendIn(mulBaseDataQueryInfo.getFieldName(), mulBaseDataQueryInfo.getPkList().toArray());
        try {
            return (List)DB.query((DBRoute)new DBRoute(mulBaseDataQueryInfo.getDbRouteKey()), (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<MulBaseData>>(){

                public List<MulBaseData> handle(ResultSet rs) throws KDException {
                    ArrayList<MulBaseData> mulBaseDatas = new ArrayList<MulBaseData>();
                    MulBaseData mulBaseData = null;
                    try {
                        while (rs.next()) {
                            Object fid;
                            Object pkId;
                            if (mulBaseDataQueryInfo.isIDLongType()) {
                                pkId = rs.getBigDecimal(1).longValue();
                                fid = rs.getBigDecimal(2).longValue();
                            } else {
                                pkId = rs.getString(1);
                                fid = rs.getString(2);
                            }
                            Object fBaseDataId = mulBaseDataQueryInfo.isBaseDataPkLongType() ? Long.valueOf(rs.getBigDecimal(3).longValue()) : rs.getString(3);
                            mulBaseData = new MulBaseData(pkId, fid, fBaseDataId);
                            mulBaseDatas.add(mulBaseData);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return mulBaseDatas;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sqlBuilder);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }
}

