/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.IQuery;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.list.query.QueryUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;

public abstract class Query
implements IQuery {
    public static final String MAX_GET_ROW_COUNT = "100000";
    public static final String MAX_GET_ROW_COUNT_STR = "bos.billlist.maxRowCount";
    public static final String MAX_THREAD = "bos.billlist.maxThread";
    QueryResult queryResult = new QueryResult();
    List<IDataEntityType> dataEntityTypes;
    protected Log log = LogFactory.getLog(Query.class);
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"Query-Thread", (int)3, (int)Query.getMaxThread());

    public List<IDataEntityType> getDataEntityTypes() {
        return this.dataEntityTypes;
    }

    public void setDataEntityTypes(List<IDataEntityType> dataEntityTypes) {
        this.dataEntityTypes = dataEntityTypes;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    protected static int getMaxThread() {
        String maxThreadStr = System.getProperty(MAX_THREAD, "50");
        return Integer.parseInt(maxThreadStr);
    }

    protected DataSet queryDB(QueryBuilder queryBuilder) {
        ORM orm = ORM.create();
        orm.setDataEntityType(queryBuilder.getEntityName(), queryBuilder.getEntityType());
        if (this.dataEntityTypes != null) {
            for (IDataEntityType iDataEntityType : this.dataEntityTypes) {
                orm.setDataEntityType(iDataEntityType.getName(), iDataEntityType);
            }
        }
        return orm.queryDataSet(this.getClass().getName(), queryBuilder.getEntityName(), queryBuilder.getSelectFields(), queryBuilder.getFilters(), queryBuilder.getOrderBys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObjectCollection getData(QueryBuilder queryBuilder) {
        DataSet ds = this.queryDB(queryBuilder);
        if (ds == null) {
            return new DynamicObjectCollection(queryBuilder.getReturnEntityType(), null);
        }
        ArrayList<AbstractRow> dsLs = new ArrayList<AbstractRow>();
        try {
            for (Row row : ds) {
                dsLs.add(((AbstractRow)row).persist());
            }
        }
        finally {
            ds.close();
        }
        QueryUtils queryUtils = new QueryUtils(queryBuilder);
        this.queryResult = queryUtils.getQueryResult(dsLs.iterator(), ds.getRowMeta(), true);
        return this.queryResult.getCollection();
    }

    public List<TreeNode> getGroupNodes(GroupProp groupProp, List<QFilter> filters, final String format, Object parentId, String longNumber, Map<String, Object> queryParas) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(16);
        qfilters.addAll(filters);
        List<TreeNode> nodes = new ArrayList(16);
        ArrayList<TreeNode> list = new ArrayList<TreeNode>(16);
        HashMap<String, TreeNode> dctItems = new HashMap<String, TreeNode>(16);
        HashMap<String, String> statusMap = null;
        String entityId = groupProp.getBaseEntityId();
        if (!groupProp.isCustom() && !"bos_group".equals(entityId)) {
            DynamicProperty statusProp;
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return new ArrayList<TreeNode>();
            }
            BasedataEntityType entityType = groupProp.getEntityType();
            DataEntityPropertyCollection props = entityType.getProperties();
            String parentField = "";
            ParentBasedataProp parentProp = null;
            if ("bos_group".equals(entityId)) {
                parentField = "fparentid";
            } else {
                for (IDataEntityProperty prop : props) {
                    if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
                    parentField = prop.getName();
                    parentProp = (ParentBasedataProp)prop;
                    break;
                }
            }
            ArrayList<String> originKeys = new ArrayList<String>();
            HashSet<String> fieldKeys = new HashSet<String>();
            fieldKeys.add(entityType.getPrimaryKey().getName());
            fieldKeys.add(entityType.getNumberProperty());
            fieldKeys.add(entityType.getNameProperty());
            originKeys.add(entityType.getPrimaryKey().getName());
            originKeys.add(entityType.getNumberProperty());
            originKeys.add(entityType.getNameProperty());
            if (StringUtils.isNotBlank((CharSequence)parentField)) {
                fieldKeys.add(parentField);
                originKeys.add(parentField);
            }
            DynamicProperty dynamicProperty = statusProp = StringUtils.isNotBlank((CharSequence)entityType.getBillStatus()) ? entityType.getProperty(entityType.getBillStatus()) : null;
            if (statusProp != null) {
                statusMap = new HashMap<String, String>(16);
                fieldKeys.add(entityType.getBillStatus());
            }
            DynamicProperty longnumberProp = entityType.getProperty("longnumber");
            String longNumberDLM = ".";
            if (parentProp != null) {
                longNumberDLM = parentProp.getLongNumberDLM();
            }
            if (groupProp instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)groupProp).getLongNumberDLM();
            }
            if (longnumberProp != null) {
                fieldKeys.add(longnumberProp.getName());
                if (parentId != null && !StringUtils.isBlank((CharSequence)longNumber)) {
                    QFilter filter = new QFilter(longnumberProp.getName(), "like", (Object)(longNumber + longNumberDLM + "%"));
                    qfilters.add(filter);
                }
            }
            ORM orm = ORM.create();
            String selectFields = StringUtils.join((Object[])fieldKeys.toArray(), (String)",");
            String order = queryParas.get("order") instanceof String ? queryParas.get("order").toString() : null;
            try (DataSet ds = orm.queryDataSet("kd.bos.list.query.Query", entityType.getName(), selectFields, qfilters.toArray(new QFilter[qfilters.size()]), order);){
                for (Row row : ds) {
                    TreeNode node = new TreeNode();
                    node.setId(row.getString((String)originKeys.get(0)));
                    String code = row.getString((String)originKeys.get(1)) == null ? "" : row.getString((String)originKeys.get(1));
                    String name = row.getString((String)originKeys.get(2)) == null ? "" : row.getString((String)originKeys.get(2));
                    String text = format.replace("{name}", name).replace("{code}", code);
                    if (longnumberProp != null) {
                        node.setLongNumber(row.getString(longnumberProp.getName()) == null ? "" : row.getString(longnumberProp.getName()));
                    } else {
                        node.setLongNumber("");
                    }
                    node.setText(text);
                    if ("".equals(parentField)) {
                        node.setParentid("0");
                    } else {
                        node.setParentid(row.getString((String)originKeys.get(3)));
                    }
                    if (statusProp != null && statusMap != null) {
                        statusMap.put(row.getString((String)originKeys.get(0)), row.getString(statusProp.getName()));
                    }
                    nodes.add(node);
                }
            }
        } else {
            String tableName;
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            params.add(new SqlParameter("@LCID", 12, (Object)Locale.getDefault().toString()));
            BasedataEntityType entityType = groupProp.getEntityType();
            Class pkClass = entityType.getPrimaryKey().getPropertyType();
            String parentFilter = "";
            if (parentId != null) {
                boolean number;
                boolean bl = number = pkClass == Integer.TYPE || pkClass == Integer.class || pkClass == Long.TYPE || pkClass == Long.class;
                if (number) {
                    params.add(new SqlParameter("@parentId", -5, (Object)Long.parseLong(String.valueOf(parentId))));
                } else {
                    params.add(new SqlParameter("@parentId", 12, (Object)parentId.toString()));
                }
                parentFilter = " AND a.fparentId = ? ";
            }
            if (StringUtils.isBlank((CharSequence)(tableName = groupProp.getGroupTableName()))) {
                throw new KDBizException(BosErrorCode.tableNotDefined, new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u8868\u540d\uff0c\u4e0d\u80fd\u9884\u89c8\u3002", (String)"Query_1", (String)"bos-dao", (Object[])new Object[0])});
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT a.FId, a.FParentId, a.FNumber, b.FName ");
            sb.append(String.format(" FROM %s a LEFT JOIN %s_L b ON (a.FID = b.FID) ", tableName, tableName));
            sb.append(String.format(" WHERE   b.FLocaleId = ? %s ORDER BY a.FNumber,a.FParentId, b.FName", parentFilter));
            ResultSetHandler<List<TreeNode>> action = new ResultSetHandler<List<TreeNode>>(){

                public List<TreeNode> handle(ResultSet rs) throws SQLException {
                    ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
                    while (rs.next()) {
                        TreeNode node = new TreeNode();
                        node.setId(rs.getObject(1).toString());
                        String text = format.replace("{name}", rs.getString(4)).replace("{code}", rs.getString(3));
                        node.setText(text);
                        node.setParentid(rs.getString("FParentID"));
                        nodes.add(node);
                    }
                    return nodes;
                }
            };
            nodes = (List)DB.query((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)sb.toString(), (Object[])params.toArray(), (ResultSetHandler)action);
        }
        for (TreeNode node : nodes) {
            dctItems.put(node.getId(), node);
        }
        for (TreeNode node : nodes) {
            if (statusMap != null && !StringUtils.equals((CharSequence)"C", (CharSequence)((CharSequence)statusMap.get(node.getId())))) continue;
            TreeNode parentNode = this.findParentNode(node.getParentid(), dctItems, statusMap);
            if (parentNode != null) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren(new ArrayList());
                }
                parentNode.getChildren().add(node);
                continue;
            }
            if (parentId != null) {
                node.setParentid(parentId.toString());
            }
            list.add(node);
        }
        return list;
    }

    private TreeNode findParentNode(String parentId, Map<String, TreeNode> dctItems, Map<String, String> statusMap) {
        TreeNode parentNode = dctItems.get(parentId);
        if (parentNode == null) {
            return null;
        }
        if (statusMap == null || StringUtils.equals((CharSequence)"C", (CharSequence)statusMap.get(parentId))) {
            return parentNode;
        }
        return this.findParentNode(parentNode.getParentid(), dctItems, statusMap);
    }

    public List<String> getChildsId(GroupProp groupProp, String longNumber) {
        BasedataEntityType entityType = groupProp.getEntityType();
        String selectFields = entityType.getPrimaryKey().getName();
        ArrayList<String> nodeIdList = new ArrayList<String>();
        ParentBasedataProp parentProp = null;
        DataEntityPropertyCollection props = entityType.getProperties();
        for (IDataEntityProperty prop : props) {
            if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
            parentProp = (ParentBasedataProp)prop;
            break;
        }
        String longNumberDLM = ".";
        if (parentProp != null) {
            longNumberDLM = parentProp.getLongNumberDLM();
        }
        if (groupProp instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)groupProp).getLongNumberDLM();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("longnumber", "like", (Object)(longNumber + longNumberDLM + "%"))};
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.bos.list.query.Query", entityType.getName(), selectFields, qFilters);){
            for (Row row : ds) {
                String code = row.getString(0) == null ? "" : row.getString(0);
                nodeIdList.add(code);
            }
        }
        return nodeIdList;
    }
}

