/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.util.trie.TrieTree;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.config.client.util.StringUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.exception.XDBErrorCode;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.query.Mapper;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.list.query.QueryUtils;
import kd.bos.list.query.impl.IdQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.ORMException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QParameter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.query.hugein.AutoRelease;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.orm.query.multi.MultiQuery;
import kd.bos.orm.query.multi.SingleQuery;
import kd.bos.orm.query.optimize.PrepareJoinDB;
import kd.bos.orm.query.optimize.QueryTreeNode;
import kd.bos.orm.sequence.DBType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.QueryTimeout;

public class SqlQuery
extends IdQuery {
    private QueryBuilder queryBuilder;
    private static final String convertToSubquery = "billlist.convertToSubquery.enable";
    private static final String convertToSubqueryFormSameDB = "billlist.convertToSubquery.samedb.enable";
    private static final String convertToSubqueryFormCrossDB = "billlist.convertToSubquery.crossdb.enable";
    private static final String entrySecondSortEnable = "billlist.memorySecondSort.enable";
    private static final String defaultEntrySecondSortValue = "true";
    private static final String MIDDLE = "BILLLIST_sqlQuery_";
    private static final String packageDataModel = "billlist.packageData.enable";
    private static final String autoAddOrder = "billlist.autoaddorder.enable";
    private TreeSet<String> hederOrderFields = new TreeSet();
    private TreeSet<String> entryOrderFields = new TreeSet();
    private static Log logger = LogFactory.getLog(SqlQuery.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DynamicObjectCollection getData(QueryBuilder queryBuilder) {
        try (QueryTimeout timeout = DB.timeout((int)queryBuilder.getTimeOutSecends());){
            this.queryBuilder = queryBuilder;
            if (queryBuilder.getMaxReturnData() != -1 && this.isMemorySecondSort()) {
                DynamicObjectCollection dynamicObjectCollection = this.getData0();
                return dynamicObjectCollection;
            }
            DynamicObjectCollection dynamicObjectCollection = this.defaultGetData();
            return dynamicObjectCollection;
        }
        catch (KDException e) {
            if (e.getErrorCode() == BosErrorCode.sQLRWTimeOut) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u65f6\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"SqlQuery_0", (String)"bos-dao", (Object[])new Object[0])});
            }
            if (e.getErrorCode() == XDBErrorCode.exceedShardingTableQueryLimit) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"SqlQuery_1", (String)"bos-dao", (Object[])new Object[0])});
            }
            if (e.getErrorCode() == ORMException.excessiveInParameters) {
                throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"LimitInSize_0", (String)"bos-dao", (Object[])new Object[0])});
            }
            if (e.getErrorCode() != BosErrorCode.tableNotDefined) throw e;
            throw new KDBizException(e.getErrorCode(), new Object[]{ResManager.loadKDString((String)"\u6ca1\u6709\u7ef4\u62a4\u5b9e\u4f53\u5c5e\u6027\u4e2d\u7684\u8868\u540d\uff0c\u4e0d\u80fd\u9884\u89c8\u3002", (String)"SqlQuery_2", (String)"bos-dao", (Object[])new Object[0])});
        }
    }

    private boolean isMemorySecondSort() {
        if (this.queryBuilder.getEntityType() instanceof QueryEntityType || "false".equals(System.getProperty(entrySecondSortEnable, defaultEntrySecondSortValue))) {
            return false;
        }
        this.parseOrderBy();
        return !this.hederOrderFields.isEmpty() && !this.entryOrderFields.isEmpty() && this.getHeadPkField().equalsIgnoreCase(this.hederOrderFields.first().split(" ")[0]);
    }

    private DynamicObjectCollection getData0() {
        CacheInfo cacheInfo = this.getCacheInfo();
        QueryInfo queryInfo = this.getQueryInfo(cacheInfo);
        if (cacheInfo.pageSize != 0 && cacheInfo.pageSize != this.queryBuilder.getLimit()) {
            if (StringUtils.isNotEmpty((String)cacheInfo.dataCacheId)) {
                PageRowCacheUtils.clearPageRowcache(PageRowCacheUtils.getPageId());
            }
            cacheInfo = this.getCacheInfo();
            queryInfo = this.getQueryInfo(cacheInfo);
        }
        if (queryInfo.isCacheContainAll) {
            return this.getResultAllInCache(cacheInfo, queryInfo);
        }
        cacheInfo.pageSize = this.queryBuilder.getLimit();
        if (queryInfo.cacheContainRange != null) {
            return this.getResultCacheCotain(cacheInfo, queryInfo);
        }
        return this.getResultNoCache(cacheInfo, queryInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection defaultGetData() {
        ORM orm = ORM.create();
        orm.setDataEntityType(this.queryBuilder.getEntityName(), this.queryBuilder.getEntityType());
        try (DataSet ds = null;){
            String selectFields = this.getSelectFields();
            String[] oldFields = this.queryBuilder.getSelectFields().split(",");
            String[] newFields = selectFields.split(",");
            boolean needSelect = this.needSelect(oldFields, newFields);
            if (this.queryBuilder.getEntityType() instanceof QueryEntityType) {
                QueryEntityType qet = (QueryEntityType)this.queryBuilder.getEntityType();
                ds = qet.getQueryDataSet(this.queryBuilder, this.queryBuilder.getSelectFields(), true);
            } else if (needSelect && Boolean.parseBoolean(System.getProperty(packageDataModel, defaultEntrySecondSortValue))) {
                String orderBys = this.queryBuilder.getOrderBys();
                if (StringUtils.isEmpty((String)orderBys)) {
                    orderBys = this.queryBuilder.getEntityType().getPrimaryKey().getName() + " desc";
                } else if (!orderBys.contains(this.queryBuilder.getEntityType().getPrimaryKey().getName()) && Boolean.parseBoolean(System.getProperty(autoAddOrder, "false"))) {
                    orderBys = orderBys + "," + this.queryBuilder.getEntityType().getPrimaryKey().getName() + " desc";
                }
                ArrayList<Object[]> rows = new ArrayList<Object[]>();
                TrieTree trieTree = new TrieTree();
                ArrayList<String> entityIds = new ArrayList<String>();
                this.getEntityIds(this.queryBuilder.getSelectFields(), entityIds);
                TrieTree resultTrieTree = new TrieTree();
                int start = this.queryBuilder.getStart();
                if (start < 0) {
                    start = 0;
                    logger.warn("SqlQuery start:" + start + ",limit:" + this.queryBuilder.getLimit() + "maxReturnData:" + this.queryBuilder.getMaxReturnData());
                }
                int queryLimit = this.getQueryLimit(start, this.queryBuilder.getLimit(), this.queryBuilder.getMaxReturnData());
                ds = this.addRows(orderBys, true, trieTree, resultTrieTree, selectFields, oldFields, rows, 0L, start, start, queryLimit, 0, entityIds);
                ds = Algo.create((String)"SqlQuery").createDataSet(rows.iterator(), ds.getRowMeta());
            } else {
                ds = orm.queryDataSet(this.getClass().getName(), this.queryBuilder.getEntityName(), selectFields, this.queryBuilder.getFilters(), this.queryBuilder.isNeedResum() ? "" : this.queryBuilder.getOrderBys(), this.queryBuilder.getStart(), this.queryBuilder.getLimit(), (Distinctable)WithEntityEntryDistinctable.get());
                if (needSelect) {
                    boolean distinct = this.needDistinct(this.queryBuilder.getEntityName(), oldFields, newFields);
                    ds = ds.select(distinct, oldFields);
                }
            }
            RowMeta rowMeta = ds.getRowMeta();
            IdQuery.RowsResult rowsResult = this.getRowsResult(ds);
            DynamicObjectCollection collection = this.getDynamicCollection(rowsResult.getDealRows(), null, rowMeta, this.queryBuilder);
            this.setQueryResult(collection, 0, 0, this.queryBuilder, rowsResult.getSummaryResults());
            DynamicObjectCollection dynamicObjectCollection = collection;
            return dynamicObjectCollection;
        }
    }

    private void getEntityIds(String selectFields, List<String> entityIds) {
        for (String s : selectFields.split(",")) {
            if (!"id".equals(s) && !s.endsWith(".id")) continue;
            entityIds.add(s);
        }
    }

    private DataSet addRows(String orderBys, boolean reSelect, TrieTree trieTree, TrieTree resultTrieTree, String selectFields, String[] oldFields, List<Object[]> rows, long start, int distance, int origin, int count, int depth, List<String> entityIds) {
        long limit;
        if (++depth > 20) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u65f6\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4.", (String)"SqlQuery_3", (String)"bos-dao", (Object[])new Object[0]));
        }
        if (distance == 0) {
            limit = rows.size() == 0 ? (long)count : (long)count * (long)(count / rows.size() + 1);
        } else {
            long l = limit = origin - distance == 0 ? (long)origin : (long)origin * (long)(origin / (origin - distance));
        }
        if (limit >= Integer.MAX_VALUE) {
            limit = Integer.MAX_VALUE;
        }
        DataSet ds = this.queryDataSet(selectFields, this.queryBuilder.getFilters(), this.queryBuilder.isNeedResum() ? "" : orderBys, (int)start, (int)limit);
        if (reSelect) {
            ds = ds.select(false, oldFields);
        }
        int flag = 0;
        while (ds.hasNext()) {
            StringBuilder sb;
            ++flag;
            Row row = ds.next();
            if (distance == 0) {
                if (count == rows.size()) break;
                sb = new StringBuilder();
                entityIds.forEach(s -> sb.append(row.get(s)));
                if (trieTree.search(sb.toString()) || resultTrieTree.search(sb.toString())) continue;
                Object[] r = ((AbstractRow)row).persist().values();
                rows.add(r);
                resultTrieTree.insert(sb.toString());
                continue;
            }
            sb = new StringBuilder();
            entityIds.forEach(s -> sb.append(row.get(s)));
            if (trieTree.search(sb.toString())) continue;
            trieTree.insert(sb.toString());
            --distance;
        }
        if (flag == 0 || limit == Integer.MAX_VALUE || start + limit > Integer.MAX_VALUE) {
            return ds;
        }
        if (distance > 0) {
            this.addRows(orderBys, reSelect, trieTree, resultTrieTree, selectFields, oldFields, rows, start + limit, distance, origin, count, depth, entityIds);
        }
        if (count - rows.size() > 0) {
            this.addRows(orderBys, reSelect, trieTree, resultTrieTree, selectFields, oldFields, rows, start + limit, distance, origin, count, depth, entityIds);
        }
        return ds;
    }

    public boolean contains(List<Object[]> rows, Row row, int columnCount) {
        if (rows.size() == 0) {
            return false;
        }
        boolean contains = false;
        for (Object[] obj : rows) {
            boolean t = true;
            for (int i = 0; i < columnCount; ++i) {
                if (obj[i] == null) {
                    if (row.get(i) == null) continue;
                    t = false;
                    break;
                }
                if (obj[i].equals(row.get(i))) continue;
                t = false;
                break;
            }
            if (!t) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private DataSet sortDataSet(String[] oldFields, boolean distinct, DataSet ds) {
        String orderBys = this.queryBuilder.getOrderBys();
        List<String> fields = Arrays.asList(oldFields);
        ArrayList<String> newOrderBy = new ArrayList<String>();
        if (distinct && orderBys != null && orderBys.length() > 0) {
            String[] split;
            for (String order : split = orderBys.split(",")) {
                String[] s = order.split(" ");
                if (!fields.contains(s[0])) continue;
                newOrderBy.add(order);
            }
            if (newOrderBy != null && newOrderBy.size() > 0) {
                ds = ds.orderBy(newOrderBy.toArray(new String[newOrderBy.size()]));
            }
        }
        return ds;
    }

    private boolean needDistinct(String entityName, String[] oldFields, String[] newFields) {
        List<String> oldFieldsList = this.toList(oldFields);
        List<String> newFieldsList = this.toList(newFields);
        newFieldsList.removeAll(oldFieldsList);
        if (!CollectionUtils.isEmpty(newFieldsList)) {
            for (String field : newFieldsList) {
                if (this.isEntryOrSubEntry(entityName, field)) continue;
                return false;
            }
        }
        return true;
    }

    private List<String> toList(String[] fields) {
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (String field : fields) {
            list.add(field);
        }
        return list;
    }

    private boolean isEntryOrSubEntry(String entityName, String fieldName) {
        int i;
        if (!fieldName.startsWith(entityName + ".")) {
            fieldName = entityName + "." + fieldName;
        }
        while ((i = fieldName.lastIndexOf(".")) >= 0) {
            String fullObjectName = fieldName.substring(0, i);
            IDataEntityType iDataEntityType = ORMConfiguration.innerGetDataEntityType((String)fullObjectName, new HashMap());
            if (ORMConfiguration.isSubEntityType((IDataEntityType)iDataEntityType) || ORMConfiguration.isEntryEntityType((IDataEntityType)iDataEntityType) || ORMConfiguration.isMulBasedata((IDataEntityType)iDataEntityType)) {
                return true;
            }
            fieldName = fullObjectName;
        }
        return false;
    }

    private boolean needSelect(String[] oldSelectFields, String[] newSelectFidlds) {
        HashSet<String> oldFieldSet = new HashSet<String>(oldSelectFields.length);
        for (String field : oldSelectFields) {
            oldFieldSet.add(field);
        }
        for (String field : newSelectFidlds) {
            if (oldFieldSet.contains(field)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdQuery.RowsResult getRowsResult(DataSet ds) {
        try {
            IdQuery.RowsResult rowsResult;
            IdQuery.RowsResult rowsResult2 = rowsResult = this.getRowsResult(ds, this.queryBuilder);
            return rowsResult2;
        }
        finally {
            ds.close();
        }
    }

    private String getSelectFields() {
        HashSet<String> selectFieldSet = new HashSet<String>(16);
        for (String field : this.queryBuilder.getSelectFields().split(",")) {
            selectFieldSet.add(field);
        }
        String orderByStr = this.queryBuilder.getOrderBys();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            String[] tempStrs;
            for (String temp : tempStrs = orderByStr.trim().split(",")) {
                selectFieldSet.add(temp.trim().split(" ")[0].toLowerCase());
            }
        }
        return Joiner.on((char)',').join(selectFieldSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getResultNoCache(CacheInfo cacheInfo, QueryInfo queryInfo) {
        Row row;
        DataSet dataSet = this.getDataSetOrderByHeader(queryInfo.queryStartIndex, queryInfo.queryLimit);
        DataSet dataSetCopy = dataSet.copy();
        RowMeta rowMeta = dataSetCopy.getRowMeta();
        int pageStartIndex = this.queryBuilder.getStart();
        int pageLimit = this.queryBuilder.getLimit();
        int pageEndIndex = pageStartIndex + pageLimit - 1;
        String headPkField = this.getHeadPkField();
        Object firstId = null;
        Object lastId = null;
        boolean firstIdNeedQuery = false;
        boolean lastIdNeedQuery = true;
        ArrayList<Row> pageRows = new ArrayList<Row>(pageLimit);
        int indexFlag = 0;
        dataSetCopy = dataSetCopy.orderBy(this.queryBuilder.getOrderBys().split(","));
        block6: while (dataSetCopy.hasNext()) {
            int rowQueryIndex;
            Row row2 = RowUtil.persist((Row)dataSetCopy.next());
            if (indexFlag == 0) {
                firstId = row2.get(headPkField);
            }
            if ((rowQueryIndex = queryInfo.queryStartIndex + indexFlag) >= pageStartIndex && rowQueryIndex <= pageEndIndex) {
                pageRows.add(row2);
                if (rowQueryIndex == pageStartIndex && firstId != null && firstId.equals(row2.get(headPkField))) {
                    firstIdNeedQuery = true;
                }
                if (rowQueryIndex == pageEndIndex) {
                    lastId = row2.get(headPkField);
                    while (dataSetCopy.hasNext()) {
                        Row lastRow = RowUtil.persist((Row)dataSetCopy.next());
                        if (lastId.equals(lastRow.get(headPkField))) continue;
                        lastIdNeedQuery = false;
                        break block6;
                    }
                    break;
                }
            }
            ++indexFlag;
        }
        if (firstIdNeedQuery && queryInfo.queryStartIndex > 0) {
            int pageFirstIdSize = 0;
            Iterator itr = pageRows.iterator();
            while (itr.hasNext()) {
                row = (Row)itr.next();
                if (firstId == null || !firstId.equals(row.get(headPkField))) continue;
                itr.remove();
                ++pageFirstIdSize;
            }
            EvictingQueue queue = EvictingQueue.create((int)pageFirstIdSize);
            try (DataSet firstIdDs = null;){
                firstIdDs = this.getDataSetByIDs(new Object[]{firstId});
                firstIdDs = firstIdDs.orderBy(this.entryOrderFields.toArray(new String[0]));
                for (Row row3 : firstIdDs) {
                    queue.add(RowUtil.persist((Row)row3));
                }
            }
            ArrayList<Row> pageFirstIdList = new ArrayList<Row>(pageFirstIdSize);
            for (Row row4 : queue) {
                pageFirstIdList.add(row4);
            }
            pageFirstIdList.addAll(pageRows);
            pageRows = pageFirstIdList;
        }
        if (lastId != null && lastIdNeedQuery) {
            int pageLastIdSize = 0;
            Iterator itr = pageRows.iterator();
            while (itr.hasNext()) {
                row = (Row)itr.next();
                if (!lastId.equals(row.get(headPkField))) continue;
                itr.remove();
                ++pageLastIdSize;
            }
            try (DataSet lastIdDs = null;){
                lastIdDs = this.getDataSetByIDs(new Object[]{lastId});
                lastIdDs = lastIdDs.orderBy(this.queryBuilder.getOrderBys().split(","));
                for (int i = 0; i < pageLastIdSize; ++i) {
                    if (!lastIdDs.hasNext()) continue;
                    pageRows.add(RowUtil.persist((Row)lastIdDs.next()));
                }
            }
        }
        if (!"run".equals(cacheInfo.cacheState)) {
            this.asynCacheData(cacheInfo, queryInfo, dataSet);
        }
        IdQuery.RowsResult rowsResult = this.getRowsResult(pageRows, rowMeta);
        DynamicObjectCollection collection = this.getDynamicCollection(rowsResult.getDealRows(), null, rowMeta, this.queryBuilder);
        this.setQueryResult(collection, 0, 0, this.queryBuilder, rowsResult.getSummaryResults());
        return collection;
    }

    private void asynCacheData(CacheInfo cacheInfo, QueryInfo queryInfo, DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<Row> rows = new ArrayList<Row>(8);
        while (dataSet.hasNext()) {
            Row perRow = RowUtil.persist((Row)dataSet.next());
            rows.add(perRow);
        }
        es.execute(ThreadLifeCycleManager.wrapRunnable((Runnable)new SqlRunner(RequestContext.get(), this.queryBuilder, cacheInfo, queryInfo, rowMeta, rows)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getResultCacheCotain(CacheInfo cacheInfo, QueryInfo queryInfo) {
        DataSet dataSet = this.getDataSetOrderByHeader(queryInfo.queryStartIndex, queryInfo.queryLimit);
        RowMeta rowMeta = dataSet.getRowMeta();
        DataSet dataSetCopy = dataSet.copy();
        dataSetCopy = dataSetCopy.orderBy(this.queryBuilder.getOrderBys().split(","));
        int pageStartIndex = this.queryBuilder.getStart();
        int pageLimit = this.queryBuilder.getLimit();
        String headPkField = this.getHeadPkField();
        int startContainIndex = (Integer)queryInfo.cacheContainRange.lowerEndpoint();
        int endContainIndex = (Integer)queryInfo.cacheContainRange.upperEndpoint();
        int cotianLimit = endContainIndex - startContainIndex + 1;
        pageLimit -= cotianLimit;
        ArrayList<Row> pageRows = new ArrayList<Row>(this.queryBuilder.getLimit());
        CachedDataSet cds = Algo.getCacheDataSet((String)cacheInfo.dataCacheId);
        List rows = cds.getList(startContainIndex - cacheInfo.startIndex, cotianLimit);
        if (startContainIndex == pageStartIndex) {
            pageRows.addAll(rows);
            pageStartIndex = endContainIndex + 1;
            boolean pageLastIdNeedQuery = true;
            Object pageLastId = null;
            block6: for (int i = 0; i < pageLimit; ++i) {
                if (!dataSetCopy.hasNext()) continue;
                Row row = RowUtil.persist((Row)dataSetCopy.next());
                pageRows.add(row);
                if (i != pageLimit - 1) continue;
                pageLastId = row.get(headPkField);
                while (dataSetCopy.hasNext()) {
                    Row nextRow = RowUtil.persist((Row)dataSetCopy.next());
                    if (pageLastId.equals(nextRow.get(headPkField))) continue;
                    pageLastIdNeedQuery = false;
                    continue block6;
                }
            }
            if (pageLastId != null && pageLastIdNeedQuery) {
                Iterator itr = pageRows.iterator();
                int pageLastIdSize = 0;
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    if (!pageLastId.equals(row.get(headPkField))) continue;
                    itr.remove();
                    ++pageLastIdSize;
                }
                try (DataSet lastIdDs = null;){
                    lastIdDs = this.getDataSetByIDs(new Object[]{pageLastId});
                    lastIdDs = lastIdDs.orderBy(this.queryBuilder.getOrderBys().split(","));
                    for (int i = 0; i < pageLastIdSize; ++i) {
                        if (!lastIdDs.hasNext()) continue;
                        pageRows.add(RowUtil.persist((Row)lastIdDs.next()));
                    }
                }
            }
        } else {
            if (queryInfo.queryStartIndex == 0) {
                dataSetCopy = dataSetCopy.limit(queryInfo.queryLimit - pageLimit, pageLimit);
                for (Row row : dataSetCopy) {
                    pageRows.add(RowUtil.persist((Row)row));
                }
            } else {
                boolean pageFirstIdQuery = false;
                Object pageFirstId = null;
                int pageFirstIdSize = 0;
                int i = 0;
                while (dataSetCopy.hasNext()) {
                    Row row = RowUtil.persist((Row)dataSetCopy.next());
                    if (i == 0) {
                        pageFirstId = row.get(headPkField);
                    }
                    if (queryInfo.queryStartIndex + i >= pageStartIndex) {
                        if (pageFirstId != null && pageFirstId.equals(row.get(headPkField))) {
                            ++pageFirstIdSize;
                            pageFirstIdQuery = true;
                        } else {
                            pageRows.add(row);
                        }
                    }
                    ++i;
                }
                if (pageFirstId != null && pageFirstIdQuery) {
                    try (DataSet firstIdDs = null;){
                        firstIdDs = this.getDataSetByIDs(new Object[]{pageFirstId});
                        firstIdDs = firstIdDs.orderBy(this.queryBuilder.getOrderBys().split(","));
                        EvictingQueue queue = EvictingQueue.create((int)pageFirstIdSize);
                        for (Row row : firstIdDs) {
                            queue.add(RowUtil.persist((Row)row));
                        }
                        ArrayList<Row> pageFirstIdRows = new ArrayList<Row>(pageLimit);
                        for (Row row : queue) {
                            pageFirstIdRows.add(row);
                        }
                        pageFirstIdRows.addAll(pageRows);
                        pageRows = pageFirstIdRows;
                    }
                }
            }
            pageRows.addAll(rows);
        }
        this.asynCacheData(cacheInfo, queryInfo, dataSet);
        IdQuery.RowsResult rowsResult = this.getRowsResult(pageRows, rowMeta);
        DynamicObjectCollection collection = this.getDynamicCollection(rowsResult.getDealRows(), null, rowMeta, this.queryBuilder);
        this.setQueryResult(collection, 0, 0, this.queryBuilder, rowsResult.getSummaryResults());
        return collection;
    }

    private DynamicObjectCollection getResultAllInCache(CacheInfo cacheInfo, QueryInfo queryInfo) {
        CachedDataSet cds = Algo.getCacheDataSet((String)cacheInfo.dataCacheId);
        RowMeta rowMeta = cds.getRowMeta();
        List rows = cds.getList(queryInfo.queryStartIndex - cacheInfo.startIndex, queryInfo.queryLimit);
        IdQuery.RowsResult rowsResult = this.getRowsResult(rows, rowMeta);
        DynamicObjectCollection collection = this.getDynamicCollection(rowsResult.getDealRows(), null, rowMeta, this.queryBuilder);
        this.setQueryResult(collection, 0, 0, this.queryBuilder, rowsResult.getSummaryResults());
        return collection;
    }

    private String getHeadPkField() {
        return this.queryBuilder.getEntityType().getPrimaryKey().getName();
    }

    private DataSet getDataSetByIDs(Object[] ids) {
        String headPkField = this.getHeadPkField();
        QFilter filter = new QFilter(headPkField, "in", (Object)ids);
        ORM orm = ORM.create();
        orm.setDataEntityType(this.queryBuilder.getEntityName(), this.queryBuilder.getEntityType());
        String selectFields = this.getSelectFields();
        return orm.queryDataSet(this.getClass().getName(), this.queryBuilder.getEntityName(), selectFields, new QFilter[]{filter}, null, -1, (Distinctable)WithEntityEntryDistinctable.get());
    }

    private QueryInfo getQueryInfo(CacheInfo cacheInfo) {
        QueryInfo queryInfo = new QueryInfo();
        int queryStartIndex = this.queryBuilder.getStart();
        int queryLimit = this.queryBuilder.getLimit();
        int batchQuerySize = this.getBatchQuerySize();
        if ("end".equals(cacheInfo.cacheState)) {
            int queryEndIndex = queryStartIndex + queryLimit - 1;
            if (this.queryBuilder.getMaxReturnData() > 0 && queryEndIndex + 1 > this.queryBuilder.getMaxReturnData() && (queryEndIndex = this.queryBuilder.getMaxReturnData() - 1) < queryStartIndex) {
                queryEndIndex = queryStartIndex;
            }
            Range cacheRange = Range.closed((Comparable)Integer.valueOf(cacheInfo.startIndex), (Comparable)Integer.valueOf(cacheInfo.endIndex));
            if (cacheInfo.cacheContainAllPage || cacheRange.encloses(Range.closed((Comparable)Integer.valueOf(queryStartIndex), (Comparable)Integer.valueOf(queryEndIndex)))) {
                queryInfo.isCacheContainAll = true;
            } else {
                ArrayList<Integer> containIndexs = new ArrayList<Integer>();
                for (int i = queryStartIndex; i <= queryEndIndex; ++i) {
                    if (!cacheRange.contains((Comparable)Integer.valueOf(i))) continue;
                    containIndexs.add(i);
                }
                if (!containIndexs.isEmpty()) {
                    int startContainIndex = (Integer)containIndexs.get(0);
                    int endContainIndex = (Integer)containIndexs.get(containIndexs.size() - 1);
                    if (startContainIndex == cacheInfo.startIndex) {
                        if ((queryStartIndex -= batchQuerySize) <= 0) {
                            queryStartIndex = 0;
                        } else {
                            queryInfo.firstIdNeedQuery = true;
                        }
                        queryLimit = startContainIndex - queryStartIndex;
                    } else {
                        queryStartIndex = endContainIndex + 1;
                        queryLimit = batchQuerySize;
                        queryInfo.lastIdNeedQuery = true;
                    }
                    queryInfo.cacheContainRange = Range.closed((Comparable)Integer.valueOf(startContainIndex), (Comparable)Integer.valueOf(endContainIndex));
                } else if (queryEndIndex < cacheInfo.startIndex) {
                    if ((queryStartIndex -= batchQuerySize) <= 0) {
                        queryStartIndex = 0;
                    } else {
                        queryInfo.firstIdNeedQuery = true;
                    }
                    queryLimit = 2 * batchQuerySize + queryLimit;
                    if (queryLimit - 1 + queryStartIndex <= cacheInfo.startIndex) {
                        queryInfo.lastIdNeedQuery = true;
                    }
                } else {
                    if ((queryStartIndex -= batchQuerySize) <= cacheInfo.endIndex) {
                        queryStartIndex = cacheInfo.endIndex + 1;
                    } else {
                        queryInfo.firstIdNeedQuery = true;
                    }
                    queryLimit = 2 * batchQuerySize + queryLimit;
                    queryInfo.lastIdNeedQuery = true;
                }
            }
        } else if ("run".equals(cacheInfo.cacheState)) {
            if ((queryStartIndex -= queryLimit) <= 0) {
                queryStartIndex = 0;
            } else {
                queryInfo.firstIdNeedQuery = true;
            }
            queryLimit = 3 * queryLimit;
            queryInfo.lastIdNeedQuery = true;
        } else {
            if ((queryStartIndex -= batchQuerySize) <= 0) {
                queryStartIndex = 0;
            } else {
                queryInfo.firstIdNeedQuery = true;
            }
            queryLimit = 2 * batchQuerySize + queryLimit;
            queryInfo.lastIdNeedQuery = true;
        }
        queryInfo.queryLimit = this.queryBuilder.getMaxReturnData() > 0 && this.queryBuilder.getMaxReturnData() < queryLimit ? this.queryBuilder.getMaxReturnData() : (this.queryBuilder.getMaxReturnData() > 0 && this.queryBuilder.getStart() + this.queryBuilder.getLimit() > this.queryBuilder.getMaxReturnData() ? this.queryBuilder.getMaxReturnData() - queryStartIndex : queryLimit);
        queryInfo.queryStartIndex = queryStartIndex;
        return queryInfo;
    }

    private int getBatchQuerySize() {
        int pageSize = this.queryBuilder.getLimit();
        int querySize = pageSize <= 100 ? 1000 : (pageSize <= 1000 ? 5 * pageSize : (pageSize <= 5000 ? 2 * pageSize : pageSize));
        return querySize;
    }

    private CacheInfo getCacheInfo() {
        String cacheKey = PageRowCacheUtils.getCacheKey();
        Map<String, String> allCachemap = this.getCacheMap(cacheKey);
        String controlKey = PageRowCacheUtils.getControlKey();
        String cacheMapKeyPrefix = StringUtil.isEmpty((String)controlKey) ? "" : controlKey;
        CacheInfo cacheInfo = new CacheInfo();
        cacheInfo.cacheKey = cacheKey;
        cacheInfo.mapPrefix = cacheMapKeyPrefix;
        if (allCachemap == null || allCachemap.isEmpty()) {
            cacheInfo.cacheState = "nocache";
        } else {
            String cacheState;
            cacheInfo.cacheState = cacheState = allCachemap.get(cacheMapKeyPrefix + MIDDLE + "BILLLIST_cacheState");
            if ("end".equals(cacheState)) {
                String pageSizeString;
                String endIndexString;
                String startIndexString;
                String cacheIdString = allCachemap.get(cacheMapKeyPrefix + MIDDLE + "BILLLIST_cacheId");
                if (!StringUtil.isEmpty((String)cacheIdString)) {
                    cacheInfo.dataCacheId = cacheIdString;
                }
                if (!StringUtil.isEmpty((String)(startIndexString = allCachemap.get(cacheMapKeyPrefix + MIDDLE + "BILLLIST_startIndex")))) {
                    cacheInfo.startIndex = Integer.parseInt(startIndexString);
                }
                if (!StringUtil.isEmpty((String)(endIndexString = allCachemap.get(cacheMapKeyPrefix + MIDDLE + "BILLLIST_endIndex")))) {
                    cacheInfo.endIndex = Integer.parseInt(endIndexString);
                }
                if (defaultEntrySecondSortValue.equals(allCachemap.get(cacheMapKeyPrefix + MIDDLE + "BILLLIST_cacheCotainAllPage"))) {
                    cacheInfo.cacheContainAllPage = true;
                }
                if (!StringUtil.isEmpty((String)(pageSizeString = allCachemap.get(cacheMapKeyPrefix + MIDDLE + "BILLLIST_pageSize")))) {
                    cacheInfo.pageSize = Integer.parseInt(pageSizeString);
                }
            }
        }
        return cacheInfo;
    }

    private DataSet getDataSetOrderByHeader(int start, int limit) {
        ORM orm = ORM.create();
        orm.setDataEntityType(this.queryBuilder.getEntityName(), this.queryBuilder.getEntityType());
        String selectFields = this.getSelectFields();
        String headerOrderBys = Joiner.on((char)',').join(this.hederOrderFields);
        return orm.queryDataSet(this.getClass().getName(), this.queryBuilder.getEntityName(), selectFields, this.queryBuilder.getFilters(), headerOrderBys, start, limit, (Distinctable)WithEntityEntryDistinctable.get());
    }

    private void parseOrderBy() {
        String orderByStr = this.queryBuilder.getOrderBys();
        MainEntityType mainEntityType = (MainEntityType)this.queryBuilder.getEntityType();
        if (!StringUtil.isEmpty((String)orderByStr)) {
            int index = 0;
            for (String orderField : orderByStr.trim().split(",")) {
                boolean isEntryProp = false;
                String tempField = orderField.trim().split(" ")[0].toLowerCase();
                if (index == 0 && !this.getHeadPkField().equalsIgnoreCase(tempField)) {
                    return;
                }
                ++index;
                for (String part : tempField.split("\\.")) {
                    DynamicProperty dp = mainEntityType.getProperty(part);
                    if (!(dp instanceof EntryProp)) continue;
                    isEntryProp = true;
                    break;
                }
                if (isEntryProp) {
                    if (this.entryOrderFields.contains(orderField)) continue;
                    this.entryOrderFields.add(orderField);
                    continue;
                }
                if (this.hederOrderFields.contains(orderField)) continue;
                this.hederOrderFields.add(orderField);
            }
        }
    }

    private Map<String, String> getCacheMap(String cacheKey) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        return cache.getAll(cacheKey);
    }

    private IdQuery.RowsResult getRowsResult(List<Row> rows, RowMeta rowMeta) {
        Map<String, SummaryResult> sumResultsMap = this.getSumResultsMap(this.queryBuilder);
        ArrayList<Row> dealRows = new ArrayList<Row>(10);
        QueryUtils queryUtils = new QueryUtils(this.queryBuilder);
        int n = rowMeta.getFieldCount();
        Map<String, Mapper> mappers = this.getMappers(this.queryBuilder, rowMeta, n);
        String seqFieldStr = this.queryBuilder.getSeqField();
        boolean seqIsEntity = StringUtil.isEmpty((String)seqFieldStr);
        RowMeta seqRowMeta = null;
        int seqIndex = this.queryBuilder.getStart() + 1;
        if (!seqIsEntity) {
            seqRowMeta = this.rowMetaAddField(rowMeta, seqFieldStr, (DataType)DataType.IntegerType);
        }
        for (Row row : rows) {
            if (!this.queryBuilder.getSumFields().isEmpty()) {
                queryUtils.addRowSummaryResult(row, mappers, sumResultsMap);
            }
            Row seqRow = null;
            if (!seqIsEntity) {
                seqRow = this.rowAddField(row, seqRowMeta, seqIndex);
                ++seqIndex;
            } else {
                seqRow = row;
            }
            dealRows.add(seqRow);
        }
        ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>();
        summaryResults.addAll(sumResultsMap.values());
        return new IdQuery.RowsResult(dealRows, 0, summaryResults);
    }

    private void cacheMap(String cacheKey, Map<String, String> map) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        cache.put(cacheKey, map, timeout, TimeUnit.SECONDS);
    }

    private String cacheDataSet(DataSet ds) {
        int timeout = CacheKeyUtil.getPageCacheKeyTimeout();
        CacheHint cacheHint = new CacheHint();
        cacheHint.setPageSize(ConfigurationUtil.getInteger((String)"bos.billlist.pagesize", (Integer)1000).intValue());
        cacheHint.setTimeout((long)timeout, TimeUnit.SECONDS);
        CachedDataSetBuilder cacheBuilder = new CachedDataSetBuilder(ds.getRowMeta(), cacheHint, this.getClass().getSimpleName() + ".cacheData.dataset");
        cacheBuilder.append(ds.iterator());
        CachedDataSet cds = cacheBuilder.build();
        return cds.getCacheId();
    }

    private void removeCacheData(String cacheId) {
        try {
            CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
            cds.close();
        }
        catch (Exception e) {
            this.log.error("PageRowCacheUtils clearPageRowCache" + e.getMessage());
        }
    }

    private DataSet queryDataSet(String selectFields, QFilter[] filters, String orderBys, int from, int length) {
        final SubqueryInfo subqueryInfo = this.convertToSubquery(selectFields, filters, this.queryBuilder.getOrderBys(), from, length);
        ORM orm = ORM.create();
        orm.setDataEntityType(this.queryBuilder.getEntityName(), this.queryBuilder.getEntityType());
        if (subqueryInfo.hasConvertToInId) {
            from = 0;
            length = -1;
        }
        DataSet ds = orm.queryDataSet(this.getClass().getName(), this.queryBuilder.getEntityName(), selectFields, subqueryInfo.qFilters, orderBys, from, length, (Distinctable)WithEntityEntryDistinctable.get());
        if (subqueryInfo.autoRelease != null) {
            ds.addListener(new DataSet.Listener(){

                public void beforeClosed() {
                    subqueryInfo.autoRelease.close();
                }
            });
        }
        return ds;
    }

    private SubqueryInfo convertToSubquery(String selectFields, QFilter[] filters, String orderBys, int start, int limit) {
        SubqueryInfo subqueryInfo = new SubqueryInfo();
        if (!this.isNeedConvertToSubquery(subqueryInfo, selectFields, filters, orderBys)) {
            subqueryInfo.qFilters = filters;
            return subqueryInfo;
        }
        String selectPKName = "id";
        if (Boolean.parseBoolean(System.getProperty(convertToSubqueryFormSameDB, "false"))) {
            String rootEntityName = this.queryBuilder.getEntityName();
            MultiQuery multiQuery = ORM.create().$createMultiQuery(rootEntityName, selectPKName, filters);
            QueryTreeNode root = QueryTreeNode.create((SingleQuery[])multiQuery.getQueries());
            PrepareJoinDB.prepare((QueryTreeNode)root);
            kd.bos.orm.query.multi.QueryUtils.joinInSameDatabase((QueryTreeNode)root);
            if (root.isLeaf()) {
                AutoRelease autoRelease = root.getQuery().optInFilter();
                root.getQuery().removeInnerField(true, true);
                Object[] params = root.getQuery().getQueryParameter().getParams();
                String sql = root.getQuery().getSql();
                QParameter qParameter = new QParameter(sql, params);
                QFilter qFilter = new QFilter(selectPKName, "in", (Object)qParameter);
                subqueryInfo.qFilters = qFilter.toArray();
                subqueryInfo.autoRelease = autoRelease;
                return subqueryInfo;
            }
        }
        if (Boolean.parseBoolean(System.getProperty(convertToSubqueryFormCrossDB, defaultEntrySecondSortValue))) {
            Set<String> selectFieldSet = this.orderByToSet(orderBys);
            selectFieldSet.add(selectPKName);
            String selectFieldStr = Joiner.on((char)',').join(selectFieldSet);
            DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), this.queryBuilder.getEntityName(), selectFieldStr, filters, orderBys, start, limit, (Distinctable)WithEntityEntryDistinctable.get());
            ArrayList<Long> ids = new ArrayList<Long>(100);
            int count = 0;
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong(selectPKName));
                if (++count <= HugeInConfig.inMaxSize()) continue;
                ds.close();
                throw new KDBizException(XDBErrorCode.exceedShardingTableQueryLimit, new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"SqlQuery_1", (String)"bos-dao", (Object[])new Object[0])});
            }
            QFilter qFilter = new QFilter(selectPKName, "in", ids);
            subqueryInfo.qFilters = qFilter.toArray();
            subqueryInfo.hasConvertToInId = true;
            return subqueryInfo;
        }
        subqueryInfo.qFilters = filters;
        return subqueryInfo;
    }

    private boolean isNeedConvertToSubquery(SubqueryInfo subqueryInfo, String selectFields, QFilter[] filters, String orderBys) {
        if (!Boolean.parseBoolean(System.getProperty(convertToSubquery, "false"))) {
            return false;
        }
        String dbRoute = this.queryBuilder.getEntityType().getDBRouteKey();
        DBType dbType = ORMUtil.getDBType((String)dbRoute);
        if (dbType != DBType.Postgres) {
            return false;
        }
        String rootEntityName = this.queryBuilder.getEntityName();
        MainEntityType mainEntityType = (MainEntityType)this.queryBuilder.getEntityType();
        Set<String> selectFieldSet = this.selectFieldsToSet(selectFields);
        for (String string : selectFieldSet) {
            List<String> allParentObjectNames = this.getAllParentObjectNames(string);
            if (allParentObjectNames.isEmpty()) continue;
            return false;
        }
        ArrayList<QFilter> allFilters = new ArrayList<QFilter>(16);
        for (QFilter filter : filters) {
            if (filter == null) continue;
            allFilters.add(filter);
            List nests = filter.getNests(true);
            if (nests == null) continue;
            for (QFilter.QFilterNest nest : nests) {
                QFilter nestFilter = nest.getFilter();
                if (nestFilter == null) continue;
                allFilters.add(nestFilter);
            }
        }
        HashSet<String> hashSet = new HashSet<String>(8);
        for (QFilter filter : allFilters) {
            for (String field : filter.getProperties()) {
                hashSet.addAll(this.getAllParentObjectNames(field));
            }
        }
        for (String entityName : hashSet) {
            if (!(mainEntityType.findProperty(entityName) instanceof EntryProp)) continue;
            return true;
        }
        return false;
    }

    private List<String> getAllParentObjectNames(String field) {
        String rootEntityName = this.queryBuilder.getEntityName();
        if (field.startsWith(rootEntityName + ".")) {
            field = field.substring((rootEntityName + ".").length());
        }
        ArrayList<String> list = new ArrayList<String>(1);
        while (field.contains(".")) {
            int index = field.lastIndexOf(".");
            field = field.substring(0, index);
            list.add(field);
        }
        return list;
    }

    private int getQueryLimit(int start, int limit, int maxReturnData) {
        if (maxReturnData > 0) {
            if (maxReturnData < limit) {
                return maxReturnData;
            }
            if (start + limit > maxReturnData) {
                return maxReturnData - start;
            }
        }
        return limit;
    }

    static class SubqueryInfo {
        QFilter[] qFilters;
        AutoRelease autoRelease;
        boolean hasConvertToInId;

        SubqueryInfo() {
        }
    }

    class SqlRunner
    implements Runnable {
        RequestContext rc;
        private CacheInfo cacheInfo;
        private QueryInfo queryInfo;
        private RowMeta rowMeta;
        private List<Row> rows;

        public SqlRunner(RequestContext rc, QueryBuilder runnerQueryBuider, CacheInfo cacheInfo, QueryInfo queryInfo, RowMeta rowMeta, List<Row> rows) {
            this.rc = rc;
            this.cacheInfo = cacheInfo;
            this.queryInfo = queryInfo;
            this.rowMeta = rowMeta;
            this.rows = rows;
        }

        @Override
        public void run() {
            RequestContext.copyAndSet((RequestContext)this.rc);
            this.cacheData();
        }

        private void cacheData() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_cacheState", "run");
            SqlQuery.this.cacheMap(this.cacheInfo.cacheKey, map);
            String headPKField = SqlQuery.this.getHeadPkField();
            DataSetBuilder cacheDsBuilder = Algo.create((String)this.getClass().getName()).createDataSetBuilder(this.rowMeta);
            Object firstId = null;
            ArrayList<Row> firstIDRows = new ArrayList<Row>(10);
            Object lastId = null;
            ArrayList<Row> lastIDRows = new ArrayList<Row>(10);
            int dataCount = 0;
            for (Row row : this.rows) {
                Object id = row.get(headPKField);
                if (dataCount == 0) {
                    firstId = id;
                }
                if (firstId != null && firstId.equals(id)) {
                    firstIDRows.add(row);
                } else if (lastId != null && lastId.equals(id)) {
                    lastIDRows.add(row);
                } else {
                    for (Row row2 : lastIDRows) {
                        cacheDsBuilder.append(row2);
                    }
                    lastId = id;
                    lastIDRows.clear();
                    lastIDRows.add(row);
                }
                ++dataCount;
            }
            int cacheStartIndex = this.queryInfo.queryStartIndex;
            int cacheEndIndex = this.queryInfo.queryStartIndex + dataCount - 1;
            if (dataCount == 0) {
                map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_cacheState", this.cacheInfo.cacheState);
                SqlQuery.this.cacheMap(this.cacheInfo.cacheKey, map);
                return;
            }
            if (StringUtils.isNotEmpty((String)this.cacheInfo.dataCacheId)) {
                SqlQuery.this.removeCacheData(this.cacheInfo.dataCacheId);
            }
            if (dataCount == this.queryInfo.queryLimit) {
                if (firstId != null && this.queryInfo.firstIdNeedQuery) {
                    Throwable throwable = null;
                    try (DataSet firstIdDs = SqlQuery.this.getDataSetByIDs(new Object[]{firstId});){
                        int firstIdCount = 0;
                        for (Row row2 : firstIdDs) {
                            cacheDsBuilder.append(RowUtil.persist((Row)row2));
                            ++firstIdCount;
                        }
                        cacheStartIndex -= firstIdCount - firstIDRows.size();
                    }
                    catch (Throwable firstIdCount) {
                        Throwable throwable2 = firstIdCount;
                        throw firstIdCount;
                    }
                } else {
                    for (Row row : firstIDRows) {
                        cacheDsBuilder.append(row);
                    }
                }
                if (lastId != null && this.queryInfo.lastIdNeedQuery) {
                    Throwable throwable = null;
                    try (DataSet lastIdDs = SqlQuery.this.getDataSetByIDs(new Object[]{lastId});){
                        int lastIdCount = 0;
                        for (Row row : lastIdDs) {
                            cacheDsBuilder.append(RowUtil.persist((Row)row));
                            ++lastIdCount;
                        }
                        cacheEndIndex += lastIdCount - lastIDRows.size();
                    }
                    catch (Throwable throwable3) {
                        Throwable throwable4 = throwable3;
                        throw throwable3;
                    }
                } else {
                    for (Row row : lastIDRows) {
                        cacheDsBuilder.append(row);
                    }
                }
            } else {
                for (Row row : firstIDRows) {
                    cacheDsBuilder.append(row);
                }
                for (Row row : lastIDRows) {
                    cacheDsBuilder.append(row);
                }
                if (this.queryInfo.queryStartIndex == 0) {
                    map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_cacheCotainAllPage", SqlQuery.defaultEntrySecondSortValue);
                }
            }
            DataSet cacheDataSet = cacheDsBuilder.build();
            cacheDataSet = cacheDataSet.orderBy(SqlQuery.this.queryBuilder.getOrderBys().split(","));
            String string = SqlQuery.this.cacheDataSet(cacheDataSet);
            map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_cacheState", "end");
            map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_cacheId", string);
            map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_startIndex", String.valueOf(cacheStartIndex));
            map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_endIndex", String.valueOf(cacheEndIndex));
            map.put(this.cacheInfo.mapPrefix + SqlQuery.MIDDLE + "BILLLIST_pageSize", String.valueOf(this.cacheInfo.pageSize));
            SqlQuery.this.cacheMap(this.cacheInfo.cacheKey, map);
        }
    }

    static class QueryInfo {
        boolean isCacheContainAll = false;
        Range<Integer> cacheContainRange;
        int queryStartIndex = 0;
        int queryLimit = 0;
        boolean firstIdNeedQuery = false;
        boolean lastIdNeedQuery = false;

        QueryInfo() {
        }
    }

    class CacheInfo {
        String cacheKey;
        String mapPrefix;
        boolean cacheContainAllPage = false;
        String cacheState;
        int startIndex = 0;
        int endIndex = 0;
        String dataCacheId;
        int pageSize = 0;

        CacheInfo() {
        }
    }
}

