/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metagray;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.gray.GrayAppInfo;
import kd.bos.entity.gray.GrayInfo;
import kd.bos.entity.gray.MetaGrayInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;

public class MetaGrayService {
    private static Log log = LogFactory.getLog(MetaGrayService.class);

    public GrayInfo getGrayInfo(String appGroup) {
        Object[] filters = new String[]{appGroup};
        GrayInfo grayInfo = (GrayInfo)DB.query((DBRoute)DBRoute.meta, (String)"select FAPPGROUP, FVER, FCREATETIME, FRELEASESTATUS, FRELEASETIME from T_BAS_GRAYINFO where FAPPGROUP = ?", (Object[])filters, (ResultSetHandler)new ResultSetHandler<GrayInfo>(){

            public GrayInfo handle(ResultSet rs) throws SQLException {
                GrayInfo grayInfo = new GrayInfo();
                if (rs.next()) {
                    grayInfo.setAppGroup(rs.getString(1));
                    grayInfo.setVer(rs.getString(2));
                    grayInfo.setCreateTime((Date)rs.getDate(3));
                    grayInfo.setReleaseStatus(rs.getString(4));
                    grayInfo.setReleaseTime((Date)rs.getDate(5));
                }
                return grayInfo;
            }
        });
        return grayInfo;
    }

    public void saveGrayInfo(GrayInfo grayInfo) {
        String sql = "insert into T_BAS_GRAYINFO (FAPPGROUP, FVER, FCREATETIME, FRELEASESTATUS, FRELEASETIME) values(?, ?, ?, ?, ?)";
        Object[] params = new SqlParameter[]{new SqlParameter("FAPPGROUP", 12, (Object)grayInfo.getAppGroup()), new SqlParameter("FVER", 12, (Object)grayInfo.getVer()), new SqlParameter("FCREATETIME", 91, (Object)grayInfo.getCreateTime()), new SqlParameter("FRELEASESTATUS", 1, (Object)grayInfo.getReleaseStatus()), new SqlParameter("FRELEASETIME", 91, (Object)grayInfo.getReleaseTime())};
        Object[] delParams = new SqlParameter[]{new SqlParameter("FAPPGROUP", 12, (Object)grayInfo.getAppGroup())};
        String delSql = "delete from T_BAS_GRAYINFO where FAPPGROUP = ?";
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.meta, (String)delSql, (Object[])delParams);
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(GrayInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        cacheMgr.removeByDt();
        cacheMgr.removeByFilterDt();
    }

    public void updateGrayInfoStatus(String appGroup, String status) {
        GrayInfo currentGrayInfo = this.getGrayInfo(appGroup);
        if (currentGrayInfo == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"T_BAS_GRAYINFO.AppGroup | T_BAS_GRAYAPP.AppGroup does not exist"});
        }
        String sql = "update T_BAS_GRAYINFO set FRELEASESTATUS = ? where FAPPGROUP = ?";
        Object[] params = new Object[]{status, appGroup};
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }

    public void releaseGrayInfo(String appGroup) {
        GrayInfo currentGrayInfo = this.getGrayInfo(appGroup);
        List<GrayAppInfo> grayAppInfoList = this.getGrayAppInfo(appGroup);
        if (currentGrayInfo == null || grayAppInfoList.isEmpty()) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"T_BAS_GRAYINFO.AppGroup | T_BAS_GRAYAPP.AppGroup does not exist"});
        }
        String sql = "update T_BAS_GRAYINFO set FRELEASESTATUS = '1', FRELEASETIME = getdate() where FAPPGROUP = ?";
        String insAppVerSql = "insert into T_BAS_APPVERSION (FID, FAPPID, FITERATION, FUPGRADETIME, FDBVERSION) values(?, ?, ?, getdate(), ?);";
        String updAppVerSql = "update T_META_BIZAPP set FVERSION = ? where FNUMBER = ?;";
        Object[] params = new Object[]{appGroup};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
            for (GrayAppInfo grayAppInfo : grayAppInfoList) {
                String appId = grayAppInfo.getAppId();
                Object[] appIds = new Object[]{grayAppInfo.getAppId()};
                DB.execute((DBRoute)DBRoute.meta, (String)"delete from T_BAS_APPVERSION where FAPPID = ? ;", (Object[])appIds);
                Object[] insAppParams = new Object[]{DB.genGlobalLongId(), appId, grayAppInfo.getIteration(), grayAppInfo.getVersion()};
                DB.execute((DBRoute)DBRoute.meta, (String)insAppVerSql, (Object[])insAppParams);
                Object[] updBizAppParams = new Object[]{appId, grayAppInfo.getVersion()};
                DB.execute((DBRoute)DBRoute.meta, (String)updAppVerSql, (Object[])updBizAppParams);
            }
        }
    }

    public List<GrayAppInfo> getGrayAppInfo(String appGroup) {
        Object[] params = new Object[]{appGroup};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)"select FID, FAPPGROUP, FAPPID, FDBVERSION, FITERATION from T_BAS_GRAYAPP where FAPPGROUP = ?", (Object[])params, (ResultSetHandler)new ResultSetHandler<List<GrayAppInfo>>(){

            public List<GrayAppInfo> handle(ResultSet rs) throws SQLException {
                ArrayList<GrayAppInfo> list = new ArrayList<GrayAppInfo>(10);
                while (rs.next()) {
                    GrayAppInfo grayAppInfo = new GrayAppInfo();
                    grayAppInfo.setId(rs.getLong(1));
                    grayAppInfo.setAppGroup(rs.getString(2));
                    grayAppInfo.setAppId(rs.getString(3));
                    grayAppInfo.setVersion(rs.getString(4));
                    grayAppInfo.setIteration(rs.getString(5));
                    list.add(grayAppInfo);
                }
                return list;
            }
        });
    }

    public void saveGrayAppInfo(List<GrayAppInfo> grayAppInfos) {
        String sql = "insert into T_BAS_GRAYAPP (FID, FAPPGROUP, FAPPID, FDBVERSION, FITERATION) values(?, ?, ?, ?, ?)";
        for (GrayAppInfo grayAppInfo : grayAppInfos) {
            Object[] params = new SqlParameter[]{new SqlParameter("FID", -5, (Object)grayAppInfo.getId()), new SqlParameter("FAPPGROUP", 12, (Object)grayAppInfo.getAppGroup()), new SqlParameter("FAPPID", 12, (Object)grayAppInfo.getAppId()), new SqlParameter("FDBVERSION", 12, (Object)grayAppInfo.getVersion()), new SqlParameter("FFITERATION", 12, (Object)grayAppInfo.getIteration())};
            Object[] delParams = new SqlParameter[]{new SqlParameter("FAPPGROUP", 12, (Object)grayAppInfo.getAppGroup()), new SqlParameter("FAPPID", 12, (Object)grayAppInfo.getAppId())};
            String delSql = "delete from T_BAS_GRAYAPP where FAPPGROUP = ? and FAPPID = ?";
            TXHandle h = TX.required();
            Throwable throwable = null;
            try {
                DB.execute((DBRoute)DBRoute.meta, (String)delSql, (Object[])delParams);
                DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h == null) continue;
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                h.close();
            }
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(GrayAppInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        cacheMgr.removeByDt();
        cacheMgr.removeByFilterDt();
    }

    public MetaGrayInfo getMetaGrayInfo(String formId) {
        Object[] cacheObjects;
        for (Object obj : cacheObjects = this.getMetaGrayInfo()) {
            MetaGrayInfo mgi = (MetaGrayInfo)obj;
            if (!formId.equals(mgi.getNumber())) continue;
            this.setMainApp(mgi);
            return mgi;
        }
        return null;
    }

    public List<MetaGrayInfo> getMasterMetaGrayInfoByGroup(final String appGroup) {
        HashMap<String, MetaGrayInfo> map = new HashMap<String, MetaGrayInfo>(16);
        Object[] cacheObjects = this.getMetaGrayInfo();
        ArrayList<String> formIds = new ArrayList<String>(16);
        for (Object object : cacheObjects) {
            MetaGrayInfo mgi = (MetaGrayInfo)object;
            if (!appGroup.equals(mgi.getAppGroup())) continue;
            this.setMainApp(mgi);
            formIds.add(mgi.getId());
            map.put(mgi.getId(), mgi);
        }
        if (formIds.isEmpty()) {
            return new ArrayList<MetaGrayInfo>(1);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        String tabName = String.format("t_meta_formdesign_%s", appGroup);
        sqlBuilder.append("select FId, FType, FMasterId from ", new Object[0]).append(tabName, new Object[0]).append(" where ", new Object[0]).appendIn("FId", formIds);
        Map extendMap = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>(10);
                while (rs.next()) {
                    if (!"2".equals(rs.getString(2))) continue;
                    map.put(rs.getString(1), rs.getString(3));
                }
                return map;
            }
        });
        for (String extendFormId : extendMap.keySet()) {
            map.remove(extendFormId);
        }
        if (!extendMap.isEmpty()) {
            sqlBuilder = new SqlBuilder();
            String string = String.format("t_meta_formdesign_l_%s", appGroup);
            sqlBuilder.append("select a.FID, a.FNUMBER, b.FNAME, a.FMODELTYPE, a.FBIZAPPID from ", new Object[0]).append(tabName, new Object[0]).append(" a inner join ", new Object[0]).append(string, new Object[0]).append(" b on a.fid = b.fid and b.flocaleid = ", new Object[0]).append(String.format("'%s'", Lang.get().toString()), new Object[0]).append(" where ", new Object[0]).appendIn("a.FID", extendMap.values().toArray());
            List grayInfoList = (List)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<List<MetaGrayInfo>>(){

                public List<MetaGrayInfo> handle(ResultSet rs) throws SQLException {
                    ArrayList<MetaGrayInfo> list = new ArrayList<MetaGrayInfo>(10);
                    while (rs.next()) {
                        MetaGrayInfo grayInfo = new MetaGrayInfo();
                        grayInfo.setId(rs.getString(1));
                        grayInfo.setNumber(rs.getString(2));
                        grayInfo.setName(rs.getString(3));
                        grayInfo.setModelType(rs.getString(4));
                        grayInfo.setAppId(rs.getString(5));
                        grayInfo.setAppGroup(appGroup);
                        list.add(grayInfo);
                    }
                    return list;
                }
            });
            for (MetaGrayInfo metaGrayInfo : grayInfoList) {
                String masterFormId = metaGrayInfo.getId();
                if (map.containsKey(masterFormId)) continue;
                map.put(masterFormId, metaGrayInfo);
            }
        }
        ArrayList<MetaGrayInfo> arrayList = new ArrayList<MetaGrayInfo>(16);
        for (MetaGrayInfo metaGrayInfo : map.values()) {
            arrayList.add(metaGrayInfo);
        }
        return arrayList;
    }

    public List<MetaGrayInfo> getGrayInfoByGroup(String appGroup) {
        Object[] cacheObjects;
        ArrayList<MetaGrayInfo> list = new ArrayList<MetaGrayInfo>(16);
        for (Object obj : cacheObjects = this.getMetaGrayInfo()) {
            MetaGrayInfo mgi = (MetaGrayInfo)obj;
            if (!appGroup.equals(mgi.getAppGroup())) continue;
            this.setMainApp(mgi);
            list.add((MetaGrayInfo)obj);
        }
        return list;
    }

    private Object[] getMetaGrayInfo() {
        IDataEntityType dt = OrmUtils.getDataEntityType(MetaGrayInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        QFilter[] filters = new QFilter[]{new QFilter("id", "is not null", (Object)"")};
        Object[] cacheObjects = cacheMgr.getCachePks(filters);
        if (cacheObjects == null) {
            List grayInfoList = (List)DB.query((DBRoute)DBRoute.meta, (String)"select FID, FNUMBER, FNAME, FMODELTYPE, FAPPID, FAPPGROUP from T_META_GRAYMETA", (ResultSetHandler)new ResultSetHandler<List<MetaGrayInfo>>(){

                public List<MetaGrayInfo> handle(ResultSet rs) throws SQLException {
                    ArrayList<MetaGrayInfo> list = new ArrayList<MetaGrayInfo>(10);
                    while (rs.next()) {
                        MetaGrayInfo grayInfo = new MetaGrayInfo();
                        grayInfo.setId(rs.getString(1));
                        grayInfo.setNumber(rs.getString(2));
                        grayInfo.setName(rs.getString(3));
                        grayInfo.setModelType(rs.getString(4));
                        grayInfo.setAppId(rs.getString(5));
                        grayInfo.setAppGroup(rs.getString(6));
                        list.add(grayInfo);
                    }
                    return list;
                }
            });
            cacheObjects = grayInfoList.toArray(new MetaGrayInfo[0]);
            cacheMgr.putCachePks(filters, grayInfoList.toArray());
        }
        return cacheObjects;
    }

    private void setMainApp(final MetaGrayInfo mgi) {
        if (StringUtils.isBlank((CharSequence)mgi.getMainAppId())) {
            String appGroup = mgi.getAppGroup();
            String sql = String.format("select FId, FNumber, FMasterId, FType from t_meta_bizapp_%s", appGroup);
            DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> mapMasterId = new HashMap<String, String>(10);
                    HashMap<String, String> mapNumber = new HashMap<String, String>(10);
                    String appId = "";
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String number = rs.getString(2);
                        if ("2".equals(rs.getString(4))) {
                            mapMasterId.put(id, rs.getString(3));
                        }
                        mapNumber.put(id, number);
                        if (!mgi.getAppId().equals(number)) continue;
                        appId = id;
                    }
                    String masterId = (String)mapMasterId.get(appId);
                    if (StringUtils.isBlank((CharSequence)masterId)) {
                        mgi.setMainAppId(mgi.getAppId());
                    } else {
                        mgi.setMainAppId((String)mapNumber.get(masterId));
                    }
                    return null;
                }
            });
        }
    }

    public boolean saveMetaGrayInfo(List<MetaGrayInfo> grayInfoList) {
        String sql = "insert into T_META_GRAYMETA (FID, FNUMBER, FNAME, FMODELTYPE, FAPPID, FAPPGROUP) values(?, ?, ?, ?, ?, ?)";
        ArrayList<SqlParameter[]> paraList = new ArrayList<SqlParameter[]>(10);
        ArrayList<String> ids = new ArrayList<String>(10);
        for (MetaGrayInfo grayInfo : grayInfoList) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("FID", 12, (Object)grayInfo.getId()), new SqlParameter("FNUMBER", 12, (Object)grayInfo.getNumber()), new SqlParameter("FNAME", 12, (Object)grayInfo.getName()), new SqlParameter("FMODELTYPE", 12, (Object)grayInfo.getModelType()), new SqlParameter("FAPPID", 12, (Object)grayInfo.getAppId()), new SqlParameter("FAPPGROUP", 12, (Object)grayInfo.getAppGroup())};
            paraList.add(params);
            ids.add(grayInfo.getId());
        }
        if (!ids.isEmpty()) {
            SqlBuilder delSql = new SqlBuilder();
            delSql.append("delete from T_META_GRAYMETA where ", new Object[0]).appendIn("FID", ids);
            try (TXHandle h = TX.required();){
                try {
                    DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)delSql);
                    DB.executeBatch((DBRoute)DBRoute.meta, (String)sql, paraList);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(MetaGrayInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        cacheMgr.removeByDt();
        cacheMgr.removeByFilterDt();
        return true;
    }

    public boolean removeGrayMeta(String appGroup) {
        Object[] params = new SqlParameter[]{new SqlParameter("FAPPGROUP", 12, (Object)appGroup)};
        String delSql = "delete from T_META_GRAYMETA where FAPPGROUP = ?";
        try (TXHandle h = TX.required();){
            try {
                DB.execute((DBRoute)DBRoute.meta, (String)delSql, (Object[])params);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        IDataEntityType dt = OrmUtils.getDataEntityType(MetaGrayInfo.class);
        DataEntityCacheManager cacheMgr = new DataEntityCacheManager(dt);
        cacheMgr.removeByDt();
        cacheMgr.removeByFilterDt();
        return true;
    }
}

