/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userconfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.userconfig.UserConfigQuery;
import kd.bos.userconfig.UserConfigWriter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class GridConfigDAO {
    public static final String ENTRYFIELD_SETTING = "gridConfig";
    public static final String SETTING_IN_ENTRY = "setting_in_entry";
    private static final Log log = LogFactory.getLog(GridConfigDAO.class);

    public void saveGridConfig(String formId, String entryId, List<GridConfigurationRow> configRows) {
        Objects.requireNonNull(formId, "formId can not be blank");
        Objects.requireNonNull(entryId, "entryId can not be blank");
        Objects.requireNonNull(configRows, "entryFieldSettingBean list can not be null");
        String setting = SerializationUtils.toJsonString(configRows);
        UserConfig userConfig = new UserConfig();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        userConfig.setKey(GridConfigDAO.buildUserConfigKey(formId, entryId));
        userConfig.setSetting(setting);
        userConfig.setUserId(userId);
        StringBuilder errorMessage = new StringBuilder();
        UserConfigWriter userConfigWriter = new UserConfigWriter();
        String userConfigPkId = this.getUserConfigPkId(GridConfigDAO.buildUserConfigKey(formId, entryId), userId);
        if (StringUtils.isNotBlank((CharSequence)userConfigPkId)) {
            userConfig.setId(userConfigPkId);
        }
        userConfigWriter.saveUserConfig(userConfig, errorMessage);
        if (errorMessage.length() > 0) {
            log.error(errorMessage.insert(0, "\u8868\u683c\u914d\u7f6e\u9519\u8bef\uff1a").toString());
        }
    }

    public List<GridConfigurationRow> getGridConfig(String formId, String entryId) {
        List configRows = null;
        UserConfigQuery userConfigQuery = new UserConfigQuery();
        UserConfig userConfig = userConfigQuery.getUserConfig(GridConfigDAO.buildUserConfigKey(formId, entryId), Long.parseLong(RequestContext.get().getUserId()));
        if (userConfig != null && userConfig.getSetting() != null) {
            configRows = SerializationUtils.fromJsonStringToList((String)userConfig.getSetting(), GridConfigurationRow.class);
        }
        return configRows != null ? configRows : new ArrayList();
    }

    public String getUserConfigPkId(String key, long userId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FKEY", 12, (Object)key), new SqlParameter(":FUSERID", -5, (Object)userId)};
        String sql = "SELECT FUSERCONFIGID FROM T_BAS_USERCONFIG WHERE FKEY=? AND FUSERID=?";
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            String userConfigPkId1 = null;
            if (rs.next()) {
                userConfigPkId1 = rs.getString("FUSERCONFIGID");
            }
            return userConfigPkId1;
        });
    }

    public boolean deleteGridConfig(String formId, String entryId) {
        UserConfigWriter userConfigWriter = new UserConfigWriter();
        return userConfigWriter.deleteUserConfig(GridConfigDAO.buildUserConfigKey(formId, entryId), Long.parseLong(RequestContext.get().getUserId()));
    }

    public static String buildUserConfigKey(String formId, String entryId) {
        return String.format("%s_%s_%s", formId, entryId, ENTRYFIELD_SETTING);
    }
}

