/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userconfig;

import kd.bos.data.BusinessDataWriter;
import kd.bos.data.PkSnapshotFactory;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.PkSnapshotSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.userconfig.UserConfigDistributeCache;

public class UserConfigWriter {
    private static final Log log = LogFactory.getLog(UserConfigWriter.class);

    public boolean saveUserConfig(UserConfig userConfig, StringBuilder errorMessage) {
        try {
            if (StringUtils.isBlank((CharSequence)userConfig.getSetting())) {
                return false;
            }
            String regionKey = String.valueOf(userConfig.getUserId());
            String[] valueList = (String[])UserConfigDistributeCache.getDistributeCache(regionKey, userConfig.getKey(), new String[2].getClass());
            if (valueList != null && userConfig.getSetting().equalsIgnoreCase(valueList[1])) {
                return true;
            }
            DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(UserConfig.class);
            if (userConfig.getId() != null) {
                PkSnapshotSet pkSnapshotSet = new PkSnapshotSet();
                pkSnapshotSet.Snapshots.add(PkSnapshotFactory.createDataEntitiesSnapshot(dataEntityType, userConfig));
                dataEntityType.setPkSnapshot((Object)userConfig, pkSnapshotSet);
            } else {
                userConfig.setId(SequenceReader.getStringSequence((int)1)[0]);
            }
            BusinessDataWriter.save((IDataEntityType)dataEntityType, new UserConfig[]{userConfig});
            valueList = new String[]{userConfig.getId(), userConfig.getSetting()};
            UserConfigDistributeCache.putDistributeCache(regionKey, userConfig.getKey(), valueList);
            return true;
        }
        catch (Exception e) {
            errorMessage.append(e.getMessage());
            log.error((Throwable)e);
            return false;
        }
    }

    public boolean deleteUserConfig(String key) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FKEY", 12, (Object)key)};
        String sql = "DELETE FROM T_BAS_USERCONFIG WHERE FKEY=?";
        try {
            boolean isSuccess = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            UserConfigDistributeCache.removeDistributeCache(key);
            return isSuccess;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public boolean deleteUserConfig(String key, long userId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FKEY", 12, (Object)key), new SqlParameter(":FUSERID", -5, (Object)userId)};
        String sql = "DELETE FROM T_BAS_USERCONFIG WHERE FKEY=? AND FUSERID = ?";
        try {
            boolean isSuccess = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            String regionKey = String.valueOf(userId);
            UserConfigDistributeCache.removeDistributeCache(regionKey, key);
            return isSuccess;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
    }

    public boolean deleteUserConfig(UserConfig userConfig, StringBuilder errorMessage) {
        try {
            DataEntityType dataEntityType = (DataEntityType)OrmUtils.getDataEntityType(UserConfig.class);
            BusinessDataWriter.delete((IDataEntityType)dataEntityType, new Object[]{userConfig.getId()});
            String regionKey = String.valueOf(userConfig.getUserId());
            UserConfigDistributeCache.removeDistributeCache(regionKey, userConfig.getKey());
            return true;
        }
        catch (Exception e) {
            errorMessage.append(e.getMessage());
            return false;
        }
    }
}

