/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.metadata.IMetadataDeployService;

public class DeployServiceFactory {
    private static Log log = LogFactory.getLog((String)"DeployServiceFactory");
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static boolean isExistService(String fileName) {
        String suffix = DeployServiceFactory.getSuffix(fileName);
        if (suffix == null) {
            log.info(String.format("%s fileName inValid", fileName));
            return false;
        }
        String className = serviceMap.get(suffix);
        return className != null;
    }

    public static IMetadataDeployService getService(String fileName) {
        String suffix = DeployServiceFactory.getSuffix(fileName);
        if (suffix == null) {
            log.info(String.format("%s fileName inValid", fileName));
            return null;
        }
        String className = serviceMap.get(suffix);
        if (className == null) {
            String appName = Instance.getAppName();
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"bos-core-api", (Object[])new Object[0]), suffix, appName));
        }
        return (IMetadataDeployService)TypesContainer.createInstance((String)className);
    }

    private static String getSuffix(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(index);
        }
        return null;
    }

    static {
        serviceMap.put(".ksc", "kd.bos.kingscript.deploy.KingScriptDeployServiceImpl");
    }
}

