/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.io.InputStream;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.FileNameUtils;
import org.apache.log4j.Logger;

public class DeployCustomerCtlHelper {
    private static final String BOS_ATTACHMENT = "bos_attachment";
    private static Logger logger = Logger.getLogger(DeployCustomerCtlHelper.class);

    public static boolean deploy(String appId, String pkId, String fileName, InputStream in) {
        DynamicObjectCollection attDynColls = null;
        try {
            int fileSize = in.available();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            String formId = "ide_controlschema";
            String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)appId, (String)formId, (Object)pkId, (String)fileName);
            FileItem fileItem = new FileItem(fileName, path, in);
            fileItem.setCreateNewFileWhenExists(true);
            String url = fileService.upload(fileItem);
            if (StringUtils.isBlank((CharSequence)url)) {
                return false;
            }
            DynamicObject[] oldData = BusinessDataServiceHelper.load(BOS_ATTACHMENT, "id", new QFilter[]{new QFilter("finterid", "=", (Object)pkId)});
            if (oldData != null && oldData.length > 0) {
                Object[] oldPkIds = new String[oldData.length];
                for (int i = 0; i < oldData.length; ++i) {
                    DynamicObject dynamicObject = oldData[i];
                    oldPkIds[i] = dynamicObject.getString("id");
                }
                BusinessDataServiceHelper.delete(oldData[0].getDataEntityType(), oldPkIds);
            }
            ORM orm = ORM.create();
            attDynColls = orm.query(BOS_ATTACHMENT, new QFilter[]{new QFilter("FNUMBER", "=", (Object)"-1")});
            DynamicObject dObject = orm.newDynamicObject(BOS_ATTACHMENT);
            dObject.set("id", (Object)orm.genLongId(BOS_ATTACHMENT));
            dObject.set("FNUMBER", (Object)Uuid8.generateShortUuid());
            dObject.set("FBillType", (Object)formId);
            dObject.set("FInterID", (Object)pkId);
            Date today = new Date();
            dObject.set("FModifyTime", (Object)today);
            dObject.set("fcreatetime", (Object)today);
            dObject.set("FaliasFileName", (Object)fileName);
            dObject.set("FAttachmentName", (Object)fileName);
            dObject.set("FExtName", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
            dObject.set("FATTACHMENTSIZE", (Object)fileSize);
            dObject.set("FCREATEMEN", (Object)RequestContext.get().getUserId());
            dObject.set("fattachmentpanel", (Object)"attachmentpanelap");
            dObject.set("fdescription", (Object)"");
            dObject.set("FFileId", (Object)(url + "?v=1"));
            orm.insert(dObject);
            dObject.set("FFileId", (Object)url);
            attDynColls.add((Object)dObject);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return !attDynColls.isEmpty();
    }
}

