/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.sdk.annotation.SdkService;

@SdkService(name="\u5fae\u670d\u52a1\u8c03\u7528\u5165\u53e3")
public class DispatchServiceHelper {
    private static Map<String, Object> proxyMap = new ConcurrentHashMap<String, Object>();

    public static <T> T getBOSService(final String appId, String serviceName, Class<T> bizCls) {
        if (serviceName == null) {
            serviceName = bizCls.getSimpleName();
        }
        String key = (appId + "#" + serviceName + "#" + bizCls.getName()).toLowerCase();
        final String sn = serviceName;
        Object obj = proxyMap.computeIfAbsent(key, k -> Proxy.newProxyInstance(bizCls.getClassLoader(), new Class[]{bizCls}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return DispatchServiceHelper.invokeBOSService(appId, sn, method.getName(), args);
            }
        }));
        return (T)obj;
    }

    public static Object invokeBOSService(String appId, String serviceName, String methodName, Object ... paras) {
        try (EntityTraceSpan span = EntityTracer.create((String)(appId + "." + serviceName), (String)methodName);){
            DispatchService service = DispatchServiceHelper.serviceLookup(appId);
            Object object = service.invoke("kd.bos.service.ServiceFactory", serviceName, methodName, paras);
            return object;
        }
    }

    public static <T> T invokeBizService(String cloudId, String appId, String serviceName, String methodName, Object ... paras) {
        try (EntityTraceSpan span = EntityTracer.create((String)(appId + "." + serviceName), (String)methodName);){
            DispatchService service = DispatchServiceHelper.serviceLookup(appId);
            String factory = String.format("kd.%s.%s.servicehelper.ServiceFactory", cloudId, appId);
            Object object = service.invoke(factory, serviceName, methodName, paras);
            return (T)object;
        }
    }

    public static <T> T invokeService(String factoryQualifiedPrefix, String appId, String serviceName, String methodName, Object ... paras) {
        try (EntityTraceSpan span = EntityTracer.create((String)(appId + "." + serviceName), (String)methodName);){
            DispatchService service = DispatchServiceHelper.serviceLookup(appId);
            String factory = String.format("%s.ServiceFactory", factoryQualifiedPrefix);
            Object object = service.invoke(factory, serviceName, methodName, paras);
            return (T)object;
        }
    }

    public static <T> T invokeExternalService(String callerAppId, String apiNumber, Map<String, Object> params) {
        return DispatchServiceHelper.invokeBizService("isc", "iscb.cic", "IscApicService", "invokeBOSExternalService", callerAppId, apiNumber, params);
    }

    private static DispatchService serviceLookup(String appId) {
        DispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        return service;
    }

    static {
        ServiceLookup.addSystemAppId((String[])new String[]{"bos", "bd", "qing", "sbd", "nocode"});
        ServiceLookup.addSystemAppId((String[])new String[]{"iscb"});
        ServiceLookup.addSystemAppId((String[])new String[]{"cvp"});
        ServiceLookup.addSystemAppId((String[])new String[]{"idi"});
        ServiceLookup.addSystemAppId((String[])new String[]{"adm", "bid", "ent", "im", "mal", "pbd", "pur", "quo", "scp", "sou", "srm", "ten", "bdm", "mm", "lbd"});
        ServiceLookup.addSystemAppId((String[])new String[]{"mppm", "mpur", "mscp", "pm", "pmm", "rebm", "repe", "resc", "resm"});
        ServiceLookup.addSystemAppId((String[])new String[]{"pmbd", "pmpd", "pmps"});
        ServiceLookup.addSystemAppId((String[])new String[]{"aifs", "ai", "ap", "ar", "bcm", "cas", "er", "fa", "fibd", "gl", "iep", "pa", "ua", "rpt", "cm", "em"});
        ServiceLookup.addSystemAppId((String[])new String[]{"ssc", "task"});
        ServiceLookup.addSystemAppId((String[])new String[]{"am", "bei", "fbp", "fim"});
        ServiceLookup.addSystemAppId((String[])new String[]{"exp", "kdem", "tra"});
        ServiceLookup.addSystemAppId((String[])new String[]{"eb"});
        ServiceLookup.addSystemAppId((String[])new String[]{"haos", "hbom", "hbp", "hbss", "heo", "hers", "hjms", "hlcs"});
        ServiceLookup.addSystemAppId((String[])new String[]{"hsas", "hsbp", "hsbs", "hscs", "hspp", "hsss"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bbc", "dmp", "dpa", "dpm", "drm", "gcm", "gmc", "mdr", "mem", "ocic", "ococ", "ocp", "orvc", "pos", "posm", "rsp", "rspm", "rss", "saa", "dbd"});
        ServiceLookup.addSystemAppId((String[])new String[]{"tc"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bcm_calcnode"});
        ServiceLookup.addSystemAppId((String[])new String[]{"ir"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bos-up"});
    }
}

