/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TimeService;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u65f6\u95f4\u670d\u52a1")
public class TimeServiceHelper {
    static final TimeService svc = new TimeService();

    public static InteTimeZone getUserTimeZone() {
        return TimeServiceHelper.getUserTimeZone(Long.parseLong(RequestContext.getOrCreate().getUserId()));
    }

    public static InteTimeZone getUserTimeZone(Long userId) {
        return svc.getUserTimeZone(userId);
    }

    public static InteTimeZone getOrgTimeZone(Long orgId) {
        return svc.getOrgTimeZone(orgId);
    }

    public static InteTimeZone getSysTimeZone() {
        return svc.getSysTimeZone();
    }

    @KSMethod
    public static Date now() {
        return svc.now();
    }

    public static Date today() {
        return svc.today();
    }

    public static long getTimeStamp() {
        return TimeServiceHelper.now().getTime();
    }

    public static String getDateTimeFormatString() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static String getDateFormatString() {
        return "yyyy-MM-dd";
    }

    public static String formatToday() {
        return TimeServiceHelper.formatDate(TimeServiceHelper.today());
    }

    public static String formatDate(Date datetime) {
        return svc.formatDate(datetime);
    }

    public static String formatUserNow() {
        return TimeServiceHelper.formatUserNow(Long.parseLong(RequestContext.getOrCreate().getUserId()));
    }

    public static String formatUserNow(Long userId) {
        return TimeServiceHelper.formatUserTime(TimeServiceHelper.now(), userId);
    }

    public static String formatUserTime(Date datetime, Long userId) {
        return TimeServiceHelper.formatUserTime(datetime, userId, null);
    }

    public static String formatUserTime(Date datetime, Long userId, DateFormat fmt) {
        return TimeServiceHelper.getUserTimeZone(userId).format(datetime, fmt);
    }

    public static Date parseUserTime(String datetime, Long userId) throws ParseException {
        return TimeServiceHelper.parseUserTime(datetime, userId, null);
    }

    public static Date parseUserTime(String datetime, Long userId, DateFormat fmt) throws ParseException {
        return TimeServiceHelper.getUserTimeZone(userId).parse(datetime, fmt);
    }

    public static String formatOrgNow(Long orgId) {
        return TimeServiceHelper.formatOrgTime(TimeServiceHelper.now(), orgId);
    }

    public static String formatOrgTime(Date datetime, Long orgId) {
        return TimeServiceHelper.getOrgTimeZone(orgId).format(datetime);
    }

    public static Date parseOrgTime(String datetime, Long orgId) throws ParseException {
        return TimeServiceHelper.parseOrgTime(datetime, orgId, null);
    }

    public static Date parseOrgTime(String datetime, Long orgId, DateFormat fmt) throws ParseException {
        return TimeServiceHelper.getOrgTimeZone(orgId).parse(datetime, fmt);
    }

    @Deprecated
    public static Date GetSystemDateTime() {
        return TimeServiceHelper.now();
    }

    @Deprecated
    public static Date getCurrentSystemTime() {
        return svc.getCurrentSystemTime();
    }

    @Deprecated
    public static long getSysTimeStamp() {
        return TimeServiceHelper.getTimeStamp();
    }

    @Deprecated
    public static Date getCurrentUserTime() {
        return TimeServiceHelper.now();
    }
}

