/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.basedata;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CreateBDUseRegTable {
    private static Log logger = LogFactory.getLog(CreateBDUseRegTable.class);
    private static final String CREATE_USE_REG_TABLE_SQL = "create table %s (  FUseOrgID\t\tbigint          not null,  FDataID      \tbigint          not null,  FCreateOrgID \tbigint          null,  FAdminOrgID  \tbigint          null,  FCtrlStrategy\tvarchar(10)     null,  FIsAssign        char(1)         null,  constraint PK_%s primary key (FUseOrgID, FDataID) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String CREATE_INDEX_SQL = "create index %s on %s (FCreateOrgID ASC)";
    private EntityType baseDataEntity;

    public void create(EntityType baseDataEntity) {
        if (baseDataEntity == null) {
            return;
        }
        this.baseDataEntity = baseDataEntity;
        if (this.tableIsExisted()) {
            return;
        }
        try {
            this.createTable();
            this.createIndex();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    private boolean tableIsExisted() {
        String sql = String.format(TABLE_IS_EXISTED_SQL, this.buildRefTableName());
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    private void createTable() {
        String createSQL = String.format(CREATE_USE_REG_TABLE_SQL, this.buildRefTableName(), this.buildRefTableName());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)createSQL, null);
    }

    private String buildRefTableName() {
        return this.baseDataEntity.getAlias() + "UseReg";
    }

    private String buildIndexName() {
        return "IDX_" + this.buildRefTableName() + "_CO";
    }

    private void createIndex() {
        String sql = String.format(CREATE_INDEX_SQL, this.buildIndexName(), this.buildRefTableName());
        DB.execute((DBRoute)DBRoute.of((String)this.baseDataEntity.getDBRouteKey()), (String)sql, null);
    }
}

