/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.devportal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.devportal.AppTemplate;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
@KSObject
public class BizAppServiceHelp {
    public static Object searchAppAndMenu(String key) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.searchAppAndMenu(key);
    }

    @KSMethod
    public static Object getRuntimeSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getRuntimeSubsysTree(bizCloudIds, bizAppIds, industryId, leafType);
    }

    @KSMethod
    public static Object getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime, boolean onlyVisible, boolean onlyDeployed) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSubsysTree(bizCloudIds, bizAppIds, industryId, leafType, isRuntime, onlyVisible, onlyDeployed);
    }

    @KSMethod
    public static String getAppIsvByAppId(String bizAppId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, "bos_devportal_bizapp", "isv");
        String isv = null;
        if (obj != null) {
            isv = obj.getString("isv");
        }
        return isv;
    }

    @KSMethod
    public static DynamicObject getParentIdAndNumberByAppId(String bizAppId) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, "bos_devportal_bizapp", "parentid,number");
        return obj;
    }

    @KSMethod
    public static String getFormIsvByFormId(String formId) {
        String bizAppId;
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, "bos_formmeta", "isv,bizappid");
        String isv = obj.getString("isv");
        if (StringUtils.isBlank((CharSequence)isv) && StringUtils.isNotBlank((CharSequence)(bizAppId = obj.getString("bizappid")))) {
            isv = BizAppServiceHelp.getAppIsvByAppId(bizAppId);
        }
        return isv;
    }

    @KSMethod
    public static String getScriptIsvByScriptId(String scriptId) {
        String bizAppId;
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, "ide_pluginscript", "isv,bizappid");
        String isv = obj.getString("isv");
        if (StringUtils.isBlank((CharSequence)isv) && StringUtils.isNotBlank((CharSequence)(bizAppId = obj.getString("bizappid")))) {
            isv = BizAppServiceHelp.getAppIsvByAppId(bizAppId);
        }
        return isv;
    }

    @Deprecated
    @KSMethod
    public static boolean isCustomForm(String formId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.isCustomForm(formId);
    }

    @KSMethod
    public static List<String> getFormsIdByAppId(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getFormsIdByAppId(appId);
    }

    public static List<Map<String, Object>> getFormsRuntimeInfoByAppId(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getFormsRuntimeInfoByAppId(appId);
    }

    @KSMethod
    public static List<String> getAppsIdByCloudId(String cloudId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppsIdByCloudId(cloudId);
    }

    @KSMethod
    public static List<String> getSysAppsId() {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSysAppsId();
    }

    @KSMethod
    public static List<String> getSysAppsNumber() {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSysAppsNumber();
    }

    public static List<String> getSysRuntimeMainConsoleInfoGroupByCloud() {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSysRuntimeMainConsoleInfoGroupByCloud();
    }

    public static List<String> getRuntimeMainConsoleInfoByCloudId(String cloudId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppsRuntimeMainConsoleInfoByCloudId(cloudId);
    }

    public static List<String> getSysAppsRuntimeInfoGroupByCloud() {
        return BizAppServiceHelp.getSysAppsRuntimeInfoGroupByCloud(true);
    }

    public static List<String> getSysAppsRuntimeInfoGroupByCloud(boolean onlyActive) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSysAppsRuntimeInfoGroupByCloud(onlyActive);
    }

    public static List<String> getAppsRuntimeInfoByCloudId(String cloudId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppsRuntimeInfoByCloudId(cloudId);
    }

    public static List<Object> getAppsDesigntimeInfo(String cloudId, boolean onlyOriginal, boolean onlyVisible, boolean onlyActive) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppsDesigntimeInfo(cloudId, onlyOriginal, onlyVisible, onlyActive);
    }

    public static List<String> getAppsDesigntimeInfo(String cloudId) {
        List<Object> objs = BizAppServiceHelp.getAppsDesigntimeInfo(cloudId, false, false, false);
        ArrayList<String> strs = new ArrayList<String>(objs.size());
        for (Object obj : objs) {
            strs.add(obj.toString());
        }
        return strs;
    }

    @Deprecated
    public static String getAppRuntimeMetaById(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppRuntimeMetaById(appId);
    }

    public static String getAppRuntimeInfo(String appNumber) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppRuntimeInfo(appNumber);
    }

    public static String getAppRuntimeMenusInfo(String appNumber) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppRuntimeMenusInfo(appNumber);
    }

    @Deprecated
    public static List<String> getAppMenusRuntimeInfoById(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppMenusRuntimeInfoById(appId);
    }

    @Deprecated
    public static List<String> getAppFuncsRuntimeInfoById(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppFuncsRuntimeInfoById(appId);
    }

    public static List<String> getAppLevelOneFuncsRuntimeInfoById(String appId) {
        return BizAppServiceHelp.getAppSubFuncsRuntimeInfo(appId, null);
    }

    public static List<String> getAppSubFuncsRuntimeInfo(String appId, String parentFuncId) {
        List<String> allFuncs = BizAppServiceHelp.getAppFuncsRuntimeInfoById(appId);
        ArrayList<String> subFuncs = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)parentFuncId)) {
            for (String func : allFuncs) {
                JSONObject obj = JSON.parseObject((String)func);
                if (!StringUtils.isBlank((CharSequence)obj.getString("parentid"))) continue;
                subFuncs.add(func);
            }
        } else {
            Objects.requireNonNull(parentFuncId);
            for (String func : allFuncs) {
                JSONObject obj = JSON.parseObject((String)func);
                if (!parentFuncId.equals(obj.getString("parentid"))) continue;
                subFuncs.add(func);
            }
        }
        return subFuncs;
    }

    @KSMethod
    @Deprecated
    public static DynamicObject getBizAppByID(String appID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getBizAppByID(appID);
    }

    @KSMethod
    public static JSONArray getAllAppInfo() {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        String allAppInfo = bizAppService.getAllAppInfo();
        JSONArray allAppsInSystem = JSONArray.parseArray((String)allAppInfo);
        return allAppsInSystem;
    }

    @KSMethod
    public static String getAppGroupAllAppInfo(String appGroup) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppGroupAllAppInfo(appGroup);
    }

    @KSMethod
    @Deprecated
    public static AppMetadata getAppMetaByID(String appID) {
        return BizAppServiceHelp.getAppMetaByID(appID, true);
    }

    @KSMethod
    @Deprecated
    public static AppMetadata getAppMetaByID(String appID, boolean runtime) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        String appMetadataStr = bizAppService.getAppMetadataByID(appID);
        AppTemplate template = new AppTemplate();
        AppMetadata appMetadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        return appMetadata;
    }

    @KSMethod
    public static boolean isAllUserApp(String appID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.isAllUserApp(appID);
    }

    @KSMethod
    public static DynamicObject getBizAppByFormID(String formID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getBizAppByFormID(formID);
    }

    @KSMethod
    public static AppMetadata getAppMetadataByFormID(String formID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        DynamicObject unitRelForm = bizAppService.getAppFpRelByFormId(formID);
        String appId = unitRelForm.getDynamicObject("bizapp").getString("id");
        String appMetadataStr = bizAppService.getAppMetadataByID(appId);
        AppTemplate template = new AppTemplate();
        AppMetadata appMetadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        return appMetadata;
    }

    @KSMethod
    public static DynamicObjectCollection getAllBizApps() {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAllBizApps();
    }

    @KSMethod
    public static List<AppMetadata> getAllAppMetadatas() {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        List appIds = bizAppService.getAllBizAppIds();
        ArrayList<AppMetadata> appMetadataLS = new ArrayList<AppMetadata>(appIds.size());
        for (int i = 0; i < appIds.size(); ++i) {
            String appId = (String)appIds.get(i);
            AppMetadata metadata = BizAppServiceHelp.getAppMetaByID(appId);
            if (metadata == null) continue;
            appMetadataLS.add(metadata);
        }
        return appMetadataLS;
    }

    @KSMethod
    public static DynamicObjectCollection getAllBizAppsByCloudID(String cloudID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAllBizAppsByCloudID(cloudID);
    }

    @KSMethod
    public static DynamicObjectCollection getAllBizAppsByCloudID(List<String> cloudIDs) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAllBizAppsByCloudID(cloudIDs);
    }

    @KSMethod
    public static List<AppMetadata> getAllAppMetadatasByCloudID(String cloudID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        List appIds = bizAppService.getAllBizAppIdsByCloudID(cloudID);
        ArrayList<AppMetadata> appMetadataLS = new ArrayList<AppMetadata>(appIds.size());
        for (int i = 0; i < appIds.size(); ++i) {
            String appId = (String)appIds.get(i);
            AppMetadata metadata = BizAppServiceHelp.getAppMetaByID(appId);
            appMetadataLS.add(metadata);
        }
        return appMetadataLS;
    }

    @KSMethod
    @Deprecated
    public static DynamicObjectCollection getAllFormsByAppID(String appID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAllFormsByAppID(appID);
    }

    @KSMethod
    public static List<AppFunctionPacketElement> getAllAppFunctionPacketsByAppID(String appID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        String appMetadataStr = bizAppService.getAppMetadataByID(appID);
        AppTemplate template = new AppTemplate();
        AppMetadata appMetadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        return appMetadata.getAppFunctionPackets();
    }

    @KSMethod
    public static AppFunctionPacketElement getAppFunctionPacketByNumber(String appID, String funcNumber) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        AppFunctionPacketElement appFunctionPacketElement = null;
        String appMetadataStr = bizAppService.getAppMetadataByID(appID);
        AppTemplate template = new AppTemplate();
        AppMetadata metadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
            AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
            if (!funcNumber.equalsIgnoreCase(func.getNumber())) continue;
            appFunctionPacketElement = func;
            break;
        }
        return appFunctionPacketElement;
    }

    @KSMethod
    public static AppFunctionPacketElement getAppFunctionPacketById(String appID, String funcId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        AppFunctionPacketElement appFunctionPacketElement = null;
        String appMetadataStr = bizAppService.getAppMetadataByID(appID);
        AppTemplate template = new AppTemplate();
        AppMetadata metadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        for (int j = 0; j < metadata.getAppFunctionPackets().size(); ++j) {
            AppFunctionPacketElement func = (AppFunctionPacketElement)metadata.getAppFunctionPackets().get(j);
            if (!funcId.equalsIgnoreCase(func.getId())) continue;
            appFunctionPacketElement = func;
            break;
        }
        return appFunctionPacketElement;
    }

    @KSMethod
    public static List<AppMenuElement> getAllAppMenusByAppID(String appID) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        String appMetadataStr = bizAppService.getAppMetadataByID(appID);
        AppTemplate template = new AppTemplate();
        AppMetadata appMetadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        return appMetadata.getAppMenus();
    }

    @KSMethod
    public static AppMenuElement getAppMenuByNumber(String appID, String menuNumber) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        AppMenuElement appMenuElement = null;
        String appMetadataStr = bizAppService.getAppMetadataByID(appID);
        AppTemplate template = new AppTemplate();
        AppMetadata metadata = (AppMetadata)template.deserializeFromJSONString(appMetadataStr, null);
        for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
            AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
            if (!menuNumber.equalsIgnoreCase(menu.getNumber())) continue;
            appMenuElement = menu;
            break;
        }
        return appMenuElement;
    }

    @KSMethod
    public static AppMenuElement getAppMenuById(String appID, String menuId) {
        AppMetadata metadata = BizAppServiceHelp.getAppMetaByID(appID);
        AppMenuElement appMenuElement = null;
        if (metadata != null) {
            for (int j = 0; j < metadata.getAppMenus().size(); ++j) {
                AppMenuElement menu = (AppMenuElement)metadata.getAppMenus().get(j);
                if (!menuId.equalsIgnoreCase(menu.getId())) continue;
                appMenuElement = menu;
                break;
            }
        }
        return appMenuElement;
    }

    public static String getSVNPathByAppId(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSVNPathByAppId(appId);
    }

    public static String getSVNPathByAppNumber(String appNumber) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getSVNPathByAppNumber(appNumber);
    }

    private static BizAppService getBizAppService() {
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        return bizAppService;
    }

    @KSMethod
    public static String getAppIdByAppNumber(String appNumber) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppIdByAppNumber(appNumber);
    }

    @KSMethod
    public static String getAppNumByAppId(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppNumberByAppId(appId);
    }

    public static String getAppIdByFormNum(String formNum) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getAppIdByFormNum(formNum);
    }

    public static List<Map<String, Object>> getCustomerCtlResourcesBySchemaId(String formId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getCustomerCtlResourcesBySchemaId(formId);
    }

    public static List<Map<String, Object>> getCustomerCtlResourcesByAppId(String appId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.getCustomerCtlResourcesByAppId(appId);
    }

    public static boolean deployCustomerCtlSchema(String schemaId, String fileName, InputStream in) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.deployCustomerCtlSchema(schemaId, fileName, in);
    }

    @KSMethod
    public static Map<String, Object> createExtAppMetadata(String bizAppId, String extAppId) {
        BizAppService bizAppService = BizAppServiceHelp.getBizAppService();
        return bizAppService.createExtAppMetadata(bizAppId, extAppId);
    }
}

