/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.devportal;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.devportal.api.BizScriptService;
import kd.bos.script.ScriptClassInfo;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

@KSObject
public class BizScriptServiceHelper {
    public static String getScriptNumberByClassName(String classname) {
        BizScriptService bizScriptService = BizScriptServiceHelper.getBizScriptService();
        return bizScriptService.getScriptNumberByClassName(classname);
    }

    @KSMethod
    public static String getScriptNumberByName(String scriptName) {
        BizScriptService bizScriptService = BizScriptServiceHelper.getBizScriptService();
        return bizScriptService.getScriptNumberByName(scriptName);
    }

    @KSMethod
    public static DynamicObject getScriptByID(String bizScriptId) {
        BizScriptService bizScriptService = BizScriptServiceHelper.getBizScriptService();
        return bizScriptService.getScriptByID(bizScriptId);
    }

    @KSMethod
    public static DynamicObjectCollection getScriptsByUnitID(String bizUnitId) {
        BizScriptService bizScriptService = BizScriptServiceHelper.getBizScriptService();
        return bizScriptService.getScriptsByUnitID(bizUnitId);
    }

    private static BizScriptService getBizScriptService() {
        return (BizScriptService)ServiceFactory.getService(BizScriptService.class);
    }

    @KSMethod
    public static DynamicObjectCollection getScriptsByAppID(String bizAppId) {
        BizScriptService bizScriptService = BizScriptServiceHelper.getBizScriptService();
        return bizScriptService.getScriptsByAppID(bizAppId);
    }

    public static Set<ScriptClassInfo> getDefinedClasses(String ... requires) {
        BizScriptService bizScriptService = BizScriptServiceHelper.getBizScriptService();
        return bizScriptService.getDefinedClasses(requires);
    }

    @KSMethod
    public static void saveScriptTraceLog(Object object) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject("bos_devp_scriptoperatelog");
        dynamicObject.set("id", (Object)DB.genLongId((String)"t_meta_scriptlog"));
        dynamicObject.set("sessionid", (Object)RequestContext.get().getGlobalSessionId());
        dynamicObject.set("userid", (Object)RequestContext.get().getUserName());
        dynamicObject.set("currenttime", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        dynamicObject.set("data", object);
        SaveServiceHelper.save(new DynamicObject[]{dynamicObject});
    }
}

