/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.list.query.SchemeQuery;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FilterServiceHelper {
    private FilterServiceHelper() {
    }

    public static List<FilterScheme> getSchemeList(String formid) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getScheme(formid, RequestContext.get().getUserId());
    }

    public static List<FilterScheme> getPreSchemeList(String formid) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getPreScheme(formid);
    }

    public static FilterScheme getDefaultScheme(String formid) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getDefaultScheme(formid, RequestContext.get().getUserId());
    }

    public static FilterScheme getFilterSchemeById(String schemeId) {
        SchemeQuery schemeQuery = new SchemeQuery();
        return schemeQuery.getScheme(schemeId);
    }

    public static QFilter getQFilterByFilterScheme(FilterScheme fs, String entityTypeId, QFilter preFilter) {
        return FilterServiceHelper.getQFilterByFilterScheme(fs, entityTypeId, preFilter, true);
    }

    @Deprecated
    public static QFilter getQFilterByFilterScheme(FilterScheme fs, String entityTypeId, QFilter preFilter, boolean isolationOrg) {
        List<QFilter> qFilters = FilterServiceHelper.getQFiltersByFilterScheme(fs, entityTypeId, preFilter, true, "");
        QFilter qFilterResult = null;
        for (QFilter qFilter : qFilters) {
            qFilterResult = FilterUtil.combineFilter(qFilterResult, (QFilter)qFilter);
        }
        return qFilterResult;
    }

    public static List<QFilter> getQFiltersByFilterScheme(FilterScheme fs, String entityTypeId, QFilter preFilter, boolean isolationOrg, String appId) {
        if (fs == null) {
            return new ArrayList<QFilter>();
        }
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        if (dataType == null) {
            return new ArrayList<QFilter>();
        }
        FilterCondition fc = new FilterCondition();
        FilterBuilder fb = new FilterBuilder(dataType, fc, true);
        fb.setTimeService((ITimeService)new TimeService());
        fb.setUserService((IUserService)new UserService());
        List lstFilter = (List)SerializationUtils.deSerializeFromBase64((String)fs.getScheme());
        for (Map mapFilter : lstFilter) {
            fb.addFilterField(((List)mapFilter.get("FieldName")).get(0).toString(), ((List)mapFilter.get("Compare")).get(0).toString(), null, null, (List)mapFilter.get("Value"), "");
        }
        fb.buildFilter();
        List qFilters = fb.getQFilters();
        qFilters.add(preFilter);
        if (isolationOrg) {
            qFilters.add(PermissionFilterUtil.buildPermOrgFilter((MainEntityType)dataType, (boolean)fb.isContainMainOrg(), (boolean)fb.isMainOrgNoLimit(), (String)entityTypeId, (String)appId));
        }
        return qFilters;
    }

    public static int getQFilterCount(FilterScheme fs, String formId, QFilter preFilter) {
        return FilterServiceHelper.getQFilterCount(fs, formId, preFilter, true);
    }

    public static int getQFilterCount(FilterScheme fs, String entityTypeId, QFilter preFilter, boolean isolationOrg) {
        return FilterServiceHelper.getQFilterCount(fs, entityTypeId, preFilter, isolationOrg, "");
    }

    public static int getQFilterCount(FilterScheme fs, String entityTypeId, QFilter preFilter, boolean isolationOrg, String appId) {
        List<QFilter> qFilters = FilterServiceHelper.getQFiltersByFilterScheme(fs, entityTypeId, preFilter, isolationOrg, appId);
        return ORM.create().count(FilterServiceHelper.class.getName(), entityTypeId, qFilters.toArray(new QFilter[0]));
    }

    public static int getQFilterCount(String schemeId, String entityTypeId, QFilter preFilter) {
        return FilterServiceHelper.getQFilterCount(schemeId, entityTypeId, preFilter, true);
    }

    public static int getQFilterCount(String schemeId, String entityTypeId, QFilter preFilter, boolean isolationOrg) {
        FilterScheme fs = FilterServiceHelper.getFilterSchemeById(schemeId);
        return FilterServiceHelper.getQFilterCount(fs, entityTypeId, preFilter, isolationOrg);
    }
}

