/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.operation;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.util.CacheUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang.StringUtils;

@SdkPublic
public class RecordSaveFormServiceHelper {
    private static Log log = LogFactory.getLog(RecordSaveFormServiceHelper.class);
    public static HashMap<String, String> existForms = new HashMap(16);

    public static void recordSaveFormToCache(String entityId) {
        try {
            Object isRdcordCache = RecordSaveFormServiceHelper.getpublicparam("form_save_change_enable");
            if (isRdcordCache != null && !Boolean.parseBoolean(isRdcordCache.toString())) {
                return;
            }
            String key = RecordSaveFormServiceHelper.getKey(entityId);
            if (StringUtils.isNotEmpty((String)entityId) && StringUtils.isNotEmpty((String)key)) {
                String value;
                String expireTimeStr;
                if (!existForms.containsKey(key)) {
                    return;
                }
                String localValue = existForms.get(key);
                String timeStamp = String.valueOf(System.currentTimeMillis());
                String expireTime = "3";
                Object expireTimeOb = RecordSaveFormServiceHelper.getpublicparam("update_between_time");
                if (expireTimeOb != null && StringUtils.isNotEmpty((String)(expireTimeStr = expireTimeOb.toString()))) {
                    expireTime = expireTimeStr;
                }
                if (localValue == null) {
                    value = CacheUtil.get(key);
                    if (StringUtils.isNotEmpty((String)value)) {
                        if (Long.parseLong(value) + 60000L * Long.parseLong(expireTime) < System.currentTimeMillis()) {
                            RecordSaveFormServiceHelper.putCache(key, timeStamp);
                        }
                    } else {
                        RecordSaveFormServiceHelper.putCache(key, timeStamp);
                    }
                } else if (Long.parseLong(localValue) + 60000L * Long.parseLong(expireTime) < System.currentTimeMillis()) {
                    value = CacheUtil.get(key);
                    if (StringUtils.isNotEmpty((String)value)) {
                        if (Long.parseLong(value) + 60000L * Long.parseLong(expireTime) < System.currentTimeMillis()) {
                            RecordSaveFormServiceHelper.putCache(key, timeStamp);
                        }
                    } else {
                        RecordSaveFormServiceHelper.putCache(key, timeStamp);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.info("\u8868\u5355\u589e\u5220\u6539\u65f6\u8bb0\u5f55\u66f4\u65b0\u65f6\u95f4\u5f02\u5e38\uff1a", (Object)e.getMessage());
        }
    }

    private static Object getpublicparam(String key) {
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object object = systemParamService.loadPublicParameterFromCache(key);
            return object;
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u9996\u9875\u5361\u7247\u8fc7\u671f\u65f6\u95f4\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
    }

    private static void putCache(String key, String timeStamp) {
        existForms.put(key, timeStamp);
        CacheUtil.put(key, timeStamp, 30, TimeUnit.DAYS);
    }

    private static String getKey(String entityId) {
        StringBuilder keyStringBuilder = new StringBuilder();
        String accountId = RequestContext.get().getAccountId();
        if (StringUtils.isNotEmpty((String)accountId)) {
            keyStringBuilder.append("form_save_record_");
            keyStringBuilder.append(accountId);
            keyStringBuilder.append("_");
            keyStringBuilder.append(entityId);
            return keyStringBuilder.toString();
        }
        return null;
    }

    public static String getFormUpdateTimeCache(String entityId) {
        String key = RecordSaveFormServiceHelper.getKey(entityId);
        if (StringUtils.isNotEmpty((String)entityId)) {
            String value = CacheUtil.get(key);
            return value;
        }
        return null;
    }

    public static String getProptyByTenant(String key) {
        String tenantId = RequestContext.get().getTenantId();
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    public static void recordForm(String entityId) {
        if (StringUtils.isNotEmpty((String)entityId)) {
            String key = RecordSaveFormServiceHelper.getKey(entityId);
            if (StringUtils.isNotEmpty((String)entityId) && !existForms.containsKey(key)) {
                existForms.put(key, null);
            }
        }
    }
}

