/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.BizViewQueryParam;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.OrgQueryType;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u7ec4\u7ec7\u5355\u5143\u670d\u52a1")
public class OrgUnitServiceHelper {
    private static final String NUMBER = "number";
    private static final String VIEW_NUMBER = "view.number";
    private static final String ORG_ID = "org.id";
    private static final String PARENT = "parent";
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static final String VIEW_TREETYPE = "view.treetype";
    private static final String VIEW_ISDEFAULT = "view.isdefault";
    private static Log logger = LogFactory.getLog(OrgUnitServiceHelper.class);
    public static final String EntityID_Bos_Org = "bos_org";
    public static final String entityID_org_structure = "bos_org_structure";
    public static final String entityID_costcenter = "bos_costcenter";
    public static final String entityID_costcentersource = "bos_costcentersource";

    public static void addOrUpdate(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addOrUpdate(paramList);
    }

    public static void add(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.add(paramList);
    }

    public static void add(OrgParam orgParam) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.add(orgParam);
    }

    public static void addByFullname(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addByFullname(paramList);
    }

    public static void addRoot(OrgParam orgParam) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addRoot(orgParam);
    }

    public static void addDutyRoot(OrgParam orgParam) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addDutyRoot(orgParam);
    }

    public static void update(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.update(paramList);
    }

    public static void update(OrgParam orgParam) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.update(orgParam);
    }

    public static void delete(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.delete(paramList);
    }

    public static void disable(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.disable(paramList);
    }

    public static void enable(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.enable(paramList);
    }

    public static void freeze(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.freeze(paramList);
    }

    public static void unFreeze(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.unFreeze(paramList);
    }

    public static void addDuty(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.addDuty(paramList);
    }

    public static void deleteDuty(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.deleteDuty(paramList);
    }

    public static void enableHR(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.enableHR(paramList);
    }

    public static void disableHR(List<OrgParam> paramList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.disableHR(paramList);
    }

    public static long getOrgViewIdByFormId(String orgViewType, String formNumber) {
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            orgViewType = "01";
        }
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        long viewid = orgService.getOrgViewIdByFormId(orgViewType, formNumber);
        return viewid;
    }

    public static Long getOrgSuperior(long viewId, long orgId, Date date) {
        long parentId = 0L;
        if (date == null) {
            date = Utils.getDate((int)0);
        }
        String selectFields = "id,parent";
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter parentFilter = new QFilter("org", "=", (Object)orgId);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)date);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)date);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, startDateFilter, endDateFilter};
        DynamicObjectCollection parentOrgCol = QueryServiceHelper.query("bos_org_structure_history", selectFields, filters);
        if (Utils.isListEmpty((List)parentOrgCol)) {
            return parentId;
        }
        for (DynamicObject parent : parentOrgCol) {
            parentId = parent.getLong(PARENT);
        }
        return parentId;
    }

    public static Map<String, Object> getCompanyfromOrg(Long orgID) {
        return OrgUnitServiceHelper.getCompanyfromOrgCommon(orgID);
    }

    public static <T> Map<String, Object> getCompanyfromOrg(T org) {
        return OrgUnitServiceHelper.getCompanyfromOrgCommon(org);
    }

    private static <T> Map<String, Object> getCompanyfromOrgCommon(T org) {
        if (StringUtils.isBlank(org)) {
            logger.info("\u83b7\u53d6\u6240\u5c5e\u516c\u53f8\u5931\u8d25\uff1a\u53c2\u6570\u4e3anull");
            return new HashMap<String, Object>(0);
        }
        long orgId = 0L;
        if (org instanceof Long || org instanceof Integer) {
            orgId = Long.parseLong(org.toString());
        } else if (org instanceof String) {
            QFilter numberFilter = new QFilter(NUMBER, "=", org);
            QFilter[] filters = new QFilter[]{numberFilter};
            Map<Object, DynamicObject> orgObjMap = BusinessDataServiceHelper.loadFromCache(EntityID_Bos_Org, "id", filters);
            if (orgObjMap == null || orgObjMap.isEmpty()) {
                return new HashMap<String, Object>(0);
            }
            orgId = (Long)orgObjMap.keySet().iterator().next();
        }
        return OrgUnitServiceHelper.getBelongToOrgByPatternOrType(true, "01", orgId, "1", "2");
    }

    public static List<Long> getSubOrgLimitLevel(List<Long> orgIds, int limitLevel, boolean includeCurrent) {
        ArrayList<Long> subOrgIds = new ArrayList<Long>();
        if (includeCurrent && orgIds != null) {
            subOrgIds.addAll(orgIds);
        }
        if (Utils.isListEmpty(orgIds) || limitLevel == 0) {
            return subOrgIds;
        }
        String selectFields = "id,org,longnumber,level";
        QFilter orgQFilter = new QFilter("org", "in", orgIds);
        QFilter viewFilter = new QFilter(VIEW_ISDEFAULT, "=", (Object)Boolean.TRUE);
        viewFilter.and(new QFilter(VIEW_TREETYPE, "=", (Object)"01"));
        QFilter[] filters = new QFilter[]{viewFilter, orgQFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query(entityID_org_structure, selectFields, filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return subOrgIds;
        }
        QFilter subFilter = null;
        String longNumberSep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        for (DynamicObject org : orgCol) {
            String longnumber = org.getString("longnumber") + longNumberSep + "%";
            QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)longnumber);
            int curLevel = org.getInt("level");
            longnumberFilter = longnumberFilter.and("level", "<=", (Object)(curLevel + limitLevel));
            if (subFilter == null) {
                subFilter = longnumberFilter;
                continue;
            }
            subFilter = subFilter.or(longnumberFilter);
        }
        filters = new QFilter[]{viewFilter, subFilter};
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query(entityID_org_structure, selectFields, filters);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return subOrgIds;
        }
        for (DynamicObject org : subOrgCol) {
            subOrgIds.add(org.getLong("org"));
        }
        return subOrgIds;
    }

    public static QFilter getBizOrgFilter(String orgViewType) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getBizOrgFilter(orgViewType);
    }

    public static List<Map<String, String>> getOrgBizList() {
        QFilter f1 = new QFilter("isbasetype", "=", (Object)"1");
        Map<Object, DynamicObject> orgBizMap = BusinessDataServiceHelper.loadFromCache("bos_org_biz", "id,fnumber,fname", new QFilter[]{f1}, null);
        if (orgBizMap == null || orgBizMap.isEmpty()) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> lstBizs = new ArrayList<Map<String, String>>(orgBizMap.size());
        for (DynamicObject orgBiz : orgBizMap.values()) {
            String sBizNumber = orgBiz.getString("fnumber");
            String sBizName = orgBiz.getString("fname");
            HashMap<String, String> mpBiz = new HashMap<String, String>();
            mpBiz.put(sBizNumber, sBizName);
            lstBizs.add(mpBiz);
        }
        return lstBizs;
    }

    public static List<Map<String, String>> getOrgBizSelectorList() {
        QFilter isbasetypeFilter = new QFilter("isbasetype", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visiableFilter = new QFilter("visiable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{isbasetypeFilter, enableFilter, visiableFilter};
        Map<Object, DynamicObject> orgBizMap = BusinessDataServiceHelper.loadFromCache("bos_org_biz", "id,fnumber,fname", filters, "fnumber");
        if (orgBizMap == null || orgBizMap.isEmpty()) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> lstBizs = new ArrayList<Map<String, String>>(orgBizMap.size());
        for (DynamicObject orgBiz : orgBizMap.values()) {
            String sBizNumber = orgBiz.getString("fnumber");
            String sBizName = orgBiz.getString("fname");
            HashMap<String, String> mpBiz = new HashMap<String, String>(1);
            mpBiz.put(sBizNumber, sBizName);
            lstBizs.add(mpBiz);
        }
        return lstBizs;
    }

    public static Map<String, Object> getOrgbyYzjorgId(String yzjorgId) {
        HashMap<String, Object> mpErpOrg = new HashMap<String, Object>();
        QFilter f1 = new QFilter("fyzjorgid", "=", (Object)yzjorgId);
        ORM ormOrg = ORM.create();
        try (DataSet ds = ormOrg.queryDataSet(OrgUnitServiceHelper.class.getName(), EntityID_Bos_Org, "id,number,name", new QFilter[]{f1});){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                mpErpOrg.put("id", row.get("id"));
                mpErpOrg.put(NUMBER, row.get(NUMBER));
                mpErpOrg.put("name", row.get("name"));
            }
        }
        return mpErpOrg;
    }

    public static List<Long> getSuperiorOrgs(String orgFunction, long orgId) {
        ArrayList<Long> lstOrgs = new ArrayList<Long>();
        if (orgId == 0L) {
            return lstOrgs;
        }
        return OrgUnitServiceHelper.getSuperiorOrgs(orgFunction, Collections.singletonList(orgId));
    }

    public static List<Long> getAllSuperiorOrgs(String orgFunction, long orgId) {
        return OrgUnitServiceHelper.getOrgService().getAllSuperiorOrgs(orgFunction, orgId);
    }

    public static Map<Long, List<Long>> getAllSuperiorOrgs(String viewNumber, List<Long> orgIds) {
        return OrgUnitServiceHelper.getOrgService().getAllSuperiorOrgs(viewNumber, orgIds);
    }

    public static List<Long> getSuperiorOrgs(String orgFunction, List<Long> orgIds) {
        QFilter f3;
        QFilter f2;
        Map<Object, DynamicObject> structureObjMap;
        ArrayList<Long> lstOrgs = new ArrayList<Long>();
        if (orgIds == null || orgIds.isEmpty()) {
            return lstOrgs;
        }
        if (StringUtils.isBlank((CharSequence)orgFunction)) {
            orgFunction = "01";
        }
        if ((structureObjMap = BusinessDataServiceHelper.loadFromCache(entityID_org_structure, PARENT, new QFilter[]{f2 = new QFilter(VIEW_NUMBER, "=", (Object)orgFunction), f3 = new QFilter("org", "in", orgIds)})) == null || structureObjMap.isEmpty()) {
            return lstOrgs;
        }
        for (Map.Entry<Object, DynamicObject> entry : structureObjMap.entrySet()) {
            DynamicObject parentObj = entry.getValue().getDynamicObject(PARENT);
            lstOrgs.add(parentObj == null ? 0L : parentObj.getLong("id"));
        }
        return lstOrgs;
    }

    public static List<Long> getOrgSubMainDataList(Long curOrgId, Long projectId, boolean IsIncludeAllSub) {
        ArrayList<Long> orgLst = null;
        ORM ormOV = ORM.create();
        QFilter filterMain = null;
        if (!IsIncludeAllSub) {
            filterMain = new QFilter(PARENT, "=", (Object)curOrgId);
        }
        QFilter filterView = new QFilter("view", "=", (Object)projectId);
        QFilter filterIsCtrlUnit = new QFilter("isctrlunit", "=", (Object)Boolean.FALSE);
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), entityID_org_structure, ORG_ID, new QFilter[]{filterMain, filterView, filterIsCtrlUnit});){
            orgLst = new ArrayList<Long>();
            for (Row row : ds) {
                if (row.get(ORG_ID) == null) continue;
                orgLst.add(row.getLong(ORG_ID));
            }
        }
        return orgLst;
    }

    @Deprecated
    public static Map<String, Object> deleteViewOrg(Long orgViewID, Long orgID) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        QFilter fftreetype = new QFilter("view", "=", (Object)orgViewID);
        QFilter ffparentid = new QFilter(PARENT, "=", (Object)orgID);
        QFilter[] qFilters = new QFilter[]{fftreetype, ffparentid};
        Boolean isHasSubOrg = QueryServiceHelper.exists(entityID_org_structure, qFilters);
        if (isHasSubOrg.booleanValue()) {
            String msg = ResManager.loadKDString((String)"\u88ab\u5220\u9664\u7684\u7ec4\u7ec7\u6709\u4e0b\u7ea7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"OrgUnitServiceHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]);
            result.put("result", Boolean.FALSE);
            result.put("message", msg);
            return result;
        }
        QFilter fOrgID = new QFilter("org", "=", (Object)orgID);
        qFilters = new QFilter[]{fftreetype, fOrgID};
        DeleteServiceHelper.delete(entityID_org_structure, qFilters);
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OrgUnitServiceHelper_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]);
        result.put("result", Boolean.TRUE);
        result.put("message", msg);
        return result;
    }

    public static List<Long> getAllSubordinateOrgs(Long viewType, List<Long> orgIds, boolean bIncludeCurOrg) {
        return OrgUnitServiceHelper.getOrgService().getAllSubordinateOrgs(viewType, orgIds, bIncludeCurOrg);
    }

    public static List<Long> getAllSubordinateOrgs(Long viewType, List<Long> orgIds, boolean bIncludeCurOrg, boolean isIncludeDisable) {
        return OrgUnitServiceHelper.getOrgService().getAllSubordinateOrgs(viewType, orgIds, bIncludeCurOrg, isIncludeDisable);
    }

    public static List<Long> getAllOrgByViewId(long viewId, boolean isIncludeDisable) {
        return OrgUnitServiceHelper.getOrgService().getAllOrgByViewId(viewId, isIncludeDisable);
    }

    public static List<Long> getAllOrgByViewNumber(String viewSchemaNumber, boolean isIncludeDisable) {
        return OrgUnitServiceHelper.getOrgService().getAllOrgByViewNumber(viewSchemaNumber, isIncludeDisable);
    }

    public static List<Long> getAllSubordinateOrgs(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg) {
        return OrgUnitServiceHelper.getOrgService().getAllSubordinateOrgs(viewSchemaNumber, orgIds, isIncludeCurOrg);
    }

    public static List<Long> getAllSubordinateOrgs(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeDisable) {
        return OrgUnitServiceHelper.getOrgService().getAllSubordinateOrgs(viewSchemaNumber, orgIds, isIncludeCurOrg, isIncludeDisable);
    }

    public static Map<Long, List<Long>> getAllSubordinateOrgMap(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg) {
        return OrgUnitServiceHelper.getOrgService().getAllSubordinateOrgMap(viewSchemaNumber, orgIds, isIncludeCurOrg);
    }

    public static Map<Long, List<Long>> getAllSubordinateOrgMap(long viewId, List<Long> orgIds, boolean isIncludeCurOrg) {
        return OrgUnitServiceHelper.getOrgService().getAllSubordinateOrgMap(viewId, orgIds, isIncludeCurOrg);
    }

    public static int getOrgmanageMode() {
        return LicenseServiceHelper.getModeType();
    }

    public static long getRootOrgId() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getRootOrgId();
    }

    public static Map<Long, Long> getRootOrgId(List<Long> viewIds) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getRootOrgId(viewIds);
    }

    public static String getOrg(long orgId, long userId, OrgQueryType queryType, List<Long> resultList) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getOrg(orgId, userId, queryType, resultList);
    }

    public static long getViewIdByType(String orgViewType) {
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            return 0L;
        }
        QFilter sysFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter typeFilter = new QFilter("treetype", "=", (Object)orgViewType);
        QFilter[] filters = new QFilter[]{sysFilter, typeFilter};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache("bos_org_viewschema", "id", filters);
        if (viewObj == null) {
            return 0L;
        }
        return viewObj.getLong("id");
    }

    public static Map<String, Object> getOrgProperty(long orgId, List<String> propertyNameList) {
        if (orgId == 0L || Utils.isListEmpty(propertyNameList)) {
            return new HashMap<String, Object>(0);
        }
        StringBuilder selectProperties = new StringBuilder();
        boolean isFirstProperty = true;
        int proCount = propertyNameList.size();
        ArrayList<String> noRepeatList = new ArrayList<String>(proCount);
        for (String propertyName : propertyNameList) {
            if (StringUtils.isBlank((CharSequence)propertyName) || noRepeatList.contains(propertyName)) continue;
            if (isFirstProperty) {
                isFirstProperty = false;
            } else {
                selectProperties.append(',');
            }
            noRepeatList.add(propertyName);
            selectProperties.append(propertyName);
        }
        if (StringUtils.isBlank((CharSequence)selectProperties)) {
            return new HashMap<String, Object>(0);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache(EntityID_Bos_Org, selectProperties.toString(), filters);
        if (orgObj == null) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(proCount + 1);
        propertyMap.put("id", orgId);
        for (String propertyName : noRepeatList) {
            propertyMap.put(propertyName, orgObj.get(propertyName));
        }
        return propertyMap;
    }

    public static String getBizOrgPropertyName(String orgViewType) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getBizOrgPropertyName(orgViewType);
    }

    public static Map<String, Object> getTreeRootNodeMapById(OrgTreeParam param) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getTreeRootNodeMapById(param);
    }

    public static TreeNode getTreeRootNodeById(OrgTreeParam param) {
        if (param == null) {
            return null;
        }
        param.setReturnTreeNodeOrMap(true);
        Map<String, Object> rootNodeMap = OrgUnitServiceHelper.getTreeRootNodeMapById(param);
        Object data = rootNodeMap.get("data");
        if (data == null) {
            return null;
        }
        return (TreeNode)data;
    }

    public static List<Map<String, Object>> getTreeChildrenMap(OrgTreeParam param) {
        if (param == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getTreeChildrenMap(param);
    }

    public static List<TreeNode> getTreeChildren(OrgTreeParam param) {
        if (param == null) {
            return new ArrayList<TreeNode>(0);
        }
        param.setReturnTreeNodeOrMap(true);
        List<Map<String, Object>> childrenMapList = OrgUnitServiceHelper.getTreeChildrenMap(param);
        if (Utils.isListEmpty(childrenMapList)) {
            return new ArrayList<TreeNode>(0);
        }
        Map<String, Object> dataMap = childrenMapList.get(0);
        Object data = dataMap.get("data");
        if (data == null) {
            return new ArrayList<TreeNode>(0);
        }
        return (List)data;
    }

    public static List<Long> getAdminOrgRelation(List<Long> orgIds, boolean isReturnAdminOrg) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getAdminOrgRelation(orgIds, isReturnAdminOrg);
    }

    public static List<Long> getAuthorizedAdminOrg() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getAuthorizedAdminOrg();
    }

    public static long getDefaultOrgRelation(OrgRelationParam param) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getDefaultOrgRelation(param);
    }

    public static long getOrgForFormDefValue(OrgRelationParam param) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getOrgForFormDefValue(param);
    }

    public static Map<String, Object> getOrgRelation(OrgRelationParam param) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getOrgRelation(param);
    }

    public static Map<Long, Map<Long, Map<String, Object>>> getMultiOrgRelation(OrgRelationParam param) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getMultiOrgRelation(param);
    }

    public static List<Long> getBizRelationOrgIds(OrgRelationParam param) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getBizRelationOrgIds(param);
    }

    public static Map<String, Object> getCompanyByOrg(Long orgId) {
        return OrgUnitServiceHelper.getCompanyByOrg(orgId, Boolean.TRUE, Boolean.TRUE);
    }

    public static Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSearchUpward) {
        if (orgId == null) {
            logger.info("[getCompanyByOrg]\u7ec4\u7ec7\u53c2\u6570\u4e3a\u7a7a\u3002");
            return new HashMap<String, Object>(0);
        }
        isBizUnit = isBizUnit == null ? Boolean.FALSE : isBizUnit;
        isSearchUpward = isSearchUpward == null ? Boolean.TRUE : isSearchUpward;
        Map<Long, Map<String, Object>> accountingCompanyByView = OrgUnitServiceHelper.getAccountingBizUnit(15L, Collections.singletonList(orgId), isBizUnit, isSearchUpward);
        if (accountingCompanyByView == null || accountingCompanyByView.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        return accountingCompanyByView.entrySet().iterator().next().getValue();
    }

    public static Map<String, Object> getCompanyByAdminOrg(Long adminOrgId) {
        return OrgUnitServiceHelper.getCompanyByAdminOrg(adminOrgId, Boolean.FALSE);
    }

    public static Map<String, Object> getCompanyByAdminOrg(Long adminOrgId, Boolean isBizUnit) {
        if (adminOrgId == null) {
            logger.info("[getCompanyByAdminOrg]\u7ec4\u7ec7\u53c2\u6570\u4e3a\u7a7a\u3002");
            return new HashMap<String, Object>(0);
        }
        isBizUnit = isBizUnit == null ? Boolean.FALSE : isBizUnit;
        Map<Long, Map<String, Object>> accountingCompanyByAdminOrg = OrgUnitServiceHelper.getAccountingBizUnit(1L, Collections.singletonList(adminOrgId), isBizUnit, true);
        if (accountingCompanyByAdminOrg == null || accountingCompanyByAdminOrg.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        return accountingCompanyByAdminOrg.entrySet().iterator().next().getValue();
    }

    public static void move(long viewId, long orgId, long oldParentId, long newParentId) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        orgService.move(viewId, orgId, oldParentId, newParentId);
    }

    public static List<Long> getAllOrg(String viewSchemaNumber) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getAllOrg(viewSchemaNumber);
    }

    public static boolean isDistributedDepartment() {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.isDistributedDepartment();
    }

    public static boolean checkOrgFunction(Long orgID, String orgFunction) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgID);
        return OrgUnitServiceHelper.filterOrgDuty(orgIds, orgFunction).contains(orgID);
    }

    public static boolean isParentOrg(String viewNumber, long parentId, long orgId) {
        QFilter viewFilter = new QFilter(VIEW_NUMBER, "=", (Object)viewNumber);
        QFilter parentFilter = new QFilter("org", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet(" kd.bos.org.OrgOperationServicePlugIn.isParent", entityID_org_structure, "longnumber", filters, "");){
            if (ds.hasNext()) {
                QFilter parentLongnumberFilter = new QFilter("longnumber", "like", (Object)(ds.next().getString("longnumber") + OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep() + "%"));
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter[] qFilters = new QFilter[]{viewFilter, parentLongnumberFilter, orgFilter};
                boolean bl = QueryServiceHelper.exists(entityID_org_structure, qFilters);
                return bl;
            }
        }
        return false;
    }

    public static List<Long> filterOrgDuty(List<Long> orgIds, String orgViewNumber) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.filterOrgDuty(orgIds, orgViewNumber);
    }

    public static List<Long> filterOrg(List<Long> orgIds, long viewId, boolean isFilterDisable, boolean isFilterFreeze) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.filterOrg(orgIds, viewId, isFilterDisable, isFilterFreeze);
    }

    public static List<Long> getOrgByLevel(String orgViewNumber, int level, boolean includeDisable, boolean includeFreeze) {
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.getOrgByLevel(orgViewNumber, level, includeDisable, includeFreeze);
    }

    @Deprecated
    public static List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType) {
        boolean isIncludeToOrgSelf = true;
        if ("01".equals(fromOrgType)) {
            isIncludeToOrgSelf = false;
        }
        return OrgUnitServiceHelper.getFromOrgs(toOrgType, toOrgId, fromOrgType, isIncludeToOrgSelf);
    }

    @Deprecated
    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId) {
        boolean isIncludeFromOrgSelf = true;
        if ("01".equals(toOrgType)) {
            isIncludeFromOrgSelf = false;
        }
        return OrgUnitServiceHelper.getToOrg(fromOrgType, toOrgType, fromOrgId, isIncludeFromOrgSelf);
    }

    @Deprecated
    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId) {
        boolean isIncludeFromOrgSelf = true;
        if ("01".equals(toOrgType)) {
            isIncludeFromOrgSelf = false;
        }
        return OrgUnitServiceHelper.getAllToOrg(fromOrgType, toOrgType, fromOrgId, isIncludeFromOrgSelf);
    }

    @Deprecated
    public static List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType, boolean isIncludeToOrgSelf) {
        return OrgUnitServiceHelper.getOrgService().getFromOrgs(toOrgType, toOrgId, fromOrgType, isIncludeToOrgSelf);
    }

    @Deprecated
    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        return OrgUnitServiceHelper.getOrgService().getToOrg(fromOrgType, toOrgType, fromOrgId, isIncludeFromOrgSelf);
    }

    @Deprecated
    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        return OrgUnitServiceHelper.getOrgService().getAllToOrg(fromOrgType, toOrgType, fromOrgId, isIncludeFromOrgSelf);
    }

    public static Map<String, Object> getBelongToOrgByPatternOrType(boolean isByPatternType, String orgViewNumber, long orgId, String ... patternOrPatternTypes) {
        if (patternOrPatternTypes == null || patternOrPatternTypes.length == 0) {
            logger.info(String.format("\u6839\u636e\u5f62\u6001\u6216\u8005\u5f62\u6001\u7c7b\u578b\u83b7\u53d6\u4e0a\u7ea7\u7ec4\u7ec7\u5931\u8d25\uff0c\u53c2\u6570\u4e3a\uff1a[%s][%s][%s]", isByPatternType, orgId, patternOrPatternTypes));
            return new HashMap<String, Object>(0);
        }
        ArrayList<Object> patternOrPatternTypeList = new ArrayList<Object>(patternOrPatternTypes.length);
        for (String patternOrPatternType : patternOrPatternTypes) {
            patternOrPatternTypeList.add(patternOrPatternType);
        }
        Map<Long, Map<String, Object>> orgByPattern = OrgUnitServiceHelper.getOrgByPattern(orgViewNumber, Collections.singletonList(orgId), isByPatternType, patternOrPatternTypeList);
        if (orgByPattern == null) {
            return new HashMap<String, Object>(0);
        }
        HashMap orgMap = orgByPattern.get(orgId);
        return orgMap == null ? new HashMap(0) : orgMap;
    }

    @KSMethod
    public static List<DynamicObject> getCostCenterByAdminOrg(Long adminOrgID) {
        String selectProperties = "costcenter.id, costcenter.name, costcenter.number";
        QFilter enableQFilter = new QFilter("costcenter.enable", "=", (Object)Boolean.TRUE);
        QFilter sourcetypeQFilter = new QFilter("sourcetype.number", "=", (Object)"adminorg");
        QFilter adminOrgQFilter = new QFilter("data", "=", (Object)adminOrgID);
        QFilter[] filters = new QFilter[]{enableQFilter, sourcetypeQFilter, adminOrgQFilter};
        Map<Object, DynamicObject> costCenterMap = BusinessDataServiceHelper.loadFromCache(entityID_costcentersource, selectProperties, filters);
        if (costCenterMap == null || costCenterMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        ArrayList<DynamicObject> costCenterList = new ArrayList<DynamicObject>(costCenterMap.size());
        for (DynamicObject costCenter : costCenterMap.values()) {
            costCenterList.add(costCenter.getDynamicObject("costcenter"));
        }
        return costCenterList;
    }

    public static OrgApiResult saveOrgViewSchema(ViewSchemaParam param) {
        return OrgUnitServiceHelper.getOrgService().saveOrgViewSchema(param);
    }

    public static OrgApiResult deleteOrgViewSchema(List<Long> idList) {
        return OrgUnitServiceHelper.getOrgService().deleteOrgViewSchema(idList);
    }

    public static OrgApiResult enableOrgViewSchema(List<Long> idList, boolean enable) {
        return OrgUnitServiceHelper.getOrgService().enableOrgViewSchema(idList, enable);
    }

    public static IOrgService getOrgService() {
        return (IOrgService)ServiceFactory.getService(IOrgService.class);
    }

    public static String getOrgSortSchema() {
        return OrgUnitServiceHelper.getOrgService().getOrgSortSchema();
    }

    public static String getOrgSortFields() {
        return OrgUnitServiceHelper.getOrgService().getOrgSortFields();
    }

    public static String getOrgStructureSortFields() {
        return OrgUnitServiceHelper.getOrgService().getOrgStructureSortFields();
    }

    public static List<Map<String, Object>> getViewSchemaByType(String orgViewType) {
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            return new ArrayList<Map<String, Object>>();
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter typeFilter = new QFilter("treetype", "=", (Object)orgViewType);
        QFilter[] filters = new QFilter[]{enableFilter, typeFilter};
        Map<Object, DynamicObject> viewSchemaMap = BusinessDataServiceHelper.loadFromCache("bos_org_viewschema", "id,number,name", filters, NUMBER);
        if (viewSchemaMap == null || viewSchemaMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> viewSchemaList = new ArrayList<Map<String, Object>>(viewSchemaMap.size());
        HashMap<String, Object> dataMap = null;
        for (DynamicObject viewSchemaObj : viewSchemaMap.values()) {
            dataMap = new HashMap<String, Object>(3);
            dataMap.put("id", viewSchemaObj.get("id"));
            dataMap.put(NUMBER, viewSchemaObj.get(NUMBER));
            dataMap.put("name", viewSchemaObj.get("name"));
            viewSchemaList.add(dataMap);
        }
        return viewSchemaList;
    }

    public static Map<Long, Long> getDirectSuperiorOrg(String viewSchemaNumber, List<Long> orgIds) {
        return OrgUnitServiceHelper.getOrgService().getDirectSuperiorOrg(viewSchemaNumber, orgIds);
    }

    public static OrgApiResult disableDuty(List<OrgParam> orgParamList) {
        return OrgUnitServiceHelper.getOrgService().disableDuty(orgParamList);
    }

    public static OrgApiResult enableDuty(List<OrgParam> orgParamList) {
        return OrgUnitServiceHelper.getOrgService().enableDuty(orgParamList);
    }

    public static OrgApiResult batchSyncHRViewSchemaAndOrg(ViewSchemaParam viewSchemaParam, List<OrgParam> orgParamList) {
        return OrgUnitServiceHelper.getOrgService().batchSyncHRViewSchemaAndOrg(viewSchemaParam, orgParamList);
    }

    public static OrgApiResult batchSyncHROrg(List<OrgParam> orgParamList) {
        return OrgUnitServiceHelper.getOrgService().batchSyncHROrg(orgParamList);
    }

    public static long getParentIdBySelfOrOrgUnitView(long srcParentId, long viewId) {
        return OrgUnitServiceHelper.getOrgService().getParentIdBySelfOrOrgUnitView(srcParentId, viewId);
    }

    public static long getParentIdBySelfOrOrgUnitView(long srcParentId, String viewNumber) {
        return OrgUnitServiceHelper.getOrgService().getParentIdBySelfOrOrgUnitView(srcParentId, viewNumber);
    }

    public static String getOrgTreeNodeFormat() {
        return OrgUnitServiceHelper.getOrgService().getOrgTreeNodeFormat();
    }

    public static String formatOrgTreeNodeName(String number, String name) {
        return OrgUnitServiceHelper.getOrgService().formatOrgTreeNodeName(number, name);
    }

    public static String formatOrgTreeNodeName(String number, String name, String format) {
        return OrgUnitServiceHelper.getOrgService().formatOrgTreeNodeName(number, name, format);
    }

    public static List<Map<String, Object>> getCorporateOrg(boolean includeDisable) {
        return OrgUnitServiceHelper.getOrgService().getCorporateOrg(includeDisable);
    }

    public static void listViewLazyLoadTreeSearch(Map<String, Object> param) {
        OrgUnitServiceHelper.getOrgService().listViewLazyLoadTreeSearch(param);
    }

    public static void formViewLazyLoadTreeSearch(Map<String, Object> param) {
        OrgUnitServiceHelper.getOrgService().formViewLazyLoadTreeSearch(param);
    }

    public static int getCorporateLimitCountOfGalaxy() {
        return OrgUnitServiceHelper.getOrgService().getCorporateLimitCountOfGalaxy();
    }

    public static boolean isGalaxyUltimate() {
        return 2 == OrgUnitServiceHelper.getOrgmanageMode();
    }

    public static Map<Long, Map<String, Object>> getCompanyOfOrg(Object viewIDOrNumber, Collection orgIds) {
        return OrgUnitServiceHelper.getOrgService().getCompanyOfOrg(viewIDOrNumber, orgIds);
    }

    public static Map<Long, Map<String, Object>> getOrgByPattern(Object viewIDOrNumber, Collection orgIds, boolean isByPatternType, List<Object> patternOrPatternTypes) {
        return OrgUnitServiceHelper.getOrgService().getOrgByPattern(viewIDOrNumber, orgIds, isByPatternType, patternOrPatternTypes);
    }

    public static OrgSeparation getOrgSeparation() {
        return OrgUnitServiceHelper.getOrgService().getOrgSeparation();
    }

    public static Map<Long, Set<Long>> getAdminOrgRelationMap(List<Long> orgIds, boolean isReturnAdminOrg) {
        return OrgUnitServiceHelper.getOrgService().getAdminOrgRelationMap(orgIds, isReturnAdminOrg);
    }

    public static Map<Long, Map<String, Object>> getAccountingBizUnit(long viewId, List<Long> orgIds, boolean isBizUnit, boolean isSearchUpward) {
        return OrgUnitServiceHelper.getOrgService().getAccountingBizUnit(viewId, orgIds, isBizUnit, isSearchUpward);
    }

    public static Map<Long, Long> getHandoverOrgIds(long bizId, List<Long> orgIds) {
        return OrgUnitServiceHelper.getOrgService().getHandoverOrgIds(bizId, orgIds);
    }

    public static Map<Long, Long> getHandoverOrgIds(String bizNumber, List<Long> orgIds) {
        return OrgUnitServiceHelper.getOrgService().getHandoverOrgIds(bizNumber, orgIds);
    }

    public static Map<Object, DynamicObject> getBiz(BizViewQueryParam bizViewQueryParam) {
        return OrgUnitServiceHelper.getOrgService().getBiz(bizViewQueryParam);
    }

    public static Map<Object, DynamicObject> getView(BizViewQueryParam bizViewQueryParam) {
        return OrgUnitServiceHelper.getOrgService().getView(bizViewQueryParam);
    }
}

