/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.org;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewType;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgViewServiceHelper {
    public static final String EntityID_Bos_Org_Biz = "bos_org_biz";
    public static final String entityID_org_viewschema = "bos_org_viewschema";
    public static final String EntityID_Org_structure = "bos_org_structure";
    public static final String EntityID_Bos_User = "bos_user";
    public static final String EntityID_Bos_Org = "bos_org";
    public static final String orgView_entityID = "bos_orgviewdata";
    public static final String orgView_comID = "cmborgtypelst";
    public static final String orgBiz_entityID = "bos_org_biz";
    private static final String VIRTIUAL_ROOT_ID = "9999999999999";
    public static final long ROOT_ORG_ID = 100000L;

    public static List<Long> getOVSubordinateOrgs(long ovType, Long orgId) {
        ArrayList<Long> orgLsts = new ArrayList<Long>();
        ORM ormOV = ORM.create();
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter f2 = new QFilter("view", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent.id", "=", (Object)orgId);
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), EntityID_Org_structure, "org.id", new QFilter[]{freezeFilter, f2, f3});){
            for (Row row : ds) {
                if (row.getLong("org.id") == null) continue;
                orgLsts.add(row.getLong("org.id"));
            }
        }
        return orgLsts;
    }

    public static List<Long> getOVSubordinateOrgs(String ovType, Long orgId) {
        ArrayList<Long> orgLsts = new ArrayList<Long>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent.id", "=", (Object)orgId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        try (DataSet ds = ormOV.queryDataSet(OrgServiceHelper.class.getName(), EntityID_Org_structure, "org.id", new QFilter[]{f1, f2, f3, freezeFilter});){
            for (Row row : ds) {
                if (row.getLong("org.id") == null) continue;
                orgLsts.add(row.getLong("org.id"));
            }
        }
        return orgLsts;
    }

    @Deprecated
    public static boolean existsChildOrg(long iorgViewID, long iOrgID) {
        return false;
    }

    @Deprecated
    public static boolean existsChildOrg(DynamicObjectCollection orgViewEntry, long iOrgID) {
        boolean bExistsChildOrg = false;
        return bExistsChildOrg;
    }

    public static boolean existsChildOrg(List<DynamicObject> orgLstView, long iOrgID) {
        boolean bExistsChildOrg = false;
        if (orgLstView == null) {
            return bExistsChildOrg;
        }
        for (DynamicObject doEntry : orgLstView) {
            DynamicObject doParentOrg = doEntry.getDynamicObject("parent");
            if (doParentOrg == null) continue;
            long iParentOrgID = 0L;
            if (doParentOrg.get("id") != null) {
                iParentOrgID = Long.parseLong(doParentOrg.get("id").toString());
            }
            if (iOrgID != iParentOrgID) continue;
            bExistsChildOrg = true;
            break;
        }
        return bExistsChildOrg;
    }

    public static List<Map<String, String>> getOrgChildrenTreeData(long ovType, long parentid) {
        ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>();
        ORM ormOV = ORM.create();
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter f2 = new QFilter("view", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent", "=", (Object)parentid);
        try (DataSet ds = ormOV.queryDataSet(OrgViewServiceHelper.class.getName(), EntityID_Org_structure, "org.id,org.name,org.number,org.fcomment,parent.id,isleaf", new QFilter[]{f2, f3, freezeFilter}, "org.number asc");){
            for (Row row : ds) {
                if (row.get("org.id") == null || row.get("org.id") != null && kd.bos.orm.util.StringUtils.isEmpty((Object)row.getString("org.id"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.get("org.id") == null ? "0" : row.getString("org.id"));
                map.put("name", row.get("org.name") == null ? "" : row.getString("org.name"));
                map.put("number", row.get("org.number") == null ? "" : row.getString("org.number"));
                map.put("comment", row.get("org.fcomment") == null ? "" : row.getString("org.fcomment"));
                map.put("parentid", row.get("parent.id") == null ? "0" : row.getString("parent.id"));
                if (row.get("isleaf") == null) {
                    map.put("isleaf", "1");
                } else {
                    map.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                }
                orgTreeData.add(map);
            }
        }
        return orgTreeData;
    }

    public static List<Map<String, String>> getOrgChildrenTreeData(String ovType, long parentid) {
        ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter f2 = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent", "=", (Object)parentid);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        try (DataSet ds = ormOV.queryDataSet(OrgViewServiceHelper.class.getName(), EntityID_Org_structure, "org.id,org.name,org.number,org.fcomment,parent.id,isleaf", new QFilter[]{f1, f2, f3, freezeFilter}, "org.number asc");){
            for (Row row : ds) {
                if (row.get("org.id") == null || row.get("org.id") != null && kd.bos.orm.util.StringUtils.isEmpty((Object)row.getString("org.id"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.get("org.id") == null ? "0" : row.getString("org.id"));
                map.put("name", row.get("org.name") == null ? "" : row.getString("org.name"));
                map.put("number", row.get("org.number") == null ? "" : row.getString("org.number"));
                map.put("comment", row.get("org.fcomment") == null ? "" : row.getString("org.fcomment"));
                map.put("parentid", row.get("parent.id") == null ? "0" : row.getString("parent.id"));
                if (row.get("isleaf") == null) {
                    map.put("isleaf", "1");
                } else {
                    map.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                }
                orgTreeData.add(map);
            }
        }
        return orgTreeData;
    }

    public static List<Map<String, String>> getOrgChildrenTreeData(long ovType, long iOrgViewId, long parentid) {
        ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("id", "=", (Object)iOrgViewId);
        QFilter f2 = new QFilter("view", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent", "=", (Object)parentid);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        try (DataSet ds = ormOV.queryDataSet(OrgViewServiceHelper.class.getName(), EntityID_Org_structure, "org.id,org.name,org.number,org.fcomment,parent.id,isleaf", new QFilter[]{f1, f2, f3, freezeFilter}, "org.number asc");){
            for (Row row : ds) {
                if (row.get("org.id") == null || row.get("org.id") != null && kd.bos.orm.util.StringUtils.isEmpty((Object)row.getString("org.id"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.get("org.id") == null ? "0" : row.getString("org.id"));
                map.put("name", row.get("org.name") == null ? "" : row.getString("org.name"));
                map.put("number", row.get("org.number") == null ? "" : row.getString("org.number"));
                map.put("comment", row.get("org.fcomment") == null ? "" : row.getString("org.fcomment"));
                map.put("parentid", row.get("parent.id") == null ? "0" : row.getString("parent.id"));
                if (row.get("isleaf") == null) {
                    map.put("isleaf", "1");
                } else {
                    map.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                }
                orgTreeData.add(map);
            }
        }
        return orgTreeData;
    }

    public static List<Map<String, String>> getOrgChildrenTreeData(String ovType, long iOrgViewId, long parentid) {
        ArrayList<Map<String, String>> orgTreeData = new ArrayList<Map<String, String>>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent", "=", (Object)parentid);
        try (DataSet ds = ormOV.queryDataSet(OrgViewServiceHelper.class.getName(), EntityID_Org_structure, "org.id,org.name,org.number,org.fcomment,parent.id,isleaf", new QFilter[]{f1, f2, f3}, "org.number asc");){
            for (Row row : ds) {
                if (row.get("org.id") == null || row.get("org.id") != null && kd.bos.orm.util.StringUtils.isEmpty((Object)row.getString("org.id"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.get("org.id") == null ? "0" : row.getString("org.id"));
                map.put("name", row.get("org.name") == null ? "" : row.getString("org.name"));
                map.put("number", row.get("org.number") == null ? "" : row.getString("org.number"));
                map.put("comment", row.get("org.fcomment") == null ? "" : row.getString("org.fcomment"));
                map.put("parentid", row.get("parent.id") == null ? "0" : row.getString("parent.id"));
                if (row.get("isleaf") == null) {
                    map.put("isleaf", "1");
                } else {
                    map.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                }
                orgTreeData.add(map);
            }
        }
        return orgTreeData;
    }

    public static List<Long> getChildOrgId(long ovType, long parentid, boolean includeParentSelf) {
        ArrayList<Long> childOrgs = new ArrayList<Long>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter fovType = new QFilter("view", "=", (Object)ovType);
        QFilter fparentId = new QFilter("parent", "=", (Object)parentid);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        if (includeParentSelf) {
            fparentId.or(new QFilter("org", "=", (Object)parentid));
        }
        try (DataSet ds = ormOV.queryDataSet("kd.bos.org", EntityID_Org_structure, "org.id", new QFilter[]{fovType, fparentId, freezeFilter});){
            for (Row row : ds) {
                childOrgs.add(row.getLong("org.id"));
            }
        }
        return childOrgs;
    }

    public static List<Long> getChildOrgId(String ovType, long parentid, boolean includeParentSelf) {
        ArrayList<Long> childOrgs = new ArrayList<Long>();
        ORM ormOV = ORM.create();
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter fovType = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter fisdefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter fparentId = new QFilter("parent", "=", (Object)parentid);
        if (includeParentSelf) {
            fparentId.or(new QFilter("org", "=", (Object)parentid));
        }
        try (DataSet ds = ormOV.queryDataSet("kd.bos.org", EntityID_Org_structure, "org.id", new QFilter[]{fovType, fparentId, freezeFilter, fisdefault});){
            for (Row row : ds) {
                childOrgs.add(row.getLong("org.id"));
            }
        }
        return childOrgs;
    }

    public static List<Long> getChildOrgId(String ovType, long iOrgViewId, long parentid, boolean includeParentSelf) {
        ArrayList<Long> childOrgs = new ArrayList<Long>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("id", "=", (Object)iOrgViewId);
        QFilter f2 = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter f3 = new QFilter("parent", "=", (Object)parentid);
        if (includeParentSelf) {
            f3 = f3.or(new QFilter("org", "=", (Object)parentid));
        }
        try (DataSet ds = ormOV.queryDataSet(OrgViewServiceHelper.class.getName(), EntityID_Org_structure, "org.id", new QFilter[]{f1, f2, f3}, "org.number");){
            for (Row row : ds) {
                if (row.get("org.id") == null) continue;
                childOrgs.add(Long.parseLong(row.get("org.id").toString()));
            }
        }
        return childOrgs;
    }

    public static List<Map<String, String>> getOrgViewByFilter(QFilter[] filters) {
        ORM orm = ORM.create();
        DynamicObjectCollection dcs = orm.query(EntityID_Org_structure, "id,org.id,org.name,org.number,parent.id,isleaf,longnumber,level,isctrlunit", filters, "sortcode,longnumber");
        ArrayList<Map<String, String>> rootNodeList = new ArrayList<Map<String, String>>();
        for (DynamicObject dyO : dcs) {
            HashMap<String, String> mtree = new HashMap<String, String>();
            mtree.put("id", String.valueOf(dyO.getLong("org.id")));
            mtree.put("org", String.valueOf(dyO.getLong("org.id")));
            mtree.put("name", dyO.getString("org.name"));
            mtree.put("number", dyO.getString("org.number"));
            mtree.put("parentid", String.valueOf(dyO.getLong("parent.id")));
            mtree.put("isleaf", dyO.getBoolean("isleaf") ? "1" : "0");
            mtree.put("longnumber", dyO.getString("longnumber"));
            mtree.put("level", dyO.getString("level"));
            mtree.put("isctrlunit", dyO.getBoolean("isctrlunit") ? "1" : "0");
            rootNodeList.add(mtree);
        }
        return rootNodeList;
    }

    public static List<Map<String, String>> getOrgStructureByFilter(QFilter[] filters) {
        ArrayList<Map<String, String>> rootNodeList = new ArrayList<Map<String, String>>();
        String selectFields = "id,org.number number,org.name name,org,parent,isleaf,longnumber";
        DynamicObjectCollection orgCol = QueryServiceHelper.query(EntityID_Org_structure, selectFields, filters, "sortcode");
        if (orgCol == null || orgCol.size() == 0) {
            return rootNodeList;
        }
        for (DynamicObject org : orgCol) {
            HashMap<String, String> mtree = new HashMap<String, String>();
            mtree.put("id", org.getString("id"));
            mtree.put("orgId", org.getString("org"));
            mtree.put("name", org.getString("name"));
            mtree.put("number", org.getString("number"));
            mtree.put("parentId", org.getString("parent"));
            mtree.put("isleaf", org.getBoolean("isleaf") ? "1" : "0");
            mtree.put("longNumber", org.getString("longnumber"));
            rootNodeList.add(mtree);
        }
        return rootNodeList;
    }

    public static boolean existsSubOrg(long viewId, long orgId) {
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter parentFilter = new QFilter("parent", "=", (Object)orgId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, freezeFilter};
        return QueryServiceHelper.exists(EntityID_Org_structure, filters);
    }

    public static boolean existsSubOrg(String viewType, long orgId) {
        QFilter viewFilter = new QFilter("view.treetype", "=", (Object)viewType);
        QFilter parentFilter = new QFilter("parent", "=", (Object)orgId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        QFilter filterIsDefault = new QFilter("view.isdefault", "=", (Object)"1");
        freezeFilter.or(freezeFilter1);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, freezeFilter, filterIsDefault};
        return QueryServiceHelper.exists(EntityID_Org_structure, filters);
    }

    public static boolean existsSubOrg(long viewId, List<Long> orgIds) {
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        QFilter parentFilter = new QFilter("parent", "in", orgIds);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, freezeFilter};
        return QueryServiceHelper.exists(EntityID_Org_structure, filters);
    }

    public static List<Map<String, Object>> getBizDataByID(long bizID) {
        ORM orm = ORM.create();
        QFilter[] filters = null;
        QFilter filter = new QFilter("fuserdefine", "=", (Object)"0");
        if (bizID < 0L) {
            filters = new QFilter[]{filter};
        } else {
            QFilter filterID = new QFilter("id", "=", (Object)bizID);
            filters = new QFilter[]{filter, filterID};
        }
        Map<Object, DynamicObject> orgBizMap = BusinessDataServiceHelper.loadFromCache("bos_org_biz", "id,fnumber,fname", filters);
        ArrayList<Map<String, Object>> listOrgBiz = new ArrayList<Map<String, Object>>(orgBizMap.size());
        for (DynamicObject orgBiz : orgBizMap.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", orgBiz.get("id"));
            map.put("number", orgBiz.get("fnumber").toString());
            map.put("name", orgBiz.get("fname").toString());
            listOrgBiz.add(map);
        }
        return listOrgBiz;
    }

    public static long getViewIDByNumber(String number) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter filter1 = new QFilter("view.treetype", "=", (Object)number);
        QFilter[] filters = new QFilter[]{filter, filter1};
        DynamicObject dyOrg = orm.queryOne(EntityID_Org_structure, "id", filters);
        long id = 0L;
        if (dyOrg != null) {
            id = Long.parseLong(dyOrg.get("id").toString());
        }
        return id;
    }

    @Deprecated
    public static List<Integer> getChildOrgId(OrgViewType ovType, int iOrgViewId, int parentid, boolean includeParentSelf) {
        ArrayList<Integer> childOrgs = new ArrayList<Integer>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("id", "=", (Object)Long.parseLong(Integer.toString(iOrgViewId)));
        QFilter f2 = new QFilter("view.treetype", "=", (Object)"01");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter.or(freezeFilter1);
        QFilter f3 = new QFilter("parent", "=", (Object)Long.parseLong(Integer.toString(parentid)));
        if (includeParentSelf) {
            f3.or(new QFilter("org", "=", (Object)Long.parseLong(Integer.toString(parentid))));
        }
        try (DataSet ds = ormOV.queryDataSet("kd.bos.org", EntityID_Org_structure, "org.id", new QFilter[]{f1, f2, f3, freezeFilter});){
            for (Row row : ds) {
                childOrgs.add(row.getInteger("org.id"));
            }
        }
        return childOrgs;
    }

    public static QFilter getBillListFilter(long ovType, long iOrgViewId, long parentid, boolean includeParentSelf, boolean includeChild) {
        QFilter filter = null;
        List<Long> lstChildOrgs = null;
        if (includeChild) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(parentid);
            lstChildOrgs = OrgServiceHelper.getAllSubordinateOrgs(ovType, orgIds, includeParentSelf);
        } else {
            lstChildOrgs = OrgViewServiceHelper.getChildOrgId(ovType, parentid, includeParentSelf);
        }
        if (lstChildOrgs != null && lstChildOrgs.size() > 0) {
            QFilter filterTree = new QFilter("id", "in", lstChildOrgs);
            filter = QFilter.and(filter, (QFilter)filterTree);
        }
        return filter;
    }

    public static QFilter getBillListFilter(String ovType, long iOrgViewId, long parentid, boolean includeParentSelf, boolean includeChild) {
        QFilter filter = null;
        List<Long> lstChildOrgs = null;
        if (includeChild) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(parentid);
            lstChildOrgs = OrgServiceHelper.getAllSubordinateOrgs(ovType, orgIds, includeParentSelf);
        } else {
            lstChildOrgs = OrgViewServiceHelper.getChildOrgId(ovType, iOrgViewId, parentid, includeParentSelf);
        }
        if (lstChildOrgs != null && lstChildOrgs.size() > 0) {
            QFilter filterTree = new QFilter("id", "in", lstChildOrgs);
            filter = QFilter.and(filter, (QFilter)filterTree);
        }
        return filter;
    }

    public static List<Map<String, String>> getAllPermissionOrgs(MainEntityType dataEntityType, long orgViewTypeID, boolean isOrgBaseAdmin) {
        ArrayList<Map<String, String>> treeList = new ArrayList();
        treeList = OrgViewServiceHelper.getAllPermissionOrgs(dataEntityType.getName(), orgViewTypeID, isOrgBaseAdmin, false);
        return treeList;
    }

    public static List<Map<String, String>> getAllPermissionOrgs(String formId, long orgViewTypeID, boolean isOrgBaseAdmin) {
        ArrayList<Map<String, String>> treeList = new ArrayList();
        treeList = OrgViewServiceHelper.getAllPermissionOrgs(formId, orgViewTypeID, isOrgBaseAdmin, false);
        return treeList;
    }

    public static List<Map<String, String>> getAllPermissionOrgs(MainEntityType dataEntityType, String orgViewType) {
        return OrgViewServiceHelper.getAllPermissionOrgs(dataEntityType.getName(), orgViewType);
    }

    public static List<Map<String, String>> getAllPermissionOrgs(String formId, String orgViewType) {
        RequestContext requestContext = RequestContext.get();
        long userID = Long.parseLong(requestContext.getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs(userID, null, formId, "47150e89000000ac");
        QFilter filterTreetype = new QFilter("view.treetype", "=", (Object)orgViewType);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter filterOrg = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreetype = filterTreetype.and(filterOrg);
        }
        QFilter filterIsdefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = new QFilter[]{filterTreetype, filterIsdefault, freezeFilter};
        return OrgViewServiceHelper.rebuildPermissionOrgTree(filterOrgs);
    }

    public static List<Map<String, String>> getAllPermissionOrgs(String orgViewID, MainEntityType mainEntityType) {
        RequestContext requestContext = RequestContext.get();
        long userID = Long.parseLong(requestContext.getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs(userID, null, mainEntityType.toString(), "47150e89000000ac");
        QFilter filterTreetype = new QFilter("view.treetype", "=", (Object)orgViewID);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter filterOrg = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreetype = filterTreetype.and(filterOrg);
        }
        QFilter filterIsdefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter[] filterOrgs = new QFilter[]{filterTreetype, filterIsdefault};
        return OrgViewServiceHelper.rebuildPermissionOrgTree(filterOrgs);
    }

    public static List<Map<String, String>> getAllPermissionOrgs(MainEntityType dataEntityType, long orgViewTypeID, boolean isOrgBaseAdmin, boolean isOnlyDisplayLeaves) {
        return OrgViewServiceHelper.getAllPermissionOrgs(dataEntityType.getName(), orgViewTypeID, isOrgBaseAdmin, isOnlyDisplayLeaves);
    }

    public static List<Map<String, String>> getAllPermissionOrgs(String formId, long orgViewTypeID, boolean isOrgBaseAdmin, boolean isOnlyDisplayLeaves) {
        QFilter[] filters = OrgViewServiceHelper.genAllPermissionOrgFilter(formId, orgViewTypeID, isOrgBaseAdmin, isOnlyDisplayLeaves);
        return OrgViewServiceHelper.rebuildPermissionOrgTree(filters);
    }

    private static List<Map<String, String>> rebuildPermissionOrgTree(QFilter[] filters) {
        Map<String, String> org;
        if (filters == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        DynamicObjectCollection orgCol = QueryServiceHelper.query(EntityID_Org_structure, "id, org.id org, org.number number,org.name name,longnumber,parent", filters, "level");
        if (Utils.isListEmpty((List)orgCol)) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>();
        HashMap<String, Map<String, String>> orgLongToOrg = new HashMap<String, Map<String, String>>();
        ArrayList<String> rootList = new ArrayList<String>();
        HashSet<String> hasChildList = new HashSet<String>();
        String longNumberSep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        for (DynamicObject orgView : orgCol) {
            String longnumber = orgView.getString("longnumber");
            org = new HashMap<String, String>();
            org.put("id", orgView.getString("org"));
            org.put("number", orgView.getString("number"));
            org.put("name", orgView.getString("name"));
            org.put("longnumber", longnumber);
            org.put("parentId", orgView.getString("parent"));
            org.put("isleaf", "1");
            if (rootOrgId == orgView.getLong("org")) {
                rootList.add(longnumber);
            } else {
                String parentLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)longNumberSep);
                Map parent = (Map)orgLongToOrg.get(parentLongnumber);
                if (parent == null) {
                    rootList.add(longnumber);
                } else {
                    parent.put("isleaf", "0");
                    hasChildList.add(parentLongnumber);
                }
            }
            treeList.add(org);
            orgLongToOrg.put(longnumber, org);
        }
        if (rootList.size() > 1) {
            HashMap<String, String> orgRoot = new HashMap<String, String>();
            orgRoot.put("id", VIRTIUAL_ROOT_ID);
            orgRoot.put("number", "0");
            orgRoot.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgViewServiceHelper_0", (String)"bos-servicehelper", (Object[])new Object[0]));
            orgRoot.put("longnumber", "0");
            orgRoot.put("parentId", "0");
            orgRoot.put("isleaf", "0");
            treeList.add(orgRoot);
            for (String longnumber : rootList) {
                org = (Map)orgLongToOrg.get(longnumber);
                if (org == null) continue;
                org.put("parentId", VIRTIUAL_ROOT_ID);
                if (hasChildList.contains(longnumber)) {
                    org.put("isleaf", "0");
                    continue;
                }
                org.put("isleaf", "1");
            }
        }
        return treeList;
    }

    private static QFilter[] genAllPermissionOrgFilter(String formId, long orgViewTypeID, boolean isOrgBaseAdmin, boolean isOnlyDisplayLeaves) {
        QFilter filterTreetype = new QFilter("view", "=", (Object)orgViewTypeID);
        RequestContext requestContext = RequestContext.get();
        long userID = Long.parseLong(requestContext.getUserId());
        boolean hasBindingFunctionPerm = true;
        if (isOrgBaseAdmin) {
            List<Long> list = PermissionServiceHelper.getAdminChargeOrgs(userID);
            if (Utils.isListEmpty(list)) {
                return null;
            }
            filterTreetype = filterTreetype.and(new QFilter("org", "in", list));
        } else {
            HasPermOrgResult hasPermOrgResult;
            hasBindingFunctionPerm = PermissionServiceHelper.hasBindingFunctionPerm(formId);
            if (hasBindingFunctionPerm && !(hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs(userID, null, formId, "47150e89000000ac")).hasAllOrgPerm()) {
                List list = hasPermOrgResult.getHasPermOrgs();
                if (Utils.isListEmpty((List)list)) {
                    return null;
                }
                filterTreetype = filterTreetype.and(new QFilter("org", "in", (Object)list));
            }
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        QFilter filterIsOnlyLeaves = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = null;
        filterOrgs = isOnlyDisplayLeaves ? new QFilter[]{filterTreetype, freezeFilter, filterIsOnlyLeaves} : new QFilter[]{filterTreetype, freezeFilter};
        return filterOrgs;
    }

    public static List<String> getOpenIdByUserId(List<Long> lstUserId) {
        ArrayList<String> lstOpenId = new ArrayList<String>();
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter("id", "in", lstUserId);
        DynamicObject[] ds = BusinessDataServiceHelper.load(EntityID_Bos_User, "useropenid", new QFilter[]{f1}, null);
        if (ds == null || ds.length == 0) {
            return lstOpenId;
        }
        for (int i = 0; i < ds.length; ++i) {
            if (ds[i].get("useropenid") == null) continue;
            lstOpenId.add(ds[i].getString("useropenid"));
        }
        return lstOpenId;
    }

    public static Boolean isBizUnit(String orgFunction, Long orgId) {
        boolean isBizUnit = false;
        String selectFields = "id, isstatsum,isbizunit";
        QFilter viewFilter = new QFilter("view.treetype", "=", (Object)orgFunction);
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{viewFilter, isDefaultViewFilter, orgFilter};
        DynamicObjectCollection orgCollection = QueryServiceHelper.query(EntityID_Org_structure, selectFields, filters);
        if (orgCollection != null && orgCollection.size() == 1) {
            isBizUnit = ((DynamicObject)orgCollection.get(0)).getBoolean("isbizunit");
        }
        return isBizUnit;
    }

    public static boolean isSubOrg(String orgFunction, Long subOrgID, Long superiorOrgID) {
        boolean isSubOrg = false;
        String subOrgLongNumber = null;
        String superiorOrgLongNumber = null;
        String selectFields = "id, org.id orgId, longnumber";
        QFilter viewFilter = new QFilter("view.treetype", "=", (Object)orgFunction);
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)"1");
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        orgIdList.add(subOrgID);
        orgIdList.add(superiorOrgID);
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter[] filters = new QFilter[]{viewFilter, isDefaultViewFilter, orgFilter};
        DynamicObjectCollection orgCollection = QueryServiceHelper.query(EntityID_Org_structure, selectFields, filters);
        if (orgCollection == null || orgCollection.size() != 2) {
            return isSubOrg;
        }
        if (subOrgID.equals(((DynamicObject)orgCollection.get(0)).getLong("orgId"))) {
            subOrgLongNumber = ((DynamicObject)orgCollection.get(0)).getString("longnumber");
            superiorOrgLongNumber = ((DynamicObject)orgCollection.get(1)).getString("longnumber");
        } else {
            subOrgLongNumber = ((DynamicObject)orgCollection.get(1)).getString("longnumber");
            superiorOrgLongNumber = ((DynamicObject)orgCollection.get(0)).getString("longnumber");
        }
        if (kd.bos.orm.util.StringUtils.isEmpty((Object)subOrgLongNumber) || kd.bos.orm.util.StringUtils.isEmpty((Object)superiorOrgLongNumber)) {
            return isSubOrg;
        }
        if (subOrgLongNumber.startsWith(superiorOrgLongNumber + '!')) {
            isSubOrg = true;
        }
        return isSubOrg;
    }

    public static boolean isOrgBelongTo(String orgFunction, Long subOrgId, Long superOrgId) {
        boolean isOrgBelongTo = false;
        isOrgBelongTo = OrgViewServiceHelper.isSubOrg(orgFunction, subOrgId, superOrgId);
        return isOrgBelongTo;
    }

    public static boolean isOrgInclude(String orgFunction, Long superOrgId, Long subOrgId) {
        boolean isOrgBelongTo = false;
        isOrgBelongTo = OrgViewServiceHelper.isSubOrg(orgFunction, subOrgId, superOrgId);
        return isOrgBelongTo;
    }

    public static List<Long> getOrgSubMainDataList(Long curOrgId, Long projectId, boolean IsIncludeAllSub) {
        ArrayList<Long> orgLst = new ArrayList<Long>();
        return orgLst;
    }

    @Deprecated
    public static List<Map<String, Object>> getAllChildrenData(String parentid, String treetype) {
        ORM orm = ORM.create();
        String selFields1 = "id,org.id,longnumber";
        QFilter fftreetype1 = new QFilter("view.treetype", "=", (Object)treetype);
        fftreetype1 = fftreetype1.and(new QFilter("view.isdefault", "=", (Object)Boolean.TRUE));
        QFilter ffparentid1 = new QFilter("org.id", "=", (Object)Long.valueOf(parentid));
        QFilter[] filters1 = new QFilter[]{fftreetype1, ffparentid1};
        DynamicObjectCollection dcs = orm.query(EntityID_Org_structure, selFields1, filters1);
        String longNumber = null;
        for (DynamicObject dyO : dcs) {
            longNumber = dyO.getString("longnumber");
        }
        String selFields2 = "id,org,org.id,parent,parent.id,isleaf,org.number,org.name,longnumber";
        QFilter fftreetype2 = new QFilter("view.treetype", "=", (Object)treetype);
        fftreetype2 = fftreetype2.and(new QFilter("view.isdefault", "=", (Object)Boolean.TRUE));
        QFilter flongnumber = new QFilter("longnumber", "like", (Object)(longNumber + '!' + '%'));
        QFilter fOrgId = new QFilter("org.id", "!=", (Object)Long.valueOf(parentid));
        QFilter[] filters2 = new QFilter[]{fftreetype2, flongnumber, fOrgId};
        DynamicObjectCollection dcOrgChildrens = orm.query(EntityID_Org_structure, selFields2, filters2);
        ArrayList<Map<String, Object>> rootNodeList = new ArrayList<Map<String, Object>>();
        for (DynamicObject dyO : dcOrgChildrens) {
            HashMap<String, Object> mtree = new HashMap<String, Object>();
            mtree.put("id", dyO.getLong("org.id"));
            mtree.put("name", dyO.getString("org.name"));
            mtree.put("number", dyO.getString("org.number"));
            mtree.put("parentid", dyO.getLong("parent.id"));
            mtree.put("isleaf", Character.valueOf(dyO.getBoolean("isleaf") ? (char)'1' : '0'));
            mtree.put("longnumber", dyO.getString("longnumber"));
            rootNodeList.add(mtree);
        }
        return rootNodeList;
    }

    public static boolean isBelongDirectOrgView(long orgId, String treeType) {
        QFilter filterBiz = null;
        switch (treeType) {
            case "02": {
                filterBiz = new QFilter("fispurchase", "=", (Object)"1");
                break;
            }
            case "03": {
                filterBiz = new QFilter("fissale", "=", (Object)"1");
                break;
            }
            case "04": {
                filterBiz = new QFilter("fisproduce", "=", (Object)"1");
                break;
            }
            case "05": {
                filterBiz = new QFilter("fisinventory", "=", (Object)"1");
                break;
            }
            case "06": {
                filterBiz = new QFilter("fisqc", "=", (Object)"1");
                break;
            }
            case "07": {
                filterBiz = new QFilter("fissettlement", "=", (Object)"1");
                break;
            }
            case "08": {
                filterBiz = new QFilter("fisbankroll", "=", (Object)"1");
                break;
            }
            case "09": {
                filterBiz = new QFilter("fisasset", "=", (Object)"1");
                break;
            }
            case "10": {
                filterBiz = new QFilter("fisaccounting", "=", (Object)"1");
                break;
            }
            case "11": {
                filterBiz = new QFilter("fishr", "=", (Object)"1");
                break;
            }
            case "12": {
                filterBiz = new QFilter("fisscc", "=", (Object)"1");
                break;
            }
            case "13": {
                filterBiz = new QFilter("fisbudget", "=", (Object)"1");
                break;
            }
            case "01": {
                filterBiz = new QFilter("fisadministrative", "=", (Object)"1");
                break;
            }
            case "14": {
                filterBiz = new QFilter("fiscontrolunit", "=", (Object)"1");
                break;
            }
        }
        if (filterBiz == null) {
            return false;
        }
        QFilter filterOrg = new QFilter("id", "=", (Object)orgId);
        ORM ormOV = ORM.create();
        DynamicObject ds = ormOV.queryOne(EntityID_Bos_Org, "id", new QFilter[]{filterOrg, filterBiz});
        return ds != null;
    }

    public static List<DynamicObject> getOrgUnitInfo(long orgId, String viewType) {
        ORM orm = ORM.create();
        String selFields = "id,org,org.id,parent,parent.id,isleaf,org.number,org.name,longnumber";
        QFilter fftreetypefilter = new QFilter("view.treetype", "=", (Object)viewType);
        QFilter fIsDefault = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter fpidfilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters2 = new QFilter[]{fftreetypefilter, fpidfilter, fIsDefault};
        return orm.query(EntityID_Org_structure, selFields, filters2);
    }

    public static boolean isOrgDisabled(long orgId, Long viewType) {
        boolean Disabled = true;
        ORM orm = ORM.create();
        QFilter fftreetypefilter = new QFilter("view", "=", (Object)viewType);
        QFilter fIsEnable = new QFilter("org.enable", "=", (Object)"1");
        QFilter fpidfilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters2 = new QFilter[]{fftreetypefilter, fpidfilter, fIsEnable};
        DynamicObject dyOrg = orm.queryOne(EntityID_Org_structure, "id", filters2);
        if (dyOrg != null) {
            Disabled = false;
        }
        return Disabled;
    }
}

