/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.portal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

@KSObject
public class MainPageCardServiceHelper {
    private static Log logger = LogFactory.getLog(MainPageCardServiceHelper.class);

    public static void updateQingCardId(Map<String, String> cardIdMap) {
        if (cardIdMap == null || cardIdMap.size() == 0) {
            return;
        }
        Set<String> olds = cardIdMap.keySet();
        String selFields = "id,cardid,config,cardtype,cardtitle,customname";
        try (TXHandle h = TX.required();){
            try {
                DynamicObject[] mainPageCardConfigs = BusinessDataServiceHelper.load("bos_mainpagecardconfig", selFields, new QFilter[]{new QFilter("cardtype", "=", (Object)"bos_card_qing")});
                if (mainPageCardConfigs != null && mainPageCardConfigs.length > 0) {
                    ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
                    for (DynamicObject dynamicObject : mainPageCardConfigs) {
                        JSONObject jsonObject;
                        String qingCardId;
                        String config = dynamicObject.getString("config");
                        if (!StringUtils.isNotEmpty((String)config) || StringUtils.isEmpty((String)(qingCardId = (jsonObject = JSON.parseObject((String)config)).getString("QingCardId"))) || !olds.contains(qingCardId)) continue;
                        String id = dynamicObject.getString("id");
                        String newQingCardId = cardIdMap.get(qingCardId);
                        jsonObject.put("QingCardId", (Object)newQingCardId);
                        config = jsonObject.toString();
                        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject("bos_mainpagecardconfig");
                        newDynamicObject.set("id", (Object)id);
                        newDynamicObject.set("config", (Object)config);
                        dynamicObjectList.add(newDynamicObject);
                    }
                    if (dynamicObjectList != null && dynamicObjectList.size() > 0) {
                        SaveServiceHelper.update(dynamicObjectList.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

