/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.runmode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.runmode.RunModeService;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class RunModeServiceHelper {
    private static final String OB_E_5_YAC_2_OJF = "0B+E5YAC2OJF";
    private static Log logger = LogFactory.getLog(RunModeServiceHelper.class);
    public static final int DEFUALT_PRODUCT_CODE = 1;
    public static final int GALAXY_PRODUCT_CODE = 2;
    public static final String CLOUD_BLACKLIST = "cloud";
    public static final String APP_BLACKLIST = "app";
    public static final String ENTITY_BLACKLIST = "entity";

    private static RunModeService getService() {
        return (RunModeService)ServiceFactory.getService(RunModeService.class);
    }

    public static boolean isGalaxyMode() {
        return RunModeServiceHelper.getRunModeCode() == 2;
    }

    public static int getRunModeCode() {
        Integer code = null;
        try {
            RunModeService service = RunModeServiceHelper.getService();
            code = service.getRunModeCode();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u7684\u8fd0\u884c\u6a21\u5f0f\u4ea7\u54c1\u7801\u6709\u8bef\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503c\uff01: ", (Throwable)e);
        }
        return code == null ? 1 : code;
    }

    private static Map<String, String> addIccToCloudBlackList(Map<String, String> map) {
        AppParam appParam = new AppParam();
        appParam.setAppId("83bfebc8000037ac");
        appParam.setViewType("15");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        appParam.setOrgId(Long.valueOf(rootOrgId));
        appParam.setActBookId(Long.valueOf(0L));
        Boolean paramFlag = Boolean.FALSE;
        Map<String, Object> paramMap = SystemParamServiceHelper.loadAppParameterFromCache(appParam);
        if (paramMap != null && paramMap.get("isyzjspecialversion") != null) {
            paramFlag = (Boolean)paramMap.get("isyzjspecialversion");
        }
        if (paramFlag.booleanValue()) {
            map.remove(OB_E_5_YAC_2_OJF);
        } else if (map == null) {
            map = new HashMap<String, String>();
            map.put(OB_E_5_YAC_2_OJF, "ICC");
        } else if (map.get(OB_E_5_YAC_2_OJF) == null) {
            map.put(OB_E_5_YAC_2_OJF, "ICC");
        }
        return map;
    }

    private static Map<String, String> getBlacklistByType(String type) {
        try {
            RunModeService service = RunModeServiceHelper.getService();
            int product = RunModeServiceHelper.getRunModeCode();
            switch (type) {
                case "cloud": {
                    return service.loadCloudBlacklist(product);
                }
                case "app": {
                    return service.loadAppBlacklist(product);
                }
                case "entity": {
                    return service.loadEntityBlacklist(product);
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u5f53\u524d\u4ea7\u54c1\u7684{%s}\u9ed1\u540d\u5355\u6709\u8bef\uff01: ", type), (Throwable)e);
        }
        return null;
    }

    private static String getItemIdFromBlacklist(String itemName, Map<String, String> map) {
        try {
            if (map == null || map.isEmpty()) {
                return null;
            }
            return RunModeServiceHelper.changeSetToSqlStr(map.keySet());
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u5f53\u524d\u4ea7\u54c1\u7684 {%s} \u9ed1\u540d\u5355\u6709\u8bef\uff01: ", itemName), (Throwable)e);
            return null;
        }
    }

    private static String getItemNumFromBlacklist(String itemName, Map<String, String> map) {
        try {
            if (map == null || map.isEmpty()) {
                return null;
            }
            return RunModeServiceHelper.changeSetToSqlStr(map.entrySet());
        }
        catch (Exception e) {
            logger.error(String.format("\u83b7\u53d6\u5f53\u524d\u4ea7\u54c1\u7684 {%s} \u9ed1\u540d\u5355\u6709\u8bef\uff01: ", itemName), (Throwable)e);
            return null;
        }
    }

    private static String changeListToSqlStr(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : list) {
            if (StringUtils.isEmpty((CharSequence)item)) continue;
            sb.append('\'').append(item).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }

    private static String changeSetToSqlStr(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : set) {
            if (item == null) continue;
            String val = null;
            if (item instanceof String) {
                val = item.toString();
            } else if (item instanceof Map.Entry) {
                Object tVal = ((Map.Entry)item).getValue();
                String string = val = tVal == null ? null : tVal.toString();
            }
            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
            sb.append('\'').append(val).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }

    public static QFilter[] addFilterToFilters(QFilter[] filters, QFilter qf) {
        try {
            if (qf == null) {
                return filters;
            }
            if (filters == null) {
                filters = new QFilter[]{qf};
            } else {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(Arrays.asList(filters));
                filterList.add(qf);
                filters = filterList.toArray(new QFilter[filterList.size()]);
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u8fd0\u884c\u6a21\u5f0f\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)e);
        }
        return filters;
    }

    public static QFilter wrapNotInFilterBy(Map blaklist, String filsterKey) {
        try {
            if (StringUtils.isEmpty((CharSequence)filsterKey) || blaklist == null || blaklist.isEmpty()) {
                return null;
            }
            return new QFilter(filsterKey, "not in", blaklist.keySet());
        }
        catch (Exception e) {
            logger.error("\u6839\u636e" + filsterKey + "\u5c01\u88c5\u8fd0\u884c\u6a21\u5f0f\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)e);
            return null;
        }
    }

    public static QFilter wrapNotInFilterBy(List blaklist, String filsterKey) {
        try {
            if (StringUtils.isEmpty((CharSequence)filsterKey) || blaklist == null || blaklist.isEmpty()) {
                return null;
            }
            return new QFilter(filsterKey, "not in", (Object)blaklist);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e" + filsterKey + "\u5c01\u88c5\u8fd0\u884c\u6a21\u5f0f\u9ed1\u540d\u5355\u5230QFilter[]\u6709\u8bef\uff01", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getAppBlacklist() {
        return RunModeServiceHelper.getBlacklistByType(APP_BLACKLIST);
    }

    public static Map<String, String> getCloudBlacklist() {
        return RunModeServiceHelper.getBlacklistByType(CLOUD_BLACKLIST);
    }

    public static Map<String, String> getAllEntityBlacklist() {
        return RunModeServiceHelper.getBlacklistByType(ENTITY_BLACKLIST);
    }

    public static QFilter[] getAppAndCloudBlacklistFilters(QFilter[] filters, String appfilterKey, String cloudfilterKey) {
        filters = RunModeServiceHelper.getAppIdBlacklistFilters(filters, appfilterKey);
        QFilter cloudAppFilter = RunModeServiceHelper.wrapNotInFilterBy(RunModeServiceHelper.getCloudBlacklist(), cloudfilterKey);
        filters = RunModeServiceHelper.addFilterToFilters(filters, cloudAppFilter);
        return filters;
    }

    public static QFilter[] getAppIdBlacklistFilters(QFilter[] filters, String filterKey) {
        QFilter qf = RunModeServiceHelper.wrapNotInFilterBy(RunModeServiceHelper.getAppBlacklist(), filterKey);
        return RunModeServiceHelper.addFilterToFilters(filters, qf);
    }

    public static String getAppIdFromBlacklist() {
        Map<String, String> appMap = RunModeServiceHelper.getAppBlacklist();
        return RunModeServiceHelper.getItemIdFromBlacklist("AppId", appMap);
    }

    public static String getAppNumFromBlacklist() {
        Map<String, String> appMap = RunModeServiceHelper.getAppBlacklist();
        return RunModeServiceHelper.getItemNumFromBlacklist("AppNum", appMap);
    }

    public static QFilter[] getCloudIdBlacklistFilters(QFilter[] filters, String filterKey) {
        QFilter qf = RunModeServiceHelper.wrapNotInFilterBy(RunModeServiceHelper.getCloudBlacklist(), filterKey);
        QFilter[] qFilters = RunModeServiceHelper.addFilterToFilters(filters, qf);
        return qFilters;
    }

    public static String getCloudIdsFromBlackList() {
        Map<String, String> map = RunModeServiceHelper.getCloudBlacklist();
        return RunModeServiceHelper.getItemIdFromBlacklist("CloudIdsFrom", map);
    }

    public static String getCloudNumFromBlackList() {
        Map<String, String> map = RunModeServiceHelper.getCloudBlacklist();
        return RunModeServiceHelper.getItemNumFromBlacklist("CloudNum", map);
    }

    public static List<String> getEntityNumFromBlacklistBy(String appNumber) {
        try {
            RunModeService service = RunModeServiceHelper.getService();
            return service.loadEntityBlacklistByAppNumber(RunModeServiceHelper.getRunModeCode(), appNumber);
        }
        catch (Exception e) {
            logger.error(String.format("\u6839\u636e\u5e94\u7528{%s}\u83b7\u53d6\u5f53\u524d\u4ea7\u54c1\u7684\u8868\u5355\u9ed1\u540d\u5355\u6709\u8bef\uff01: ", appNumber), (Throwable)e);
            return null;
        }
    }

    public static String getEntityIdFromBlacklist() {
        Map<String, String> map = RunModeServiceHelper.getAllEntityBlacklist();
        return RunModeServiceHelper.getItemIdFromBlacklist("EntityId", map);
    }

    public static String getEntityNumFromBlacklist() {
        Map<String, String> map = RunModeServiceHelper.getAllEntityBlacklist();
        return RunModeServiceHelper.getItemNumFromBlacklist("EntityNum", map);
    }

    public static String getEntityNumFromBlacklist(String appNumber) {
        List<String> list = RunModeServiceHelper.getEntityNumFromBlacklistBy(appNumber);
        return RunModeServiceHelper.changeListToSqlStr(list);
    }

    public static QFilter[] getEntityIdBlacklistFilters(QFilter[] filters, String filterKey) {
        QFilter qf = RunModeServiceHelper.wrapNotInFilterBy(RunModeServiceHelper.getAllEntityBlacklist(), filterKey);
        return RunModeServiceHelper.addFilterToFilters(filters, qf);
    }

    public static QFilter[] getEntityNumBlacklistFilters(String appNumber, QFilter[] filters, String filterKey) {
        QFilter qf = RunModeServiceHelper.wrapNotInFilterBy(RunModeServiceHelper.getEntityNumFromBlacklistBy(appNumber), filterKey);
        return RunModeServiceHelper.addFilterToFilters(filters, qf);
    }
}

