/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.schedule;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.ScheduleInfo;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.server.next.TimeNextUtils;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.CoreBusinessDataServiceHelper;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkService;

@SdkService(name="\u6267\u884c\u8ba1\u5212\u8c03\u5ea6\u670d\u52a1")
@KSObject
public class ScheduleServiceHelper {
    private static Log log = LogFactory.getLog(ScheduleServiceHelper.class);
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static JobDispatcher service = null;
    private static ScheduleManager scheduleManager = null;

    private static ScheduleManager getScheduleManager() {
        if (scheduleManager == null) {
            scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        }
        return scheduleManager;
    }

    private static JobDispatcher getService() {
        if (service == null) {
            service = (JobDispatcher)ServiceFactory.getService(JobDispatcher.class);
        }
        return service;
    }

    @SdkInternal
    public static String createJob(JobInfo jobInfo) {
        return ScheduleServiceHelper.getService().createJob(jobInfo);
    }

    @SdkInternal
    public static String createPlan(PlanInfo planInfo) {
        return ScheduleServiceHelper.getService().createPlan(planInfo);
    }

    @SdkInternal
    public static boolean deletePlan(String scheduleId) {
        return ScheduleServiceHelper.getService().deletePlan(scheduleId);
    }

    @SdkInternal
    public static boolean deleteJob(String jobId) {
        return ScheduleServiceHelper.getService().deleteJob(jobId);
    }

    public static String dispatch(JobInfo job) {
        return ScheduleServiceHelper.getService().dispatch(job);
    }

    public static void stopTask(String taskId) {
        ScheduleServiceHelper.getService().stopTask(taskId);
    }

    public static TaskInfo queryTask(String taskId) {
        return ScheduleServiceHelper.getService().queryTask(taskId);
    }

    public static List<TaskInfo> queryTask(List<String> taskIds) {
        return ScheduleServiceHelper.getService().queryTask(taskIds);
    }

    @SdkInternal
    public static int[] countNumOfExecute(String[] scheduleArray, Date endDate) {
        return ScheduleServiceHelper.getService().countNumOfExecute(scheduleArray, endDate);
    }

    @Deprecated
    @SdkInternal
    public static List<ZonedDateTime[]> timelistOfExecute(String[] scheduleArray, Date endDate) {
        return ScheduleServiceHelper.getService().timelistOfExecute(scheduleArray, endDate);
    }

    @SdkInternal
    public static Map<String, ZonedDateTime[]> queryTimelistOfExecute(String[] scheduleArray, Date endDate) {
        HashMap<String, ZonedDateTime[]> map = new HashMap<String, ZonedDateTime[]>();
        if (scheduleArray.length == 0) {
            return map;
        }
        List list = ScheduleServiceHelper.getService().timelistOfExecute(scheduleArray, endDate);
        int size = scheduleArray.length;
        for (int i = 0; i < size; ++i) {
            map.put(scheduleArray[i], list.get(i) == null ? new ZonedDateTime[]{} : (ZonedDateTime[])list.get(i));
        }
        return map;
    }

    @SdkInternal
    @Deprecated
    public static ZonedDateTime[] nextExecuteTime(String[] scheduleArray) {
        return ScheduleServiceHelper.getService().nextExecuteTime(scheduleArray);
    }

    @SdkInternal
    public static boolean enableSchedule(List<String> scheduleIds) throws Exception {
        try {
            if (scheduleIds == null || scheduleIds.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Error:Schedule***enableSchedule scheduleIds is null or size equals zero");
                }
                return false;
            }
            for (String id : scheduleIds) {
                ScheduleServiceHelper.getScheduleManager().enableSchedule(id);
            }
            return true;
        }
        catch (Throwable t) {
            log.error("Error:Schedule***enableSchedule", t);
            throw t;
        }
    }

    public static boolean disableSchedule(List<String> scheduleIds) {
        try {
            if (scheduleIds == null || scheduleIds.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Error:Schedule***disableSchedule scheduleIds is null or size equals zero.");
                }
                return false;
            }
            for (String scheduleId : scheduleIds) {
                ScheduleServiceHelper.getScheduleManager().disableSchedule(scheduleId);
            }
            return true;
        }
        catch (Throwable t) {
            log.error("Error:Schedule***disableSchedule error", t);
            throw t;
        }
    }

    @SdkInternal
    public static boolean enableScheduleByAppId(List<Object> appIds) throws Exception {
        List<Object> scheduleIds = ScheduleServiceHelper.getScheduleIdsByAppIds(appIds);
        try {
            if (scheduleIds == null || scheduleIds.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Error:Schedule***enableSchedule scheduleIds is null or size equals zero");
                }
                return false;
            }
            for (Object id : scheduleIds) {
                ScheduleServiceHelper.getScheduleManager().enableSchedule(id.toString());
            }
            return true;
        }
        catch (Exception e) {
            log.error("Error:Schedule***enableSchedule", (Throwable)e);
            throw e;
        }
    }

    private static List<Object> getScheduleIdsByAppIds(List<Object> appIds) {
        SqlBuilder sqlSb = new SqlBuilder();
        sqlSb.append("select  j1.fjobid as ftaskjobid, j1.fid,j1.fstarttime,j1.fendtime,j1.fplan,j1.frepeatmode,j1.fcyclenum,j1.fjobid,j1.fsfailnotify,j1.fssuccessnotify,j1.fsnotifytype,j1.fsmsgcontent,j1.fmsgreceiver,j1.fschprincipal,j1.fstimeout,", new Object[0]).append("t3.fjobtype,t3.ftaskclassname,t3.frunbyuserid,t3.fparams,t3.fnumber,t3.frunbyorgid,t3.frunbylang,t3.fconcurrent,t3.fstatus,t3.fstrategy,t3.frunmode,t3.fretrytime,t3.ftimeout,t3.fcanstop,", new Object[0]).append("t3n.fjobprincipal,t3n.ffailnotify,t3n.fsuccessnotify,t3n.fmsgcontent,t3n.fnotifytype,t3n.fcaption,t3n.fovertime,t3n.fjobmsgreceiver,", new Object[0]).append("t4.fappid,t4.fclassname,t4.fclassname as ftaskclass", new Object[0]).append(" from ", new Object[0]).append("(select case when t2.fjobnumber is null  then  t1.fjobid when t2.fjobnumber = '' then t1.fjobid when t2.fjobnumber = ' ' then t1.fjobid else t2.fjobnumber end as fjobid,t1.fid,t1.fstarttime,t1.fendtime,t1.fplan,t1.frepeatmode,t1.fcyclenum,t1.fhost,t1.fstatus,t1n.fsfailnotify,t1n.fssuccessnotify,t1n.fsnotifytype,t1n.fmsgreceiver,t1n.fsmsgcontent,t1n.fschprincipal,t1n.fstimeout from t_sch_schedule as t1 left outer join t_sch_schedule_n as t1n on t1.fid = t1n.fid left join t_sch_schedule_entry t2 on t1.fid = t2.fid) as j1 ", new Object[0]).append("left join t_sch_job t3 on j1.fjobid = t3.fid ", new Object[0]).append("left outer join t_sch_job_n as t3n on t3.fid = t3n.fid ", new Object[0]).append("left outer join t_sch_taskdefine as t4 on t4.fid = t3.ftaskdefineid ", new Object[0]).append("where j1.fstatus = '0'", new Object[0]).append(" and ", new Object[0]).appendIn("t4.fappid", appIds);
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                while (rs.next()) {
                    Object id = rs.getObject("fid");
                    if (result.contains(id)) continue;
                    result.add(id);
                }
                return result;
            }
        };
        List scheduleIds = (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sqlSb, (ResultSetHandler)action);
        return scheduleIds;
    }

    @SdkInternal
    public static Map<String, ZonedDateTime> queryNextExecuteTime(String[] scheduleArray) {
        if (scheduleArray.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ZonedDateTime> map = new HashMap<String, ZonedDateTime>(scheduleArray.length);
        ZonedDateTime[] datas = ScheduleServiceHelper.getService().nextExecuteTime(scheduleArray);
        int size = scheduleArray.length;
        for (int i = 0; i < size; ++i) {
            map.put(scheduleArray[i], datas[i]);
        }
        return map;
    }

    public static void stopGray(Map<String, Object> params) {
        try {
            Class<?> servie = Class.forName("kd.bos.schedule.utils.ScheduleGrayGroup");
            Method method = servie.getMethod("stopGray", Map.class);
            method.invoke(servie, params);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static String genPlanDesc(String cron, Date startTime, Date endTime, int numTimes) {
        return ScheduleServiceHelper.genPlanDesc(cron, startTime, endTime, 0L, numTimes);
    }

    public static String genPlanDesc(String cron, Date oriStartTime, Date endTime, long timeZoneId, int numTimes) {
        ZonedDateTime dateTime;
        ScheduleInfo info = new ScheduleInfo();
        info.setPlan(cron);
        info.setTimeZoneId(timeZoneId);
        Date startTime = oriStartTime;
        Calendar now = Calendar.getInstance();
        Date nowTime = now.getTime();
        if (startTime == null) {
            startTime = nowTime;
        }
        if (endTime == null) {
            return "";
        }
        ZoneId zoneId = ScheduleServiceHelper.getZoneId(timeZoneId);
        ZonedDateTime startTimeZone = ScheduleServiceHelper.createDate(startTime.getTime(), zoneId);
        ZonedDateTime endTimeZone = ScheduleServiceHelper.createDate(endTime.getTime(), zoneId);
        if (endTimeZone.isAfter(endTimeZone)) {
            StringBuilder sb = new StringBuilder("\n").append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"ScheduleServiceHelper_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0])).append((CharSequence)ScheduleServiceHelper.getSchFailStr());
            return sb.toString();
        }
        ZonedDateTime nowTimeZone = ScheduleServiceHelper.createDate(nowTime.getTime(), zoneId);
        if (nowTimeZone.isAfter(startTimeZone) && nowTimeZone.isBefore(endTimeZone)) {
            startTime = nowTime;
        }
        if (oriStartTime != null) {
            info.setStartTime(oriStartTime.getTime());
        } else {
            info.setStartTime(startTime.getTime());
        }
        if (endTimeZone != null) {
            Date endTs = !endTime.equals(startTime) ? new Timestamp(endTime.getTime() - 1L) : endTime;
            info.setEndTime(endTs.getTime());
            if (endTimeZone.isBefore(nowTimeZone)) {
                StringBuilder sb = new StringBuilder().append((CharSequence)ScheduleServiceHelper.getSchFailStr());
                return sb.toString();
            }
        }
        ZonedDateTime lastExeTime = ZonedDateTime.now(zoneId).truncatedTo(ChronoUnit.SECONDS).minusSeconds(5L);
        TimeNextUtils.genScheduleEx((ScheduleInfo)info, (ZonedDateTime)lastExeTime, (ZonedDateTime)lastExeTime, (int)numTimes);
        ConcurrentLinkedQueue pointOfTime = info.getPointOfTime();
        ArrayList<String> dateStr = new ArrayList<String>(10);
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        while ((dateTime = (ZonedDateTime)pointOfTime.poll()) != null) {
            dateStr.add(dateFormat.format(dateTime));
        }
        String ret = ScheduleServiceHelper.appendFireTimes(dateStr);
        StringBuilder res = new StringBuilder().append(ret);
        if (nowTime.after(endTime)) {
            StringBuilder descBuilder = ScheduleServiceHelper.getSchFailStr();
            res.append((CharSequence)descBuilder);
        }
        return res.toString();
    }

    private static StringBuilder getSchFailStr() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"%1$s\u5f53\u524d\u8c03\u5ea6\u8ba1\u5212\u5df2\u5931\u6548\u3002%2$s", (String)"ScheduleServiceHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), lineSeparator, lineSeparator));
        return sb;
    }

    private static String appendFireTimes(List<String> dateStr) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder descBuilder = new StringBuilder();
        if (dateStr.isEmpty()) {
            descBuilder.append(String.format(ResManager.loadKDString((String)"%1$s\u5f53\u524d\u8c03\u5ea6\u8ba1\u5212\u5df2\u5931\u6548\u3002%2$s", (String)"ScheduleServiceHelper_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), lineSeparator, lineSeparator));
        } else {
            descBuilder.append(lineSeparator);
            descBuilder.append(String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u6700\u8fd1%s\u6b21\u6267\u884c\u65f6\u95f4\uff1a", (String)"ScheduleServiceHelper_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), dateStr.size()));
            descBuilder.append(lineSeparator);
            descBuilder.append(dateStr.stream().collect(Collectors.joining(",\r\n")));
        }
        return descBuilder.toString();
    }

    private static ZonedDateTime createDate(long times) {
        return TimeNextUtils.createDate((long)times);
    }

    private static ZonedDateTime createDate(long times, ZoneId zoneId) {
        ZonedDateTime oriDT = ScheduleServiceHelper.createDate(times);
        return oriDT.withZoneSameLocal(zoneId);
    }

    private static ZoneId getZoneId(long timeZoneId) {
        ZoneId zoneId;
        if (timeZoneId != 0L) {
            DynamicObject dObj = CoreBusinessDataServiceHelper.loadSingleFromCache((Object)timeZoneId, (String)"inte_timezone", (String)"number");
            if (dObj == null || StringUtils.isEmpty((CharSequence)dObj.getString("number"))) {
                throw new RuntimeException(String.format("Get timeZoneand error, and timeZoneId is %d", timeZoneId));
            }
            zoneId = TimeZone.getTimeZone(dObj.getString("number")).toZoneId();
        } else {
            zoneId = Clock.systemDefaultZone().getZone();
        }
        return zoneId;
    }
}

