/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.user;

import kd.bos.entity.userconfig.UserConfig;
import kd.bos.userconfig.UserConfigQuery;
import kd.bos.userconfig.UserConfigWriter;
import kd.sdk.annotation.SdkService;

@SdkService(name="\u4eba\u5458\u914d\u7f6e\u670d\u52a1")
public class UserConfigServiceHelper {
    private UserConfigServiceHelper() {
    }

    private static UserConfig getUserConfigByCache(long userID, String key) {
        UserConfigQuery userConfigQuery = new UserConfigQuery();
        return userConfigQuery.getUserConfig(key, userID);
    }

    public static String getSetting(long userID, String key) {
        UserConfig userConfig = UserConfigServiceHelper.getUserConfigByCache(userID, key);
        if (userConfig != null) {
            return userConfig.getSetting();
        }
        return "";
    }

    public static boolean setSetting(long userID, String key, String setting) {
        UserConfigWriter userConfigWriter = new UserConfigWriter();
        UserConfig userConfig = UserConfigServiceHelper.getUserConfigByCache(userID, key);
        if (userConfig != null && setting.equalsIgnoreCase(userConfig.getSetting())) {
            return true;
        }
        if (userConfig != null) {
            userConfig.setSetting(setting);
        } else {
            userConfig = new UserConfig();
            userConfig.setKey(key);
            userConfig.setUserId(userID);
            userConfig.setSetting(setting);
        }
        StringBuilder errorMessage = new StringBuilder();
        boolean isSuccess = userConfigWriter.saveUserConfig(userConfig, errorMessage);
        return isSuccess;
    }

    public static boolean clearSetting(long userID, String key) {
        UserConfigWriter userConfigWriter = new UserConfigWriter();
        userConfigWriter.deleteUserConfig(key, userID);
        return true;
    }
}

