/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.user;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.IUserService;
import kd.bos.permission.model.PersonQueryParam;
import kd.bos.permission.model.PersonQueryType;
import kd.bos.permission.model.Position;
import kd.bos.permission.model.UserParam;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.portal.MainPageCommonSettingServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.util.EncryptUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.sdk.annotation.SdkService;

@KSObject
@SdkService(name="\u4eba\u5458\u6570\u636e\u670d\u52a1")
public class UserServiceHelper {
    private static final String ENTRYENTITY_DPT_ID = "entryentity.dpt.id";
    private static final String ENTRYENTITY_ISINCHARGE = "entryentity.isincharge";
    private static final String ENABLE = "enable";
    private static final String ID_ORG = "id,org";
    private static final String NUMBER = "number";
    private static final String ENTRYENTITY_ISPARTJOB = "entryentity.ispartjob";
    private static final String CHANGETIME = "changetime";
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static final String USER_ID = "userID";
    private static final String PHONE = "phone";
    private static final String USER_SERVICE_HELPER_1 = "UserServiceHelper_1";
    private static final String VERSION = "version";
    private static final String THEME_NUM = "themeNum";
    private static final String THEME_VER = "themeVer";
    private static final String CONTENT = "content";
    private static final String BACKGROUND = "background";
    private static final String ID_THEME_ID = "id, theme.id";
    private static final String THEME = "theme";
    private static final String COLOR = "color";
    private static final String IS_FIRSTLOGIN = "isfirstlogin";
    private static final String SUCCESS = "success";
    private static final String PSWHISSTR = "pswhisstr";
    private static final String MIN_LENGTH = "minlength";
    private static final String REPEATTIMES = "repeattimes";
    private static final String TIMESTAMP = "timestamp";
    private static final String USERTYPE = "usertype";
    private static final String USER_USERTYPE = "user.usertype";
    private static final String USER_EID = "user.eid";
    private static final String BIZPARTNER_NUMBER = "bizpartner.number";
    private static final String PARTNER_TYPE = "partnerType";
    private static final String PARTNER_EID = "partnerEid";
    private static final String PARTNER_USERS = "partnerUsers";
    private static final String ORG_ID = "orgId";
    private static final String THUMBNAIL = "thumbnail";
    private static Log logger = LogFactory.getLog(UserServiceHelper.class);
    public static final String entityID_user = "bos_user";
    public static final String entityID_userposition = "bos_userposition";
    public static final String entityID_userChange = "bos_userchange";
    public static final String entityID_uitheme = "bas_uitheme";
    public static final String entityID_useruitheme = "bas_useruitheme";
    public static final String USER = "user";
    public static final String ORG = "org";
    public static final String ENTITY_USER_DEFAULT_ORG = "bas_userdefaultorg";
    public static final String cacheKey = "userservice";
    public static final long ROOT_ORG_ID = 100000L;
    public static final String ENTITY_BIZPARTNERUSER = "bos_bizpartneruser";
    public static final int ENERGY_ORANGE_COLOR_ID = 1;
    public static final String OLD_PSW = "oldPsw";
    public static final String NEW_PSW = "newPsw";

    private static IUserService getUserService() {
        return (IUserService)ServiceFactory.getService(IUserService.class);
    }

    public static DynamicObject getCurrentUser(String fieldName) {
        long userId = UserServiceHelper.getCurrentUserId();
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("id");
        selectFields.add(fieldName);
        MainEntityType entityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)entityID_user, selectFields);
        Map loadFromCache = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)entityType);
        return (DynamicObject)loadFromCache.get(userId);
    }

    public static DynamicObjectCollection getCurrentUserInchargeDepts(String fieldName, boolean isIncludeSubOrg) {
        long userId = UserServiceHelper.getCurrentUserId();
        List<Long> deptIdList = UserServiceHelper.getInchargeOrgs(userId, isIncludeSubOrg);
        return UserServiceHelper.getUserDepts(fieldName, deptIdList);
    }

    private static DynamicObjectCollection getUserDepts(String fieldName, List<Long> deptIdList) {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("id");
        selectFields.add(fieldName);
        MainEntityType entityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bos_org", selectFields);
        DynamicObjectCollection userDepts = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        Map loadFromCache = BusinessDataReader.loadFromCache((Object[])deptIdList.toArray(), (DynamicObjectType)entityType);
        userDepts.addAll(loadFromCache.values());
        return userDepts;
    }

    public static DynamicObjectCollection getCurrentUserDepts(String fieldName, boolean isIncludeSubOrg) {
        long userId = UserServiceHelper.getCurrentUserId();
        List<Long> userOrgList = UserServiceHelper.getOrgsUserJoin(userId);
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        if (isIncludeSubOrg) {
            deptIdList.addAll(OrgUnitServiceHelper.getAllSubordinateOrgs(1L, userOrgList, true));
        } else {
            deptIdList.addAll(userOrgList);
        }
        return UserServiceHelper.getUserDepts(fieldName, deptIdList);
    }

    public static long getCurrentUserId() {
        return RequestContext.get().getCurrUserId();
    }

    public static long getUserMainOrgId(long userID) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getUserMainOrgId(userID);
    }

    public static List<Long> getUserMainOrgIds(List<Long> userIds) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getUserMainOrgIds(userIds);
    }

    public static List<Map<Long, Long>> getUserMainOrgId(List<Long> lstUserIds) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getUserMainOrgId(lstUserIds);
    }

    public static List<Long> getOrgsUserJoin(long userId) {
        return UserServiceHelper.getUserDepartments(userId, false, false);
    }

    public static List<Long> getMangedOrgsOfUser(long userId) {
        return UserServiceHelper.getUserDepartments(userId, false, true);
    }

    public static List<Long> getUsersOfEqualLevel(long userId) {
        return UserServiceHelper.getUsersOfEqualLevel(userId, false);
    }

    public static List<Long> getUsersOfEqualLevel(long userId, boolean bIncludeCurUser) {
        ArrayList<Long> lstEqLvusers = new ArrayList<Long>();
        if (userId == 0L) {
            return lstEqLvusers;
        }
        long lMainDpt = UserServiceHelper.getUserMainOrgId(userId);
        if (lMainDpt == 0L) {
            return lstEqLvusers;
        }
        ORM ormuser = ORM.create();
        QFilter f1 = new QFilter(ENTRYENTITY_DPT_ID, "=", (Object)lMainDpt);
        try (DataSet dsUser = ormuser.queryDataSet(UserServiceHelper.class.getName(), entityID_user, "id", new QFilter[]{f1});){
            for (Row row : dsUser) {
                if (row.get(0) == null || !bIncludeCurUser && userId == (Long)row.get(0)) continue;
                lstEqLvusers.add((Long)row.get(0));
            }
        }
        return lstEqLvusers;
    }

    public static List<Long> getManagersOfOrg(long orgId) {
        if (orgId == 0L) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> lstOrgs = new ArrayList<Long>(1);
        lstOrgs.add(orgId);
        Map<Long, Map<String, Object>> managerMap = UserServiceHelper.getManagersOfOrgs(lstOrgs);
        if (managerMap == null || managerMap.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> lstMangers = new ArrayList<Long>(managerMap.size());
        for (long userId : managerMap.keySet()) {
            lstMangers.add(userId);
        }
        return lstMangers;
    }

    private static Map<Long, Map<String, Object>> getManagersOfOrgs(List<Long> lstOrgs) {
        HashMap<Long, Map<String, Object>> managerMap = new HashMap<Long, Map<String, Object>>();
        String selectFields = "id,enable";
        QFilter f1 = new QFilter(ENTRYENTITY_DPT_ID, "in", lstOrgs);
        QFilter f2 = new QFilter(ENTRYENTITY_ISINCHARGE, "=", (Object)"1");
        DynamicObjectCollection userCol = QueryServiceHelper.query(entityID_user, selectFields, new QFilter[]{f1, f2});
        if (userCol == null || userCol.size() == 0) {
            return managerMap;
        }
        for (DynamicObject user : userCol) {
            HashMap<String, Boolean> userInfoMap = new HashMap<String, Boolean>();
            userInfoMap.put(ENABLE, user.getBoolean(ENABLE));
            managerMap.put(user.getLong("id"), userInfoMap);
        }
        return managerMap;
    }

    public static List<Long> getDirectUsersOfOrg(long orgId) {
        ArrayList<Long> lstOrgUsers = new ArrayList<Long>();
        ORM ormuser = ORM.create();
        QFilter f1 = new QFilter(ENTRYENTITY_DPT_ID, "=", (Object)orgId);
        try (DataSet dsUser = ormuser.queryDataSet(UserServiceHelper.class.getName(), entityID_user, "id", new QFilter[]{f1});){
            for (Row row : dsUser) {
                if (row.get(0) == null) continue;
                lstOrgUsers.add((Long)row.get(0));
            }
        }
        return lstOrgUsers;
    }

    @KSMethod
    public static List<Long> getAllUsersOfOrg(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List<Long> lstOrgUsers = UserServiceHelper.getAllUsersOfOrg(orgIds);
        return lstOrgUsers;
    }

    public static List<Long> getAllUsersOfOrg(List<Long> orgIds) {
        return UserServiceHelper.getAllUsersOfOrg(orgIds, true);
    }

    public static List<Long> getAllUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg) {
        return new ArrayList<Long>(UserServiceHelper.getAllUsersOfOrg(orgIds, isFindSubOrg, true));
    }

    @Deprecated
    public static List<Long> getUsersBySuperior(long userId) {
        ArrayList<Long> resultList = new ArrayList<Long>(1);
        return resultList;
    }

    public static Map<Long, Map<String, Object>> getUserInfoBySuperior(long userId) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getSuperiorOrgLeaderInfo(userId);
    }

    @Deprecated
    public static List<Long> getUsersBySubordinate(long userId, boolean includeIndirect) {
        ArrayList<Long> lstUser = new ArrayList<Long>();
        return lstUser;
    }

    @Deprecated
    public static List<Long> getUsersBySubordinate(long userId) {
        ArrayList<Long> lstUsers = new ArrayList<Long>();
        return lstUsers;
    }

    @Deprecated
    public static List<Long> getUsersByIndirectSuperior(long userId) {
        ArrayList<Long> namagerList = new ArrayList<Long>();
        return namagerList;
    }

    public static Map<Long, Map<String, Object>> getUserInfoByIndirectSuperior(long userId) {
        Map<Long, Map<String, Object>> superiorMap = UserServiceHelper.getUserInfoBySuperior(userId);
        if (superiorMap == null || superiorMap.size() == 0) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        ArrayList<Long> superiorUserList = new ArrayList<Long>(superiorMap.size());
        for (long manageId : superiorMap.keySet()) {
            superiorUserList.add(manageId);
        }
        List<Long> superiorOrgList = UserServiceHelper.getUserMainOrgIds(superiorUserList);
        List<Long> lstSuperiorOrg = OrgServiceHelper.getSuperiorOrgs(superiorOrgList);
        if (lstSuperiorOrg == null || lstSuperiorOrg.size() == 0) {
            lstSuperiorOrg = new ArrayList<Long>();
            lstSuperiorOrg.add(OrgUnitServiceHelper.getRootOrgId());
        }
        return UserServiceHelper.getManagersOfOrgs(lstSuperiorOrg);
    }

    @Deprecated
    public static List<Long> getUsersByIndirectSubordinate(long userId) {
        ArrayList<Long> lstOrgUsers = new ArrayList<Long>();
        return lstOrgUsers;
    }

    public static List<Long> getInchargeOrgs(long userID, boolean isIncludeSubOrg) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getInchargeOrgs(userID, isIncludeSubOrg);
    }

    public static List<Map<String, Object>> getUserChangeInfos(String timestamp, boolean includeDptAdmin, boolean includeCompany) {
        logger.info("\u83b7\u53d6\u4eba\u5458\u53d8\u66f4\u4fe1\u606f\u53c2\u6570\uff1a[timestamp]" + timestamp + "[includeDptAdmin]" + includeDptAdmin + "[includeCompany]" + includeCompany);
        Map<Long, Map<String, Object>> dptChargerMap = null;
        if (includeDptAdmin) {
            dptChargerMap = UserServiceHelper.getDepartmentAdminMap();
        }
        if (StringUtils.isBlank((CharSequence)timestamp)) {
            return UserServiceHelper.getAllUserChangeInfos(dptChargerMap, includeDptAdmin, includeCompany);
        }
        return UserServiceHelper.getUserChangeInfosByTime(timestamp, dptChargerMap, includeDptAdmin, includeCompany);
    }

    private static Map<Long, Map<String, Object>> getDepartmentAdminMap() {
        HashMap<Long, Map<String, Object>> dptChargerMap = new HashMap<Long, Map<String, Object>>();
        String selectFields = "id,user,user.number number,user.name name,org";
        QFilter filter = new QFilter("isincharge", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = QueryServiceHelper.queryDataSet("kd.bos.servicehelper.user.UserServiceHelper.getDepartmentAdminMap", entityID_userposition, selectFields, filters, "");){
            for (Row row : ds) {
                HashMap<String, Object> charger = new HashMap<String, Object>();
                charger.put("id", row.getLong(USER));
                charger.put(NUMBER, row.getString(NUMBER));
                charger.put("name", row.getString("name"));
                dptChargerMap.put(row.getLong(ORG), charger);
            }
        }
        return dptChargerMap;
    }

    private static List<Map<String, Object>> getAllUserChangeInfos(Map<Long, Map<String, Object>> dptChargerMap, boolean includeDptAdmin, boolean includeCompany) {
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>();
        String selectFields = "'1' as type,id,id user,createtime changetime,disabledate,fuid,number,name,phone,email,enable,entryentity.dpt.id dpt,entryentity.dpt.number dptnumber,entryentity.dpt.name dptname";
        QFilter userTypeFilter = new QFilter(USERTYPE, "=", (Object)"1");
        QFilter ispartjobFilter = new QFilter(ENTRYENTITY_ISPARTJOB, "=", (Object)"0");
        ispartjobFilter = ispartjobFilter.or(QFilter.isNull((String)ENTRYENTITY_ISPARTJOB));
        QFilter[] filters = new QFilter[]{userTypeFilter, ispartjobFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet("kd.bos.servicehelper.user.UserServiceHelper.getAllUserChangeInfos", entityID_user, selectFields, filters, "");){
            UserServiceHelper.genAllUserChangeInfo(userChangeList, dataSet, dptChargerMap, includeDptAdmin, includeCompany);
        }
        return userChangeList;
    }

    private static List<Map<String, Object>> getUserChangeInfosByTime(String timestamp, Map<Long, Map<String, Object>> dptChargerMap, boolean includeDptAdmin, boolean includeCompany) {
        long userId;
        ArrayList<Long> selectedUserIds;
        Date changetime = UserServiceHelper.getChangeTime(timestamp);
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>();
        String selectChangeFields = "id,type,user,changetime";
        QFilter changeTimeFilter = new QFilter(CHANGETIME, ">=", (Object)changetime);
        QFilter[] filters = new QFilter[]{changeTimeFilter};
        HashSet<Long> changeUserIds = new HashSet<Long>();
        LinkedHashMap<Long, Map<String, Object>> changeInfoMap = new LinkedHashMap<Long, Map<String, Object>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet("kd.bos.servicehelper.user.UserServiceHelper.getUserChangeInfosByTime.userchanger", entityID_userChange, selectChangeFields, filters, CHANGETIME);){
            HashMap<String, Object> changeDataMap = null;
            for (Row row : dataSet) {
                long id = row.getLong("id");
                long userId2 = row.getLong(USER);
                changeUserIds.add(userId2);
                changeDataMap = new HashMap<String, Object>();
                changeDataMap.put("id", id);
                changeDataMap.put(USER, userId2);
                changeDataMap.put("type", row.get("type"));
                changeDataMap.put(CHANGETIME, row.get(CHANGETIME));
                changeInfoMap.put(id, changeDataMap);
            }
        }
        if (changeUserIds.isEmpty()) {
            return userChangeList;
        }
        int count = changeUserIds.size();
        HashMap<Long, Map<String, Object>> orgCompanyMap = new HashMap<Long, Map<String, Object>>(count);
        HashMap<Long, Map<String, Object>> allUserInfoMap = new HashMap<Long, Map<String, Object>>(count);
        Map<String, Object> userChangeInfoMap = null;
        String commonFields = "disabledate,fuid,number,name,phone,email,enable,entryentity.dpt.id dpt,entryentity.dpt.number dptnumber,entryentity.dpt.name dptname";
        String selectFields = "id,id user," + commonFields;
        QFilter idFilter = new QFilter("id", "in", changeUserIds);
        QFilter userTypeFilter = new QFilter(USERTYPE, "=", (Object)"1");
        filters = new QFilter[]{idFilter, userTypeFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet("kd.bos.servicehelper.user.UserServiceHelper.getUserChangeInfosByTime.user", entityID_user, selectFields, filters, ENTRYENTITY_ISPARTJOB);){
            selectedUserIds = new ArrayList<Long>(count);
            for (Row row : dataSet) {
                userId = row.getLong(USER);
                if (selectedUserIds.contains(userId)) continue;
                selectedUserIds.add(userId);
                userChangeInfoMap = UserServiceHelper.genChangedUserInfo(row, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
                allUserInfoMap.put(userId, userChangeInfoMap);
            }
            changeUserIds.removeAll(selectedUserIds);
        }
        if (!changeUserIds.isEmpty()) {
            selectFields = "id,user user," + commonFields;
            idFilter = new QFilter(USER, "in", changeUserIds);
            userTypeFilter = new QFilter(USERTYPE, "=", (Object)"1");
            filters = new QFilter[]{idFilter, userTypeFilter};
            dataSet = QueryServiceHelper.queryDataSet("kd.bos.servicehelper.user.UserServiceHelper.getUserChangeInfosByTime.userHistory", "bos_user_history", selectFields, filters, "modifytime desc,entryentity.ispartjob");
            var20_24 = null;
            try {
                selectedUserIds = new ArrayList(count);
                for (Row row : dataSet) {
                    userId = row.getLong(USER);
                    if (selectedUserIds.contains(userId)) continue;
                    selectedUserIds.add(userId);
                    userChangeInfoMap = UserServiceHelper.genChangedUserInfo(row, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
                    allUserInfoMap.put(userId, userChangeInfoMap);
                }
            }
            catch (Throwable throwable) {
                var20_24 = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (var20_24 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            var20_24.addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        UserServiceHelper.genUserChangeInfo(userChangeList, changeInfoMap, allUserInfoMap);
        return userChangeList;
    }

    private static Date getChangeTime(String timestamp) {
        Date changetime = null;
        try {
            if (timestamp.length() == 10) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                changetime = sdf.parse(timestamp);
            } else if (timestamp.length() == 19) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                changetime = sdf.parse(timestamp);
            } else {
                changetime = new Date();
            }
        }
        catch (ParseException e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u67e5\u8be2\u65f6\u95f4\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u683c\u5f0f\u662f\u5426\u6b63\u786e\uff08yyyy-MM-dd/yyyy-MM-dd HH:mm:ss\uff09", (String)"UserServiceHelper_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), timestamp);
            logger.info(errorMsg);
            throw new KDBizException(errorMsg);
        }
        return changetime;
    }

    private static void genAllUserChangeInfo(List<Map<String, Object>> userChangeList, DataSet dataSet, Map<Long, Map<String, Object>> dptChargerMap, boolean includeDptAdmin, boolean includeCompany) {
        HashMap<Long, Map<String, Object>> orgCompanyMap = new HashMap<Long, Map<String, Object>>();
        HashMap<Long, Map<String, Object>> allUserChangeMap = new HashMap<Long, Map<String, Object>>();
        Map<String, Object> userChangeInfoMap = null;
        for (Row row : dataSet) {
            long changeInfoId = row.getLong("id");
            if (allUserChangeMap.containsKey(changeInfoId)) continue;
            userChangeInfoMap = UserServiceHelper.genChangedUserInfo(row, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
            userChangeInfoMap.put("id", row.getString(USER));
            userChangeInfoMap.put("type", row.getString("type"));
            userChangeInfoMap.put(CHANGETIME, row.getDate(CHANGETIME));
            userChangeList.add(userChangeInfoMap);
            allUserChangeMap.put(changeInfoId, userChangeInfoMap);
            if (row.getBoolean(ENABLE).booleanValue()) continue;
            HashMap<String, Object> disableUserMap = new HashMap<String, Object>(userChangeInfoMap);
            disableUserMap.put("type", "4");
            Date disabledate = row.getDate("disabledate");
            if (disabledate == null) {
                disabledate = new Date();
            }
            disableUserMap.put(CHANGETIME, disabledate);
            userChangeList.add(disableUserMap);
        }
    }

    private static void genUserChangeInfo(List<Map<String, Object>> userChangeList, Map<Long, Map<String, Object>> changeInfoMap, Map<Long, Map<String, Object>> allUserInfoMap) {
        Map<String, Object> userInfoMap = null;
        HashMap<String, Object> userChangeInfoMap = null;
        for (Map.Entry<Long, Map<String, Object>> changeEntry : changeInfoMap.entrySet()) {
            Map<String, Object> changeRow = changeEntry.getValue();
            userChangeInfoMap = new HashMap<String, Object>();
            userChangeInfoMap.put("id", changeRow.get(USER));
            userChangeInfoMap.put("type", changeRow.get("type"));
            userChangeInfoMap.put(CHANGETIME, changeRow.get(CHANGETIME));
            long userId = Long.parseLong(changeRow.get(USER).toString());
            userInfoMap = allUserInfoMap.get(userId);
            if (userInfoMap != null) {
                userChangeInfoMap.putAll(userInfoMap);
            }
            userChangeList.add(userChangeInfoMap);
        }
    }

    private static Map<String, Object> genChangedUserInfo(Row userRow, Map<Long, Map<String, Object>> dptChargerMap, Map<Long, Map<String, Object>> orgCompanyMap, boolean includeDptAdmin, boolean includeCompany) {
        HashMap<String, Object> userChangeInfoMap = new HashMap<String, Object>();
        if (userRow != null) {
            userChangeInfoMap.put("uid", userRow.getString("fuid"));
            userChangeInfoMap.put(NUMBER, userRow.getString(NUMBER));
            userChangeInfoMap.put("name", userRow.getString("name"));
            userChangeInfoMap.put(PHONE, userRow.getString(PHONE));
            userChangeInfoMap.put("email", userRow.getString("email"));
            UserServiceHelper.genUserChangeDeptInfo(userChangeInfoMap, userRow, dptChargerMap, orgCompanyMap, includeDptAdmin, includeCompany);
        }
        return userChangeInfoMap;
    }

    private static void genUserChangeDeptInfo(Map<String, Object> mapUser, Row row, Map<Long, Map<String, Object>> dptChargerMap, Map<Long, Map<String, Object>> orgCompanyMap, boolean includeDptAdmin, boolean includeCompany) {
        Map<String, Object> charger;
        long dptId = row.getLong("dpt");
        if (dptId == 0L) {
            return;
        }
        mapUser.put("dptId", dptId);
        mapUser.put("dpt", row.getString("dptname"));
        if (includeDptAdmin && (charger = dptChargerMap.get(dptId)) != null) {
            mapUser.put("chargerName", charger.get("name"));
            mapUser.put("chargerNumber", charger.get(NUMBER));
        }
        if (includeCompany) {
            Map<String, Object> company = orgCompanyMap.get(dptId);
            if (company == null) {
                company = OrgUnitServiceHelper.getCompanyfromOrg(dptId);
            }
            if (company == null || company.isEmpty()) {
                company = new HashMap<String, Object>(0);
            } else {
                mapUser.put("companyName", company.get("name"));
                mapUser.put("companyId", company.get("id"));
            }
            orgCompanyMap.put(dptId, company);
        }
    }

    public static List<Map<String, Object>> getUserChangeInfos(String timestamp) {
        boolean includeDptAdmin = true;
        boolean includeCompany = true;
        return UserServiceHelper.getUserChangeInfos(timestamp, includeDptAdmin, includeCompany);
    }

    public boolean updateUserChange(Map<String, Object> userMap) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityID_userChange);
            DynamicObject doOV = new DynamicObject((DynamicObjectType)dt);
            MainEntityType metOV = EntityMetadataCache.getDataEntityType((String)entityID_userChange);
            doOV.set(USER, userMap.get(USER_ID));
            doOV.set(NUMBER, userMap.get(NUMBER));
            doOV.set(PHONE, userMap.get(PHONE));
            doOV.set(CHANGETIME, userMap.get("changeTime"));
            doOV.set("name", userMap.get("name"));
            doOV.set("type", userMap.get("changeType"));
            try (TXHandle h = TX.beginRequired();){
                try {
                    BusinessDataWriter.save((IDataEntityType)metOV, (Object[])new Object[]{doOV});
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
            return false;
        }
        return true;
    }

    public boolean updateUserChange(List<Map<String, Object>> userMapList) {
        if (userMapList == null || userMapList.size() == 0) {
            return false;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityID_userChange);
        DynamicObject[] dataEntities = new DynamicObject[userMapList.size()];
        int index = 0;
        for (Map<String, Object> userMap : userMapList) {
            DynamicObject userChange = new DynamicObject((DynamicObjectType)dt);
            userChange.set(USER, userMap.get(USER_ID));
            userChange.set(NUMBER, userMap.get(NUMBER));
            userChange.set(PHONE, userMap.get(PHONE));
            userChange.set(CHANGETIME, userMap.get("changeTime"));
            userChange.set("name", userMap.get("name"));
            userChange.set("type", userMap.get("changeType"));
            dataEntities[index++] = userChange;
        }
        SaveServiceHelper.save(dataEntities);
        return true;
    }

    public static Map<String, Object> getUserInfoByID(long userID) {
        List<Map<String, Object>> userList = UserServiceHelper.getUserInfoByID(Collections.singletonList(userID));
        if (userList.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        return userList.get(0);
    }

    public static List<Map<String, Object>> getUserInfoByID(List<Long> userID) {
        QFilter filterUser = new QFilter("id", "in", userID);
        String selectFileds = "id,fuid,number,name,phone,email";
        QFilter[] filterUsers = new QFilter[]{filterUser};
        Map<Object, DynamicObject> userMap = BusinessDataServiceHelper.loadFromCache(entityID_user, selectFileds, filterUsers);
        if (CollectionUtils.isEmpty(userMap)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> userInfoLst = new ArrayList<Map<String, Object>>(userMap.size());
        HashMap<String, Object> userInfo = null;
        for (DynamicObject obj : userMap.values()) {
            userInfo = new HashMap<String, Object>(16);
            userInfo.put("id", obj.getPkValue());
            userInfo.put(USER_ID, userID);
            userInfo.put("uid", obj.getString("fuid"));
            userInfo.put(NUMBER, obj.getString(NUMBER));
            userInfo.put("name", obj.getString("name"));
            userInfo.put(PHONE, obj.getString(PHONE));
            userInfo.put("email", obj.getString("email"));
            userInfo.put("type", "1");
            userInfoLst.add(userInfo);
        }
        return userInfoLst;
    }

    public static DynamicObject getUserInfoByID(Long userID, String selector) {
        DynamicObject userInfo = BusinessDataServiceHelper.loadSingle(userID, entityID_user, selector);
        return userInfo;
    }

    public static Map<String, Object> getDefaultUIThemeNumAndVer() {
        HashMap<String, Object> theme = new HashMap<String, Object>();
        String themeNum = null;
        String themeName = null;
        Long themeVer = 0L;
        QFilter[] filters = null;
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("id", "=", (Object)1);
        filters = RunModeServiceHelper.isGalaxyMode() ? new QFilter[]{idFilter} : new QFilter[]{isDefaultFilter};
        DynamicObject themeObj = BusinessDataServiceHelper.loadSingleFromCache(entityID_uitheme, filters);
        if (themeObj == null) {
            throw new KDException(ResManager.loadKDString((String)UserServiceHelper.get_NOT_SET_TOPIC(), (String)USER_SERVICE_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        }
        themeNum = themeObj.getString(NUMBER);
        themeName = themeObj.getString("name");
        themeVer = themeObj.getLong(VERSION);
        theme.put(THEME_NUM, themeNum);
        theme.put("themeName", themeName);
        theme.put(THEME_VER, themeVer.toString());
        theme.put(THUMBNAIL, themeObj.getString(THUMBNAIL));
        theme.put(COLOR, themeObj.getString(COLOR));
        theme.put(BACKGROUND, themeObj.getString(BACKGROUND));
        return theme;
    }

    public static String getThemeCSS(String themeNum) {
        String css = null;
        String selectProperties = "id,content";
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)themeNum);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject[] themeList = BusinessDataServiceHelper.load(entityID_uitheme, selectProperties, filters);
        if (themeList == null || themeList.length == 0) {
            throw new KDException(ResManager.loadKDString((String)UserServiceHelper.get_NOT_SET_TOPIC(), (String)USER_SERVICE_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        }
        css = themeList[0].getString(CONTENT);
        return css;
    }

    public static Map<String, Object> getUserThemeNumAndVer(Long userID) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String themeNum = null;
        String themeName = null;
        Long themeVer = 0L;
        DynamicObjectCollection userThemeCol = UserServiceHelper.getUserThemeDynamicObject(userID);
        if (userThemeCol == null || userThemeCol.size() == 0) {
            return UserServiceHelper.getDefaultUIThemeNumAndVer();
        }
        DynamicObject userThemeInfo = (DynamicObject)userThemeCol.get(0);
        themeNum = userThemeInfo.getString("theme.number");
        themeName = userThemeInfo.getString("theme.name");
        themeVer = userThemeInfo.getLong("theme.version");
        result.put(THEME_NUM, themeNum);
        result.put("themeName", themeName);
        result.put(THEME_VER, themeVer.toString());
        result.put(THUMBNAIL, userThemeInfo.get("theme.thumbnail"));
        result.put(COLOR, userThemeInfo.get("theme.color"));
        result.put(BACKGROUND, userThemeInfo.get("theme.background"));
        return result;
    }

    private static DynamicObjectCollection getUserThemeDynamicObject(Long userID) {
        String selectProperties = "id,theme.id, theme.number, theme.name, theme.version,theme.thumbnail,theme.color,theme.background,theme.content,theme.ispreset,theme.enable";
        QFilter userFilter = new QFilter(USER, "=", (Object)userID);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObjectCollection userThemeCol = new DynamicObjectCollection();
        Map<Object, DynamicObject> userThemes = BusinessDataServiceHelper.loadFromCache(entityID_useruitheme, selectProperties, filters);
        if (userThemes != null && userThemes.size() > 0) {
            userThemeCol.addAll(userThemes.values());
        }
        return userThemeCol;
    }

    public static Long getUserThemeID(Long userID) {
        Long themeID = 0L;
        String selectProperties = ID_THEME_ID;
        QFilter userFilter = new QFilter(USER, "=", (Object)userID);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject[] userThemeList = BusinessDataServiceHelper.load(entityID_useruitheme, selectProperties, filters);
        if (userThemeList == null || userThemeList.length == 0) {
            return themeID;
        }
        DynamicObject userTheme = userThemeList[0];
        if (userTheme != null && userTheme.getDynamicObject(THEME) != null) {
            themeID = (Long)userTheme.getDynamicObject(THEME).getPkValue();
        }
        return themeID;
    }

    public static Map<String, Object> getUserTheme(Long userID) {
        HashMap<String, Object> userTheme = new HashMap<String, Object>();
        Map<String, Object> currentTheme = UserServiceHelper.getUserThemeNumAndVer(userID);
        userTheme.put("currentTheme", currentTheme.get(THEME_NUM));
        userTheme.put("currentVersion", currentTheme.get(THEME_VER));
        ArrayList allThemes = new ArrayList();
        String selectProperties = "id,number,name,thumbnail,preview1,preview2,preview3,version";
        QFilter[] filters = null;
        DynamicObject[] themeList = BusinessDataServiceHelper.load(entityID_uitheme, selectProperties, filters);
        String number = null;
        String name = null;
        String thumbnail = null;
        String preview1 = null;
        String preview2 = null;
        String preview3 = null;
        Long version = 0L;
        HashMap<String, Object> theme = null;
        ArrayList<String> previewImgs = null;
        for (int i = 0; themeList != null && i < themeList.length; ++i) {
            number = themeList[i].getString(NUMBER);
            name = themeList[i].getString("name");
            thumbnail = themeList[i].getString(THUMBNAIL);
            preview1 = themeList[i].getString("preview1");
            preview2 = themeList[i].getString("preview2");
            preview3 = themeList[i].getString("preview3");
            version = themeList[i].getLong(VERSION);
            theme = new HashMap<String, Object>();
            previewImgs = new ArrayList<String>();
            theme.put(THEME, number);
            theme.put("title", name);
            theme.put("img", thumbnail);
            if (!StringUtils.isBlank((CharSequence)preview1)) {
                previewImgs.add(preview1);
            }
            if (!StringUtils.isBlank((CharSequence)preview2)) {
                previewImgs.add(preview2);
            }
            if (!StringUtils.isBlank((CharSequence)preview3)) {
                previewImgs.add(preview3);
            }
            theme.put("previewImg", previewImgs);
            theme.put(VERSION, version);
            allThemes.add(theme);
        }
        userTheme.put("allThemes", allThemes);
        return userTheme;
    }

    public static boolean setUserTheme(Long userID, String themeNumber) {
        String selectProperties = "id";
        QFilter numberFilter = new QFilter(NUMBER, "=", (Object)themeNumber);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject[] themeList = BusinessDataServiceHelper.load(entityID_uitheme, selectProperties, filters);
        if (themeList == null || themeList.length == 0) {
            return false;
        }
        DynamicObject userTheme = null;
        selectProperties = ID_THEME_ID;
        QFilter userFilter = new QFilter(USER, "=", (Object)userID);
        filters = new QFilter[]{userFilter};
        DynamicObject[] userThemeList = BusinessDataServiceHelper.load(entityID_useruitheme, selectProperties, filters);
        if (userThemeList == null || userThemeList.length == 0) {
            MainEntityType useruithemeEntityType = EntityMetadataCache.getDataEntityType((String)entityID_useruitheme);
            userTheme = new DynamicObject((DynamicObjectType)useruithemeEntityType);
            userTheme.set(USER, (Object)userID);
            userTheme.set(THEME, (Object)themeList[0]);
        } else {
            userTheme = userThemeList[0];
            userTheme.set(THEME, (Object)themeList[0]);
        }
        try (TXHandle h = TX.beginRequired();){
            try {
                SaveServiceHelper.save(new DynamicObject[]{userTheme});
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
        return true;
    }

    public static void setUserTheme(Long userID, Long themeID) {
        DynamicObject userTheme = null;
        String selectProperties = ID_THEME_ID;
        QFilter userFilter = new QFilter(USER, "=", (Object)userID);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject[] userThemeList = BusinessDataServiceHelper.load(entityID_useruitheme, selectProperties, filters);
        if (userThemeList == null || userThemeList.length == 0) {
            MainEntityType useruithemeEntityType = EntityMetadataCache.getDataEntityType((String)entityID_useruitheme);
            userTheme = new DynamicObject((DynamicObjectType)useruithemeEntityType);
            userTheme.set(USER, (Object)userID);
            userTheme.set(THEME, (Object)themeID);
        } else {
            userTheme = userThemeList[0];
            userTheme.set(THEME, (Object)themeID);
        }
        try (TXHandle h = TX.beginRequired();){
            try {
                SaveServiceHelper.save(new DynamicObject[]{userTheme});
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    public static Map<String, Object> getUserThemeNumAndVerNew(Long userID) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObjectCollection userThemeCol = UserServiceHelper.getUserThemeDynamicObject(userID);
        if (userThemeCol == null || userThemeCol.size() == 0) {
            return UserServiceHelper.getDefaultUIThemeNumAndVerNew();
        }
        DynamicObject userThemeInfo = (DynamicObject)userThemeCol.get(0);
        String enable = userThemeInfo.getString("theme.enable");
        if (!"1".equals(enable)) {
            return UserServiceHelper.getDefaultUIThemeNumAndVerNew();
        }
        String name = userThemeInfo.getString("theme.name");
        String content = userThemeInfo.getString("theme.content");
        result.put("name", name);
        Map mapContent = (Map)JSON.parse((String)content);
        result.put(CONTENT, mapContent);
        result.put(COLOR, userThemeInfo.get("theme.color"));
        result.put(NUMBER, userThemeInfo.getString("theme.number"));
        result.put(BACKGROUND, userThemeInfo.getString("theme.background"));
        result.put("themetype", userThemeInfo.getString("theme.ispreset"));
        result.put("ver", userThemeInfo.getString("theme.version"));
        result.put("enableMobileTheme", MainPageCommonSettingServiceHelper.getThemeSetting());
        result.put("enableMobDesignThemeColor", MainPageCommonSettingServiceHelper.isEnableMobDesignThemeColor());
        return result;
    }

    public static Map<String, Object> getDefaultUIThemeNumAndVerNew() {
        HashMap<String, Object> theme = new HashMap<String, Object>();
        String themeNum = null;
        String themeName = null;
        Long themeVer = 0L;
        QFilter[] filters = null;
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("id", "=", (Object)1);
        filters = RunModeServiceHelper.isGalaxyMode() ? new QFilter[]{idFilter} : new QFilter[]{isDefaultFilter};
        DynamicObject themeObj = BusinessDataServiceHelper.loadSingleFromCache(entityID_uitheme, filters);
        if (themeObj == null) {
            throw new KDException(ResManager.loadKDString((String)UserServiceHelper.get_NOT_SET_TOPIC(), (String)USER_SERVICE_HELPER_1, (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        }
        themeNum = themeObj.getString(NUMBER);
        themeName = themeObj.getString("name");
        themeVer = themeObj.getLong(VERSION);
        theme.put("name", themeName);
        Map mapContent = (Map)JSON.parse((String)themeObj.getString(CONTENT));
        theme.put(CONTENT, mapContent);
        theme.put(COLOR, themeObj.getString(COLOR));
        theme.put(NUMBER, themeObj.getString(NUMBER));
        theme.put(BACKGROUND, themeObj.getString(BACKGROUND));
        theme.put("themetype", themeObj.getString("ispreset"));
        theme.put("ver", themeObj.getString(VERSION));
        theme.put("enableMobileTheme", MainPageCommonSettingServiceHelper.getThemeSetting());
        theme.put("enableMobDesignThemeColor", MainPageCommonSettingServiceHelper.isEnableMobDesignThemeColor());
        return theme;
    }

    public static DynamicObject[] getDefaultUIThemeNumAndVerList() {
        QFilter[] filters = new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")};
        DynamicObject[] dynColl = BusinessDataServiceHelper.load(entityID_uitheme, "id,number, name, version,thumbnail,color,background,content,isdefault", filters);
        return dynColl;
    }

    public static void switchUserDefaultOrg(long defaultOrgID) {
        if (defaultOrgID == 0L) {
            return;
        }
        SessionManager.editOrgSession((String)String.valueOf(defaultOrgID));
    }

    public static long getUserDefaultOrgID(long userID) {
        DynamicObject defaultOrgObj = UserServiceHelper.loadUserDefaultOrg(userID);
        if (defaultOrgObj == null) {
            return 0L;
        }
        Object orgObj = defaultOrgObj.get(ORG);
        if (orgObj == null) {
            return 0L;
        }
        if (orgObj instanceof DynamicObject) {
            return ((DynamicObject)orgObj).getLong("id");
        }
        return defaultOrgObj.getLong(ORG);
    }

    public static void setUserDefaultOrg(long userID, long defaultOrgID) {
        DynamicObject defaultOrgObj = UserServiceHelper.loadUserDefaultOrg(userID);
        if (defaultOrgObj == null) {
            defaultOrgObj = BusinessDataServiceHelper.newDynamicObject(ENTITY_USER_DEFAULT_ORG);
            defaultOrgObj.set(USER, (Object)userID);
        }
        defaultOrgObj.set(ORG, (Object)defaultOrgID);
        DynamicObject[] dataEntities = new DynamicObject[]{defaultOrgObj};
        try (TXHandle h = TX.beginRequired();){
            try {
                SaveServiceHelper.save(dataEntities);
            }
            catch (Exception e) {
                h.markRollback();
            }
        }
    }

    private static DynamicObject loadUserDefaultOrg(long userID) {
        QFilter userFilter = new QFilter(USER, "=", (Object)userID);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject[] defaultOrgArr = BusinessDataServiceHelper.load(ENTITY_USER_DEFAULT_ORG, ORG, filters);
        DynamicObject defaultOrgObj = null;
        if (defaultOrgArr != null && defaultOrgArr.length > 0) {
            defaultOrgObj = defaultOrgArr[0];
        }
        return defaultOrgObj;
    }

    public static boolean isUserBelongTo(Long userId, Long orgId) {
        return UserServiceHelper.isUserBelongTo(userId, orgId, true);
    }

    public static boolean isUserBelongTo(Long userId, Long orgId, boolean checkBelongToSubOrg) {
        boolean isUserBelongTo = false;
        QFilter userIDFilter = new QFilter(USER, "=", (Object)userId);
        String selectFields = "id, org.id orgid";
        QFilter[] filters = null;
        filters = new QFilter[]{userIDFilter};
        DynamicObjectCollection userpositionCol = QueryServiceHelper.query(entityID_userposition, selectFields, filters);
        if (userpositionCol == null || userpositionCol.size() == 0) {
            logger.info("\u5f02\u5e38\uff0c\u4eba\u5458\u6ca1\u6709\u4efb\u804c\u4fe1\u606f");
            return isUserBelongTo;
        }
        Long orgIdTemp = null;
        boolean isOrgBelongTo = false;
        for (DynamicObject userposition : userpositionCol) {
            orgIdTemp = userposition.getLong("orgid");
            isOrgBelongTo = false;
            if (orgId.equals(orgIdTemp)) {
                isUserBelongTo = true;
                break;
            }
            if (!checkBelongToSubOrg || !(isOrgBelongTo = OrgViewServiceHelper.isSubOrg("01", orgIdTemp, orgId))) continue;
            isUserBelongTo = true;
            break;
        }
        return isUserBelongTo;
    }

    public static boolean isUserEnable(long userId) {
        Map<Long, Boolean> enableMap = UserServiceHelper.isUserEnable(Collections.singletonList(userId));
        Boolean enable = enableMap.get(userId);
        if (enable == null) {
            return false;
        }
        return enable;
    }

    public static Map<Long, Boolean> isUserEnable(List<Long> userIds) {
        if (userIds == null || userIds.isEmpty()) {
            return new HashMap<Long, Boolean>(0);
        }
        HashMap<Long, Boolean> enableMap = new HashMap<Long, Boolean>(userIds.size());
        for (long userId : userIds) {
            enableMap.put(userId, false);
        }
        String selectFields = "id,enable";
        QFilter idFilter = new QFilter("id", "in", userIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query(entityID_user, selectFields, filters);
        if (userCol == null || userCol.isEmpty()) {
            return enableMap;
        }
        for (DynamicObject user : userCol) {
            enableMap.put(user.getLong("id"), user.getBoolean(ENABLE));
        }
        return enableMap;
    }

    public static String getUserMainJob(long userId) {
        QFilter mainFilter;
        String selectFields = "id,entryentity.position position";
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{idFilter, mainFilter = new QFilter(ENTRYENTITY_ISPARTJOB, "=", (Object)Boolean.FALSE)};
        DynamicObjectCollection userCol = QueryServiceHelper.query(entityID_user, selectFields, filters);
        if (userCol == null || userCol.isEmpty()) {
            return "";
        }
        return ((DynamicObject)userCol.get(0)).getString("position");
    }

    public static Map<Long, String> getUserMainJob(List<Long> userIds) {
        String selectFields = "id,entryentity.position position";
        QFilter idFilter = new QFilter("id", "in", userIds);
        QFilter mainFilter = new QFilter(ENTRYENTITY_ISPARTJOB, "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{idFilter, mainFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query(entityID_user, selectFields, filters);
        if (userCol == null || userCol.isEmpty()) {
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> userJobMap = new HashMap<Long, String>(userCol.size());
        for (DynamicObject user : userCol) {
            userJobMap.put(user.getLong("id"), user.getString("position"));
        }
        return userJobMap;
    }

    public static List<Map<String, Object>> getUserSuperior(String formId, long userId, long orgId, Date bizDate) {
        long superiorOrgId;
        ArrayList<Long> userIds;
        List<Map<String, Object>> directorList;
        long viewId = OrgUnitServiceHelper.getOrgViewIdByFormId("01", formId);
        if (bizDate == null) {
            bizDate = Utils.getDate((int)0);
        }
        if (Utils.isListEmpty(directorList = UserServiceHelper.getOrgDirector(orgId, userIds = new ArrayList<Long>()))) {
            return new ArrayList<Map<String, Object>>(0);
        }
        if (userIds.contains(userId) && (superiorOrgId = OrgUnitServiceHelper.getOrgSuperior(viewId, orgId, bizDate).longValue()) != 0L) {
            directorList = UserServiceHelper.getOrgDirector(superiorOrgId, userIds);
        }
        return directorList;
    }

    public static List<Map<String, Object>> getUserIndirectSuperior(String formId, long userId, long orgId, Date bizDate) {
        ArrayList<Long> userIds;
        List<Map<String, Object>> directorList;
        long viewId = OrgUnitServiceHelper.getOrgViewIdByFormId("01", formId);
        if (bizDate == null) {
            bizDate = Utils.getDate((int)0);
        }
        if (Utils.isListEmpty(directorList = UserServiceHelper.getOrgDirector(orgId, userIds = new ArrayList<Long>()))) {
            return new ArrayList<Map<String, Object>>(0);
        }
        long superiorOrgId = OrgUnitServiceHelper.getOrgSuperior(viewId, orgId, bizDate);
        if (superiorOrgId == 0L) {
            return directorList;
        }
        if (userIds.contains(userId)) {
            long indirectSuperiorOrgId = OrgUnitServiceHelper.getOrgSuperior(viewId, superiorOrgId, bizDate);
            if (indirectSuperiorOrgId != 0L) {
                directorList = UserServiceHelper.getOrgDirector(indirectSuperiorOrgId, userIds);
            }
        } else {
            directorList = UserServiceHelper.getOrgDirector(superiorOrgId, userIds);
        }
        return directorList;
    }

    private static List<Map<String, Object>> getOrgDirector(long orgId, List<Long> userIds) {
        ArrayList<Map<String, Object>> directorList = new ArrayList<Map<String, Object>>();
        String selectFields = "id,name,enable,entryentity.ispartjob ispartjob,entryentity.dpt.name orgName";
        QFilter orgFilter = new QFilter("entryentity.dpt", "=", (Object)orgId);
        QFilter chargeFilter = new QFilter(ENTRYENTITY_ISINCHARGE, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, chargeFilter};
        DynamicObjectCollection userPosCol = QueryServiceHelper.query(entityID_user, selectFields, filters);
        if (Utils.isListEmpty((List)userPosCol)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        for (DynamicObject userPos : userPosCol) {
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            long userId = userPos.getLong("id");
            if (userIds != null) {
                userIds.add(userId);
            }
            userMap.put(USER, userId);
            userMap.put("username", userPos.getString("name"));
            userMap.put(ORG, orgId);
            userMap.put("orgName", userPos.getString("orgName"));
            userMap.put(ENABLE, userPos.getBoolean(ENABLE));
            userMap.put("ispartjob", userPos.getBoolean("ispartjob"));
            directorList.add(userMap);
        }
        return directorList;
    }

    public static List<Long> getUserSubordinate(long userId, int limitLevel) {
        QFilter idFilter;
        QFilter isinchargeFilter;
        if (userId == 0L || limitLevel < 0) {
            return new ArrayList<Long>(0);
        }
        String selectFields = ID_ORG;
        QFilter userFilter = new QFilter(USER, "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter, isinchargeFilter = new QFilter("isincharge", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection userDptCol = QueryServiceHelper.query(entityID_userposition, selectFields, filters);
        if (Utils.isListEmpty((List)userDptCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> chargeOrgList = new ArrayList<Long>();
        for (DynamicObject dptObj : userDptCol) {
            chargeOrgList.add(dptObj.getLong(ORG));
        }
        List<Long> subOrgIds = OrgUnitServiceHelper.getSubOrgLimitLevel(chargeOrgList, limitLevel, true);
        QFilter dptFilter = new QFilter("entryentity.dpt", "in", subOrgIds);
        filters = new QFilter[]{dptFilter, idFilter = new QFilter("id", "!=", (Object)userId)};
        DynamicObjectCollection userCol = QueryServiceHelper.query(entityID_user, "id", filters);
        if (Utils.isListEmpty((List)userCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> subordinateIds = new ArrayList<Long>(userCol.size());
        for (DynamicObject user : userCol) {
            subordinateIds.add(user.getLong("id"));
        }
        return subordinateIds;
    }

    public static Boolean isFirstLogin(Long userId) {
        boolean isFirstLogin = false;
        if (userId == 0L) {
            return isFirstLogin;
        }
        String selectFields = "id,isfirstlogin";
        QFilter userFilter = new QFilter(USER, "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query("bos_user_isfirstlogin", selectFields, filters);
        if (Utils.isListEmpty((List)userCol)) {
            isFirstLogin = true;
            return isFirstLogin;
        }
        isFirstLogin = ((DynamicObject)userCol.get(0)).getBoolean(IS_FIRSTLOGIN);
        return isFirstLogin;
    }

    public static void updateFirstLoginFlag(Long userId) {
        if (userId == 0L) {
            return;
        }
        String selectFields = "id,isfirstlogin";
        QFilter userFilter = new QFilter(USER, "=", (Object)userId);
        QFilter[] filters = new QFilter[]{userFilter};
        DynamicObject[] userCol = BusinessDataServiceHelper.load("bos_user_isfirstlogin", selectFields, filters);
        if (null == userCol || userCol.length == 0) {
            DynamicObject newdoc = BusinessDataServiceHelper.newDynamicObject("bos_user_isfirstlogin");
            newdoc.set(USER, (Object)userId);
            newdoc.set(IS_FIRSTLOGIN, (Object)"0");
            DynamicObject[] forSaveArr = new DynamicObject[]{newdoc};
            SaveServiceHelper.save(forSaveArr);
        } else {
            userCol[0].set(IS_FIRSTLOGIN, (Object)"0");
            DynamicObject[] forSaveArr = new DynamicObject[]{userCol[0]};
            SaveServiceHelper.save(forSaveArr);
        }
    }

    public static List<Long> getAllDepartmentByUserId(long userId) {
        if (userId == 0L) {
            return new ArrayList<Long>(0);
        }
        String selectFields = ID_ORG;
        QFilter idFilter = new QFilter(USER, "=", (Object)userId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection dptCol = QueryServiceHelper.query(entityID_userposition, selectFields, filters);
        if (dptCol == null || dptCol.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> dptIds = new ArrayList<Long>(dptCol.size());
        for (DynamicObject dptObj : dptCol) {
            dptIds.add(dptObj.getLong(ORG));
        }
        return dptIds;
    }

    public static Map<String, Object> changePsw(long userId, String password) {
        return UserServiceHelper.changePsw(userId, null, password);
    }

    public static Map<String, Object> changePsw(long userId, String oldPassword, String newPassword) {
        UserParam userParam = new UserParam();
        userParam.setId(userId);
        HashMap<String, String> dataMap = new HashMap<String, String>(2);
        userParam.setDataMap(dataMap);
        dataMap.put(OLD_PSW, oldPassword);
        dataMap.put(NEW_PSW, newPassword);
        ArrayList<UserParam> userParamList = new ArrayList<UserParam>(1);
        userParamList.add(userParam);
        UserServiceHelper.changePsw(userParamList);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        if (userParam.isSuccess()) {
            resultMap.put(SUCCESS, Boolean.TRUE);
            resultMap.put("msg", ResManager.loadKDString((String)"\u4fee\u6539\u5bc6\u7801\u6210\u529f\u3002", (String)"UserServiceHelper_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        } else {
            resultMap.put(SUCCESS, Boolean.FALSE);
            resultMap.put("msg", userParam.getMsg());
        }
        return resultMap;
    }

    public static void changePsw(List<UserParam> userParamList) {
        UserServiceHelper.getUserService().changePsw(userParamList);
    }

    public static Map<String, Object> verifyPSWStrategy(String password) {
        String regEx;
        Pattern p;
        Matcher m;
        DynamicObject pswStrategy;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String userId = RequestContext.get().getUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, entityID_user);
        String pswStrategyID = user.getString("pswstrategy.id");
        if (StringUtils.isBlank((CharSequence)pswStrategyID) || "0".equals(pswStrategyID)) {
            pswStrategyID = "338333884850648064";
        }
        try {
            pswStrategy = BusinessDataServiceHelper.loadSingle((Object)pswStrategyID, "perm_pswstrategy");
        }
        catch (Exception e) {
            map.put(SUCCESS, Boolean.FALSE);
            map.put("msg", ResManager.loadKDString((String)"\u5bc6\u7801\u7b56\u7565\u4e0d\u5b58\u5728", (String)"UserServiceHelper_5", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return map;
        }
        if (password.length() < pswStrategy.getInt(MIN_LENGTH) || password.length() > 20) {
            if (pswStrategy.getInt(MIN_LENGTH) == 20) {
                map.put(SUCCESS, Boolean.FALSE);
                map.put("msg", ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u957f\u5ea6\u5e94\u4e3a20\u4f4d", (String)"UserServiceHelper_6", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
                return map;
            }
            map.put(SUCCESS, Boolean.FALSE);
            map.put("msg", String.format(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u957f\u5ea6\u5e94\u5728%1$s\u523020\u4f4d", (String)"UserServiceHelper_7", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), pswStrategy.get(MIN_LENGTH)));
            return map;
        }
        if (pswStrategy.getBoolean("isnumber") && !(m = (p = Pattern.compile(regEx = "[0-9]")).matcher(password)).find()) {
            map.put(SUCCESS, Boolean.FALSE);
            map.put("msg", ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u9700\u8981\u5305\u542b\u6570\u5b57", (String)"UserServiceHelper_9", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return map;
        }
        if (pswStrategy.getBoolean("isletter") && !(m = (p = Pattern.compile(regEx = "[A-Za-z]")).matcher(password)).find()) {
            map.put(SUCCESS, Boolean.FALSE);
            map.put("msg", ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u9700\u8981\u5305\u542b\u5b57\u6bcd", (String)"UserServiceHelper_10", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return map;
        }
        if (pswStrategy.getBoolean("isspecial") && !(m = (p = Pattern.compile(regEx = "[`~!@#$%^&*()\u2014_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]")).matcher(password)).find()) {
            map.put(SUCCESS, Boolean.FALSE);
            map.put("msg", ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u9700\u8981\u5305\u542b\u7279\u6b8a\u5b57\u7b26", (String)"UserServiceHelper_11", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return map;
        }
        if (pswStrategy.getInt(REPEATTIMES) > 0) {
            String pswHisStr = user.getString(PSWHISSTR);
            String[] pswHisStrs = pswHisStr.split(",");
            String PswStr = EncryptUtils.encryptPSW((String)password);
            int currPswIndex = 0;
            for (int i = 0; i < pswStrategy.getInt(REPEATTIMES); ++i) {
                currPswIndex = pswHisStrs.length - 1 - i;
                if (currPswIndex < 0) {
                    currPswIndex = 0;
                }
                if (!StringUtils.equals((CharSequence)PswStr, (CharSequence)pswHisStrs[currPswIndex]) && !PasswordEncryptUtil.checkPassword((String)password, (String)pswHisStrs[currPswIndex])) continue;
                map.put(SUCCESS, Boolean.FALSE);
                map.put("msg", String.format(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u524d%1$s\u6b21\u65e7\u5bc6\u7801\u4e00\u81f4", (String)"UserServiceHelper_12", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), pswStrategy.getInt(REPEATTIMES)));
                return map;
            }
        }
        map.put(SUCCESS, Boolean.TRUE);
        map.put("msg", ResManager.loadKDString((String)"\u5bc6\u7801\u7b56\u7565\u9a8c\u8bc1\u901a\u8fc7", (String)"UserServiceHelper_14", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
        return map;
    }

    public static void add(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.add(userList);
    }

    public static void update(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.update(userList);
    }

    public static void delete(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.delete(userList);
    }

    public static void enable(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.enable(userList);
    }

    public static void disable(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.disable(userList);
    }

    public static void enableUser(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.enableUser(userList);
    }

    public static void disableUser(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.disableUser(userList);
    }

    public static void enableHR(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.enableHR(userList);
    }

    public static void disableHR(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.disableHR(userList);
    }

    public static void updatePosition(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.updatePosition(userList);
    }

    public static List<Map<String, Object>> get(List<Long> userIds) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.get(userIds);
    }

    public static List<Map<String, Object>> get(List<Long> userIds, String[] properties, String[] jobProperties) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.get(userIds, properties, jobProperties);
    }

    public static List<Map<String, Object>> getPosition(List<Long> userIds) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getPosition(userIds);
    }

    @Deprecated
    public static String getPerson(long orgId, long userId, PersonQueryType queryType, List<Long> resultList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getPerson(orgId, userId, queryType, resultList);
    }

    public static List<Long> getPerson(PersonQueryParam personQueryParam) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getPerson(personQueryParam);
    }

    public static void addOrUpdate(List<UserParam> userList) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        userService.addOrUpdate(userList);
    }

    public static List<Long> getUserDepartment(long userId, boolean isOnlyChargeOrg) {
        QFilter idFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{idFilter};
        Map<Object, DynamicObject> userObjMap = BusinessDataServiceHelper.loadFromCache(entityID_user, filters);
        if (userObjMap == null || userObjMap.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        DynamicObject userObj = userObjMap.get(userId);
        DynamicObjectCollection positionCol = userObj.getDynamicObjectCollection("entryentity");
        if (positionCol == null || positionCol.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> departmentList = new ArrayList<Long>(positionCol.size());
        for (DynamicObject positionObj : positionCol) {
            DynamicObject orgObj = positionObj.getDynamicObject("dpt");
            if (orgObj == null || isOnlyChargeOrg && !positionObj.getBoolean("isincharge")) continue;
            departmentList.add(orgObj.getLong("id"));
        }
        return departmentList;
    }

    public static Map<String, Object> getBizPartnerUserInfo(Map<String, Object> params) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.getBizPartnerUserInfo(params);
    }

    public static Map<String, String> updateBizPartnerUserInfo(Map<String, Object> params) {
        IUserService userService = (IUserService)ServiceFactory.getService(IUserService.class);
        return userService.updateBizPartnerUserInfo(params);
    }

    public static HasPermOrgResult getUserChangeAbleOrg(long userId, boolean queryWhenAll) {
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs(userId);
        List hasPermOrgIds = null;
        if (hasPermOrgResult.hasAllOrgPerm()) {
            if (queryWhenAll) {
                HashSet<Long> allOrgIds = new HashSet<Long>();
                allOrgIds.addAll(OrgUnitServiceHelper.getAllOrg("15"));
                allOrgIds.addAll(OrgUnitServiceHelper.getAllOrg("01"));
                hasPermOrgResult.getHasPermOrgs().addAll(allOrgIds);
            }
            return hasPermOrgResult;
        }
        hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        HashSet<Long> userSet = new HashSet<Long>();
        List<Long> lstUserOrgs = UserServiceHelper.getOrgsUserJoin(userId);
        if (Utils.isListNotEmpty(lstUserOrgs)) {
            userSet.addAll(lstUserOrgs);
            if (Utils.isListNotEmpty((List)hasPermOrgIds)) {
                userSet.addAll(hasPermOrgIds);
            }
            hasPermOrgResult.getHasPermOrgs().clear();
            hasPermOrgResult.getHasPermOrgs().addAll(userSet);
        }
        return hasPermOrgResult;
    }

    public static List<Long> getAllUserType(boolean includeDisable) {
        return UserServiceHelper.getUserService().getAllUserType(includeDisable);
    }

    public static String getUserDefaultPsw() {
        return UserServiceHelper.getUserService().getUserDefaultPsw();
    }

    public static Set<Long> getAllUsersOfOrg(int jobType, List<Long> orgIds, boolean includeSubOrg, boolean includeDisableUser) {
        return UserServiceHelper.getUserService().getAllUsersOfOrg(jobType, orgIds, includeSubOrg, includeDisableUser);
    }

    public static List<Map<String, Object>> getAllUserContactType() {
        return UserServiceHelper.getUserService().getAllUserContactType();
    }

    public static Map<Long, Map<String, List<String>>> getUserContact(List<Long> userIds) {
        return UserServiceHelper.getUserService().getUserContact(userIds);
    }

    public static Map<Long, List<String>> getUserContact(String contactTypeNumber, List<Long> userIds) {
        return UserServiceHelper.getUserService().getUserContact(contactTypeNumber, userIds);
    }

    public static Map<Long, String> getUserAvatarPath(List<Long> userIds, boolean isGetFullPath) {
        return UserServiceHelper.getUserService().getUserAvatarPath(userIds, isGetFullPath);
    }

    public static Map<Long, Long> getCompanyByUserIds(List<Long> userIds) {
        return UserServiceHelper.getUserService().getCompanyByUserIds(userIds);
    }

    public static Map<Long, Integer> getUserBaseTypeByIds(List<Long> userIds) {
        return UserServiceHelper.getUserService().getUserBaseTypeByIds(userIds);
    }

    public static List<Long> getBizPartnerByUserId(long userId) {
        return UserServiceHelper.getUserService().getBizPartnerByUserId(userId);
    }

    public static List<Long> getInChargeOfBizPartnerByUserId(long userId) {
        return UserServiceHelper.getUserService().getInChargeOfBizPartnerByUserId(userId);
    }

    public static Set<Long> getAllUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable) {
        return UserServiceHelper.getUserService().getAllUsersOfOrg(orgIds, isFindSubOrg, includeDisable);
    }

    public static Set<Long> getAllPartnerUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable) {
        return UserServiceHelper.getUserService().getAllPartnerUsersOfOrg(orgIds, isFindSubOrg, includeDisable);
    }

    private static String get_NOT_SET_TOPIC() {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u4e3b\u9898\uff01", (String)"UserServiceHelper_17", (String)BOS_SERVICEHELPER, (Object[])new Object[0]);
    }

    public static Set<Long> getAllUsersOfOrg(List<Long> orgIds, boolean isFindSubOrg, boolean includeDisable, List<Long> inUserIds) {
        return UserServiceHelper.getUserService().getAllUsersOfOrg(orgIds, isFindSubOrg, includeDisable, inUserIds);
    }

    public static Map<Long, String> enablePosition(Set<Long> positionIds) {
        return UserServiceHelper.getUserService().enablePosition(positionIds);
    }

    public static Map<Long, String> disablePosition(Set<Long> positionIds) {
        return UserServiceHelper.getUserService().disablePosition(positionIds);
    }

    public static Map<Long, String> deletePosition(Set<Long> positionIds) {
        return UserServiceHelper.getUserService().deletePosition(positionIds);
    }

    public static Object addOrUpdatePositions(List<Position> positionList) {
        return UserServiceHelper.getUserService().addOrUpdatePositions(positionList);
    }

    @Deprecated
    public static Map<Long, String> addOrUpdatePosition(List<Map<String, String>> positionList) {
        return UserServiceHelper.getUserService().addOrUpdatePosition(positionList);
    }

    @Deprecated
    public static Map<Long, String> setMainPositionByDptIds(Map<Long, Long> mainPositionIds) {
        return UserServiceHelper.getUserService().setMainPositionByDptIds(mainPositionIds);
    }

    public static Map<Long, Set<Long>> getPositionIdsByDptId(List<Long> dptIds) {
        return UserServiceHelper.getUserService().getPositionIdsByDptId(dptIds);
    }

    public static Map<Long, Map<Long, String>> deleteReportRelation(Map<Long, Set<Long>> relationMap) {
        return UserServiceHelper.getUserService().deleteReportRelation(relationMap);
    }

    public static Map<Long, String> addOrUpdateReportRelation(List<Map<String, Long>> relationList) {
        return UserServiceHelper.getUserService().addOrUpdateReportRelation(relationList);
    }

    public static Map<Long, Position> getPositions(List<Long> positionIds, boolean isIncludeSuperiorPosition) {
        return UserServiceHelper.getUserService().getPositions(positionIds, isIncludeSuperiorPosition);
    }

    public static Map<String, Position> getPositionsByNumber(List<String> positionNumberList, boolean isIncludeSuperiorPosition) {
        return UserServiceHelper.getUserService().getPositionsByNumber(positionNumberList, isIncludeSuperiorPosition);
    }

    public static Map<Long, Map<String, Object>> getReportType(boolean isIncludeDisable) {
        return UserServiceHelper.getUserService().getReportType(isIncludeDisable);
    }

    public static Map<Long, Map<String, Object>> getSuperiorPositions(long reportTypeId, List<Long> positionIds) {
        return UserServiceHelper.getUserService().getSuperiorPositions(reportTypeId, positionIds);
    }

    public static String getSuperiorPosition(long reportTypeId, long positionId) {
        return UserServiceHelper.getUserService().getSuperiorPosition(reportTypeId, positionId);
    }

    public static Map<Long, Set<DynamicObject>> getPeopleUnderPosition(Set<Long> positionIds) {
        return UserServiceHelper.getUserService().getPeopleUnderPosition(positionIds);
    }

    public static Set<Long> getDepartmentIncludeSuperior(long userId) {
        return UserServiceHelper.getUserService().getDepartmentIncludeSuperior(userId);
    }

    public static Map<Long, List<Long>> getUserDepartments(List<Long> userIds, boolean onlyMainJob, boolean onlyInCharge) {
        return UserServiceHelper.getUserService().getUserDepartments(userIds, onlyMainJob, onlyInCharge);
    }

    public static List<Long> getUserDepartments(long userId, boolean onlyMainJob, boolean onlyInCharge) {
        ArrayList<Long> userIds = new ArrayList<Long>(1);
        userIds.add(userId);
        Map<Long, List<Long>> userDepartmentsMap = UserServiceHelper.getUserDepartments(userIds, onlyMainJob, onlyInCharge);
        ArrayList orgIds = userDepartmentsMap.get(userId);
        return orgIds == null ? new ArrayList() : orgIds;
    }
}

