/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.FileRecord;

public class FileRecordUtil {
    private static Log log = LogFactory.getLog(FileRecordUtil.class);

    public static void doLog(List<FileRecord> fileRecordList) {
        if (fileRecordList.isEmpty()) {
            return;
        }
        String sql = "insert into T_BAS_FILE_RECORD(FID,FURL,FTYPE,FUSERID,FCREATETIME) VALUES (?, ?, ?, ?, ?) ";
        long[] ids = DB.genLongIds((String)"T_BAS_FILE_RECORD", (int)fileRecordList.size());
        int i = 0;
        RequestContext rc = RequestContext.get();
        ArrayList<SqlParameter[]> insertData = new ArrayList<SqlParameter[]>(fileRecordList.size());
        Date now = new Date();
        for (FileRecord fileRecord : fileRecordList) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)ids[i++]), new SqlParameter(":FURL", 12, (Object)(fileRecord.getUrl() != null ? fileRecord.getUrl() : "")), new SqlParameter(":FTYPE", 1, (Object)(fileRecord.getType() != null ? fileRecord.getType() : "")), new SqlParameter(":FUSERID", -5, (Object)(fileRecord.getUserId() != null ? fileRecord.getUserId().longValue() : rc.getCurrUserId())), new SqlParameter(":FCREATETIME", 91, (Object)(fileRecord.getCreateTime() != null ? fileRecord.getCreateTime() : now))};
            insertData.add(params);
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, insertData);
    }

    public static FileRecord getFileRecordByUrl(String url) {
        FileRecord fileRecord = new FileRecord();
        String sql = "SELECT FID,FURL,FTYPE,FUSERID,FCREATETIME from T_BAS_FILE_RECORD WHERE FURL = ? ORDER BY FCREATETIME DESC ";
        Object[] params = new Object[]{url};
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, resultSet -> {
            while (resultSet.next()) {
                if (!resultSet.isFirst()) continue;
                String type = resultSet.getString("FTYPE");
                Long userId = resultSet.getLong("FUSERID");
                java.sql.Date createtime = resultSet.getDate("FCREATETIME");
                fileRecord.setUrl(url);
                fileRecord.setType(type);
                fileRecord.setUserId(userId);
                fileRecord.setCreateTime(createtime);
                break;
            }
            return null;
        });
        return fileRecord;
    }
}

