/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.GitPermissionUtil;

public class GitLockAppUtil {
    private static final String BIZAPPNUMBER = "bizappnumber";
    private static final String BOS_APP_LOCKING = "bos_app_locking";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String NUMBER = "number";
    private static final String FORMNUMBER = "formnumber";

    private GitLockAppUtil() {
    }

    public static boolean isLockFormById(String formId) {
        QFilter qFilter = new QFilter("id", "=", (Object)formId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject fromCache = BusinessDataServiceHelper.loadSingleFromCache(BOS_FORMMETA, qFilters);
        if (fromCache == null) {
            return false;
        }
        String number = fromCache.getString(NUMBER);
        QFilter qFilter1 = new QFilter(FORMNUMBER, "=", (Object)number);
        QFilter[] qFilters1 = new QFilter[]{qFilter1};
        return QueryServiceHelper.exists(BOS_APP_LOCKING, qFilters1);
    }

    public static boolean isLockFormByNumber(String formNumber) {
        QFilter qFilter = new QFilter(FORMNUMBER, "=", (Object)formNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return QueryServiceHelper.exists(BOS_APP_LOCKING, qFilters);
    }

    public static String getLockInfo(String formNumber) {
        String field = "account, accounttype";
        QFilter qFilter = new QFilter(FORMNUMBER, "=", (Object)formNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache(BOS_APP_LOCKING, field, qFilters);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getString("account");
    }

    public static void deleteLockInfo(String formNumber) {
        QFilter qFilter = new QFilter(FORMNUMBER, "=", (Object)formNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DeleteServiceHelper.delete(BOS_APP_LOCKING, qFilters);
    }

    public static DynamicObject getAppInfo(String bizAppId) {
        String bizAppNumber = BizAppServiceHelp.getAppNumByAppId(bizAppId);
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)bizAppNumber);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return BusinessDataServiceHelper.loadSingleFromCache(BOS_DEVPORTAL_BIZAPP, qFilters);
    }

    public static Set<String> getCqBizApps(Long userId, String accountType) {
        QFilter q1 = new QFilter("account", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{q1};
        HashSet<String> set = new HashSet<String>(16);
        DynamicObject[] apps = BusinessDataServiceHelper.load("bos_app_isolation", "isolationapp", qFilters);
        if (apps.length > 0) {
            DynamicObjectCollection isolations = (DynamicObjectCollection)apps[0].get("isolationapp");
            for (DynamicObject isolation : isolations) {
                DynamicObject app = (DynamicObject)isolation.get("fbasedataid");
                if (app == null) continue;
                String bizAppId = (String)app.get("id");
                set.add(bizAppId);
            }
        }
        return set;
    }

    public static String getCqUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache("bos_user", qFilters);
        if (user == null) {
            return null;
        }
        return user.getString("name");
    }

    public static JSONArray getLockForms(String bizAppId, String unitId, JSONArray formList) {
        String bizAppNumber = BizAppServiceHelp.getAppNumByAppId(bizAppId);
        boolean dev_form_lock = (Boolean)GitPermissionUtil.getParameter("dev_form_lock");
        String type = null;
        if (dev_form_lock) {
            type = "sys";
        }
        QFilter qFilter = new QFilter(BIZAPPNUMBER, "=", (Object)bizAppNumber);
        QFilter qFilter1 = new QFilter("unitid", "=", (Object)unitId);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilter1};
        Map<Object, DynamicObject> forms = BusinessDataServiceHelper.loadFromCache(BOS_APP_LOCKING, FORMNUMBER, qFilters);
        Iterator<Map.Entry<Object, DynamicObject>> iterator = forms.entrySet().iterator();
        HashSet<String> lockFroms = new HashSet<String>(10);
        while (iterator.hasNext()) {
            Map.Entry<Object, DynamicObject> next = iterator.next();
            DynamicObject value = next.getValue();
            String formnumber = value.getString(FORMNUMBER);
            lockFroms.add(formnumber);
        }
        for (Object jsonObject : formList) {
            JSONObject jsonObject1 = (JSONObject)jsonObject;
            if (lockFroms.add(jsonObject1.getString(NUMBER))) {
                lockFroms.remove(jsonObject1.getString(NUMBER));
                jsonObject1.put("accountType", (Object)type);
                jsonObject1.put("locking", (Object)1);
                continue;
            }
            jsonObject1.put("accountType", (Object)type);
            jsonObject1.put("locking", (Object)2);
        }
        return formList;
    }

    public static void lockForm(String bizAppId, String bizUnitId, String bizId, AbstractFormPlugin plugin) {
        DynamicObject bizAppInfo;
        String type = "sys";
        String userName = RequestContext.get().getUserName();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizId, BOS_FORMMETA);
        String formNumber = dynamicObject.getString(NUMBER);
        String formName = dynamicObject.getString("name");
        String bizUnitName = null;
        AppFunctionPacketElement packet = GitLockAppUtil.getFunctionById(bizAppId, bizUnitId);
        if (packet != null) {
            bizUnitName = packet.getName().getLocaleValue();
        }
        if ((bizAppInfo = GitLockAppUtil.getAppInfo(bizAppId)) == null) {
            return;
        }
        DynamicObject appInfo = BusinessDataServiceHelper.newDynamicObject(BOS_APP_LOCKING);
        appInfo.set(FORMNUMBER, (Object)formNumber);
        appInfo.set("formname", (Object)formName);
        appInfo.set("unitid", (Object)bizUnitId);
        appInfo.set("unitname", (Object)bizUnitName);
        appInfo.set(BIZAPPNUMBER, (Object)bizAppInfo.getString(NUMBER));
        appInfo.set("bizappname", (Object)bizAppInfo.getString("name"));
        appInfo.set("accounttype", (Object)type);
        appInfo.set("account", (Object)userName);
        appInfo.set("createtime", (Object)new Date());
        DynamicObject[] lockAppInfo = new DynamicObject[]{appInfo};
        SaveServiceHelper.save(lockAppInfo);
        String info = String.format(ResManager.loadKDString((String)"\u5df2\u5c06%s\u9501\u5b9a", (String)"GitLockAppUtil_2", (String)"bos-servicehelper", (Object[])new Object[0]), formNumber);
        plugin.getView().showTipNotification(ResManager.loadKDString((String)info, (String)"GitLockAppUtil_0", (String)"GitLockAppUtil_1", (Object[])new Object[0]));
    }

    public static AppFunctionPacketElement getFunctionById(String bizAppId, String unitId) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById(bizAppId, false);
        List packets = metadata.getAppFunctionPackets();
        for (AppFunctionPacketElement element : packets) {
            String id = element.getId();
            if (!StringUtils.equals((CharSequence)unitId, (CharSequence)id)) continue;
            return element;
        }
        return null;
    }
}

