/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.util.GitLockAppUtil;

public class GitPermissionUtil {
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static final String SUCCESS = "success";
    private static final String MESSAGE = "message";

    private static Map<String, Object> checkForm(JSONObject arg, String itemId) {
        HashMap<String, Object> result = null;
        long userId = RequestContext.get().getCurrUserId();
        String app = StringUtils.equals((CharSequence)"importpage", (CharSequence)itemId) || StringUtils.equals((CharSequence)"fastinherit", (CharSequence)itemId) ? arg.getString("appid") : arg.getString("bizappid");
        if (StringUtils.equals((CharSequence)"gitoperate", (CharSequence)itemId)) {
            String bizId = arg.getString("id");
            app = GitPermissionUtil.getBizAppId(bizId);
        }
        result = new HashMap<String, Object>();
        if (app == null) {
            result.put(SUCCESS, true);
            return result;
        }
        Set<String> bizApps = GitLockAppUtil.getCqBizApps(userId, "sys");
        if (bizApps.add(app)) {
            String message = ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u4e0a\u8be5\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GitPermissionUtil_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]);
            result.put(SUCCESS, false);
            result.put(MESSAGE, message);
            return result;
        }
        result.put(SUCCESS, true);
        return result;
    }

    private static Map<String, Object> checkApp(JSONObject arg, String itemId) {
        HashMap<String, Object> result = null;
        long userId = RequestContext.get().getCurrUserId();
        if (StringUtils.equals((CharSequence)"ADDNEW", (CharSequence)itemId) || StringUtils.equals((CharSequence)"VIEW", (CharSequence)itemId)) {
            result = new HashMap<String, Object>();
            result.put(SUCCESS, true);
            return result;
        }
        String bizAppId = arg.getString("bizappid");
        if (bizAppId == null) {
            result = new HashMap();
            result.put(SUCCESS, true);
            return result;
        }
        Set<String> bizApps = GitLockAppUtil.getCqBizApps(userId, "sys");
        if (bizApps.add(bizAppId)) {
            result = new HashMap();
            String message = ResManager.loadKDString((String)"\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709\u5f00\u53d1\u5e73\u53f0\u4e0a\u8be5\u5e94\u7528\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GitPermissionUtil_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]);
            result.put(SUCCESS, false);
            result.put(MESSAGE, message);
            return result;
        }
        result = new HashMap();
        result.put(SUCCESS, true);
        return result;
    }

    public static Object getParameter(String item) {
        Map<String, Object> args = GitPermissionUtil.getSystem();
        if (args == null || args.get(item) == null) {
            return false;
        }
        return args.get(item);
    }

    private static Map<String, Object> getSystem() {
        AppParam param = new AppParam();
        param.setAppId("83bfebc800003dac");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        param.setOrgId(Long.valueOf(rootOrgId));
        param.setViewType("15");
        return SystemParamServiceHelper.loadAppParameterFromCache(param);
    }

    public static Map<String, Object> verifyPermission(JSONObject arg, String item, String type) {
        HashMap<String, Object> result = null;
        long userId = RequestContext.get().getCurrUserId();
        boolean dev_permission = (Boolean)GitPermissionUtil.getParameter("dev_permission");
        boolean adminUser = PermissionServiceHelper.isAdminUser(userId);
        boolean superUser = PermissionServiceHelper.isSuperUser(userId);
        if (!dev_permission || adminUser || superUser) {
            result = new HashMap<String, Object>();
            result.put(SUCCESS, true);
            return result;
        }
        if (StringUtils.equals((CharSequence)"app", (CharSequence)type)) {
            return GitPermissionUtil.checkApp(arg, item);
        }
        return GitPermissionUtil.checkForm(arg, item);
    }

    public static Map<String, Object> verifyLock(JSONObject arg, String itemId) {
        HashMap<String, Object> result = null;
        boolean dev_form_lock = (Boolean)GitPermissionUtil.getParameter("dev_form_lock");
        if (!dev_form_lock) {
            result = new HashMap<String, Object>();
            result.put(SUCCESS, true);
            return result;
        }
        if (StringUtils.equals((CharSequence)"addnewunit", (CharSequence)itemId) || StringUtils.equals((CharSequence)"addnewpage", (CharSequence)itemId) || StringUtils.equals((CharSequence)"importpage", (CharSequence)itemId) || StringUtils.equals((CharSequence)"fastinherit", (CharSequence)itemId)) {
            result = new HashMap();
            result.put(SUCCESS, true);
            return result;
        }
        String bizNumber = arg.getString("biznumber");
        if (StringUtils.equals((CharSequence)"gitoperate", (CharSequence)itemId)) {
            String bizId = arg.getString("id");
            bizNumber = MetadataDao.getNumberById((String)bizId);
        }
        String userName = RequestContext.get().getUserName();
        if (bizNumber == null) {
            result = new HashMap();
            result.put(SUCCESS, true);
            return result;
        }
        if (GitLockAppUtil.isLockFormByNumber(bizNumber)) {
            result = new HashMap();
            String lockUserName = GitLockAppUtil.getLockInfo(bizNumber);
            if (StringUtils.equals((CharSequence)userName, (CharSequence)lockUserName)) {
                result.put(SUCCESS, true);
                return result;
            }
            String message = String.format(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u5df2\u88ab\u201c%s\u201d\u9501\u5b9a\u3002", (String)"GitPermissionUtil_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]), lockUserName);
            result.put(SUCCESS, false);
            result.put(MESSAGE, message);
            return result;
        }
        result = new HashMap();
        result.put(SUCCESS, true);
        return result;
    }

    public static String getBizAppId(String bizId) {
        QFilter qFilter = new QFilter("id", "=", (Object)bizId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject appInfo = BusinessDataServiceHelper.loadSingleFromCache("bos_formmeta", qFilters);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getString("bizappid");
    }

    public static String getCloudByApp(String appId) {
        DynamicObject cloud = BizCloudServiceHelp.getBizCloudByAppID(appId);
        if (cloud == null) {
            return null;
        }
        return (String)cloud.get("id");
    }
}

