/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class TenantLoginConfigUtils {
    public static boolean isUseTenantLoginConfig() {
        String tenantId = RequestContext.get() == null ? null : RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)"tenant.login.config.share_to_cosmic", (String)tenantId);
        return Boolean.parseBoolean(value);
    }

    public static String getLogoUrlConfig() {
        String urlFromLocalCache = (String)TenantLoginConfigUtils.getCache().get("_custom_logo_url_");
        if (StringUtils.isNotEmpty((String)urlFromLocalCache)) {
            return UrlService.getImageFullUrl((String)urlFromLocalCache);
        }
        String url = null;
        try {
            LoginMCService mcService = LoginMCService.create();
            String urlFromMC = mcService.getMCData(RequestContext.get().getTenantId(), "_tenant_login_config_values_");
            if (StringUtils.isNotEmpty((String)urlFromMC)) {
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)urlFromMC, Map.class);
                if (Objects.isNull(dataMap)) {
                    return null;
                }
                url = (String)dataMap.get("lefttoplogoimg");
                if (StringUtils.isNotEmpty((String)url)) {
                    TenantLoginConfigUtils.updateCacheValue("_custom_logo_url_", url);
                    return UrlService.getImageFullUrl((String)url);
                }
            }
        }
        catch (Exception e) {
            return url;
        }
        return url;
    }

    private static void updateCacheValue(String key, String url) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        if (Objects.isNull(TenantLoginConfigUtils.getCache())) {
            return;
        }
        TenantLoginConfigUtils.getCache().remove(new String[]{key});
        TenantLoginConfigUtils.getCache().put(key, (Object)url);
    }

    private static LocalMemoryCache getCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(Integer.MAX_VALUE);
        info.setMaxItemSize(50);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), "custLoginConfig", info);
    }
}

