/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;

public class VersionManageUtil {
    private static final String BIZAPPID = "83bfebc800003dac";
    private static final String ENTITY_NUMBER = "bos_devportal_bizapplist";
    private static final String PERITEM_ID = "47150e89000000ac";
    private static final String SUCCESS = "success";
    private static final String DESCRIPTION = "description";
    private static final String BOS_SERVICEHELPER = "bos-servicehelper";
    private static final String COMPRESS = "&#compress#&";
    private static Log log = LogFactory.getLog(VersionManageUtil.class);
    private static List<String> type = new ArrayList<String>();

    public static void checkPermission(Map<String, Object> result, boolean isGit) {
        if (!VersionManageUtil.checkDevportal(result)) {
            return;
        }
        if (!VersionManageUtil.checkParameter(result, isGit)) {
            return;
        }
        VersionManageUtil.checkProParameter(result);
    }

    private static boolean checkDevportal(Map<String, Object> result) {
        long userId = RequestContext.get().getCurrUserId();
        boolean permission = PermissionServiceHelper.checkPermission(userId, BIZAPPID, ENTITY_NUMBER, PERITEM_ID);
        if (!permission) {
            result.put(SUCCESS, false);
            result.put(DESCRIPTION, ResManager.loadKDString((String)"\u65e0\u5f00\u53d1\u5e73\u53f0\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VersionManageUtil_0", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean checkParameter(Map<String, Object> result, boolean isGit) {
        String codeManageType = DevportalCommonUtil.getCodeManageType();
        if (StringUtils.equalsIgnoreCase((CharSequence)"none", (CharSequence)codeManageType)) {
            result.put(SUCCESS, false);
            result.put(DESCRIPTION, ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u662f\u5f00\u53d1\u73af\u5883\uff0c\u65e0\u6cd5\u4f7f\u7528Git/SVN\u3002", (String)"VersionManageUtil_1", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        if (isGit && !StringUtils.equals((CharSequence)"git", (CharSequence)codeManageType)) {
            result.put(SUCCESS, false);
            result.put(DESCRIPTION, ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6ca1\u6709\u5f00\u542fGit\uff0c\u65e0\u6cd5\u4f7f\u7528Git\u529f\u80fd\u3002", (String)"VersionManageUtil_4", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        if (!isGit && !StringUtils.equals((CharSequence)"svn", (CharSequence)codeManageType)) {
            result.put(SUCCESS, false);
            result.put(DESCRIPTION, ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u6ca1\u6709\u5f00\u542fSVN\uff0c\u65e0\u6cd5\u4f7f\u7528SVN\u529f\u80fd\u3002", (String)"VersionManageUtil_5", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean checkProParameter(Map<String, Object> result) {
        if (VersionManageUtil.isProduct()) {
            result.put(SUCCESS, false);
            result.put(DESCRIPTION, ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\uff0c\u65e0\u6cd5\u4f7f\u7528Git/SVN\u3002", (String)"VersionManageUtil_2", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean checkFileType(String fileName, Map<String, Object> map) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return true;
        }
        if (!fileName.contains(".")) {
            map.put(SUCCESS, false);
            map.put(DESCRIPTION, ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u5728\u767d\u540d\u5355\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\u3002", (String)"VersionManageUtil_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        String[] split = fileName.trim().split("\\.");
        String fileType = split[split.length - 1];
        if (!type.contains(fileType)) {
            map.put(SUCCESS, false);
            map.put(DESCRIPTION, ResManager.loadKDString((String)"\u6587\u4ef6\u7c7b\u578b\u4e0d\u5728\u767d\u540d\u5355\u8303\u56f4\uff0c\u4e0d\u5141\u8bb8\u4e0a\u4f20\u3002", (String)"VersionManageUtil_3", (String)BOS_SERVICEHELPER, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean isProduct() {
        String talentCode = RequestContext.get().getTenantCode();
        String talentEnvType = System.getProperty(talentCode + "_env.type");
        if (StringUtils.isNotBlank((CharSequence)talentEnvType)) {
            return "prod".equals(talentEnvType);
        }
        return false;
    }

    public static String compress(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            return COMPRESS + out.toString("ISO-8859-1");
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return str;
        }
    }

    public static String unCompress(String str) {
        if (null == str || str.length() <= 0 || !str.startsWith(COMPRESS)) {
            return str;
        }
        try {
            str = str.replaceFirst(COMPRESS, "");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes("ISO-8859-1"));
            GZIPInputStream gzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            int n = 0;
            while ((n = gzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return str;
        }
    }

    static {
        type.add("dym");
        type.add("dymx");
        type.add("app");
        type.add("appx");
        type.add("cld");
        type.add("cldx");
        type.add("ks");
        type.add("cr");
        type.add("crx");
        type.add("wb");
        type.add("wbx");
        type.add("pdm");
        type.add("xml");
        type.add("kpdm");
        type.add("sql");
    }
}

